/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.zub.jasper.AnfrageBeanFactory;
import de.esg.zub.jasper.AnfrageFactory;
import de.esg.zub.jasper.NoReportFoundException;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.log4j.Logger;

public class AnfragePrinter {
    private static final String PRINT_PREVIEW = "Druckvorschau";
    Logger logger = Logger.getLogger(AnfragePrinter.class);

    public AnfragePrinter() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to set Layout in Printing", (Throwable)e);
        }
    }

    private JasperPrint prepareReport(boolean recompile, boolean isAngebot) throws JRException {
        URL url = ClassLoader.getSystemResource("reports/Anfrage.jrxml");
        if (url == null) {
            throw new NoReportFoundException("AnfrageBericht nicht vorhanden!");
        }
        String path = new File(url.getPath()).getParent() + File.separator;
        File file = new File(path + "Kalkulationspositionen.jasper");
        if (!file.exists() || recompile) {
            JasperCompileManager.compileReportToFile((String)(path + "Kalkulationspositionen.jrxml"), (String)(path + "Kalkulationspositionen.jasper"));
        }
        if (!(file = new File(path + "Anfrage.jasper")).exists() || recompile) {
            JasperCompileManager.compileReportToFile((String)(path + "Anfrage.jrxml"), (String)(path + "Anfrage.jasper"));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("SUBREPORT_DIR", path);
        parameters.put("SUBREPORT_DATASOURCE", (String)AnfrageBeanFactory.getKalkulationsDataSource());
        JasperPrint jasperPrint = JasperFillManager.fillReport((String)(path + "Anfrage.jasper"), parameters, (JRDataSource)AnfrageFactory.getAnfrageSource(isAngebot));
        return jasperPrint;
    }

    public void printAnfrageToScreen(boolean recompile, boolean isAngebot) {
        try {
            JasperPrint jasperPrint = this.prepareReport(recompile, isAngebot);
            final JasperViewer viewer = new JasperViewer(jasperPrint);
            viewer.setTitle(PRINT_PREVIEW);
            viewer.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("img/ai_etk.jpg")));
            viewer.setDefaultCloseOperation(3);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    viewer.setVisible(true);
                }
            });
        }
        catch (JRException e) {
            this.logger.error((Object)"Error in printing Report", (Throwable)e);
        }
    }

    public void printAnfrageToPrinter(boolean recompile, boolean isAngebot) {
        try {
            JasperPrint jasperPrint = this.prepareReport(recompile, isAngebot);
            JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printAnfrageToFax(boolean recompile, boolean isAngebot) {
        try {
            JasperPrint jasperPrint = this.prepareReport(recompile, isAngebot);
            JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void printAnfrageToPdf(boolean recompile, String path, boolean isAngebot) {
        try {
            JasperPrint jasperPrint = this.prepareReport(recompile, isAngebot);
            JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)path);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }
}

