/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.marketing.ControllerMarketingPanel;
import de.esg.zub.jasper.EmailData;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import java.awt.Component;
import java.io.InputStream;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.resources.Resource;

public class JasperPrintHelper {
    private static JDialog viewerDialog;

    private static JDialog getViewerDialog() {
        if (viewerDialog == null) {
            viewerDialog = new JDialog(MainController.getInstance().getMainFrame(), Resource.getInstance().getDruckansicht(), false);
            viewerDialog.setDefaultCloseOperation(2);
        }
        return viewerDialog;
    }

    public static void print(String reportName, InputStream is, Map<String, Object> parameter, JRDataSource dataSource, EmailData emailData) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((InputStream)is, parameter, (JRDataSource)dataSource);
        byte[] pdfContent = JasperExportManager.exportReportToPdf((JasperPrint)print);
        String produktName = ControllerMarketingPanel.getInstance().getModel().getProductName();
        String dateiname = "";
        if (reportName.equals("Anfrage.jasper")) {
            dateiname = "Anfrage";
        } else if (reportName.equals("Angebot.jasper")) {
            dateiname = "Angebot.jasper";
        } else if (reportName.equals("Marketingbericht.jasper")) {
            dateiname = "Marketinginfo";
        }
        dateiname = dateiname + "_" + produktName + ".pdf";
        TrfZubVerwaltung transferableMap = new TrfZubVerwaltung(null);
        transferableMap.setValue("berichtsInhalt", pdfContent);
        transferableMap.setValue("empfaenger", emailData.getNameEmail());
        transferableMap.setValue("empfaengerMail", emailData.getAnMail());
        transferableMap.setValue("sender", emailData.getVonEmail());
        transferableMap.setValue("betreff", emailData.getBetreffEmail());
        transferableMap.setValue("freiTextEmail", emailData.getFreitextEmail());
        transferableMap.setValue("attachmentName", dateiname);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(transferableMap, Command.DRUCKE_BERICHT_EMAIL);
            if (transferableMap.getError() != null) {
                JOptionPane.showMessageDialog((Component)MainController.getIMainControllerInstance().getMainFrame(), Resource.getInstance().getSendMailFailed(), Resource.getInstance().getSonstigerFehler(), 0);
                return;
            }
            JOptionPane.showMessageDialog((Component)MainController.getIMainControllerInstance().getMainFrame(), Resource.getInstance().getTeilelisteMailOk());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)MainController.getIMainControllerInstance().getMainFrame(), Resource.getInstance().getSendMailFailed(), Resource.getInstance().getSonstigerFehler(), 0);
        }
    }

    public static void print(InputStream is, Map<String, Object> parameter, JRDataSource dataSource) throws JRException {
        JasperPrint print = JasperFillManager.fillReport((InputStream)is, parameter, (JRDataSource)dataSource);
        JasperViewer viewer = new JasperViewer(print);
        final JDialog dialog = JasperPrintHelper.getViewerDialog();
        dialog.setContentPane(viewer.getContentPane());
        dialog.setPreferredSize(viewer.getPreferredSize());
        dialog.setSize(viewer.getSize());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
    }
}

