/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.zub.jasper.AnfrageFactory;
import de.esg.zub.jasper.KalkulationspositionBean;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import webetk.app.zub.verwaltung.FilialeZub;

public class KalkulationspositionSource
implements JRDataSource {
    List<KalkulationspositionBean> data = new ArrayList<KalkulationspositionBean>();
    String legende;
    String mFirmenName;
    String mFilialName;
    String mNetto;
    String mAufschlag;
    String mMwst;
    String mAngebotsbetrag;
    String mGesamtpreis;
    private int index = -1;

    public KalkulationspositionSource(String netto, String aufschlag, String mwst, String angebotsbetrag, String gesamtpreis) {
        this.setFirma();
        this.mNetto = netto;
        this.mAufschlag = aufschlag;
        this.mMwst = mwst;
        this.mAngebotsbetrag = angebotsbetrag;
        this.mGesamtpreis = gesamtpreis;
    }

    private void setFirma() {
        FilialeZub fil = AnfrageFactory.getFiliale();
        this.mFilialName = fil.getBezeichnung();
        this.mFirmenName = fil.getBezeichnungFirma();
    }

    public void setData(List<KalkulationspositionBean> data) {
        this.data = data;
        this.initLegende();
    }

    public void cleanData() {
        this.data.clear();
    }

    public void addData(KalkulationspositionBean bean) {
        this.data.add(bean);
        this.legende = null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        if (field.getName().equals("pos")) {
            return this.data.get(this.index).getPos();
        }
        if (field.getName().equals("teileNummer")) {
            return this.data.get(this.index).getTeileNummer();
        }
        if (field.getName().equals("benennung")) {
            return this.data.get(this.index).getBenennung();
        }
        if (field.getName().equals("menge")) {
            return this.data.get(this.index).getMenge();
        }
        if (field.getName().equals("einzelPreis")) {
            return this.data.get(this.index).getEinzelPreis();
        }
        if (field.getName().equals("rabatt")) {
            return this.data.get(this.index).getRabatt();
        }
        if (field.getName().equals("gesamtPreis")) {
            return this.data.get(this.index).getGesamtPreis();
        }
        if (field.getName().equals("Steuerart")) {
            return this.data.get(this.index).getMwStSymbol();
        }
        if (field.getName().equals("legende")) {
            return this.getLegende();
        }
        if (field.getName().equals("Filialname")) {
            return this.mFilialName;
        }
        if (field.getName().equals("Firmenname")) {
            return this.mFirmenName;
        }
        if (field.getName().equals("Anzahl")) {
            return this.data.size();
        }
        if (field.getName().equals("Index")) {
            return this.index;
        }
        if (field.getName().equals("Netto")) {
            return this.mNetto;
        }
        if (field.getName().equals("Aufschlag")) {
            return this.mAufschlag;
        }
        if (field.getName().equals("Mwst")) {
            return this.mMwst;
        }
        if (field.getName().equals("Angebotsbetrag")) {
            return this.mAngebotsbetrag;
        }
        if (field.getName().equals("Gesamtpreis")) {
            return this.mGesamtpreis;
        }
        return null;
    }

    private String getLegende() {
        if (this.legende == null) {
            this.initLegende();
        }
        return this.legende;
    }

    private void initLegende() {
        StringBuilder bui = new StringBuilder();
        ArrayList<String> chars = new ArrayList<String>();
        for (KalkulationspositionBean bean : this.data) {
            if (bean.getMwStSymbol() == null || chars.contains(bean.getMwStSymbol())) continue;
            bui.append(bean.getMwStSymbol()).append(" - ").append(bean.getMwSteuerSatz().toString()).append(" %\n");
            chars.add(bean.getMwStSymbol());
        }
        this.legende = bui.length() != 0 ? bui.toString() : "";
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.data.size();
    }
}

