/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.zub.configurator.content.marketing.MarketingModel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.jasper.AnfrageFactory;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import webetk.app.zub.verwaltung.FilialeZub;

public class NutzenDataSource
implements JRDataSource {
    String mFirmenName;
    String mFilialName;
    String mNutzen;
    String mProduktName;
    int index = -1;

    public NutzenDataSource(MarketingModel model) {
        this.setFirma();
        this.mNutzen = model.getMarketingProdukt().getNutzen();
        this.mProduktName = model.getProductNamePlain();
    }

    private void setFirma() {
        FilialeZub fil = AnfrageFactory.getFiliale();
        this.mFilialName = fil.getBezeichnung();
        this.mFirmenName = fil.getBezeichnungFirma();
    }

    public Object getFieldValue(JRField arg0) throws JRException {
        if (arg0.getName().equals("Produktbezeichnung")) {
            return this.getProductNamePlain();
        }
        if (arg0.getName().equals("Firmenname")) {
            return this.getFirmenName();
        }
        if (arg0.getName().equals("Filialname")) {
            return this.getFilialName();
        }
        if (arg0.getName().equals("Nutzen")) {
            return WorkflowController.getInstance().getMarkenLayout().cleanTextComplete(this.mNutzen, "#", " - ");
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index == 0;
    }

    public String getFirmenName() {
        return this.mFirmenName;
    }

    public String getFilialName() {
        return this.mFilialName;
    }

    public String getNutzen() {
        return this.mNutzen;
    }

    public String getProductNamePlain() {
        return this.mProduktName;
    }
}

