/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.zub.configurator.content.technisch.TechnikModel;
import de.esg.zub.jasper.AnfrageFactory;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import webetk.app.zub.verwaltung.FilialeZub;

public class TechnikDataSource
implements JRDataSource {
    TechnikModel mModel;
    String mFirmenName;
    String mFilialName;
    int index = -1;

    public TechnikDataSource(TechnikModel model) {
        this.mModel = model;
        this.setFirma();
    }

    private void setFirma() {
        FilialeZub fil = AnfrageFactory.getFiliale();
        this.mFilialName = fil.getBezeichnung();
        this.mFirmenName = fil.getBezeichnungFirma();
    }

    public Object getFieldValue(JRField arg0) throws JRException {
        if (arg0.getName().equals("image")) {
            return this.mModel.getCurrentGrafikAsImage();
        }
        if (arg0.getName().equals("Produktbezeichnung")) {
            return this.mModel.getProduktBenennung();
        }
        if (arg0.getName().equals("Firmenname")) {
            return this.getFirmenName();
        }
        if (arg0.getName().equals("Filialname")) {
            return this.getFilialName();
        }
        if (arg0.getName().equals("Schwierigkeitsgrad")) {
            return this.mModel.getSchwierigkeitsgrad();
        }
        if (arg0.getName().equals("MechanischeArbeit")) {
            if (this.mModel.getMechanischeArbeit().startsWith("0")) {
                return null;
            }
            return this.mModel.berechneMinInStunden(this.mModel.getMechanischeArbeit());
        }
        if (arg0.getName().equals("MechanischeArbeitAW")) {
            return this.mModel.getMechanischeArbeitAw();
        }
        if (arg0.getName().equals("ElektrischeArbeit")) {
            if (this.mModel.getElektrikArbeit().startsWith("0")) {
                return null;
            }
            return this.mModel.berechneMinInStunden(this.mModel.getElektrikArbeit());
        }
        if (arg0.getName().equals("ElektrischeArbeitAW")) {
            return this.mModel.getElektrikArbeitAw();
        }
        if (arg0.getName().equals("ProgrammierArbeit")) {
            return this.mModel.berechneMinInStunden(this.mModel.getProgrammierArbeit());
        }
        if (arg0.getName().equals("ProgrammierArbeitAW")) {
            return this.mModel.getProgrammierArbeitAw();
        }
        if (arg0.getName().equals("LackierArbeit")) {
            return this.mModel.berechneMinInStunden(this.mModel.getLackierArbeit());
        }
        if (arg0.getName().equals("LackierArbeitAW")) {
            return this.mModel.getLackierArbeitAw();
        }
        if (arg0.getName().equals("SonstigeArbeit")) {
            return this.mModel.berechneMinInStunden(this.mModel.getSonstigeArbeit());
        }
        if (arg0.getName().equals("SonstigeArbeitAW")) {
            return this.mModel.getSonstigeArbeitAw();
        }
        if (arg0.getName().equals("GesamtArbeit")) {
            return this.mModel.berechneMinInStunden(this.mModel.getGesamteArbeit());
        }
        if (arg0.getName().equals("GesamtArbeitAW")) {
            return this.mModel.getGesamteArbeitAw();
        }
        if (arg0.getName().equals("bteKommentar")) {
            return "";
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index == 0;
    }

    public String getFirmenName() {
        return this.mFirmenName;
    }

    public void setFirmenName(String firmenName) {
        this.mFirmenName = firmenName;
    }

    public String getFilialName() {
        return this.mFilialName;
    }
}

