/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.jasper;

import de.esg.zub.configurator.content.technisch.Arbeit;
import de.esg.zub.jasper.AnfrageFactory;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.verwaltung.FilialeZub;

public class TechnikListenDataSource
implements JRDataSource {
    List<Bauteil> bauteile = new ArrayList<Bauteil>();
    List<Arbeit> arbeiten = new ArrayList<Arbeit>();
    int mAnzahlDerVorgaenger;
    String mFirmenName;
    String mFilialName;
    int index = -1;

    public TechnikListenDataSource(List<TechnischerBnb> bnbListe, List<Arbeit> arbeitListe, int anzahlDerVorgaenger) {
        this.mAnzahlDerVorgaenger = anzahlDerVorgaenger;
        this.setFirma();
        if (bnbListe != null) {
            for (TechnischerBnb bnb : bnbListe) {
                for (Bauteil bauteil : bnb.getBauteile()) {
                    this.bauteile.add(bauteil);
                }
            }
        }
        if (arbeitListe != null) {
            this.arbeiten = arbeitListe;
        }
    }

    private void setFirma() {
        FilialeZub fil = AnfrageFactory.getFiliale();
        this.mFilialName = fil.getBezeichnung();
        this.mFirmenName = fil.getBezeichnungFirma();
    }

    public Object getFieldValue(JRField arg0) throws JRException {
        if (arg0.getName().equals("Anzahl")) {
            return this.getAnzahlDerVorgaenger();
        }
        if (arg0.getName().equals("Firmenname")) {
            return this.getFirmenName();
        }
        if (arg0.getName().equals("Filialname")) {
            return this.getFilialName();
        }
        if (arg0.getName().equals("Index")) {
            return this.index;
        }
        if (this.index < this.bauteile.size()) {
            if (arg0.getName().equals("id")) {
                return this.bauteile.get(this.index).getTeilenummer();
            }
            if (arg0.getName().equals("benennung")) {
                return this.bauteile.get(this.index).getBenennung();
            }
            if (arg0.getName().equals("menge")) {
                return this.bauteile.get(this.index).getMenge();
            }
            if (arg0.getName().equals("einzelpreis")) {
                return new Double(this.bauteile.get(this.index).getEinzelPreis());
            }
            if (arg0.getName().equals("gesamtpreis")) {
                return new Double(this.bauteile.get(this.index).getGesamtPreis());
            }
            if (arg0.getName().equals("aktiv")) {
                return this.bauteile.get(this.index).isAktiv();
            }
            return null;
        }
        if (this.index >= this.bauteile.size()) {
            if (arg0.getName().equals("id")) {
                return this.arbeiten.get(this.index - this.bauteile.size()).getAwnummer();
            }
            if (arg0.getName().equals("benennung")) {
                return this.arbeiten.get(this.index - this.bauteile.size()).getBenennung();
            }
            if (arg0.getName().equals("menge")) {
                return this.arbeiten.get(this.index - this.bauteile.size()).getMenge();
            }
            if (arg0.getName().equals("einzelpreis")) {
                return new Double(this.arbeiten.get(this.index - this.bauteile.size()).getEinzelPreisBruttoNumeric());
            }
            if (arg0.getName().equals("gesamtpreis")) {
                return new Double(this.arbeiten.get(this.index - this.bauteile.size()).getGesamtPreisBruttoNumeric());
            }
            if (arg0.getName().equals("aktiv")) {
                return true;
            }
            return null;
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.bauteile.size() + this.arbeiten.size();
    }

    public int getAnzahlDerVorgaenger() {
        return this.mAnzahlDerVorgaenger;
    }

    public String getFirmenName() {
        return this.mFirmenName;
    }

    public String getFilialName() {
        return this.mFilialName;
    }
}

