/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.score;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.AnfrageHandler;
import de.esg.zub.common.MainController;
import de.esg.zub.configurator.content.ClientKonfiguration;
import de.esg.zub.configurator.content.anfrage.AnfragenDataLoader;
import de.esg.zub.configurator.content.kalkulation.KalkulationDataLoader;
import de.esg.zub.configurator.workflow.ControllerMenuBar;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.ObjectLockedException;
import webetk.app.zub.verwaltung.Anfrage;
import webetk.app.zub.verwaltung.Konfiguration;
import webetk.app.zub.verwaltung.KonfigurationsPosition;
import webetk.app.zub.verwaltung.Vorgang;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubVerwaltung;
import webetk.etkscore.ZubIspaPaketliste;
import webetk.etkscore.ZubIspaPaketlistePosition;
import webetk.etkscore.ZubIspaZubehoerpakete;
import webetk.resources.Resource;

public class ZubScoreDataCreator {
    private static ZubScoreDataCreator mInstance = null;
    private int mCountKonfig;
    static Logger log = Logger.getLogger(AnfrageHandler.class);

    private ZubScoreDataCreator() {
    }

    public static ZubScoreDataCreator getInstance() {
        if (mInstance == null) {
            mInstance = new ZubScoreDataCreator();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZubIspaZubehoerpakete calculateAllKonfigurationen() {
        try {
            MainController.getInstance().getMainFrame().setBusiCursor();
            Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
            ZubIspaZubehoerpakete zubPakete = new ZubIspaZubehoerpakete();
            ArrayList<ZubIspaPaketliste> zubListenPaket = new ArrayList<ZubIspaPaketliste>();
            if (anfrage.getVorgang().getKonfiguration().getAngebot() != null) {
                zubListenPaket.add(this.createZubehoerpaketlistePosition(true, anfrage.getVorgang()));
                zubPakete.setAngebotsnummer(Integer.valueOf(anfrage.getVorgang().getKonfiguration().getAnfrageId()));
                try {
                    this.setzeFlagAnIspa(anfrage.getVorgang().getKonfiguration().getKonfigurationsId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error((Object)("Setze Flag anIspa : " + e.getMessage()));
                }
            } else {
                int sizeVorgaenge = anfrage.getVorgangsId().size();
                boolean weitermachen = this.calculateCountVorgaenge();
                if (!weitermachen) {
                    ZubIspaZubehoerpakete zubIspaZubehoerpakete = null;
                    return zubIspaZubehoerpakete;
                }
                for (int jj = 0; jj < sizeVorgaenge; ++jj) {
                    int vorgangId = anfrage.getVorgangsId().get(jj);
                    try {
                        Vorgang vorgang = anfrage.getVorgang();
                        if (vorgangId != 0) {
                            vorgang = KalkulationDataLoader.ladeVorgang(vorgangId);
                        }
                        int sizeKonfig = vorgang.getKonfigurationsId().size();
                        log.debug((Object)("Konfigurationen des Vorgangs " + vorgang.getProduktName() + " mit ID " + vorgang.getVorgangsId() + " durchlaufen und ZubIspaPaketliste erstellen"));
                        for (int ii = 0; ii < sizeKonfig; ++ii) {
                            int konfigId = vorgang.getKonfigurationsId().get(ii);
                            try {
                                Konfiguration konfiguration = anfrage.getVorgang().getKonfiguration();
                                if (konfigId != 0) {
                                    konfiguration = KalkulationDataLoader.ladeKonfiguration(konfigId);
                                    GlobalObjects.getInstance().getIpacData().getAnfrage().getVorgang().setKonfiguration(konfiguration);
                                    ClientKonfiguration konfig = ClientKonfiguration.getClientKonfiguration();
                                    konfig.setKonfiguration(konfiguration);
                                    konfig.setKalkulationSet(true);
                                    konfig.setSaved(true);
                                    AnfrageHandler.getInstance().refreshKonfiguration(GlobalObjects.getInstance().getIpacData().getAnfrage(), konfig, true);
                                }
                                zubListenPaket.add(this.createZubehoerpaketlistePosition(false, vorgang));
                                continue;
                            }
                            catch (Exception e1) {
                                log.debug((Object)"Fehler beim Erzeugen der Zubehoerpakete f\u00fcr ISPA beim Laden einer Konfiguration");
                                log.error((Object)e1.getMessage());
                                e1.printStackTrace();
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.debug((Object)"Fehler beim Erzeugen der Zubehoerpakete f\u00fcr ISPA beim Laden des Vorgangs");
                        log.error((Object)e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            zubPakete.setPaketliste(zubListenPaket.toArray(new ZubIspaPaketliste[zubListenPaket.size()]));
            try {
                AnfragenDataLoader.entsperreAnfrage(GlobalObjects.getInstance().getIpacData().getAnfrage().getAnfrageId());
            }
            catch (ObjectLockedException e1) {
                log.error((Object)("Fehler beim Entsperren der Anfrage mit der Id: " + anfrage.getAnfrageId()));
                e1.printStackTrace();
            }
            catch (Exception e1) {
                log.error((Object)("Fehler beim Entsperren der Anfrage mit der Id: " + anfrage.getAnfrageId()));
                e1.printStackTrace();
            }
            if (anfrage.getVorgang().getKonfiguration().getAngebot() == null) {
                try {
                    AnfragenDataLoader.loescheAnfrage(anfrage.getAnfrageId());
                }
                catch (Exception e) {
                    log.error((Object)("Fehler beim L\u00f6schen der Anfrage mit der Id: " + anfrage.getAnfrageId()));
                    e.printStackTrace();
                }
            }
            ZubIspaZubehoerpakete zubIspaZubehoerpakete = zubPakete;
            return zubIspaZubehoerpakete;
        }
        finally {
            MainController.getInstance().getMainFrame().setDefaultCursor();
        }
    }

    private void setzeFlagAnIspa(int konfigId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("konfigurationsId", konfigId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.SET_AN_ISPA);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
    }

    public ZubIspaPaketliste createZubehoerpaketlistePosition(boolean isAngebot, Vorgang vorgang) {
        MainController.getInstance().getMainFrame().setBusiCursor();
        System.out.println("Create Zubehoerpakete  ! ! !");
        ClientKonfiguration ck = ClientKonfiguration.getClientKonfiguration();
        if (ck.getKalkulationModel() == null) {
            ck.estimateKalkulationModelFromTechnik(GlobalObjects.getInstance().getIpacData().getAnfrage(), true);
        }
        log.debug((Object)("ZubIspaPaketliste f\u00fcr " + ck.getKalkulationModel().getKonfiguration().getKonfigurationsName()));
        ArrayList positionenList = (ArrayList)ck.getKalkulationModel().getKonfiguration().getPositionen();
        int size = positionenList.size();
        ZubIspaPaketlistePosition[] zubPositionen = new ZubIspaPaketlistePosition[size];
        int zeile = 0;
        for (int ii = 0; ii < positionenList.size(); ++ii) {
            KonfigurationsPosition pos = (KonfigurationsPosition)positionenList.get(ii);
            ZubIspaPaketlistePosition zubpos = new ZubIspaPaketlistePosition();
            zubpos.setBezeichnung(pos.getArtikelBenennung());
            zubpos.setNummer(pos.getArtikelNummer());
            zubpos.setMenge(pos.getMenge());
            if (isAngebot) {
                zubpos.setEinzelpreisnetto(Double.valueOf(pos.getPreis()));
                double mwstsatz = 1.0 + pos.getMwstSatz() / 100.0;
                double rabattsatz = 1.0 - pos.getRabatt();
                double preis = Math.floor(pos.getPreis() * mwstsatz * 100.0 + 0.5) / 100.0;
                zubpos.setEinzelpreisbrutto(Double.valueOf(preis));
                zubpos.setEinzelpreismitrabattnetto(Double.valueOf(pos.getPreis() * rabattsatz));
                preis = Math.floor(pos.getPreis() * rabattsatz * mwstsatz * 100.0 + 0.5) / 100.0;
                zubpos.setEinzelpreismitrabattbrutto(Double.valueOf(preis));
                zubpos.setMwstsatz(Double.valueOf(pos.getMwstSatz()));
                zubpos.setPreispositionnetto(Double.valueOf(pos.getGesamtPreis()));
                zubpos.setPreispositionbrutto(Double.valueOf(pos.getGesamtPreis() + mwstsatz));
                zubpos.setRabatt(Double.valueOf(pos.getRabatt()));
            }
            zubPositionen[zeile] = zubpos;
            ++zeile;
        }
        ZubIspaPaketliste zubliste = new ZubIspaPaketliste();
        zubliste.setPositionen(zubPositionen);
        String bildPosNr = "0";
        if (vorgang.getBildPos() != null) {
            bildPosNr = vorgang.getBildPos();
        }
        zubliste.setProduktid(vorgang.getBtNummer() + "_" + bildPosNr);
        log.debug((Object)("Produktid = " + vorgang.getBtNummer() + "_" + bildPosNr));
        String variante = "";
        if (ck.getMarketingModel().getSelectedVariante() != null && ck.getMarketingModel().getSelectedVariante().getName() != null) {
            variante = "_" + ck.getMarketingModel().getSelectedVariante().getName();
        }
        zubliste.setBezeichnung(vorgang.getPlainProduktName() + variante + "_" + ck.getKonfigurationsName());
        if (isAngebot) {
            zubliste.setAufab(Double.valueOf(ck.getKalkulationModel().getAufAbschlag()));
            double preis = Math.floor(ck.getKalkulationModel().getGesamtPreis() * 100.0 + 0.5) / 100.0;
            zubliste.setGesamtpreisbrutto(Double.valueOf(preis));
            zubliste.setGesamtpreisnetto(Double.valueOf(ck.getKalkulationModel().getNettoPreis()));
            zubliste.setMwst(Double.valueOf(Math.floor(ck.getKalkulationModel().getMwSt() * 100.0 + 0.5) / 100.0));
        }
        return zubliste;
    }

    private boolean calculateCountVorgaenge() {
        MainController.getInstance().getMainFrame().setBusiCursor();
        Anfrage anfrage = GlobalObjects.getInstance().getIpacData().getAnfrage();
        this.mCountKonfig = 0;
        int sizeVorgaenge = anfrage.getVorgangsId().size();
        ArrayList<Integer> vorgaenge = new ArrayList<Integer>();
        boolean result = true;
        for (int jj = 0; jj < sizeVorgaenge; ++jj) {
            int vorgangId = anfrage.getVorgangsId().get(jj);
            try {
                int count = 1;
                if (vorgangId != 0) {
                    count = this.bestimmeAnzahlKonfigurationen(vorgangId);
                }
                this.mCountKonfig += count;
                System.out.println("Anzahl Konfigurationen des Vorgangs " + vorgangId + " = " + count);
                if (count <= 1) continue;
                vorgaenge.add(vorgangId);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
        }
        if (vorgaenge.size() > 0) {
            if (vorgaenge.size() == 1) {
                result = MainController.getInstance().getMainFrame().showConfirmMessage(Resource.getInstance().getKonfMessage());
            }
            if (vorgaenge.size() > 1) {
                result = MainController.getInstance().getMainFrame().showConfirmMessage(Resource.getInstance().getVorgMessage());
            }
            try {
                if (anfrage.getVorgang().getVorgangsId() != ((Integer)vorgaenge.get(0)).intValue()) {
                    ControllerMenuBar.getInstance().handleLadeVorgangEvent((Integer)vorgaenge.get(0));
                }
            }
            catch (Exception e) {
                log.debug((Object)"Erzeugung der ISPA-Pakete: Fehler beim Laden des Vorgangs");
                log.error((Object)e.getMessage());
                e.printStackTrace();
            }
            return result;
        }
        return result;
    }

    private int bestimmeAnzahlKonfigurationen(int vorgangsId) throws Exception {
        TrfZubVerwaltung verwaltung = new TrfZubVerwaltung(null);
        verwaltung.setValue("vorgangsId", vorgangsId);
        GlobalObjects.getInstance().getServiceExecutor().executeService(verwaltung, Command.ERMITTLE_ANZAHL_KONFIG_VON_VORGANG);
        if (verwaltung.getError() != null) {
            throw verwaltung.getError();
        }
        return (Integer)verwaltung.getValue("anzahlSuchergebnisse");
    }
}

