/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class AdjustableLineBorder
extends AbstractBorder {
    private boolean paintTopLine = true;
    private boolean paintBottomLine = true;
    private boolean paintLeftLine = true;
    private boolean paintRightLine = true;
    private int thickness;
    private Color topColor;
    private Color bottomColor;
    private Color rightColor;
    private Color leftColor;

    public AdjustableLineBorder(Color color, int thickness) {
        this.topColor = color;
        this.bottomColor = color;
        this.rightColor = color;
        this.leftColor = color;
        this.thickness = thickness;
    }

    public void setBorderVisibility(boolean top, boolean left, boolean bottom, boolean right) {
        this.paintTopLine = top;
        this.paintBottomLine = bottom;
        this.paintLeftLine = left;
        this.paintRightLine = right;
    }

    public boolean isBottomLineVisible() {
        return this.paintBottomLine;
    }

    public void setVisibilityOfBottomLine(boolean visible) {
        this.paintBottomLine = visible;
    }

    public boolean isLeftLineVisible() {
        return this.paintLeftLine;
    }

    public void setVisibilityOfLeftLine(boolean visible) {
        this.paintLeftLine = visible;
    }

    public boolean isRightLineVisible() {
        return this.paintRightLine;
    }

    public void setVisibilityOfRightLine(boolean visible) {
        this.paintRightLine = visible;
    }

    public boolean isTopLineVisible() {
        return this.paintTopLine;
    }

    public void setVisibilityOfTopLine(boolean visible) {
        this.paintTopLine = visible;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return super.getBorderInsets(c, insets);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return super.getBorderInsets(c);
    }

    @Override
    public boolean isBorderOpaque() {
        return super.isBorderOpaque();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.paintRightLine) {
            g2.setColor(this.rightColor);
            g2.fillRect(x + width - 1, y, this.thickness, height);
        }
        if (this.paintLeftLine) {
            g2.setColor(this.leftColor);
            g2.fillRect(x, y, this.thickness, height);
        }
        if (this.paintTopLine) {
            g2.setColor(this.topColor);
            g2.fillRect(x, y, width, this.thickness);
        }
        if (this.paintBottomLine) {
            g2.setColor(this.bottomColor);
            g2.fillRect(x, y + height - 1, width, this.thickness);
        }
    }

    public Color getLineColor() {
        if (this.topColor.equals(this.bottomColor) && this.bottomColor.equals(this.rightColor) && this.rightColor.equals(this.leftColor)) {
            return this.leftColor;
        }
        return null;
    }

    public Color getBottomColor() {
        return this.bottomColor;
    }

    public void setBottomColor(Color bottomColor) {
        this.bottomColor = bottomColor;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    public Color getTopColor() {
        return this.topColor;
    }

    public void setTopColor(Color topColor) {
        this.topColor = topColor;
    }

    public int getThickness() {
        return this.thickness;
    }
}

