/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Logger;

public class CssEditorKit
extends HTMLEditorKit {
    private static StyleSheet styleSheet;
    private static final Logger logger;

    @Override
    public String getContentType() {
        return "text/html";
    }

    @Override
    public StyleSheet getStyleSheet() {
        if (styleSheet == null) {
            styleSheet = this.loadStyleSheet();
        }
        return styleSheet;
    }

    private StyleSheet loadStyleSheet() {
        StyleSheet result = new StyleSheet();
        URL url = CssEditorKit.class.getResource("/css/style.css");
        try {
            InputStream istr = url.openStream();
            InputStreamReader in = new InputStreamReader(istr);
            result.loadRules(in, url);
        }
        catch (Exception ex) {
            logger.error((Object)("An error occurred while loading the style sheet from " + url), (Throwable)ex);
            System.out.println(ex);
        }
        return result;
    }

    static {
        logger = Logger.getLogger(CssEditorKit.class);
    }
}

