/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities;

import de.esg.zub.customizable.ZubCustomizable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class CurrencyFormatter {
    private static CurrencyFormatter mInstance = null;
    private String waehrung = ZubCustomizable.getInstance().getWaehrungsKz();

    private CurrencyFormatter() {
        if (this.waehrung == null || this.waehrung.length() <= 0) {
            this.waehrung = "";
        }
    }

    public static CurrencyFormatter getInstance() {
        if (mInstance == null) {
            mInstance = new CurrencyFormatter();
        }
        return mInstance;
    }

    public String getFormattedCurrency(Double betrag) {
        if (betrag == null) {
            return "?.??";
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat decimalFormat = new DecimalFormat("0.00", symbols);
        String betragText = decimalFormat.format(betrag);
        return betragText + " " + this.waehrung;
    }
}

