/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities;

import de.esg.zub.utilities.viewcomp.JLabel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class RequiredFieldChecker {
    private String errorMessage;
    private String errorTextComplete;
    private List<TextFieldLabelMapper> requiredFields = new ArrayList<TextFieldLabelMapper>();

    public RequiredFieldChecker(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void addRequiredField(JTextComponent comp, JLabel label) {
        this.requiredFields.add(new TextFieldLabelMapper(comp, label));
    }

    public void clearChecks() {
        this.requiredFields.clear();
    }

    public JComponent validate() {
        this.errorTextComplete = null;
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder bui = new StringBuilder();
        JTextComponent comp = null;
        for (TextFieldLabelMapper c : this.requiredFields) {
            String labelText;
            if (c.getComponent().getText() != null && c.getComponent().getText().length() != 0 && c.getComponent().getText().trim().length() != 0) continue;
            if (comp == null && c.getComponent().isEnabled()) {
                comp = c.getComponent();
            }
            if ((labelText = c.getLabel().getText()).length() > 0 && labelText.endsWith(":")) {
                labelText = labelText.substring(0, labelText.length() - 1).trim();
            }
            String message = MessageFormat.format(this.errorMessage, "\"" + labelText + "\"");
            errors.add(message);
            bui.append(message).append("\n");
        }
        if (bui.toString() != null) {
            this.errorTextComplete = bui.toString();
        }
        return comp;
    }

    public String getErrorString() {
        return this.errorTextComplete;
    }

    private static class TextFieldLabelMapper {
        private static final long serialVersionUID = 1L;
        private JTextComponent component;
        private JLabel label;

        public TextFieldLabelMapper(JTextComponent component, JLabel label) {
            this.component = component;
            this.label = label;
        }

        public JTextComponent getComponent() {
            return this.component;
        }

        public void setComponent(JTextComponent component) {
            this.component = component;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setLabel(JLabel label) {
            this.label = label;
        }
    }
}

