/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities.viewcomp;

import de.esg.zub.utilities.viewcomp.JTextField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JPatternTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    Matcher matcher;

    public JPatternTextField(String pattern) {
        this.matcher = Pattern.compile(pattern).matcher("");
        this.setDocument(new PatternDocument(this.matcher));
    }

    public JPatternTextField(String pattern, int columns) {
        super(columns);
        this.matcher = Pattern.compile(pattern).matcher("");
        this.setDocument(new PatternDocument(this.matcher));
    }

    public JPatternTextField(String pattern, String text, int columns, int maxChars) {
        super(text, columns);
        this.matcher = Pattern.compile(pattern).matcher("");
        this.setDocument(new PatternDocument(maxChars, this.matcher));
    }

    public JPatternTextField(String pattern, String text, int columns) {
        super(text, columns);
        this.matcher = Pattern.compile(pattern).matcher("");
        this.setDocument(new PatternDocument(this.matcher));
    }

    public JPatternTextField(String pattern, String text) {
        super(text);
        this.matcher = Pattern.compile(pattern).matcher("");
        this.setDocument(new PatternDocument(this.matcher));
    }

    @Override
    public void setMaxCharacters(int maxChars) {
        this.setDocument(new PatternDocument(maxChars, this.matcher));
    }

    private static class PatternDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int limit;
        private boolean toUppercase = false;
        Matcher matcher;

        public PatternDocument(Matcher matcher) {
            this.matcher = matcher;
            this.limit = -1;
        }

        PatternDocument(int limit, Matcher matcher) {
            this.limit = limit;
            this.matcher = matcher;
        }

        PatternDocument(int limit, boolean upper, Matcher matcher) {
            this.limit = limit;
            this.toUppercase = upper;
            this.matcher = matcher;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null || str.length() == 0) {
                return;
            }
            PlainDocument doc = new PlainDocument();
            doc.insertString(0, this.getText(0, this.getLength()), attr);
            doc.insertString(offset, str, attr);
            this.matcher.reset(doc.getText(0, doc.getLength()));
            if ((this.limit == -1 || this.getLength() + str.length() <= this.limit) && this.matcher.matches()) {
                if (this.toUppercase) {
                    str = str.toUpperCase();
                }
                super.insertString(offset, str, attr);
            }
        }
    }
}

