/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.utilities.viewcomp;

import de.esg.zub.common.Constants;
import de.esg.zub.common.MarkenLayout;
import java.awt.Color;
import java.awt.Font;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTextField
extends javax.swing.JTextField {
    private static final long serialVersionUID = 1L;

    public JTextField(String text, int columns, int maxChars) {
        this.setDocument(new SetMaxText(maxChars));
        super.setColumns(columns);
        super.setFont(Constants.Layout.getJTextFieldDefaultFont());
        super.setText(text);
    }

    public JTextField(int columns) {
        super(columns);
        super.setFont(Constants.Layout.getJTextFieldDefaultFont());
    }

    public JTextField(String text, int columns) {
        super.setColumns(columns);
        super.setFont(Constants.Layout.getJTextFieldDefaultFont());
        super.setText(text);
    }

    public JTextField(String text) {
        super.setFont(Constants.Layout.getJTextFieldDefaultFont());
        super.setText(text);
    }

    public JTextField() {
        super.setFont(Constants.Layout.getJTextFieldDefaultFont());
    }

    public void setMaxCharacters(int maxChars) {
        this.setDocument(new SetMaxText(maxChars));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.getBackground().equals(Constants.Layout.BLACK_COLOR)) {
            if (!isEnabled) {
                this.setBackground(Constants.Layout.BLACK_COLOR);
                this.setForeground(Color.GRAY);
            } else {
                this.setBackground(Constants.Layout.BLACK_COLOR);
                this.setForeground(Constants.Layout.WHITE_COLOR);
            }
        } else if (!isEnabled) {
            this.setBackground(Constants.Layout.WHITE_COLOR);
            this.setForeground(Color.GRAY);
        } else {
            this.setBackground(Constants.Layout.WHITE_COLOR);
            this.setForeground(Constants.Layout.BLACK_COLOR);
        }
    }

    @Override
    public void setFont(Font font) {
    }

    public void setBoldFont() {
        super.setFont(Constants.Layout.getZubBoldFont());
    }

    public void setSmallboldFont() {
        super.setFont(Constants.Layout.getZubSmallBoldFont());
    }

    public void setDefaultFont() {
        super.setFont(Constants.Layout.getZubDefaultFont());
    }

    public void setBigFont() {
        super.setFont(Constants.Layout.getZubBigFont());
    }

    public void setStyle(MarkenLayout mLayout, boolean isNavi) {
        this.setSelectedTextColor(mLayout.getSelectedReiterForeground());
        this.setSelectionColor(mLayout.getSelectedReiterBackground());
        if (isNavi) {
            this.setForeground(mLayout.getPrimaryForeground());
            this.setBackground(mLayout.getPrimaryBackground());
        } else {
            this.setForeground(Constants.Layout.BLACK_COLOR);
            this.setBackground(Constants.Layout.WHITE_COLOR);
        }
    }

    private static class SetMaxText
    extends PlainDocument {
        private int limit;
        private boolean toUppercase = false;

        SetMaxText(int limit) {
            this.limit = limit;
        }

        SetMaxText(int limit, boolean upper) {
            this.limit = limit;
            this.toUppercase = upper;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                if (this.toUppercase) {
                    str = str.toUpperCase();
                }
                super.insertString(offset, str, attr);
            }
        }
    }
}

