/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.welcome;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MainController;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.configurator.content.admin.ControllerAdminPanel;
import de.esg.zub.configurator.content.anfrage.ControllerAnfragenPanel;
import de.esg.zub.configurator.content.angebot.ControllerAngebotsPanel;
import de.esg.zub.configurator.content.technisch.ControllerTechnikPanel;
import de.esg.zub.configurator.workflow.WorkflowController;
import de.esg.zub.utilities.viewcomp.JOptionPane;
import de.esg.zub.welcome.HomePanel;
import de.esg.zub.welcome.MarkenPanel;
import de.esg.zub.welcome.WelcomePanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfZubMisc;
import webetk.mrkprd.Marken;
import webetk.mrkprd.Produkte;

public class ControllerWelcomePanel {
    private boolean mAdminVisible = false;
    private boolean isWelcomeReiterEnable = true;
    private boolean isNeuAnfrageReiterEnable = true;
    private boolean isBestAnfrageReiterEnable = true;
    private boolean isAngebotReiterEnable = true;
    private static ControllerWelcomePanel mInstance = null;
    private static Logger log;
    private WelcomePanel mWelcomePanel;
    private HomePanel mHomePanel;
    private MarkenPanel mMarkenPanel;

    public static void setMarkeProduktartGlobal(String marke, String produkt) {
        WorkflowController.getInstance().setMarkenLayout(marke, produkt);
        GlobalObjects.getInstance().getSessionInfo().setMarke(marke);
        GlobalObjects.getInstance().getSessionInfo().setProduktart(produkt);
        ControllerWelcomePanel.setzeServerSessionInfo(marke, produkt);
        GlobalObjects.getInstance().getSessionInfo().setKatalogumfang("VT");
        if (ControllerTechnikPanel.getInstance().getModel() != null) {
            ControllerTechnikPanel.getInstance().setModel(null);
        }
    }

    private boolean checkDataAdmin() {
        boolean changed = false;
        if (this.mAdminVisible) {
            if (GlobalObjects.getInstance().getSessionInfo().getLogin().equals("admin")) {
                ControllerAdminPanel.getInstance().stopEditingTable();
                if (ControllerAdminPanel.getInstance().checkFilialDatenChanged()) {
                    changed = true;
                }
            }
            if (ControllerAdminPanel.getInstance().checkNutzerDatenChanged()) {
                changed = true;
            }
            if (changed) {
                if (ControllerAdminPanel.getInstance().popUpSpeichernGesamt() != 2) {
                    this.mAdminVisible = false;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private ControllerWelcomePanel() {
    }

    public static ControllerWelcomePanel getInstance() {
        if (mInstance == null) {
            mInstance = new ControllerWelcomePanel();
            log = Logger.getLogger(ControllerWelcomePanel.class);
            log.debug((Object)"WelcomeController initialisiert");
            mInstance.init();
        }
        return mInstance;
    }

    public static void reset() {
        mInstance = null;
    }

    private void init() {
        Dimension wPSize = MainController.getInstance().getMainFrame().getFrameSize();
        MarkenLayout markenLayout = WorkflowController.getInstance().getMarkenLayout();
        this.mWelcomePanel = new WelcomePanel(wPSize, markenLayout);
        this.createHomePanel(markenLayout);
        this.createMarkenPanel(markenLayout);
        ControllerAnfragenPanel.getInstance().init(this.mWelcomePanel.getContentSize(), WorkflowController.getInstance().getMarkenLayout());
        ControllerAngebotsPanel.getInstance().init(this.mWelcomePanel.getContentSize(), WorkflowController.getInstance().getMarkenLayout());
        for (int i = 0; i < this.mWelcomePanel.getMenus().size(); ++i) {
            this.mWelcomePanel.getMenus().get(i).addMouseListener(new WelcomePanelMouseListener());
        }
    }

    public void refreshWelcomePanel() {
        MarkenLayout markenLayout = WorkflowController.getInstance().getMarkenLayout();
        this.createHomePanel(markenLayout);
        this.createMarkenPanel(markenLayout);
    }

    private void createHomePanel(MarkenLayout markenLayout) {
        this.mHomePanel = new HomePanel(this.mWelcomePanel.getContentSize(), markenLayout);
        this.mHomePanel.getContentPanel().addMouseListener(new HilfeMouseListener("i5400"));
    }

    private void createMarkenPanel(MarkenLayout markenLayout) {
        this.mMarkenPanel = new MarkenPanel(this.mWelcomePanel.getContentSize(), markenLayout);
        for (int i = 0; i < this.mMarkenPanel.getMarkenImages().size(); ++i) {
            this.mMarkenPanel.getMarkenImages().get(i).addMouseListener(new WelcomePanelMouseListener());
            this.mMarkenPanel.getMarkenBeschriftungen().get(i).addMouseListener(new WelcomePanelMouseListener());
        }
    }

    public void entry() {
        this.mWelcomePanel.setPanel(this.mHomePanel);
        this.mWelcomePanel.setSelectedReiter("Home");
        MainController.getInstance().getMainFrame().addPanel(this.mWelcomePanel);
    }

    private static void setzeServerSessionInfo(String marke, String produktArt) {
        TrfZubMisc misc = new TrfZubMisc(null);
        misc.setValue("marke", marke);
        misc.setValue("produktart", produktArt);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(misc, Command.SETZE_MARKE);
        }
        catch (CommunicationException e) {
            log.error((Object)"Kommunikationsfehler beim Setzen der Marke und Produktart am Server!", (Throwable)e);
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), e.getMessage());
        }
        if (misc.getError() != null) {
            log.error((Object)"Sonstiger Fehler beim Setzen der Marke und Produktart am Server", (Throwable)misc.getError());
            MainController.getInstance().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog((Component)MainController.getInstance().getMainFrame(), misc.getError().getMessage());
        }
    }

    public HomePanel getHomePanel() {
        return this.mHomePanel;
    }

    public MarkenPanel getMarkenPanel() {
        return this.mMarkenPanel;
    }

    public WelcomePanel getWelcomePanel() {
        return this.mWelcomePanel;
    }

    public void setAdminVisible() {
        this.mWelcomePanel.setSelectedReiter("Admin");
        ControllerAdminPanel.getInstance().init(this.mWelcomePanel.getContentSize(), WorkflowController.getInstance().getMarkenLayout());
        this.mWelcomePanel.setPanel(ControllerAdminPanel.getInstance().getAdminPanel());
        this.mAdminVisible = true;
    }

    public void setEnableReiter(boolean enable) {
        this.isWelcomeReiterEnable = enable;
        this.isNeuAnfrageReiterEnable = enable;
        this.isBestAnfrageReiterEnable = enable;
        this.isAngebotReiterEnable = enable;
    }

    private class WelcomePanelMouseListener
    extends MouseAdapter {
        private WelcomePanelMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(3));
                if (e.getButton() == 3) {
                    return;
                }
                if (ControllerWelcomePanel.this.checkDataAdmin()) {
                    return;
                }
                if (e.getComponent().getName().equals("Home")) {
                    if (ControllerWelcomePanel.this.isWelcomeReiterEnable) {
                        ControllerWelcomePanel.this.mWelcomePanel.setPanel(ControllerWelcomePanel.this.mHomePanel);
                        ControllerWelcomePanel.this.mWelcomePanel.setSelectedReiter("Home");
                    }
                } else if (e.getComponent().getName().equals("Neue Anfrage")) {
                    if (ControllerWelcomePanel.this.isNeuAnfrageReiterEnable) {
                        ControllerWelcomePanel.this.mWelcomePanel.setSelectedReiter("Neue Anfrage");
                        GlobalObjects.getInstance().getIpacData().setAnfrage(null);
                        if (GlobalObjects.getInstance().getIpacData().isUs()) {
                            WorkflowController.getInstance().changeState("CONFIG");
                            ControllerWelcomePanel.setMarkeProduktartGlobal(Marken.getInstance().getMarke("BMW").getBerechtigung(), Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
                        } else {
                            Collection<String> sProdukte = GlobalObjects.getInstance().getSessionInfo().getUserProdukte();
                            if (GlobalObjects.getInstance().getSessionInfo().getUserMarken().size() == 1 && sProdukte.size() == 1) {
                                WorkflowController.getInstance().changeState("CONFIG");
                                String sMarke = null;
                                String sProdukt = null;
                                Iterator<String> i$ = GlobalObjects.getInstance().getSessionInfo().getUserMarken().iterator();
                                if (i$.hasNext()) {
                                    String marke;
                                    sMarke = marke = i$.next();
                                }
                                if ((i$ = sProdukte.iterator()).hasNext()) {
                                    String produkt;
                                    sProdukt = produkt = i$.next();
                                }
                                ControllerWelcomePanel.setMarkeProduktartGlobal(sMarke, sProdukt);
                            } else {
                                ControllerWelcomePanel.this.mWelcomePanel.setPanel(ControllerWelcomePanel.this.mMarkenPanel);
                            }
                        }
                    }
                } else if (e.getComponent().getName().equals("Bestehende Anfragen")) {
                    if (ControllerWelcomePanel.this.isBestAnfrageReiterEnable) {
                        ControllerWelcomePanel.this.mWelcomePanel.setSelectedReiter("Bestehende Anfragen");
                        if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                            ControllerAnfragenPanel.getInstance().getAnfragenPanel().getSuchkriterienPanel().setVinField(GlobalObjects.getInstance().getIpacData().getVINfromISPA());
                            ControllerAnfragenPanel.getInstance().sucheAnfragen();
                        }
                        ControllerWelcomePanel.this.mWelcomePanel.setPanel(ControllerAnfragenPanel.getInstance().getAnfragenPanel());
                    }
                } else if (e.getComponent().getName().equals("Angebot")) {
                    if (ControllerWelcomePanel.this.isAngebotReiterEnable) {
                        ControllerWelcomePanel.this.mWelcomePanel.setSelectedReiter("Angebot");
                        if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                            ControllerAngebotsPanel.getInstance().getAngebotsPanel().getSuchkriterienPanel2().setVinField(GlobalObjects.getInstance().getIpacData().getVINfromISPA());
                            ControllerAngebotsPanel.getInstance().sucheAngebote();
                        }
                        ControllerWelcomePanel.this.mWelcomePanel.setPanel(ControllerAngebotsPanel.getInstance().getAngebotsPanel());
                    }
                } else if (e.getComponent().getName().equals("Admin")) {
                    if (!GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                        ControllerWelcomePanel.this.setAdminVisible();
                    }
                } else {
                    if (e.getComponent().equals(ControllerWelcomePanel.this.mMarkenPanel.getContentPanel())) {
                        ControllerWelcomePanel.setMarkeProduktartGlobal(Marken.getInstance().getMarke("BMW").getBerechtigung(), Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung());
                    } else {
                        String[] sMarkeProdukt = e.getComponent().getName().split(";");
                        ControllerWelcomePanel.setMarkeProduktartGlobal(sMarkeProdukt[0], sMarkeProdukt[1]);
                    }
                    WorkflowController.getInstance().changeState("CONFIG");
                }
            }
            finally {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

