/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.welcome;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.common.ViewComponent;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.welcome.AbstractWelcomeContent;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import webetk.mrkprd.MarkeProdukt;
import webetk.mrkprd.MarkenProdukte;

public class HomePanel
extends AbstractWelcomeContent {
    public HomePanel(Dimension panelSize, MarkenLayout markenLayout) {
        super(panelSize, markenLayout);
        this.setImagePanel();
        this.mContentPanel.validate();
    }

    private void setImagePanel() {
        Collection<String> userMarkenList = GlobalObjects.getInstance().getSessionInfo().getUserMarken();
        Collection<String> userProdukteList = GlobalObjects.getInstance().getSessionInfo().getUserProdukte();
        Collection<String> marktProdukteList = GlobalObjects.getInstance().getSessionInfo().getSettings().getIPACMarkt() != null ? GlobalObjects.getInstance().getSessionInfo().getSettings().getIPACMarkt().getProdukte() : null;
        boolean isUs = GlobalObjects.getInstance().getIpacData().isUs();
        this.mContentPanel.setLayout(null);
        int pictureWidth = 480;
        int pictureHeight = 305;
        int gapX = 180;
        int gapY = 150;
        ArrayList<ViewComponent> components = new ArrayList<ViewComponent>();
        ArrayList<MarkeProdukt> ldarfMarkenProdukte = MarkenProdukte.getInstance(2).getBerechtigteMarkenProdukte(userMarkenList, userProdukteList, marktProdukteList, isUs);
        for (MarkeProdukt oMarkeProdukt : ldarfMarkenProdukte) {
            ViewComponent viewComp = new ViewComponent();
            String sImageName = oMarkeProdukt.getImageWelcome();
            viewComp.setImage(ImageCache.getInstance().getImage(sImageName), 0, 0, pictureWidth, pictureHeight);
            viewComp.setImageLocation(sImageName);
            boolean bViewCompVorhanden = false;
            for (ViewComponent viewComponent : components) {
                if (!viewComponent.getImageLocation().equalsIgnoreCase(sImageName)) continue;
                bViewCompVorhanden = true;
                break;
            }
            if (bViewCompVorhanden) continue;
            components.add(viewComp);
        }
        double factor = 2.0 * (double)(components.size() - 1) / (double)components.size();
        int posX = (int)(this.mContentPanel.getPreferredSize().getWidth() - (double)(components.size() * pictureWidth) + (double)(components.size() - 1) * factor * (double)gapX) / 2;
        int posY = (int)(this.mContentPanel.getPreferredSize().getHeight() - (double)(components.size() * pictureHeight) + (double)(components.size() - 1) * factor * (double)gapY) / 2;
        for (int i = 0; i < components.size(); ++i) {
            int startX = (int)((double)(posX + (components.size() - i - 1) * pictureWidth) - (double)(components.size() - i - 1) * factor * (double)gapX);
            int startY = (int)((double)(posY + (components.size() - i - 1) * pictureHeight) - (double)(components.size() - i - 1) * factor * (double)gapY);
            ((ViewComponent)components.get(i)).setBounds(startX, startY, pictureWidth, pictureHeight);
            this.mContentPanel.add((Component)components.get(i));
        }
    }
}

