/*
 * Decompiled with CFR 0.152.
 */
package de.esg.zub.welcome;

import de.esg.commonclient.GlobalObjects;
import de.esg.zub.common.HilfeMouseListener;
import de.esg.zub.common.MarkenLayout;
import de.esg.zub.utilities.AdjustableLineBorder;
import de.esg.zub.utilities.ImageCache;
import de.esg.zub.utilities.viewcomp.JLabel;
import de.esg.zub.welcome.AbstractWelcomeContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import webetk.resources.Resource;

public class WelcomePanel
extends JPanel {
    private JPanel headerPanel;
    private JPanel menuPanel;
    private JPanel contentContainer;
    private AbstractWelcomeContent mAktuellContent;
    private MarkenLayout mMarkenLayout;
    private ArrayList<JLabel> menus;
    private Dimension mHeaderSize;
    private Dimension mMenuSize;
    private Dimension mContentSize;
    private Dimension mWelcomePanelSize;

    public WelcomePanel(Dimension welcomePanelSize, MarkenLayout markenLayout) {
        this.mWelcomePanelSize = welcomePanelSize;
        this.mMarkenLayout = markenLayout;
        this.mHeaderSize = new Dimension(this.mWelcomePanelSize.width, 100);
        this.mMenuSize = new Dimension(this.mWelcomePanelSize.width, 25);
        this.mContentSize = new Dimension(this.mWelcomePanelSize.width, this.mWelcomePanelSize.height - 110 - 25);
        this.setLayout(new GridBagLayout());
        this.setSize(welcomePanelSize);
        GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.add((Component)this.createHeaderPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0));
        this.add((Component)this.createMenuPanel(), gbc);
        gbc = this.mMarkenLayout.setGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
        this.add((Component)this.createContentContainer(), gbc);
    }

    private JPanel createHeaderPanel() {
        JLabel nameLabel = new JLabel(Resource.getInstance().getIpacTitel(), 2);
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setPreferredSize(this.mHeaderSize);
            this.headerPanel.setMinimumSize(this.mHeaderSize);
            this.headerPanel.setBackground(this.mMarkenLayout.getPrimaryBackground());
            this.headerPanel.setLayout(new GridBagLayout());
            nameLabel.setHeaderFont();
            nameLabel.setForeground(this.mMarkenLayout.getPrimaryForeground());
            GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 30, 0, 30));
            this.headerPanel.add((Component)nameLabel, gbc);
        }
        return this.headerPanel;
    }

    private JPanel createMenuPanel() {
        if (this.menuPanel == null) {
            this.menuPanel = new JPanel(new GridBagLayout());
            this.menuPanel.setPreferredSize(this.mMenuSize);
            this.menuPanel.setMinimumSize(this.mMenuSize);
            this.createMenus();
            for (int i = 0; i < this.menus.size(); ++i) {
                GridBagConstraints gbc = this.mMarkenLayout.setGridBagConstraints(i, 0, 1, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0));
                this.menuPanel.add((Component)this.menus.get(i), gbc);
            }
        }
        return this.menuPanel;
    }

    private ArrayList<JLabel> createMenus() {
        String beschriftung = "";
        if (this.menus == null) {
            this.menus = new ArrayList(5);
            AdjustableLineBorder borderLayout = new AdjustableLineBorder(Color.WHITE, 1);
            Dimension menuDim = new Dimension(this.mMenuSize.width / 5, this.mMenuSize.height);
            Icon img = ImageCache.getInstance().getIcon("home_small.gif");
            JLabel label = new JLabel(img, 0);
            label.setPreferredSize(menuDim);
            label.setMinimumSize(menuDim);
            label.setBackground(this.mMarkenLayout.getTertiaryBackground());
            label.setOpaque(true);
            label.setForeground(this.mMarkenLayout.getTertiaryForeground());
            label.setName("Home");
            borderLayout.setBorderVisibility(true, true, true, true);
            label.setBorder(borderLayout);
            this.menus.add(0, label);
            label = new JLabel(Resource.getInstance().getNeueAnfrage(), 0);
            label.setPreferredSize(menuDim);
            label.setMinimumSize(menuDim);
            label.setBackground(this.mMarkenLayout.getTertiaryBackground());
            label.setOpaque(true);
            label.setForeground(this.mMarkenLayout.getTertiaryForeground());
            label.setName("Neue Anfrage");
            borderLayout.setBorderVisibility(true, false, true, true);
            label.setBorder(borderLayout);
            label.addMouseListener(new HilfeMouseListener("i50032"));
            this.menus.add(1, label);
            beschriftung = Resource.getInstance().getBestehendeAnfragen();
            if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                beschriftung = beschriftung + " (" + GlobalObjects.getInstance().getIpacData().getAnzahlAnfragen() + ") ";
            }
            label = new JLabel(beschriftung, 0);
            label.setPreferredSize(menuDim);
            label.setMinimumSize(menuDim);
            label.setBackground(this.mMarkenLayout.getTertiaryBackground());
            label.setOpaque(true);
            label.setForeground(this.mMarkenLayout.getTertiaryForeground());
            label.setName("Bestehende Anfragen");
            borderLayout.setBorderVisibility(true, false, true, true);
            label.setBorder(borderLayout);
            label.addMouseListener(new HilfeMouseListener("i6040"));
            this.menus.add(2, label);
            beschriftung = Resource.getInstance().getBestehendeAngebote();
            if (GlobalObjects.getInstance().getIpacData().isStartedFromISPA()) {
                beschriftung = beschriftung + " (" + GlobalObjects.getInstance().getIpacData().getAnzahlAngebote() + ") ";
            }
            label = new JLabel(beschriftung, 0);
            label.setPreferredSize(menuDim);
            label.setMinimumSize(menuDim);
            label.setBackground(this.mMarkenLayout.getTertiaryBackground());
            label.setOpaque(true);
            label.setForeground(this.mMarkenLayout.getTertiaryForeground());
            label.setName("Angebot");
            borderLayout.setBorderVisibility(true, false, true, true);
            label.setBorder(borderLayout);
            label.addMouseListener(new HilfeMouseListener("i6060"));
            this.menus.add(3, label);
            label = new JLabel(Resource.getInstance().getAdmin(), 0);
            label.setPreferredSize(menuDim);
            label.setMinimumSize(menuDim);
            label.setBackground(this.mMarkenLayout.getTertiaryBackground());
            label.setOpaque(true);
            label.setForeground(this.mMarkenLayout.getTertiaryForeground());
            label.setName("Admin");
            borderLayout.setBorderVisibility(true, false, true, true);
            label.setBorder(borderLayout);
            label.addMouseListener(new HilfeMouseListener("i5400"));
            this.menus.add(4, label);
        }
        return this.menus;
    }

    private JPanel createContentContainer() {
        if (this.contentContainer == null) {
            this.contentContainer = new JPanel(new GridBagLayout());
            this.contentContainer.setPreferredSize(this.mContentSize);
            this.contentContainer.setMinimumSize(this.mContentSize);
            this.contentContainer.setBackground(this.mMarkenLayout.getSecondaryBackground());
        }
        return this.contentContainer;
    }

    public void setPanel(AbstractWelcomeContent panel) {
        this.contentContainer.removeAll();
        this.mAktuellContent = panel;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.contentContainer.add((Component)this.mAktuellContent.getContentPanel(), gbc);
        this.contentContainer.validate();
        this.contentContainer.updateUI();
        this.validate();
    }

    public ArrayList<JLabel> getMenus() {
        return this.menus;
    }

    public Dimension getContentSize() {
        return this.mContentSize;
    }

    public void setSelectedReiter(String name) {
        for (JLabel head : this.menus) {
            Icon img;
            if (head.getName().equals(name)) {
                if (head.getName().equals("Home")) {
                    img = this.mMarkenLayout.getTransparentImageIcon(ImageCache.getInstance().getImage("home_small_dark2.gif"), this.mMarkenLayout.getPrimaryBackground());
                    head.setIcon(img);
                }
                head.setBackground(this.mMarkenLayout.getSecondaryBackground());
                head.setForeground(this.mMarkenLayout.getSecondaryForeground());
                continue;
            }
            if (head.getName().equals("Home")) {
                img = ImageCache.getInstance().getIcon("home_small.gif");
                head.setIcon(img);
            }
            head.setBackground(this.mMarkenLayout.getTertiaryBackground());
            head.setForeground(this.mMarkenLayout.getTertiaryForeground());
        }
        this.validate();
        this.updateUI();
    }

    public void setBeschriftungBestehendeAnfragen() {
        String beschriftung = Resource.getInstance().getBestehendeAnfragen() + " (" + GlobalObjects.getInstance().getIpacData().getAnzahlAngebote() + ") ";
        this.menus.get(2).setText(beschriftung);
        this.validate();
        this.updateUI();
    }
}

