/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.app.Bedingung;
import webetk.app.BedingungLongTypeAdapter;
import webetk.app.BedingungStringTypeAdapter;
import webetk.app.Bedingungsmenge;
import webetk.app.Bedingungswert;
import webetk.app.cache.CBTEBedingungsmenge;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.BTEBedingungsmenge")
public class BTEBedingungsmenge
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(BTEBedingungsmenge.class);
    @XmlElement
    private boolean mbIsReperatur = true;
    @XmlElement
    private String msBTE;
    @XmlElement
    private long mlModellspalte;
    @XmlElements(value={@XmlElement(type=String.class)})
    private Collection<String> mcRelevanteBildposNr;
    @XmlElement
    @XmlJavaTypeAdapter(value=BedingungStringTypeAdapter.class)
    protected Hashtable<String, ArrayList<Integer>> mVariantenZuRelevantenBildposNr = new Hashtable();
    @XmlElement
    @XmlJavaTypeAdapter(value=BedingungLongTypeAdapter.class)
    private Hashtable<Long, Bedingungswert> mhBedingungswerte = new Hashtable();
    @XmlElement
    private Bedingungsmenge moBedingungen = null;

    public BTEBedingungsmenge() {
    }

    public BTEBedingungsmenge(String sBTENr, long lModellspalte, Bedingungsmenge oBedSet) {
        this.mbIsReperatur = true;
        this.msBTE = sBTENr;
        this.mlModellspalte = lModellspalte;
        this.moBedingungen = oBedSet == null ? new Bedingungsmenge() : oBedSet;
        this.mhBedingungswerte = new Hashtable();
    }

    public BTEBedingungsmenge(String sBTENr, Collection<String> cRelevanteBildposNr, Hashtable<String, ArrayList<Integer>> hVariantenZuBildpos, long lModellspalte, Bedingungsmenge oBedSet) {
        this.mbIsReperatur = false;
        this.msBTE = sBTENr;
        this.mlModellspalte = lModellspalte;
        this.mcRelevanteBildposNr = cRelevanteBildposNr;
        this.mVariantenZuRelevantenBildposNr = hVariantenZuBildpos;
        this.moBedingungen = oBedSet == null ? new Bedingungsmenge() : oBedSet;
        this.mhBedingungswerte = new Hashtable();
    }

    public String getBTE() {
        return this.msBTE;
    }

    public void load(String sLanguage, boolean bNachruestRelevant, boolean bIGDOMaktiv, Boolean bUSATyp, Boolean bVinIdentif) throws SQLException, DatabaseBusyException {
        boolean igDOM = bIGDOMaktiv;
        boolean isNachruestRelevant = !bNachruestRelevant && !igDOM ? true : bNachruestRelevant;
        this.mhBedingungswerte = this.mbIsReperatur ? this.moBedingungen.loadAdditional(sLanguage, this.msBTE, this.mlModellspalte, isNachruestRelevant, bUSATyp, bVinIdentif) : this.moBedingungen.loadAdditional(sLanguage, this.msBTE, this.mcRelevanteBildposNr, this.mlModellspalte, isNachruestRelevant, bUSATyp, bVinIdentif);
    }

    public Hashtable<Long, Bedingungswert> getWerteTable() {
        return this.mhBedingungswerte;
    }

    public Bedingungsmenge getBedingungsmenge() {
        return this.moBedingungen;
    }

    public String getBedNamen(Long lBed) {
        return this.moBedingungen.getBedNamen(lBed);
    }

    public Bedingung getBed(Long lBed) {
        return this.moBedingungen.getBed(lBed);
    }

    public String getBedWert(Long lBed) {
        if (this.mhBedingungswerte == null) {
            return null;
        }
        Bedingungswert oWert = this.mhBedingungswerte.get(lBed);
        if (oWert == null) {
            return null;
        }
        return oWert.toString();
    }

    public void setBedWert(Long lBed, Bedingungswert oWert) throws InvalidDataException {
        log.debug((Object)("Setting value for condition " + lBed.toString() + " to " + oWert.toString()));
        String sCurrentValue = this.getBedWert(lBed);
        if (sCurrentValue != null && oWert.equals(sCurrentValue)) {
            return;
        }
        this.moBedingungen.setBedingungsWert(lBed, oWert, this.mhBedingungswerte);
    }

    public void resetWerte() {
        if (this.mhBedingungswerte == null) {
            return;
        }
        Enumeration<Long> eBeds = this.mhBedingungswerte.keys();
        while (eBeds.hasMoreElements()) {
            Long lBedId = eBeds.nextElement();
            if (lBedId == null) continue;
            try {
                this.mhBedingungswerte.put(lBedId, new Bedingungswert("0"));
            }
            catch (InvalidInitializationException invalidInitializationException) {}
        }
    }

    public void setWerte(Collection<Object> cSalaIds) {
        if (this.mhBedingungswerte == null) {
            return;
        }
        Enumeration<Long> eBeds = this.mhBedingungswerte.keys();
        while (eBeds.hasMoreElements()) {
            Long lBedId = eBeds.nextElement();
            if (lBedId == null) continue;
            try {
                this.mhBedingungswerte.put(lBedId, new Bedingungswert("2"));
            }
            catch (InvalidInitializationException e) {}
        }
        for (Object object : cSalaIds) {
            String sBed = object.toString();
            try {
                this.mhBedingungswerte.put(new Long(sBed), new Bedingungswert("1"));
            }
            catch (InvalidInitializationException e) {}
        }
    }

    public void goFirst() throws NoDataFoundException {
        this.moBedingungen.goFirst();
    }

    public void next() throws NoDataFoundException {
        this.moBedingungen.next();
    }

    public boolean isBteBedingung(Long lBed) {
        return lBed != null && this.mhBedingungswerte.get(lBed) != null;
    }

    public boolean hasNext() throws NoDataFoundException {
        return this.moBedingungen.hasNext();
    }

    public String getCurrentIdAsString() {
        return this.moBedingungen.getCurrentIdAsString();
    }

    public Long getCurrentId() {
        return this.moBedingungen.getCurrentId();
    }

    public String getCurrentCode() {
        return this.moBedingungen.getCurrentCode();
    }

    public String getCurrentBenennung() {
        return this.moBedingungen.getCurrentBenennung();
    }

    public String getCurrentWert() {
        return this.moBedingungen.getCurrentWert();
    }

    public void setCurrentWert(String sWert) throws InvalidInitializationException {
        this.moBedingungen.setCurrentWert(sWert);
    }

    public Boolean getCurrentNachruestungAufNein() {
        return this.moBedingungen.getCurrentNachruestungAufNein();
    }

    public String getCurrentIndex(String sArt) {
        return Integer.toString(this.getCurrentIndexAsInteger(sArt));
    }

    public int getCurrentIndexAsInteger(String sArt) {
        Long lBedIdAkt = this.getCurrentId();
        TreeSet<Bedingung> cSortedKeys = this.moBedingungen.getSortedKeys();
        Iterator<Bedingung> iterator = cSortedKeys.iterator();
        int nIndex = 1;
        while (iterator.hasNext()) {
            Bedingung oBed = iterator.next();
            Long lBedId = oBed.getId();
            String sAktWert = this.getBedWert(lBedId);
            if (lBedId.compareTo(new Long(33691L)) == 0 || lBedId.compareTo(new Long(31929L)) == 0 || lBedId.compareTo(new Long(31744L)) == 0) {
                log.debug((Object)(" lBedId : " + lBedId + " BedWert: " + sAktWert));
            }
            if (sAktWert == null) {
                sAktWert = this.getBedingungsmenge().getBedWert(lBedId);
            }
            if (!oBed.showBed(sArt, sAktWert)) continue;
            if (lBedId.compareTo(lBedIdAkt) == 0) {
                return nIndex;
            }
            ++nIndex;
        }
        return nIndex;
    }

    public boolean isCurrentSchnittstellenBed() {
        return this.moBedingungen.isCurrentSchnittstellenBed();
    }

    public boolean isCurrentBedingungExclusive() {
        return this.moBedingungen.isCurrentBedingungExclusive();
    }

    public boolean showCurrentBed(String sArt) {
        return this.moBedingungen.showCurrentBed(sArt);
    }

    public boolean alleWerteGesetzt() {
        if (this.mhBedingungswerte == null) {
            return true;
        }
        Enumeration<Bedingungswert> eBeds = this.mhBedingungswerte.elements();
        while (eBeds.hasMoreElements()) {
            Bedingungswert oWert = eBeds.nextElement();
            String sValue = oWert.toString();
            if (!sValue.equals("0")) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllValuesSet() {
        return this.moBedingungen.vergleicheBedMenge(this.mhBedingungswerte);
    }

    public void uebernehmenWerte(boolean bOverwrite, boolean bInsert) {
        log.debug((Object)("Retreiving values from condition set: " + this.moBedingungen.toString()));
        boolean bDoSet = false;
        Enumeration<Long> eBeds = this.moBedingungen.getBedingungen();
        while (eBeds.hasMoreElements()) {
            bDoSet = false;
            Long lBed = eBeds.nextElement();
            log.log((Priority)Level.ALL, (Object)("Checking condition: " + lBed.toString()));
            String sValue = this.moBedingungen.getBedWert(lBed);
            bDoSet = this.mhBedingungswerte.containsKey(lBed) ? bOverwrite : bInsert;
            if (!bDoSet) continue;
            try {
                this.mhBedingungswerte.put(lBed, new Bedingungswert(sValue));
            }
            catch (InvalidInitializationException e) {
                log.error((Object)"One of the values in the other Bedingungsmenge is not valid!");
            }
            log.log((Priority)Level.ALL, (Object)("Setting value for condition (" + lBed.toString() + ") to: " + sValue));
        }
    }

    public Vector loadHotspotsForBild(String sBildId, String sFormFaktor) {
        return null;
    }

    public boolean hasBedingungen() {
        if (this.moBedingungen == null) {
            return false;
        }
        return this.moBedingungen.hasBedingungen();
    }

    public Object clone() throws CloneNotSupportedException {
        Object key;
        BTEBedingungsmenge copy = (BTEBedingungsmenge)super.clone();
        copy.mbIsReperatur = this.mbIsReperatur;
        copy.msBTE = this.msBTE == null ? null : new String(this.msBTE);
        copy.mlModellspalte = this.mlModellspalte;
        copy.mcRelevanteBildposNr = this.mcRelevanteBildposNr == null ? null : new Vector();
        copy.mVariantenZuRelevantenBildposNr = this.mVariantenZuRelevantenBildposNr == null ? null : new Hashtable();
        copy.mhBedingungswerte = this.mhBedingungswerte == null ? null : new Hashtable();
        Bedingungsmenge bedingungsmenge = copy.moBedingungen = this.moBedingungen == null ? null : this.moBedingungen.copy();
        if (this.mcRelevanteBildposNr != null) {
            for (String value : this.mcRelevanteBildposNr) {
                copy.mcRelevanteBildposNr.add(new String(value));
            }
        }
        if (this.mVariantenZuRelevantenBildposNr != null) {
            Enumeration<String> variantenZuRelevantenBildposNrIter = this.mVariantenZuRelevantenBildposNr.keys();
            while (variantenZuRelevantenBildposNrIter.hasMoreElements()) {
                key = variantenZuRelevantenBildposNrIter.nextElement();
                ArrayList<Integer> values = this.mVariantenZuRelevantenBildposNr.get(key);
                ArrayList<Integer> valuesCopy = new ArrayList<Integer>();
                for (Integer value : values) {
                    valuesCopy.add(new Integer(value));
                }
                copy.mVariantenZuRelevantenBildposNr.put(new String((String)key), valuesCopy);
            }
        }
        if (this.mhBedingungswerte != null) {
            Enumeration<Long> hBedingungswerteIter = this.mhBedingungswerte.keys();
            while (hBedingungswerteIter.hasMoreElements()) {
                key = hBedingungswerteIter.nextElement();
                Bedingungswert value = this.mhBedingungswerte.get(key);
                copy.mhBedingungswerte.put(new Long((Long)key), value.copy());
            }
        }
        return copy;
    }

    public BTEBedingungsmenge copy() throws CloneNotSupportedException {
        Object copy = this.clone();
        if (copy instanceof BTEBedingungsmenge) {
            return (BTEBedingungsmenge)copy;
        }
        throw new CloneNotSupportedException("Not an instance of class " + this.getClass().getName());
    }

    public boolean alleBedingungswerteEindeutig() {
        Bedingungsmenge oBedingungen = this.getBedingungsmenge();
        try {
            oBedingungen.goFirst();
            boolean bIsFinished = false;
            while (!bIsFinished) {
                int nCurrentStatus;
                String sCurrentWert = oBedingungen.getCurrentWert();
                if (oBedingungen.isCurrentBteBedingung() && (nCurrentStatus = sCurrentWert.equals("1") ? 1 : (sCurrentWert.equals("2") ? 2 : 3)) == 3) {
                    return false;
                }
                bIsFinished = !oBedingungen.hasNext();
                if (bIsFinished) continue;
                oBedingungen.next();
            }
        }
        catch (NoDataFoundException exc) {
            log.error((Object)exc.getMessage());
            return false;
        }
        return true;
    }

    public boolean alleWerteOriginal(String sBTENr) {
        CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
        BTEBedingungsmenge oBTEOriginale = oCache.get(sBTENr);
        if (oBTEOriginale == null) {
            return true;
        }
        Bedingungsmenge oOriginale = oBTEOriginale.getBedingungsmenge();
        Bedingungsmenge oBedingungen = this.getBedingungsmenge();
        try {
            oBedingungen.goFirst();
            boolean bIsFinished = false;
            while (!bIsFinished) {
                if (oBedingungen.isCurrentBteBedingung()) {
                    Long lCurrentID = oBedingungen.mlCurrentId;
                    String sCurrentWert = oBedingungen.getCurrentWert();
                    int nCurrentStatus = sCurrentWert.equals("1") ? 1 : (sCurrentWert.equals("2") ? 2 : 3);
                    String sOriginalWert = oOriginale.getBedWert(lCurrentID);
                    if (sOriginalWert == null) {
                        return true;
                    }
                    int nOriginalStatus = sOriginalWert.equals("1") ? 1 : (sOriginalWert.equals("2") ? 2 : 3);
                    if (nCurrentStatus != nOriginalStatus) {
                        return false;
                    }
                }
                if (bIsFinished = !oBedingungen.hasNext()) continue;
                oBedingungen.next();
            }
        }
        catch (NoDataFoundException exc) {
            log.error((Object)exc.getMessage());
            return false;
        }
        return true;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        BTEBedingungsmenge.log = log;
    }

    public boolean isMbIsReperatur() {
        return this.mbIsReperatur;
    }

    public void setMbIsReperatur(boolean mbIsReperatur) {
        this.mbIsReperatur = mbIsReperatur;
    }

    public String getMsBTE() {
        return this.msBTE;
    }

    public void setMsBTE(String msBTE) {
        this.msBTE = msBTE;
    }

    public long getMlModellspalte() {
        return this.mlModellspalte;
    }

    public void setMlModellspalte(long mlModellspalte) {
        this.mlModellspalte = mlModellspalte;
    }

    public Collection<String> getMcRelevanteBildposNr() {
        return this.mcRelevanteBildposNr;
    }

    public void setMcRelevanteBildposNr(Collection<String> mcRelevanteBildposNr) {
        this.mcRelevanteBildposNr = mcRelevanteBildposNr;
    }

    public Hashtable<String, ArrayList<Integer>> getmVariantenZuRelevantenBildposNr() {
        return this.mVariantenZuRelevantenBildposNr;
    }

    public void setmVariantenZuRelevantenBildposNr(Hashtable<String, ArrayList<Integer>> mVariantenZuRelevantenBildposNr) {
        this.mVariantenZuRelevantenBildposNr = mVariantenZuRelevantenBildposNr;
    }

    public Hashtable<Long, Bedingungswert> getMhBedingungswerte() {
        return this.mhBedingungswerte;
    }

    public void setMhBedingungswerte(Hashtable<Long, Bedingungswert> mhBedingungswerte) {
        this.mhBedingungswerte = mhBedingungswerte;
    }

    public Bedingungsmenge getMoBedingungen() {
        return this.moBedingungen;
    }

    public void setMoBedingungen(Bedingungsmenge moBedingungen) {
        this.moBedingungen = moBedingungen;
    }
}

