/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingung;
import webetk.app.BedingungLongTypeAdapter;
import webetk.app.BedingungStringTypeAdapter;
import webetk.app.Bedingungswert;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.BedAuswertungDbAccess;
import webetk.db.zub.dbaccess.TechnischDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Bedingungsmenge
implements Serializable,
Cloneable {
    protected Long mlCurrentId = null;
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Bedingungsmenge.class);
    @XmlElement
    @XmlJavaTypeAdapter(value=BedingungLongTypeAdapter.class)
    protected Hashtable<Long, Bedingung> mhBedingungen;
    @XmlElement
    @XmlJavaTypeAdapter(value=BedingungLongTypeAdapter.class)
    protected Hashtable<Long, Bedingungswert> mhBedingungsWerte = new Hashtable();
    @XmlElement
    @XmlJavaTypeAdapter(value=BedingungLongTypeAdapter.class)
    protected Hashtable<Long, Boolean> mhNachruestungAufNein;
    @XmlElement
    @XmlJavaTypeAdapter(value=BedingungStringTypeAdapter.class)
    private Hashtable<String, Vector<Long>> mhExclusiveGruppen;
    protected transient Iterator<Bedingung> mIterator = null;
    @XmlElement
    protected TreeSet<Bedingung> mcSortedKeys = null;

    public Bedingungsmenge() {
        this.mhBedingungen = new Hashtable();
        this.mhNachruestungAufNein = new Hashtable();
        this.mhExclusiveGruppen = new Hashtable();
        this.mcSortedKeys = new TreeSet<Bedingung>(new BedingungsKomparator("btanzeige_ungefiltert"));
    }

    public void sort(String sArt) {
        BedingungsKomparator oKomparator = (BedingungsKomparator)this.mcSortedKeys.comparator();
        String sArtOld = oKomparator.getArt();
        boolean bToSort = false;
        if (sArt.equals("ausstattungen") && !sArtOld.equals("ausstattungen") || !sArt.equals("ausstattungen") && sArtOld.equals("ausstattungen")) {
            bToSort = true;
        }
        if (!bToSort) {
            return;
        }
        TreeSet tsSave = (TreeSet)this.mcSortedKeys.clone();
        this.mcSortedKeys.clear();
        this.mcSortedKeys = new TreeSet<Bedingung>(new BedingungsKomparator(sArt));
        this.mcSortedKeys.addAll(tsSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Long, Bedingungswert> loadAdditional(String sLanguage, String sBteNr, long lMosp, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Hashtable<Long, Bedingungswert> hBteBedWerte = new Hashtable<Long, Bedingungswert>();
        log.info((Object)("Adding conditions for (BTE: " + sBteNr + ", Modellspalte: " + lMosp + ", Language: " + sLanguage + ") to set."));
        this.resetBteBedingungenFlag();
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Bedingungsmenge.loadAdditional");
            log.debug((Object)"Retrieving AFL's ...");
            res = BedAuswertungDbAccess.loadBTEBedingungenAFL(con, sBteNr, lMosp, sLanguage);
            this.insertBedingungen('A', res, hBteBedWerte, bNachruestRelevant, bUSATyp, bVinIdentif);
            WebetkUtils.closeQuery(res);
            log.debug((Object)"Retrieving SALAPA's ...");
            res = BedAuswertungDbAccess.loadBTEBedingungenSala(con, sBteNr, lMosp, sLanguage);
            this.insertBedingungen('S', res, hBteBedWerte, bNachruestRelevant, bUSATyp, bVinIdentif);
            WebetkUtils.closeQuery(res);
            log.debug((Object)"Retrieving Textbedingungen ...");
            res = BedAuswertungDbAccess.loadBTEBedingungenText(con, sBteNr, lMosp, sLanguage);
            this.insertBedingungen('T', res, hBteBedWerte, bNachruestRelevant, bUSATyp, bVinIdentif);
            log.debug((Object)"Done.");
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Bedingungsmenge.loadAdditional");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Bedingungsmenge.loadAdditional");
        return hBteBedWerte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Long, Bedingungswert> loadAdditional(String sLanguage, String sBteNr, Collection<String> cRelevanteBildPosNr, long lMosp, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Hashtable<Long, Bedingungswert> hBteBedWerte = new Hashtable<Long, Bedingungswert>();
        log.info((Object)("Adding conditions for (BTE: " + sBteNr + ", Modellspalte: " + lMosp + ", Language: " + sLanguage + ") to set."));
        this.resetBteBedingungenFlag();
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Bedingungsmenge.loadAdditional");
            log.debug((Object)"Retrieving SALAPA's ...");
            res = TechnischDbAccess.loadZubBildtafelBedingungenSala(con, sBteNr, cRelevanteBildPosNr, lMosp, sLanguage);
            this.insertBedingungen('S', res, hBteBedWerte, bNachruestRelevant, bUSATyp, bVinIdentif);
            WebetkUtils.closeQuery(res);
            log.debug((Object)"Retrieving Textbedingungen ...");
            res = TechnischDbAccess.loadZubBildtafelBedingungenText(con, sBteNr, cRelevanteBildPosNr, lMosp, sLanguage);
            this.insertBedingungen('T', res, hBteBedWerte, bNachruestRelevant, bUSATyp, bVinIdentif);
            log.debug((Object)"Done.");
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Bedingungsmenge.loadAdditional");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Bedingungsmenge.loadAdditional");
        return hBteBedWerte;
    }

    private synchronized void resetBteBedingungenFlag() {
        for (Bedingung bed : this.mcSortedKeys) {
            bed.isBteBedingung(false);
        }
    }

    public Collection<Bedingung> getSonderausstattungen() {
        Vector<Bedingung> cSonderausstatungen = new Vector<Bedingung>();
        for (Bedingung bed : this.mcSortedKeys) {
            bed.isBteBedingung(false);
            if (bed.getBedingungsartSS() == null || !bed.getBedingungsartSS().equals("S_SONDER")) continue;
            cSonderausstatungen.add(bed);
        }
        return cSonderausstatungen;
    }

    public Collection<Bedingung> getSerienausstattungen() {
        Vector<Bedingung> cSerienausstattungen = new Vector<Bedingung>();
        for (Bedingung bed : this.mcSortedKeys) {
            bed.isBteBedingung(false);
            if (bed.getBedingungsartSS() == null || !bed.getBedingungsartSS().equals("S_SERIE")) continue;
            cSerienausstattungen.add(bed);
        }
        return cSerienausstattungen;
    }

    public Collection<Bedingung> getInformationen() {
        Vector<Bedingung> cInformationen = new Vector<Bedingung>();
        for (Bedingung bed : this.mcSortedKeys) {
            bed.isBteBedingung(false);
            if (bed.getBedingungsartSS() == null || !bed.getBedingungsartSS().equals("S_INFORMATION")) continue;
            cInformationen.add(bed);
        }
        return cInformationen;
    }

    private void insertBedingungen(char cArt, ResultSet res, Hashtable<Long, Bedingungswert> hBteBedWerte, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif) throws SQLException, DatabaseBusyException {
        boolean bHatSchnittstellenBed = this.hatSchnittstellenBedingungen();
        while (res != null && res.next()) {
            Long lId = new Long(res.getLong("ElementId"));
            String sBedCode = "";
            if (cArt != 'T') {
                sBedCode = res.getString("Code");
            }
            String sBedName = res.getString("Benennung");
            boolean bExclusiveGruppe = res.getString("Exklusiv").equalsIgnoreCase("J");
            String sGruppe = bExclusiveGruppe ? res.getString("EGruppenId") : null;
            long lGruppenPos = res.getLong("EGruppenPosition");
            String sPrimaNr = null;
            boolean bIsSAZ = false;
            if (cArt == 'S') {
                sPrimaNr = res.getString("PrimaNr");
                String sIsSAZ = res.getString("SAZ");
                bIsSAZ = sIsSAZ != null && sIsSAZ.equalsIgnoreCase("J");
            }
            String sLogMsg = "Inserting condition (ID: " + lId.toString();
            sLogMsg = sLogMsg + ", Code: " + sBedCode + ", Name: " + sBedName;
            sLogMsg = sLogMsg + ", Group: " + sGruppe + ", PosNr: " + Long.toString(lGruppenPos);
            sLogMsg = sLogMsg + ", Primanummer: " + sPrimaNr;
            sLogMsg = sLogMsg + ", Group: " + sGruppe + ", Exclusive: ";
            sLogMsg = sLogMsg + (bExclusiveGruppe ? "yes" : "no");
            sLogMsg = sLogMsg + ", ist SAZ: " + (bIsSAZ ? "yes)" : "no)");
            log.debug((Object)sLogMsg);
            String sBedWert = "0";
            Boolean bNachruestAufNein = Boolean.FALSE;
            Bedingung oBed = this.mhBedingungen.get(lId);
            if (oBed != null) {
                oBed.isBteBedingung(true);
                oBed.isSAZ(bIsSAZ);
            } else {
                if (cArt == 'A') {
                    oBed = new Bedingung(lId, sBedCode, sBedName, sGruppe, lGruppenPos);
                }
                if (cArt == 'S') {
                    oBed = new Bedingung(lId, sBedCode, sBedName, sGruppe, lGruppenPos, sPrimaNr);
                    oBed.isSAZ(bIsSAZ);
                }
                if (cArt == 'T') {
                    oBed = new Bedingung(lId, sBedName, sGruppe, lGruppenPos);
                }
                oBed.isBteBedingung(true);
                this.mhBedingungen.put(lId, oBed);
                this.mcSortedKeys.add(oBed);
                if (bExclusiveGruppe) {
                    Vector<Long> cGruppe = this.mhExclusiveGruppen.get(sGruppe);
                    if (cGruppe == null) {
                        cGruppe = new Vector();
                    }
                    for (Long lIdBedSchonDrin : cGruppe) {
                        String sBedWertSchonDrin = this.getBedWert(lIdBedSchonDrin);
                        if (!sBedWertSchonDrin.equals("1")) continue;
                        sBedWert = "2";
                    }
                    cGruppe.add(lId);
                    this.mhExclusiveGruppen.put(sGruppe, cGruppe);
                }
                if (oBed.getBedingungsOberart() == 'S' && bHatSchnittstellenBed && !oBed.isSchnittstellenBed() && !oBed.isSAZ()) {
                    sBedWert = "2";
                }
                if (oBed.getBedingungsOberart() == 'S' && !oBed.isSchnittstellenBed() && oBed.isSAZ() && !bNachruestRelevant) {
                    sBedWert = "2";
                    bNachruestAufNein = Boolean.TRUE;
                }
                boolean bUSATypSonderlocke = false;
                if (bUSATyp != null && bVinIdentif != null && bUSATyp.booleanValue() && bVinIdentif.booleanValue()) {
                    bUSATypSonderlocke = true;
                }
                if (oBed.getCode() != null && !oBed.getCode().equals("")) {
                    boolean bIsLaenderausfuehrung;
                    String sBedArt = oBed.getCode().substring(0, 1);
                    boolean bl = bIsLaenderausfuehrung = sBedArt.equals("L") || sBedArt.equals("Y");
                    if (bUSATypSonderlocke && oBed.getBedingungsOberart() == 'S' && !oBed.isSchnittstellenBed() && bIsLaenderausfuehrung && !oBed.getId().equals(new Long(32340L)) && !oBed.getId().equals(new Long(32216L))) {
                        sBedWert = "2";
                    }
                }
            }
            this.insertBedWert(lId, sBedWert, hBteBedWerte);
            this.insertNachruestungAufNein(lId, bNachruestAufNein);
        }
    }

    public String getBedNamen(Long lBed) {
        Bedingung oBed = this.mhBedingungen.get(lBed);
        if (oBed == null) {
            return null;
        }
        return oBed.getName();
    }

    public Bedingung getBed(Long lBed) {
        Bedingung oBed = this.mhBedingungen.get(lBed);
        return oBed;
    }

    public String getBedNameSchnittstelle(Long lBed) {
        Bedingung oBed = this.mhBedingungen.get(lBed);
        if (oBed == null) {
            return null;
        }
        return oBed.getNameSS();
    }

    public boolean isSchnittstellenBed(Long lBed) {
        Bedingung oBed = this.mhBedingungen.get(lBed);
        if (oBed == null) {
            return false;
        }
        return oBed.isSchnittstellenBed();
    }

    private void insertBedWert(Long lBedId, String sBedWert, Hashtable<Long, Bedingungswert> hBedWerte) {
        Bedingungswert oWert;
        if (this.mhBedingungsWerte == null) {
            this.mhBedingungsWerte = new Hashtable();
        }
        if ((oWert = this.mhBedingungsWerte.get(lBedId)) != null) {
            hBedWerte.put(lBedId, oWert);
            return;
        }
        try {
            oWert = new Bedingungswert(sBedWert);
            this.mhBedingungsWerte.put(lBedId, oWert);
            hBedWerte.put(lBedId, oWert);
        }
        catch (InvalidInitializationException e) {
            log.error((Object)"diese Exception kann gar nicht auftreten...");
        }
    }

    private void insertNachruestungAufNein(Long lBedId, Boolean bNachruest) {
        Boolean wert;
        if (this.mhNachruestungAufNein == null) {
            this.mhNachruestungAufNein = new Hashtable();
        }
        if ((wert = this.mhNachruestungAufNein.get(lBedId)) != null) {
            return;
        }
        wert = bNachruest;
        this.mhNachruestungAufNein.put(lBedId, wert);
    }

    public String getBedWert(Long lBed) {
        if (this.mhBedingungsWerte == null) {
            return null;
        }
        Bedingungswert oWert = this.mhBedingungsWerte.get(lBed);
        if (oWert == null) {
            return null;
        }
        return oWert.toString();
    }

    public void setBedWert(Long lBed, String sWert) throws InvalidInitializationException {
        if (this.mhBedingungsWerte == null) {
            throw new InvalidInitializationException("Bedingungswerte sind nicht vorhanden!");
        }
        if (lBed == null) {
            throw new InvalidInitializationException("ID der Bedingung nicht gesetzt!");
        }
        Bedingungswert oWert = this.mhBedingungsWerte.get(lBed);
        if (oWert == null) {
            throw new InvalidInitializationException("Fuer BedingungsID " + lBed.toString() + " ist keine Bedingung vorhanden!");
        }
        oWert.setWert(sWert);
    }

    public Boolean getNachruestungAufNein(Long lBed) {
        if (this.mhNachruestungAufNein == null) {
            return null;
        }
        Boolean wert = this.mhNachruestungAufNein.get(lBed);
        if (wert == null) {
            return null;
        }
        return wert;
    }

    public boolean hatSicherheitrelevanteBedingungen() {
        for (Bedingung bed : this.mcSortedKeys) {
            if (!bed.isSicherheitsrelevant()) continue;
            return true;
        }
        return false;
    }

    public boolean hatSchnittstellenBedingungen() {
        for (Bedingung bed : this.mcSortedKeys) {
            if (!bed.isSchnittstellenBed()) continue;
            return true;
        }
        return false;
    }

    public boolean hatNachruestenRelevantBTEBedingungen() {
        for (Bedingung bed : this.mcSortedKeys) {
            if (!bed.isBteBedingung() || bed.getBedingungsOberart() != 'S' || bed.isSchnittstellenBed() || !bed.isSAZ()) continue;
            return true;
        }
        return false;
    }

    public Collection<Long> getSchnittstellenBedingungen() {
        Vector<Long> cSalaIds = new Vector<Long>();
        for (Bedingung bed : this.mcSortedKeys) {
            if (!bed.isSchnittstellenBed()) continue;
            cSalaIds.add(bed.getId());
        }
        return cSalaIds;
    }

    public boolean hatAnzuzeigendeSchnittstellenBedingungen(String sArt) {
        for (Bedingung bed : this.mcSortedKeys) {
            String sAktWert = this.getBedWert(bed.getId());
            if (!bed.isSchnittstellenBed() || !bed.showBed(sArt, sAktWert)) continue;
            return true;
        }
        return false;
    }

    public void setBedingungsWert(Long lBed, Bedingungswert oWert, Hashtable<Long, Bedingungswert> hBedWerte) throws InvalidDataException {
        if (hBedWerte == null) {
            log.error((Object)"The set of condition of the BTE is null!!");
            throw new InvalidDataException("The set of condition of the BTE is null!!");
        }
        log.debug((Object)("Setting value for condition " + lBed.toString() + " to " + oWert.toString()));
        String sCurrentValue = this.getBedWert(lBed);
        if (sCurrentValue == null) {
            log.error((Object)("The condition " + lBed.toString() + " does not exist! Cannot set value."));
            throw new InvalidDataException("The condition " + lBed.toString() + " does not exist! Cannot set value.");
        }
        if (oWert.equals(sCurrentValue)) {
            return;
        }
        this.setBedWert(lBed, oWert);
        if (hBedWerte.containsKey(lBed)) {
            hBedWerte.put(lBed, oWert);
        }
        if (!oWert.equals("1")) {
            return;
        }
        Bedingung oBed = this.mhBedingungen.get(lBed);
        if (oBed == null) {
            log.error((Object)("The condition " + lBed.toString() + " does not exist! Cannot set value."));
            throw new InvalidDataException("The condition " + lBed.toString() + " does not exist! Cannot set value.");
        }
        String sGruppe = oBed.getGruppe();
        if (sGruppe == null) {
            return;
        }
        Collection cGruppe = this.mhExclusiveGruppen.get(sGruppe);
        if (cGruppe == null) {
            return;
        }
        for (Long lGruppenBed : cGruppe) {
            if (lGruppenBed == null || lGruppenBed.equals(lBed)) continue;
            log.debug((Object)("Recursive call for condition: " + lGruppenBed.toString()));
            try {
                this.setBedingungsWert(lGruppenBed, new Bedingungswert("2"), hBedWerte);
            }
            catch (InvalidInitializationException e) {}
        }
    }

    public Enumeration<Long> getBedingungen() {
        if (this.mhBedingungsWerte == null) {
            return null;
        }
        return this.mhBedingungsWerte.keys();
    }

    public void setBedWert(Long lBedId, Bedingungswert oWert) {
        if (this.mhBedingungsWerte == null) {
            this.mhBedingungsWerte = new Hashtable();
        }
        this.mhBedingungsWerte.put(lBedId, oWert);
    }

    public void resetWerte() {
        if (this.mhBedingungsWerte == null) {
            return;
        }
        Enumeration<Long> eBeds = this.getBedingungen();
        while (eBeds.hasMoreElements()) {
            Long lBedId = eBeds.nextElement();
            if (lBedId == null) continue;
            try {
                this.setBedWert(lBedId, new Bedingungswert("0"));
            }
            catch (InvalidInitializationException invalidInitializationException) {}
        }
    }

    public void goFirst() throws NoDataFoundException {
        this.mIterator = this.mcSortedKeys.iterator();
        if (!this.mIterator.hasNext()) {
            this.mlCurrentId = null;
            throw new NoDataFoundException("no bedingung found!");
        }
        Bedingung bed = this.mIterator.next();
        this.mlCurrentId = bed.getId();
    }

    public Bedingung next() {
        if (this.mIterator == null) {
            this.mIterator = this.mcSortedKeys.iterator();
        }
        if (this.mIterator.hasNext()) {
            Bedingung bed = this.mIterator.next();
            this.mlCurrentId = bed.getId();
            return bed;
        }
        this.mlCurrentId = null;
        return null;
    }

    public boolean hasNext() {
        if (this.mIterator == null) {
            this.mIterator = this.mcSortedKeys.iterator();
        }
        return this.mIterator.hasNext();
    }

    public String getCurrentIdAsString() {
        return this.mlCurrentId == null ? "" : this.mlCurrentId.toString();
    }

    public Long getCurrentId() {
        return this.mlCurrentId;
    }

    public String getCurrentCode() {
        if (this.mlCurrentId == null) {
            return "";
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return "";
        }
        return oBed.getCode();
    }

    public String getCurrentBenennung() {
        if (this.mlCurrentId == null) {
            return "";
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return "";
        }
        return oBed.getName();
    }

    public String getCurrentBenennungSS() {
        if (this.mlCurrentId == null) {
            return "";
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return "";
        }
        String sBenennungSchnittstelle = oBed.getNameSS();
        return sBenennungSchnittstelle == null ? "" : sBenennungSchnittstelle;
    }

    public boolean isCurrentBteBedingung() {
        if (this.mlCurrentId == null) {
            return false;
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return false;
        }
        return oBed.isBteBedingung();
    }

    public boolean isCurrentSchnittstellenBed() {
        if (this.mlCurrentId == null) {
            return false;
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return false;
        }
        return oBed.isSchnittstellenBed();
    }

    public boolean isCurrentBedSicherheitsrelvant() {
        if (this.mlCurrentId == null) {
            return false;
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return false;
        }
        return oBed.isSicherheitsrelevant();
    }

    public boolean showCurrentBed(String sArt) {
        if (this.mlCurrentId == null) {
            return false;
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return false;
        }
        String sAktWert = this.getBedWert(oBed.getId());
        return oBed.showBed(sArt, sAktWert);
    }

    public String getCurrentWert() {
        if (this.mlCurrentId == null) {
            return "";
        }
        return this.getBedWert(this.mlCurrentId);
    }

    public void setCurrentWert(String sWert) throws InvalidInitializationException {
        if (this.mlCurrentId == null) {
            throw new InvalidInitializationException("ID der aktuellen Bedingung nicht gesetzt!");
        }
        this.setBedWert(this.mlCurrentId, sWert);
    }

    public Boolean getCurrentNachruestungAufNein() {
        if (this.mlCurrentId == null) {
            return null;
        }
        return this.getNachruestungAufNein(this.mlCurrentId);
    }

    public String getCurrentIndex(String sArt) {
        if (this.mlCurrentId == null) {
            return "0";
        }
        return Integer.toString(this.getCurrentIndexAsInteger(sArt));
    }

    public int getCurrentIndexAsInteger(String sArt) {
        Long lBedIdAkt = this.getCurrentId();
        Iterator<Bedingung> iterator = this.mcSortedKeys.iterator();
        int nIndex = 1;
        while (iterator.hasNext()) {
            Long lBedId;
            String sAktWert;
            Bedingung oBed = iterator.next();
            if (!oBed.showBed(sArt, sAktWert = this.getBedWert(lBedId = oBed.getId()))) continue;
            if (lBedId.compareTo(lBedIdAkt) == 0) {
                return nIndex;
            }
            ++nIndex;
        }
        return nIndex;
    }

    public boolean isCurrentBedingungExclusive() {
        if (this.mlCurrentId == null) {
            return false;
        }
        Bedingung oBed = this.mhBedingungen.get(this.mlCurrentId);
        if (oBed == null) {
            return false;
        }
        return oBed.isExclusive();
    }

    public boolean alleWerteGesetzt() {
        if (this.mhBedingungsWerte == null) {
            return true;
        }
        Enumeration<Bedingungswert> eBeds = this.mhBedingungsWerte.elements();
        while (eBeds.hasMoreElements()) {
            Bedingungswert oWert = eBeds.nextElement();
            String sValue = oWert.toString();
            if (!sValue.equals("0")) continue;
            return false;
        }
        return true;
    }

    public boolean vergleicheBedMenge(Bedingungsmenge pBedMenge) {
        return this.vergleicheBedMenge(pBedMenge.mhBedingungsWerte);
    }

    public boolean vergleicheBedMenge(Hashtable<Long, Bedingungswert> hWerteTable) {
        log.debug((Object)("Checking Conditions in current set of conditions (" + this.toString() + ")"));
        if (hWerteTable == null) {
            log.debug((Object)"Set of conditions to check is null. Function returns true.");
            return true;
        }
        Enumeration<Long> eBeds = hWerteTable.keys();
        while (eBeds.hasMoreElements()) {
            Long lBed = eBeds.nextElement();
            log.log((Priority)Level.ALL, (Object)("Checking condition: " + lBed.toString()));
            String sOurValue = this.getBedWert(lBed);
            if (sOurValue != null && !sOurValue.equals("0")) continue;
            log.log((Priority)Level.ALL, (Object)("Condition (" + lBed.toString() + ") is not set."));
            return false;
        }
        log.log((Priority)Level.ALL, (Object)"All conditions are set.");
        return true;
    }

    public void uebernehmenWerte(BTEBedingungsmenge pBteBedMenge, boolean bOverwrite, boolean bInsert) {
        this.uebernehmenWerte(pBteBedMenge.getWerteTable(), bOverwrite, bInsert);
    }

    public void uebernehmenWerte(Bedingungsmenge pBedMenge, boolean bOverwrite, boolean bInsert) {
        this.uebernehmenWerte(this.mhBedingungsWerte, bOverwrite, bInsert);
    }

    public void uebernehmenWerte(Hashtable<Long, Bedingungswert> hWerteTable, boolean bOverwrite, boolean bInsert) {
        log.debug((Object)("Retreiving values from condition set: " + hWerteTable.toString()));
        boolean bDoSet = false;
        Enumeration<Long> eBeds = hWerteTable.keys();
        while (eBeds.hasMoreElements()) {
            bDoSet = false;
            Long lBed = eBeds.nextElement();
            log.log((Priority)Level.ALL, (Object)("Checking condition: " + lBed.toString()));
            Bedingungswert oValue = hWerteTable.get(lBed);
            bDoSet = this.mhBedingungsWerte.containsKey(lBed) ? bOverwrite : bInsert;
            if (!bDoSet) continue;
            try {
                if (oValue == null) {
                    oValue = new Bedingungswert("0");
                }
            }
            catch (InvalidInitializationException e) {
                log.error((Object)"One of the values in the other Bedingungsmenge is not valid!");
            }
            this.mhBedingungsWerte.put(lBed, oValue);
            log.log((Priority)Level.ALL, (Object)("Setting value for condition (" + lBed.toString() + ") to: " + oValue.toString()));
        }
    }

    public void appendSchnittstellenBedingungen(Collection<Bedingung> cBedingungen) {
        if (cBedingungen == null) {
            return;
        }
        for (Bedingung oBedingung : cBedingungen) {
            Long lElementId = oBedingung.getId();
            if (this.mhBedingungen.get(lElementId) == null) {
                this.mhBedingungen.put(lElementId, oBedingung);
                this.mcSortedKeys.add(oBedingung);
                if (oBedingung.isExclusive()) {
                    String sGruppe = oBedingung.getGruppe();
                    Vector<Long> cGruppe = this.mhExclusiveGruppen.get(sGruppe);
                    if (cGruppe == null) {
                        cGruppe = new Vector();
                    }
                    cGruppe.add(lElementId);
                    this.mhExclusiveGruppen.put(sGruppe, cGruppe);
                }
            } else {
                Bedingung oBedinungVorhanden = this.mhBedingungen.get(lElementId);
                if (oBedingung.hasBedZusatzInfo()) {
                    oBedinungVorhanden.hasBedZusatzInfo(true);
                }
                if (!oBedingung.showBedZusatzInfo()) {
                    oBedinungVorhanden.showBedZusatzInfo(false);
                }
                if (oBedingung.isSicherheitsrelevant()) {
                    oBedinungVorhanden.isSicherheitsrelevant(true);
                }
            }
            Hashtable<Long, Bedingungswert> hBteBedWerte = new Hashtable<Long, Bedingungswert>();
            this.insertBedWert(lElementId, "1", hBteBedWerte);
        }
        this.adjustSchnittstellenBedingungen();
    }

    private void adjustSchnittstellenBedingungen() {
        Enumeration<Vector<Long>> eExcluvieGruppen = this.mhExclusiveGruppen.elements();
        while (eExcluvieGruppen.hasMoreElements()) {
            Vector<Long> cGruppe = eExcluvieGruppen.nextElement();
            if (cGruppe.size() <= 1) continue;
            for (Long lBedId : cGruppe) {
                if (lBedId == null) continue;
                try {
                    Bedingungswert oBedWert = this.mhBedingungsWerte.get(lBedId);
                    if (oBedWert.equals("1")) continue;
                    this.setBedWert(lBedId, new Bedingungswert("0"));
                }
                catch (InvalidInitializationException exc) {}
            }
        }
    }

    public TreeSet<Bedingung> getSortedKeys() {
        return this.mcSortedKeys;
    }

    public String getAFCodeSS() {
        for (Bedingung bed : this.mcSortedKeys) {
            if (!bed.isSchnittstellenBed() || !bed.getBedingungsartSS().equals("AF")) continue;
            return bed.getCode();
        }
        return null;
    }

    public String getLackCodeSS() {
        for (Bedingung bed : this.mcSortedKeys) {
            if (!bed.isSchnittstellenBed() || !bed.getBedingungsartSS().equals("L")) continue;
            return bed.getCode();
        }
        return null;
    }

    public boolean hasBedingungen() {
        if (this.mhBedingungen == null) {
            return false;
        }
        return this.mhBedingungen.size() != 0;
    }

    public Object clone() throws CloneNotSupportedException {
        Serializable value;
        Object key;
        Bedingungsmenge copy = (Bedingungsmenge)super.clone();
        copy.mlCurrentId = this.mlCurrentId == null ? null : new Long(this.mlCurrentId);
        copy.mhBedingungen = this.mhBedingungen == null ? null : new Hashtable();
        copy.mhBedingungsWerte = this.mhBedingungsWerte == null ? null : new Hashtable();
        copy.mhNachruestungAufNein = this.mhNachruestungAufNein == null ? null : new Hashtable();
        copy.mhExclusiveGruppen = this.mhExclusiveGruppen == null ? null : new Hashtable();
        TreeSet treeSet = copy.mcSortedKeys = this.mcSortedKeys == null ? null : new TreeSet();
        if (this.mhBedingungen != null) {
            Enumeration<Long> hBedingungenIter = this.mhBedingungen.keys();
            while (hBedingungenIter.hasMoreElements()) {
                key = hBedingungenIter.nextElement();
                value = this.mhBedingungen.get(key);
                copy.mhBedingungen.put(new Long((Long)key), ((Bedingung)value).copy());
            }
        }
        if (this.mhBedingungsWerte != null) {
            Enumeration<Long> hBedingungswerteIter = this.mhBedingungsWerte.keys();
            while (hBedingungswerteIter.hasMoreElements()) {
                key = hBedingungswerteIter.nextElement();
                value = this.mhBedingungsWerte.get(key);
                copy.mhBedingungsWerte.put(new Long((Long)key), ((Bedingungswert)value).copy());
            }
        }
        if (this.mhNachruestungAufNein != null) {
            Enumeration<Long> hNachruestungAufNeinIter = this.mhNachruestungAufNein.keys();
            while (hNachruestungAufNeinIter.hasMoreElements()) {
                key = hNachruestungAufNeinIter.nextElement();
                value = this.mhNachruestungAufNein.get(key);
                copy.mhNachruestungAufNein.put(new Long((Long)key), new Boolean((Boolean)value));
            }
        }
        if (this.mhExclusiveGruppen != null) {
            Enumeration<String> hExclusiveGruppen = this.mhExclusiveGruppen.keys();
            while (hExclusiveGruppen.hasMoreElements()) {
                key = hExclusiveGruppen.nextElement();
                Vector<Long> values = this.mhExclusiveGruppen.get(key);
                Vector<Long> valuesCopy = new Vector<Long>();
                for (Long value2 : values) {
                    valuesCopy.add(new Long(value2));
                }
                copy.mhExclusiveGruppen.put(new String((String)key), valuesCopy);
            }
        }
        if (this.mcSortedKeys != null) {
            for (Bedingung value3 : this.mcSortedKeys) {
                copy.mcSortedKeys.add(value3.copy());
            }
        }
        return copy;
    }

    public Bedingungsmenge copy() throws CloneNotSupportedException {
        Object copy = this.clone();
        if (copy instanceof Bedingungsmenge) {
            return (Bedingungsmenge)copy;
        }
        throw new CloneNotSupportedException("Not an instance of class " + this.getClass().getName());
    }

    public Long getMlCurrentId() {
        return this.mlCurrentId;
    }

    public void setMlCurrentId(Long mlCurrentId) {
        this.mlCurrentId = mlCurrentId;
    }

    public Hashtable<Long, Bedingung> getMhBedingungen() {
        return this.mhBedingungen;
    }

    public void setMhBedingungen(Hashtable<Long, Bedingung> mhBedingungen) {
        this.mhBedingungen = mhBedingungen;
    }

    public Hashtable<Long, Bedingungswert> getMhBedingungsWerte() {
        return this.mhBedingungsWerte;
    }

    public void setMhBedingungsWerte(Hashtable<Long, Bedingungswert> mhBedingungsWerte) {
        this.mhBedingungsWerte = mhBedingungsWerte;
    }

    public Hashtable<Long, Boolean> getMhNachruestungAufNein() {
        return this.mhNachruestungAufNein;
    }

    public void setMhNachruestungAufNein(Hashtable<Long, Boolean> mhNachruestungAufNein) {
        this.mhNachruestungAufNein = mhNachruestungAufNein;
    }

    public Hashtable<String, Vector<Long>> getMhExclusiveGruppen() {
        return this.mhExclusiveGruppen;
    }

    public void setMhExclusiveGruppen(Hashtable<String, Vector<Long>> mhExclusiveGruppen) {
        this.mhExclusiveGruppen = mhExclusiveGruppen;
    }

    public Iterator<Bedingung> getmIterator() {
        return this.mIterator;
    }

    public void setmIterator(Iterator<Bedingung> mIterator) {
        this.mIterator = mIterator;
    }

    public TreeSet<Bedingung> getMcSortedKeys() {
        return this.mcSortedKeys;
    }

    public void setMcSortedKeys(TreeSet<Bedingung> mcSortedKeys) {
        this.mcSortedKeys = mcSortedKeys;
    }

    private static class BedingungsKomparator
    implements Comparator<Bedingung>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String msArt = null;

        public BedingungsKomparator(String sArt) {
            this.msArt = sArt;
        }

        @Override
        public boolean equals(Object oObj) {
            if (oObj instanceof BedingungsKomparator) {
                return false;
            }
            return super.equals(oObj);
        }

        @Override
        public int compare(Bedingung o1, Bedingung o2) throws IllegalArgumentException {
            Bedingung bed1 = o1;
            Bedingung bed2 = o2;
            return bed1.compareTo(bed2, this.msArt);
        }

        public String getArt() {
            if (this.msArt == null) {
                return "";
            }
            return this.msArt;
        }
    }
}

