/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.WebetkUtils;
import webetk.app.ComplexTypeAdapter;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.BTVerweisZeile;
import webetk.app.bteanzeige.KommZeile;
import webetk.app.bteanzeige.RawKommZeile;
import webetk.app.bteanzeige.RawZeile;
import webetk.app.bteanzeige.Textteil;
import webetk.app.bteanzeige.Zeile;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.BteAnzeigeDbAccess;
import webetk.mrkprd.Produkte;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class BaseTextteil
implements Textteil,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String msHG = null;
    protected String msFG = null;
    protected String msBTENummer = null;
    protected String msBTEUeberschrift;
    protected String msBTEType;
    protected Vector<AbstractZeile> mcZeilen = new Vector();
    protected Vector<RawZeile> mcRawZeilen = null;
    protected Vector<RawZeile> mcRawZeilenTemp = null;
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    protected Hashtable<Long, Vector<RawKommZeile>> mhKommentare = new Hashtable();
    protected Vector<BTVerweisZeile> mcBTVerweisZeilen = null;
    private Vector<String> msIds = null;
    @XmlTransient
    private static Logger log = Logger.getLogger(BaseTextteil.class);

    protected boolean removeKommentareVorBedingungen(String sBTENr) {
        return false;
    }

    public void aktualisierenZeilen(SucheInfo oSucheInfo, Collection<String> cVisibleSachnummern, String sLandkuerzel, boolean isFromWebEtk) throws SQLException, DatabaseBusyException, IllegalArgumentException, InvalidDataException {
        if (this.getBTEType().equals("FZG")) {
            log.debug((Object)"Trying to load Zeilen for FZG-BTE ...");
            if (oSucheInfo instanceof FzgSucheInfo) {
                log.debug((Object)"SucheInfo object has been casted correctly to FzgSuchInfo.");
                this.aktualisierenZeilenFzg((FzgSucheInfo)oSucheInfo, cVisibleSachnummern, sLandkuerzel, isFromWebEtk);
            } else {
                log.error((Object)"The given SucheInfo object is not of class FzgSuchInfo!");
                throw new IllegalArgumentException("Illegal call of aktualisiereZeile with wrong Suche-Object");
            }
        }
        if (this.getBTEType().equals("ASS")) {
            log.debug((Object)"Trying to load Zeilen for ASS-BTE ...");
            this.aktualisierenZeilenUgb(oSucheInfo, cVisibleSachnummern, sLandkuerzel);
        }
    }

    private void aktualisierenZeilenFzg(FzgSucheInfo oFzgSucheInfo, Collection<String> cVisibleSachnummern, String sLandkuerzel, boolean isFromWebEtk) throws SQLException, DatabaseBusyException, InvalidDataException {
        this.loadTextteilFromDBFzg(oFzgSucheInfo, sLandkuerzel);
        if (this.msIds != null) {
            for (String msID : this.msIds) {
                this.setZeileSelected(msID);
            }
        }
        this.copyRawZeilenToTemp(!isFromWebEtk);
        this.auswertenBedingungen();
        this.removeKabelbaumRows();
        this.auswertenChangepoints(oFzgSucheInfo);
        this.auswertenFahrzeugAlter(oFzgSucheInfo);
        this.auswertenPGBedingungen();
        this.setzenAZWZeichenBAP(oFzgSucheInfo);
        if (cVisibleSachnummern != null && cVisibleSachnummern.size() > 0) {
            this.expandZeileBySachnummer(cVisibleSachnummern);
        }
        this.erzeugenKompZeilen();
        this.erzeugenKommZeilen(oFzgSucheInfo.getProduktart());
    }

    protected void auswertenFahrzeugAlter(FzgSucheInfo oFzgSucheInfo) {
    }

    protected void auswertenPGBedingungen() {
    }

    protected void removeKabelbaumRows() {
    }

    protected void loadTextteilFromDBFzg(FzgSucheInfo oFzgSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException, InvalidDataException {
    }

    protected void auswertenBedingungen() {
    }

    protected void auswertenChangepoints(FzgSucheInfo oFzgSucheInfo) {
    }

    private void aktualisierenZeilenUgb(SucheInfo oSucheInfo, Collection<String> cVisibleSachnummern, String sLandkuerzel) throws SQLException, DatabaseBusyException, InvalidDataException {
        this.loadTextteilFromDBUgb(oSucheInfo, sLandkuerzel);
        this.copyRawZeilenToTemp(false);
        if (cVisibleSachnummern != null && cVisibleSachnummern.size() > 0) {
            this.expandZeileBySachnummer(cVisibleSachnummern);
        }
        this.erzeugenKompZeilen();
        this.setzenAZWZeichenBAP(oSucheInfo);
        this.erzeugenKommZeilen(oSucheInfo.getProduktart());
    }

    protected void loadTextteilFromDBUgb(SucheInfo oSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException {
    }

    private void erzeugenKompZeilen() throws InvalidDataException {
        if (this.getRawZeilen() == null) {
            log.error((Object)"The internal rows for the BTE are not loaded!!");
            throw new InvalidDataException("mcRawZeilen is null!!");
        }
        int nBildnummerMerk = -1;
        int nAnzahlZeilen = 0;
        RawZeile kompRawZeile2 = null;
        Vector<RawZeile> cKompZeilen = new Vector<RawZeile>();
        int nSize = this.getRawZeilenTemp().size();
        boolean bFirst = true;
        for (int i = 0; i < nSize; ++i) {
            RawZeile zeilePrev;
            RawZeile rawZeile = this.getRawZeilenTemp().get(i);
            if (rawZeile.getBildnummerInt() == 0) continue;
            if (rawZeile.getBildnummer().equals("--") && bFirst) {
                this.getRawZeilenTemp().removeElementAt(i);
                nSize = this.getRawZeilenTemp().size();
                if (i >= nSize) break;
                rawZeile = this.getRawZeilenTemp().get(i);
            }
            bFirst = false;
            boolean bZeileAktIsStrich = rawZeile.getBildnummer().equals("--");
            long lKommVorIdAktZeile = rawZeile.getKommVor();
            boolean bZeilePrevIsStrich = false;
            long lKommVorIdPrevZeile = 0L;
            if (i - 1 >= 0) {
                zeilePrev = this.getRawZeilenTemp().get(i - 1);
                bZeilePrevIsStrich = zeilePrev.getBildnummer().equals("--");
                lKommVorIdPrevZeile = zeilePrev.getKommVor();
            }
            while (bZeilePrevIsStrich && bZeileAktIsStrich && lKommVorIdPrevZeile != lKommVorIdAktZeile) {
                this.getRawZeilenTemp().removeElementAt(i);
                nSize = this.getRawZeilenTemp().size();
                if (i >= nSize) break;
                rawZeile = this.getRawZeilenTemp().get(i);
                bZeileAktIsStrich = rawZeile.getBildnummer().equals("--");
                lKommVorIdAktZeile = rawZeile.getKommVor();
                if (i - 1 < 0) continue;
                zeilePrev = this.getRawZeilenTemp().get(i - 1);
                bZeilePrevIsStrich = zeilePrev.getBildnummer().equals("--");
                lKommVorIdPrevZeile = zeilePrev.getKommVor();
            }
            if (rawZeile.getBildnummerInt() != nBildnummerMerk) {
                if (nAnzahlZeilen > 1) {
                    cKompZeilen.add(kompRawZeile2);
                }
                kompRawZeile2 = new RawZeile(rawZeile.getIsFzgZeile(), 0, 0L, 0L);
                kompRawZeile2.copyKompZeile(rawZeile);
                nBildnummerMerk = rawZeile.getBildnummerInt();
                nAnzahlZeilen = 1;
                continue;
            }
            if (!rawZeile.getBildnummer().equals("--")) {
                ++nAnzahlZeilen;
            }
            if (kompRawZeile2.getKommVor() != rawZeile.getKommVor()) {
                kompRawZeile2.resetKommVor();
            }
            if (kompRawZeile2.getKommNach() == rawZeile.getKommNach()) continue;
            kompRawZeile2.resetKommNach();
        }
        if (nAnzahlZeilen > 1) {
            cKompZeilen.add(kompRawZeile2);
        }
        block2: for (RawZeile kompRawZeile2 : cKompZeilen) {
            nSize = this.getRawZeilenTemp().size();
            for (int i = 0; i < nSize; ++i) {
                RawZeile Zeile2 = this.getRawZeilenTemp().get(i);
                if (kompRawZeile2.getBildnummerInt() != Zeile2.getBildnummerInt()) continue;
                this.getRawZeilenTemp().add(i, kompRawZeile2);
                String sBildnummer = kompRawZeile2.getBildnummer();
                boolean bExpandBnb = this.getExpandedZeilen().contains(sBildnummer);
                if (bExpandBnb) continue block2;
                kompRawZeile2.setIsKomprimiert(true);
                nSize = this.getRawZeilenTemp().size();
                ++i;
                while (i < nSize) {
                    Zeile2 = this.getRawZeilenTemp().get(i);
                    if (kompRawZeile2.getBildnummerInt() <= Zeile2.getBildnummerInt()) {
                        if (kompRawZeile2.getBildnummerInt() < Zeile2.getBildnummerInt()) continue block2;
                        this.getRawZeilenTemp().remove(i);
                        --nSize;
                        --i;
                    }
                    ++i;
                }
                continue block2;
            }
        }
        Iterator<Object> iterator = this.getRawZeilenTemp().iterator();
        while (iterator.hasNext()) {
            log.debug((Object)("Zeile: " + ((RawZeile)iterator.next()).toString()));
        }
    }

    public void setzenAZWZeichenBAP(SucheInfo oSucheInfo) throws SQLException, DatabaseBusyException, InvalidDataException {
        if (this.getRawZeilen() == null) {
            log.error((Object)"The internal rows for the BTE are not loaded!!");
            throw new InvalidDataException("mcRawZeilen is null!!");
        }
        for (RawZeile oZeile : this.getRawZeilenTemp()) {
            oZeile.setToDelete(false);
        }
        int nStartindex = 0;
        while (nStartindex != -1) {
            Vector<RawZeile> cZeilen1 = new Vector<RawZeile>();
            nStartindex = this.getZeilenMenge(nStartindex, cZeilen1);
            Vector<RawZeile> cZeilen2 = new Vector<RawZeile>();
            this.getZeilenMenge(nStartindex, cZeilen2);
            this.setzenAZWeichenBAP(oSucheInfo, cZeilen1, cZeilen2);
            boolean bZeilenGeloescht = cZeilen2.size() > 0 && ((RawZeile)cZeilen2.toArray()[0]).getToDelete();
            if (!bZeilenGeloescht) continue;
            nStartindex = this.findIndex((RawZeile)cZeilen1.toArray()[0]);
        }
    }

    public int findIndex(RawZeile oZeile) {
        int nSize = this.getRawZeilenTemp().size();
        for (int i = 0; i < nSize; ++i) {
            RawZeile oZeileComp = this.getRawZeilenTemp().get(i);
            if (!oZeileComp.getId().equals(oZeile.getId())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setzenAZWeichenBAP(SucheInfo oSuchInfo, Collection<RawZeile> cZeilen1, Collection<RawZeile> cZeilen2) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (cZeilen1.size() == 0 || cZeilen2.size() == 0) {
            return;
        }
        RawZeile Zeile1 = (RawZeile)cZeilen1.toArray()[0];
        RawZeile Zeile2 = (RawZeile)cZeilen2.toArray()[0];
        if (!Zeile1.getBildnummer().equals(Zeile2.getBildnummer())) {
            return;
        }
        String sSachnummer1 = Zeile1.getSachnummer();
        String sSachnummer2 = Zeile2.getSachnummer();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.setzenAZWZeichenBAP");
            res = BteAnzeigeDbAccess.loadAZeichen(con, sSachnummer1, sSachnummer2);
            String sAZWZeichen = "";
            Boolean bBAP = Boolean.FALSE;
            if (res != null && res.next()) {
                String sBAP = res.getString("BAP");
                bBAP = sBAP.equals("J") ? Boolean.TRUE : Boolean.FALSE;
                sAZWZeichen = res.getString("ATB").trim();
            }
            this.setTeilAZWZeichen(cZeilen1, sAZWZeichen);
            if (Boolean.TRUE.equals(bBAP)) {
                Vector<RawZeile> cZeilenNew = new Vector<RawZeile>();
                Vector<RawZeile> cZeilenNewVor = new Vector<RawZeile>();
                this.anpassenBzglBAP(oSuchInfo, cZeilen1, cZeilen2, cZeilenNew, cZeilenNewVor);
                this.anpassenRawZeilenTempBzglBAPAuswirkung(cZeilenNew, cZeilenNewVor);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.setzenAZWZeichen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.setzenAZWZeichen");
    }

    public void erzeugenKommZeilen(String sProduktart) throws InvalidDataException {
        this.getNewZeilen();
        if (this.getRawZeilen() == null) {
            log.error((Object)"The internal rows for the BTE are not loaded!!");
            throw new InvalidDataException("mcRawZeilen is null!!");
        }
        boolean bKommBTGeschrieben = false;
        boolean bLeerzeileVor = false;
        boolean bEsSindVerschiedeneKommentareImBildnummernblockVorhanden = false;
        String sBildNrOld = "";
        RawZeile zeilePrev = null;
        String sBildNrPrevZeile = null;
        boolean bZeilePrevIsStrich = false;
        long lKommVorIdPrevZeile = 0L;
        long lKommNachIdPrevZeile = 0L;
        RawZeile zeileAkt = null;
        String sBildNrAktZeile = null;
        boolean bZeileAktIsStrich = false;
        long lKommVorIdAktZeile = 0L;
        long lKommNachIdAktZeile = 0L;
        RawZeile zeileNext = null;
        String sBildNrNextZeile = null;
        boolean bZeileNextIsStrich = false;
        long lKommVorIdNextZeile = 0L;
        long lKommNachIdNextZeile = 0L;
        if (sProduktart != null && sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            Iterator<BTVerweisZeile> iteratorBTVerweise = this.getBTVerweisZeilen().iterator();
            boolean bLeerzeile = false;
            while (iteratorBTVerweise.hasNext()) {
                BTVerweisZeile oZeile = iteratorBTVerweise.next();
                this.appendBTVerweisZeilen(oZeile, bLeerzeile);
                bLeerzeileVor = true;
            }
        }
        boolean bRemoveBedKomm = this.removeKommentareVorBedingungen(this.msBTENummer);
        int nSize = this.getRawZeilenTemp().size();
        for (int i = 0; i < nSize; ++i) {
            String sBildnummer;
            Vector<RawKommZeile> cKommentar;
            zeileAkt = this.getRawZeilenTemp().get(i);
            bZeileAktIsStrich = zeileAkt.getBildnummer().equals("--");
            sBildNrAktZeile = bZeileAktIsStrich || zeileAkt.getIsKomprimierungszeile() ? "" : zeileAkt.getBildnummer();
            lKommVorIdAktZeile = zeileAkt.getKommVor();
            lKommNachIdAktZeile = zeileAkt.getKommNach();
            if (i + 1 < nSize) {
                zeileNext = this.getRawZeilenTemp().get(i + 1);
                bZeileNextIsStrich = zeileNext.getBildnummer().equals("--");
                sBildNrNextZeile = bZeileNextIsStrich || zeileNext.getIsKomprimierungszeile() ? "" : zeileNext.getBildnummer();
                lKommVorIdNextZeile = zeileNext.getKommVor();
                lKommNachIdNextZeile = zeileNext.getKommNach();
            } else {
                bZeileNextIsStrich = false;
                sBildNrNextZeile = "";
                lKommVorIdNextZeile = 0L;
                lKommNachIdNextZeile = 0L;
            }
            if (i - 1 >= 0) {
                zeilePrev = this.getRawZeilenTemp().get(i - 1);
                bZeilePrevIsStrich = zeilePrev.getBildnummer().equals("--");
                sBildNrPrevZeile = bZeilePrevIsStrich || zeilePrev.getIsKomprimierungszeile() ? "" : zeilePrev.getBildnummer();
                lKommVorIdPrevZeile = zeilePrev.getKommVor();
                lKommNachIdPrevZeile = zeilePrev.getKommNach();
            } else {
                bZeilePrevIsStrich = false;
                sBildNrPrevZeile = "";
                lKommVorIdPrevZeile = 0L;
                lKommNachIdPrevZeile = 0L;
            }
            if (zeileAkt != null) {
                log.debug((Object)("#*# ZeileAkt Bild-Nr.: " + sBildNrAktZeile + " isStrich: " + bZeileAktIsStrich + " isKomprZeile: " + zeileAkt.getIsKomprimierungszeile() + " Teile-Nr.: " + zeileAkt.getTeilenummer() + " KommVor: " + lKommVorIdAktZeile + " KommNach: " + lKommNachIdAktZeile));
            }
            if (!sBildNrAktZeile.equals("") && !sBildNrAktZeile.equals(sBildNrOld)) {
                sBildNrOld = sBildNrAktZeile;
                bEsSindVerschiedeneKommentareImBildnummernblockVorhanden = this.checkVerschiedeneKommentare(sBildNrAktZeile);
            }
            if (!bKommBTGeschrieben && zeileAkt.getKommBT() != 0L) {
                cKommentar = this.getKommentare().get(new Long(zeileAkt.getKommBT()));
                this.appendKommZeilen(cKommentar, bLeerzeileVor, true);
                bLeerzeileVor = false;
            }
            bKommBTGeschrieben = true;
            if (lKommVorIdAktZeile != lKommVorIdPrevZeile || lKommNachIdAktZeile != lKommNachIdPrevZeile && !bZeileAktIsStrich || bZeilePrevIsStrich && !bZeileAktIsStrich) {
                cKommentar = null;
                boolean bIsToRemove = false;
                if (lKommVorIdAktZeile != 0L) {
                    cKommentar = this.getKommentare().get(new Long(lKommVorIdAktZeile));
                    int rowCounter = 0;
                    int lastZusatzRow = 0;
                    for (RawKommZeile oZeile : cKommentar) {
                        ++rowCounter;
                        if (oZeile.getCode() == null || oZeile.getCode().length() <= 0) continue;
                        lastZusatzRow = rowCounter;
                        if (!bRemoveBedKomm) continue;
                        bIsToRemove = !bEsSindVerschiedeneKommentareImBildnummernblockVorhanden;
                        log.debug((Object)("#*# - " + i + " bIsToRemove: " + bIsToRemove));
                    }
                    if (bIsToRemove) {
                        Vector<RawKommZeile> cKommentareZuSchreiben = new Vector<RawKommZeile>();
                        for (int cnt = lastZusatzRow; cnt < cKommentar.size(); ++cnt) {
                            RawKommZeile oZeile = cKommentar.get(cnt);
                            cKommentareZuSchreiben.add(oZeile);
                        }
                        cKommentar = cKommentareZuSchreiben;
                    }
                }
                this.appendKommZeilen(cKommentar, bLeerzeileVor, false);
                bLeerzeileVor = true;
            }
            if (!(sBildnummer = zeileAkt.getBildnummer()).equals("")) {
                this.appendBTZeilen(zeileAkt);
                bLeerzeileVor = true;
            }
            if (lKommNachIdAktZeile == 0L || lKommVorIdNextZeile == lKommVorIdAktZeile && lKommNachIdNextZeile == lKommNachIdAktZeile && (!bZeileAktIsStrich || bZeileNextIsStrich)) continue;
            Vector<RawKommZeile> cKommentar2 = this.getKommentare().get(new Long(lKommNachIdAktZeile));
            this.appendKommZeilen(cKommentar2, false, false);
        }
        if (sProduktart == null || !sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            Iterator<BTVerweisZeile> iteratorBTVerweise = this.getBTVerweisZeilen().iterator();
            boolean bLeerzeile = true;
            while (iteratorBTVerweise.hasNext()) {
                BTVerweisZeile oZeile = iteratorBTVerweise.next();
                this.appendBTVerweisZeilen(oZeile, bLeerzeile);
                bLeerzeile = false;
            }
        }
        for (AbstractZeile obj : this.getZeilen()) {
            if (obj instanceof Zeile) {
                log.debug((Object)("Zeile: " + ((Zeile)obj).toString()));
            }
            if (obj instanceof KommZeile) {
                log.debug((Object)("KommZeile: " + ((KommZeile)obj).toString()));
            }
            if (!(obj instanceof BTVerweisZeile)) continue;
            log.debug((Object)("BTVerweisZeile: " + ((BTVerweisZeile)obj).toString()));
        }
    }

    private boolean checkVerschiedeneKommentare(String sBildNummernBlock) {
        long lVorangestellterKommentar = -1L;
        for (RawZeile oRawZeile : this.getRawZeilenTemp()) {
            String sBildNummer = oRawZeile.getBildnummer();
            boolean bIsKomprimierungszeile = oRawZeile.getIsKomprimierungszeile();
            long lKommVor = oRawZeile.getKommVor();
            if (sBildNummer.equals(sBildNummernBlock) && !sBildNummer.equals("") && !sBildNummer.equals("--") && !bIsKomprimierungszeile && lKommVor != 0L) {
                if (lVorangestellterKommentar == -1L) {
                    lVorangestellterKommentar = lKommVor;
                } else if (lVorangestellterKommentar != lKommVor) {
                    return true;
                }
            }
            if (sBildNummer.compareTo(sBildNummernBlock) <= 0 || sBildNummer.equals("") || sBildNummer.equals("--") || bIsKomprimierungszeile) continue;
            return false;
        }
        return false;
    }

    public void expandZeile(String sBildnummer) {
        if (this.mcRawZeilen != null) {
            for (RawZeile rz : this.mcRawZeilen) {
                if (!this.getExpandedZeilen().contains(rz.getBildnummer())) continue;
                rz.setSelected(false);
            }
        }
        if (this.getExpandedZeilen().contains(sBildnummer)) {
            return;
        }
        this.getExpandedZeilen().add(sBildnummer);
    }

    public void collapseZeile(String sBildnummer) {
        this.getExpandedZeilen().remove(sBildnummer);
        if (this.msIds != null) {
            log.debug((Object)"*** msIds nicht null'");
            if (this.mcRawZeilen != null) {
                log.debug((Object)"*** mcRawZeilen nicht null'");
                Iterator<RawZeile> iterator = this.mcRawZeilen.iterator();
                while (iterator.hasNext()) {
                    log.debug((Object)"*** mcRawZeilen hasNext'");
                    RawZeile rz = iterator.next();
                    if (!this.getExpandedZeilen().contains(rz.getBildnummer()) && (!rz.getBildnummer().equals(sBildnummer) || this.msIds.contains(rz.getId())) && (!rz.getBildnummer().equals("--") || this.msIds.contains(rz.getId()))) continue;
                    log.debug((Object)"*** set selected false'");
                    rz.setSelected(false);
                }
            }
        }
    }

    public void setZeileSelected(String msID) {
        for (RawZeile oZeile : this.mcRawZeilen) {
            String id = oZeile.getId();
            if (!id.equals(msID)) continue;
            log.debug((Object)("%%% ID: " + id));
            oZeile.setSelected(true);
        }
    }

    public void resetSelectedZeilen() {
        if (this.mcRawZeilen != null) {
            for (RawZeile oZeile : this.mcRawZeilen) {
                oZeile.setSelected(false);
            }
        }
    }

    public void expandZeileBySachnummer(Collection<String> cVisibleSachnummern) {
        if (cVisibleSachnummern == null || cVisibleSachnummern.size() == 0) {
            return;
        }
        Vector<RawZeile> cRawZeilen = this.getRawZeilen();
        if (cRawZeilen == null) {
            return;
        }
        for (RawZeile raw : cRawZeilen) {
            for (String sSachnummerComp : cVisibleSachnummern) {
                if (!sSachnummerComp.equals(raw.getSachnummer())) continue;
                this.expandZeile(raw.getBildnummer());
            }
        }
    }

    @Override
    public String getScrollTarget() {
        return null;
    }

    private void appendBTZeilen(RawZeile rawZeile) {
        Zeile ZeileDest = new Zeile(rawZeile);
        this.getZeilen().add(ZeileDest);
    }

    private void appendKommZeilen(Vector<RawKommZeile> cKommZeilen, boolean bLeerzeileVor, boolean bLeerzeileNach) {
        KommZeile kommZeile;
        if (bLeerzeileVor) {
            kommZeile = new KommZeile();
            this.getZeilen().add(kommZeile);
        }
        if (cKommZeilen != null) {
            for (RawKommZeile rawKommZeile : cKommZeilen) {
                KommZeile kommZeile2 = new KommZeile(rawKommZeile);
                this.getZeilen().add(kommZeile2);
            }
        }
        if (bLeerzeileNach) {
            kommZeile = new KommZeile();
            this.getZeilen().add(kommZeile);
        }
    }

    private void appendBTVerweisZeilen(BTVerweisZeile ZeileSrc, boolean bLeerzeile) {
        AbstractZeile oZeileDest;
        if (bLeerzeile) {
            oZeileDest = new KommZeile();
            this.getZeilen().add(oZeileDest);
        }
        oZeileDest = new BTVerweisZeile(ZeileSrc);
        this.getZeilen().add(oZeileDest);
    }

    public String getHG() {
        return this.msHG;
    }

    public String getFG() {
        return this.msFG;
    }

    @Override
    public String getBTENr() {
        return this.msBTENummer;
    }

    @Override
    public String getBTEType() {
        return this.msBTEType;
    }

    @Override
    public String getBTEUeberschrift() {
        return this.msBTEUeberschrift;
    }

    @Override
    public Vector<RawZeile> getRawZeilen() {
        return this.mcRawZeilen;
    }

    public void setRawZeilen(Vector<RawZeile> rawZeilen) {
        this.mcRawZeilen = rawZeilen;
    }

    @Override
    public Vector<RawZeile> getRawZeilenTemp() {
        return this.mcRawZeilenTemp;
    }

    @Override
    public Vector<AbstractZeile> getZeilen() {
        return this.mcZeilen;
    }

    public void setZeilen(Vector<AbstractZeile> zeilen) {
        this.mcZeilen = zeilen;
    }

    @Override
    public boolean copyRawZeilenToTemp(boolean isDeepCopy) {
        if (this.mcRawZeilenTemp != null) {
            this.mcRawZeilenTemp.clear();
        }
        if (isDeepCopy) {
            if (this.mcRawZeilen != null && this.mcRawZeilenTemp == null) {
                this.mcRawZeilenTemp = new Vector();
            }
            for (RawZeile oRawZeile : this.mcRawZeilen) {
                RawZeile nRawZeile = new RawZeile(oRawZeile);
                this.mcRawZeilenTemp.add(nRawZeile);
            }
        } else {
            this.mcRawZeilenTemp = (Vector)this.mcRawZeilen.clone();
        }
        return true;
    }

    @Override
    public Vector<AbstractZeile> getNewZeilen() {
        if (this.mcZeilen == null) {
            this.mcZeilen = new Vector();
        } else {
            this.mcZeilen.clear();
        }
        return this.mcZeilen;
    }

    @Override
    public Hashtable<Long, Vector<RawKommZeile>> getKommentare() {
        return this.mhKommentare;
    }

    public Vector<BTVerweisZeile> getBTVerweisZeilen() {
        if (this.mcBTVerweisZeilen == null) {
            this.mcBTVerweisZeilen = new Vector();
        }
        return this.mcBTVerweisZeilen;
    }

    @Override
    public String getHighlight() {
        return null;
    }

    private void setTeilAZWZeichen(Collection<RawZeile> cZeilen, String sAZWeichen) {
        for (RawZeile Zeile2 : cZeilen) {
            Zeile2.setTeilAZeichen(sAZWeichen);
        }
    }

    private void anpassenBzglBAP(SucheInfo oSucheInfo, Collection<RawZeile> cZeilen1, Collection<RawZeile> cZeilen2, Collection<RawZeile> cZeilen2New, Collection<RawZeile> cZeilen2NewVor) {
        if (cZeilen2New == null) {
            cZeilen2New = new Vector<RawZeile>();
        }
        if (cZeilen1.size() == 0 || cZeilen2.size() == 0) {
            return;
        }
        boolean bHabenGleichenDatumsZeitraum1 = this.habenGleichenZeitraum(cZeilen1);
        boolean bHabenGleichenDatumsZeitraum2 = this.habenGleichenZeitraum(cZeilen2);
        if (!bHabenGleichenDatumsZeitraum1 || !bHabenGleichenDatumsZeitraum2) {
            return;
        }
        RawZeile ZeileVorg = (RawZeile)cZeilen1.toArray()[0];
        for (RawZeile Zeile2 : cZeilen2) {
            String sAbDatum;
            String sAbDatumVorg = ZeileVorg.getEinsatz();
            if (sAbDatumVorg.compareToIgnoreCase(sAbDatum = Zeile2.getEinsatz()) >= 0) {
                Zeile2.setEinsatzAuslauf(ZeileVorg.getAuslauf(), Zeile2.getAuslauf());
                String sAbDatumZeile = Zeile2.getEinsatz();
                String sBisDatumZeile = Zeile2.getAuslauf();
                if (sAbDatumZeile.equals("") && sBisDatumZeile.equals("")) {
                    Zeile2.setToDelete(true);
                    continue;
                }
                if (!sAbDatumZeile.equals("") && !sBisDatumZeile.equals("") && sAbDatumZeile.compareToIgnoreCase(sBisDatumZeile) >= 0) {
                    Zeile2.setToDelete(true);
                    continue;
                }
                boolean bRelevant = this.checkZeileEinschraenkungFzg(Zeile2, oSucheInfo);
                if (!bRelevant) {
                    Zeile2.setToDelete(true);
                    continue;
                }
            }
            sAbDatum = Zeile2.getEinsatz();
            if (sAbDatumVorg.equals("") || sAbDatum.equals("") || sAbDatumVorg.compareToIgnoreCase(sAbDatum) <= 0) continue;
            RawZeile ZeileNew = new RawZeile(Zeile2);
            ZeileNew.setEinsatzAuslauf(sAbDatum, sAbDatumVorg);
            boolean bRelevant = this.checkZeileEinschraenkungFzg(ZeileNew, oSucheInfo);
            if (bRelevant) {
                cZeilen2NewVor.add(ZeileVorg);
                cZeilen2New.add(ZeileNew);
            }
            Zeile2.setEinsatzAuslauf(ZeileVorg.getAuslauf(), Zeile2.getAuslauf());
            bRelevant = this.checkZeileEinschraenkungFzg(Zeile2, oSucheInfo);
            if (bRelevant) continue;
            Zeile2.setToDelete(true);
        }
    }

    public int getZeilenMenge(int nStartIndex, Collection<RawZeile> cZeilen) {
        String sSachnummer = "";
        String sBildnummer = "";
        if (nStartIndex == -1) {
            return -1;
        }
        int nSize = this.getRawZeilenTemp().size();
        boolean bFirst = true;
        for (int i = nStartIndex; i < nSize; ++i) {
            RawZeile Zeile2 = this.getRawZeilenTemp().get(i);
            if (Zeile2.getIsKomprimierungszeile() || Zeile2.getBildnummer().equals("--")) continue;
            if (bFirst) {
                sSachnummer = Zeile2.getSachnummer();
                sBildnummer = Zeile2.getBildnummer();
                cZeilen.add(Zeile2);
                bFirst = false;
                continue;
            }
            if (sSachnummer.equals(Zeile2.getSachnummer()) && sBildnummer.equals(Zeile2.getBildnummer())) {
                cZeilen.add(Zeile2);
                continue;
            }
            return i;
        }
        return -1;
    }

    private boolean habenGleichenZeitraum(Collection<RawZeile> cZeilen) {
        String sEinsatz = null;
        String sAuslauf = null;
        Iterator<RawZeile> iterZeilen = cZeilen.iterator();
        boolean bFirst = true;
        while (iterZeilen.hasNext()) {
            RawZeile Zeile2 = iterZeilen.next();
            if (bFirst) {
                sEinsatz = Zeile2.getEinsatz();
                sAuslauf = Zeile2.getAuslauf();
                bFirst = false;
                continue;
            }
            if (!sEinsatz.equals(Zeile2.getEinsatz())) {
                return false;
            }
            if (sAuslauf.equals(Zeile2.getAuslauf())) continue;
            return false;
        }
        return true;
    }

    private void anpassenRawZeilenTempBzglBAPAuswirkung(Collection<RawZeile> cZeilenInsert, Collection<RawZeile> cZeilenInsertVor) {
        for (int i = this.getRawZeilenTemp().size() - 1; i >= 0; --i) {
            RawZeile zeile2;
            RawZeile zeile = this.getRawZeilenTemp().get(i);
            boolean bToDelete = zeile.getToDelete();
            if (!bToDelete) continue;
            while (this.getRawZeilenTemp().size() > i + 1 && "--".equals((zeile2 = this.getRawZeilenTemp().get(i + 1)).getBildnummer())) {
                this.getRawZeilenTemp().remove(i + 1);
            }
            this.getRawZeilenTemp().remove(i);
        }
        if (cZeilenInsert.size() != cZeilenInsertVor.size()) {
            log.error((Object)"anpassenRawZeilenTemp: Size of collection not equal");
            return;
        }
        if (cZeilenInsert.size() > 0) {
            int nSize = cZeilenInsertVor.size();
            for (int i = 0; i < nSize; ++i) {
                RawZeile Zeile2 = (RawZeile)cZeilenInsert.toArray()[i];
                RawZeile ZeileVor = (RawZeile)cZeilenInsertVor.toArray()[i];
                int nSizeRawZeilen = this.getRawZeilenTemp().size();
                for (int j = 0; j < nSizeRawZeilen; ++j) {
                    RawZeile ZeileComp = (RawZeile)this.getRawZeilenTemp().toArray()[j];
                    if (!ZeileComp.getId().equals(ZeileVor.getId())) continue;
                    this.getRawZeilenTemp().insertElementAt(Zeile2, j);
                }
            }
        }
    }

    private boolean checkZeileEinschraenkungFzg(RawZeile Zeile2, SucheInfo oSucheInfo) {
        if (oSucheInfo == null) {
            return true;
        }
        if (oSucheInfo instanceof AssSucheInfo) {
            return true;
        }
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
        String sBaujahr = oFzgSucheInfo.getBaujahr();
        sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
        String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
        sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
        boolean bIdentifiedByFgstnr = oFzgSucheInfo.getFahrgestellnummer() != null;
        String sProdDatumEinsatzComp = "";
        String sProdDatumAuslaufComp = "";
        long lProdDatumEinsatzComp = 0L;
        long lProdDatumAuslaufComp = 0L;
        if (!sBaujahr.equals("kA")) {
            if (sZulassungsmonat.equals("kA")) {
                sProdDatumEinsatzComp = sBaujahr + "12" + "00";
                sProdDatumAuslaufComp = sBaujahr + "01" + "00";
            } else {
                sProdDatumEinsatzComp = sBaujahr + sZulassungsmonat + "00";
                sProdDatumAuslaufComp = sBaujahr + sZulassungsmonat + "00";
            }
            lProdDatumEinsatzComp = Long.decode(sProdDatumEinsatzComp);
            lProdDatumAuslaufComp = Long.decode(sProdDatumAuslaufComp);
        }
        if (!sBaujahr.equals("kA")) {
            String sAuslaufZeile;
            String sEinsatzZeile = Zeile2.getEinsatz();
            String string = sEinsatzZeile = sEinsatzZeile.equals("") ? null : sEinsatzZeile;
            if (sEinsatzZeile != null) {
                int nMonat;
                String sMonat = sEinsatzZeile.substring(4, 6);
                String sJahr = sEinsatzZeile.substring(0, 4);
                String sZeileEinsatzComp = WebetkUtils.modifyDate(sJahr, sMonat, nMonat = bIdentifiedByFgstnr ? 0 : -2);
                long lZeileEinsatzComp = Long.decode(sZeileEinsatzComp);
                if (lProdDatumEinsatzComp < lZeileEinsatzComp) {
                    return false;
                }
            }
            String string2 = sAuslaufZeile = (sAuslaufZeile = Zeile2.getAuslauf()).equals("") ? null : sAuslaufZeile;
            if (sAuslaufZeile != null) {
                int nMonat;
                String sMonat = sAuslaufZeile.substring(4, 6);
                String sJahr = sAuslaufZeile.substring(0, 4);
                String sZeileAuslaufComp = WebetkUtils.modifyDate(sJahr, sMonat, nMonat = bIdentifiedByFgstnr ? -1 : 1);
                long lZeileAuslaufComp = Long.decode(sZeileAuslaufComp);
                if (lProdDatumAuslaufComp > lZeileAuslaufComp) {
                    return false;
                }
            }
        }
        return true;
    }

    public void setMsIds(Vector<String> msIds) {
        this.msIds = msIds;
    }

    public Vector<String> getMsIds() {
        return this.msIds;
    }
}

