/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgsuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.TeileSucheFzgDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="TeileSucheFzg")
@XmlType(name="webetk.app.fzgsuche.TeileSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TeileSuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TeileSuche.class);
    private Collection<String> mcSuchTeile = null;

    public TeileSuche() {
    }

    public TeileSuche(Collection<String> cTeile) {
        this.mcSuchTeile = cTeile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof FzgSucheInfo)) {
            log.error((Object)"oSucheInfo is no instance of FzgSucheInfo!");
            return 4;
        }
        FzgSucheInfo oFzgSucheInfo = (FzgSucheInfo)oSucheInfo;
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        oSucheInfo.setSuchSachnummern(this.mcSuchTeile);
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("TeileSuche.performSearch");
            String sMarke = oFzgSucheInfo.getMarke();
            String sProduktart = oFzgSucheInfo.getProduktart();
            String sKatalogumfang = oFzgSucheInfo.getKatalogumfang();
            long lModellspalte = oFzgSucheInfo.getModellspalte();
            String sLenkung = oFzgSucheInfo.getLenkung();
            String sGetriebe = oFzgSucheInfo.getGetriebe();
            String sBaujahr = oFzgSucheInfo.getBaujahr();
            String sZulassungsmonat = oFzgSucheInfo.getZulassungsmonat();
            String sFahrgestellnummer = oFzgSucheInfo.getFahrgestellnummer();
            boolean bIdentifiedByFgstnr = sFahrgestellnummer != null && !sFahrgestellnummer.equals("");
            boolean bSicherheitsrelevant = oFzgSucheInfo.isSicherheitsfahrzeug();
            sLenkung = sLenkung == null ? "kA" : sLenkung;
            sGetriebe = sGetriebe == null ? "kA" : sGetriebe;
            sBaujahr = sBaujahr == null ? "kA" : sBaujahr;
            sZulassungsmonat = sZulassungsmonat == null ? "kA" : sZulassungsmonat;
            res = TeileSucheFzgDbAccess.searchBildtafel_SNrs(con, this.mcSuchTeile, sLang, sMarke, sProduktart, sKatalogumfang, lModellspalte, sLenkung, sGetriebe, sBaujahr, sZulassungsmonat, bIdentifiedByFgstnr, bSicherheitsrelevant, this.includeAccessoiresBildtafeln());
            while (res != null && res.next()) {
                SearchBTETeile.PartOrBTE obj = TeileSuche.readResultIntoBte(res, sLang, sProduktart, null, bIGDOM);
                this.mcBTEs.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "TeileSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "TeileSuche.performSearch");
        return this.mcBTEs.size() == 0 ? 4 : 1;
    }
}

