/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Firma;
import webetk.db.dbaccess.KonfigurationDbAccess;

public class Firmen {
    private static Logger log = Logger.getLogger(Firmen.class);
    private Vector<Firma> mcFirmen = new Vector();

    public Vector<Firma> getFirmen() {
        return this.mcFirmen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFirmen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading SprachenFirmen");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Firmen.load");
            res = KonfigurationDbAccess.loadFirmen(con);
            if (res != null) {
                while (res.next()) {
                    String sId = res.getString("Id");
                    String sBezeichnung = res.getString("Bezeichnung");
                    this.mcFirmen.add(new Firma(sId, sBezeichnung));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Firmen.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Firmen.load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existiertEineFirmaFilialeNutzer(List<String> aUserIdsToIgnore) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        boolean ergebnis = false;
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Firmen.existiertEineFirmaFilialeNutzer");
            res = KonfigurationDbAccess.existiertEineFirmaFilialeNutzer(con);
            int count = 0;
            while (res.next()) {
                String sUserId = res.getString("UserId");
                boolean bIgnore = false;
                if (aUserIdsToIgnore != null) {
                    for (String sUserIdComp : aUserIdsToIgnore) {
                        if (!sUserIdComp.equals(sUserId)) continue;
                        bIgnore = true;
                        break;
                    }
                }
                if (bIgnore) continue;
                ++count;
            }
            if (count == 1) {
                ergebnis = true;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Firmen.existiertEineFirmaFilialeNutzer");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Firmen.existiertEineFirmaFilialeNutzer");
        return ergebnis;
    }
}

