/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.BaseNutzer;
import webetk.db.dbaccess.KonfigurationDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Nutzer
extends BaseNutzer {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Nutzer.class);
    private Vector<Nutzer> mcNutzer = new Vector();

    public Nutzer(String sFirmaId, String sUserId, String sPassword) {
        super(sFirmaId, sUserId, sPassword);
    }

    public Nutzer(String sFirmaId, String sUserId, String sUserName, String sPassword, String sDefaultFiliale, String sBearbeiternummer) {
        super(sFirmaId, sUserId, sUserName, sPassword, sDefaultFiliale, sBearbeiternummer);
    }

    public Nutzer(String sFirmaId) {
        super(sFirmaId);
    }

    Nutzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkLogin() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Check User");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.checkLogin");
            boolean bl = KonfigurationDbAccess.checkUser(con, this.getFirmaId(), this.getUserId(), this.getPassword());
            return bl;
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.checkLogin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDMSVerwenden(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"checkDMSVerwenden");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.checkDMSVerwenden");
            boolean bl = KonfigurationDbAccess.checkDMSVerwenden(con, sFirma, sFiliale);
            return bl;
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.checkDMSVerwenden");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNutzer(List<String> aNutzerIgnore) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Nutzer");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.load");
            res = KonfigurationDbAccess.loadNutzer(con, this.getFirmaId());
            if (res != null) {
                while (res.next()) {
                    String sNutzerId = res.getString("NutzerId");
                    String sNutzerName = res.getString("NutzerName");
                    String sPasswort = res.getString("Passwort");
                    String sDefaultFiliale = res.getString("DefaultFiliale");
                    String sBearbeiternummer = res.getString("BearbeiterNummer");
                    boolean bIgnore = false;
                    if (aNutzerIgnore != null) {
                        for (int i = 0; i < aNutzerIgnore.size(); ++i) {
                            String sNutzerIdComp = aNutzerIgnore.get(i);
                            if (sNutzerIdComp == null || !sNutzerIdComp.equals(sNutzerId)) continue;
                            bIgnore = true;
                        }
                    }
                    if (bIgnore) continue;
                    this.mcNutzer.add(new Nutzer(this.getFirmaId(), sNutzerId, sNutzerName, sPasswort, sDefaultFiliale, sBearbeiternummer));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Nutzer.load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadNutzerName(String sFirma, String sID) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Nutzer");
        Connection con = null;
        ResultSet res = null;
        String sNutzerName = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.loadNutzerName");
            res = KonfigurationDbAccess.loadNutzer(con, sFirma, sID);
            if (res != null) {
                while (res.next()) {
                    sNutzerName = res.getString("NutzerName");
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.loadNutzerName");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Nutzer.loadNutzerName");
        return sNutzerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer loadBearbeiterNr(String sFirma, String sID) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Nutzer");
        Connection con = null;
        ResultSet res = null;
        Integer nBearbeiterNr = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.loadBearbeiterNr");
            res = KonfigurationDbAccess.loadNutzer(con, sFirma, sID);
            if (res != null) {
                while (res.next()) {
                    String sBearbeiterNr = res.getString("BearbeiterNummer");
                    if (sBearbeiterNr == null) continue;
                    nBearbeiterNr = new Integer(sBearbeiterNr);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.loadBearbeiterNr");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Nutzer.loadBearbeiterNr");
        return nBearbeiterNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadDefaultFilialePasswort() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading DefaultFiliale, Passwort");
        int retCode = 0;
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.loadDefaultFilialePasswort");
            res = KonfigurationDbAccess.loadDefaultFilialePasswort(con, this.getFirmaId(), this.getUserId());
            if (res != null) {
                while (res.next()) {
                    this.setPassword(res.getString("Passwort"));
                    this.setDefaultFiliale(res.getString("DefaultFiliale"));
                    this.setDefaultFilialeBezeichnung(res.getString("FilialBezeichnung"));
                    this.msIso = res.getString("Iso");
                    this.msRegIso = res.getString("RegIso");
                    this.setBearbeiterNummer(res.getString("BearbeiterNummer"));
                    retCode = 1;
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.loadDefaultFilialePasswort");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Nutzer.loadDefaultFilialePasswort");
        return retCode;
    }

    public Vector<Nutzer> getNutzer() {
        return this.mcNutzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String sNutzerId, String sFirmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Delete Nutzer");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.delete");
            KonfigurationDbAccess.deleteNutzer(con, sNutzerId, sFirmaId);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Nutzer.delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existNutzerId() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"ExistNutzerId");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.checkLogin");
            boolean bl = KonfigurationDbAccess.existNutzerId(con, this.getFirmaId(), this.getUserId());
            return bl;
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.checkLogin");
        }
    }

    public void store(Connection con) throws SQLException, DatabaseBusyException {
        log.info((Object)"Store Nutzer");
        KonfigurationDbAccess.storeNutzer(con, this.getFirmaId(), this.getUserId(), this.getUserName(), this.getPassword(), this.getDefaultFiliale(), this.getBearbeiterNummer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNutzerByFilialId(String sDefaultFiliale, String sFirmaId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Loading Nutzer By FilialId");
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Nutzer.loadNutzerByFilialId");
            res = KonfigurationDbAccess.loadNutzerByFilialId(con, sDefaultFiliale, sFirmaId);
            if (res != null) {
                while (res.next()) {
                    String sNutzerId = res.getString("NutzerId");
                    String sNutzerName = res.getString("NutzerName");
                    String sPasswort = res.getString("Passwort");
                    String sBearbeiternummer = res.getString("BearbeiterNummer");
                    this.mcNutzer.add(new Nutzer(this.getFirmaId(), sNutzerId, sNutzerName, sPasswort, sDefaultFiliale, sBearbeiternummer));
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Nutzer.loadNutzerByFilialId");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Nutzer.loadNutzerByFilialId");
    }
}

