/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileliste;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.DuplicateValueException;
import webetk.InvalidDataException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.teileliste.ScorelisteJob;
import webetk.app.teileliste.ScorelisteSrp;
import webetk.app.teileliste.Teil;
import webetk.app.teileliste.Teileliste;
import webetk.db.dbaccess.BteAnzeigeDbAccess;
import webetk.db.dbaccess.TeileListeDbAccess;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Scoreliste
extends Teileliste
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Scoreliste.class);
    @XmlElement
    private String msDurchlaufId;
    @XmlElement
    private String msFzgIdString;
    @XmlElements(value={@XmlElement(type=ScorelisteJob.class)})
    private Vector<ScorelisteJob> mcJobs;
    @XmlElement
    private String msAlterEigentuemerId = null;

    public Collection<ScorelisteJob> getJobs() {
        return this.mcJobs;
    }

    public void setJobs(Vector<ScorelisteJob> jobs) {
        this.mcJobs = jobs;
    }

    public Scoreliste() {
        this.mcJobs = new Vector();
    }

    public Scoreliste(String sID, String sSprache, String sNutzerID, String sFiliale) {
        this.msID = sID;
        this.msLanguage = sSprache;
        this.msFiliale = sFiliale;
        this.msNutzerID = sNutzerID;
        this.mcJobs = new Vector();
    }

    @Override
    public String getFzgIdString() {
        return this.msFzgIdString;
    }

    public void setFzgIdString(String sFzgIdString) {
        this.msFzgIdString = sFzgIdString;
    }

    public Vector getTeile() {
        Vector<Teil> aTeile = new Vector<Teil>();
        for (ScorelisteJob job : this.mcJobs) {
            for (ScorelisteSrp srp : job.getSrps()) {
                aTeile.addAll(srp.getTeile());
            }
        }
        return aTeile;
    }

    public Vector getTeileOhneLoeschflag() {
        Vector<Teil> aTeile = new Vector<Teil>();
        for (ScorelisteJob job : this.mcJobs) {
            for (ScorelisteSrp srp : job.getSrps()) {
                for (Teil oTeil : srp.getTeile()) {
                    if (oTeil.getScoreAenderung() == 4) continue;
                    aTeile.add(oTeil);
                }
            }
        }
        return aTeile;
    }

    public void setTeile(Collection cTeile) {
        for (Teil oTeil : cTeile) {
            ScorelisteJob job;
            boolean bFoundJob = false;
            Iterator<ScorelisteJob> iterJobs = this.mcJobs.iterator();
            while (iterJobs.hasNext() && !bFoundJob) {
                ScorelisteSrp srp;
                job = iterJobs.next();
                if (!oTeil.getJobId().equals(job.getId())) continue;
                bFoundJob = true;
                boolean bFoundSrp = false;
                Iterator<ScorelisteSrp> iterSrps = job.getSrps().iterator();
                while (iterSrps.hasNext() && !bFoundSrp) {
                    srp = iterSrps.next();
                    if (!oTeil.getSrpId().equals(srp.getId())) continue;
                    bFoundSrp = true;
                    srp.addTeil(oTeil);
                }
                if (bFoundSrp) continue;
                srp = new ScorelisteSrp();
                srp.setId(oTeil.getSrpId());
                srp.addTeil(oTeil);
                job.getSrps().add(srp);
            }
            if (bFoundJob) continue;
            job = new ScorelisteJob();
            job.setId(oTeil.getJobId());
            ScorelisteSrp srp = new ScorelisteSrp();
            srp.setId(oTeil.getSrpId());
            srp.addTeil(oTeil);
            job.getSrps().add(srp);
            this.mcJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextFreePos(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"getNextFreePos");
        long pos = 0L;
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Scoreliste.getNextFreePos");
            pos = TeileListeDbAccess.getNextPos(con, this.msID, this.msNutzerID, sFirma, this.msFiliale);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Scoreliste.getNextFreePos");
        }
        return pos;
    }

    public Collection getTeile(String jobId, String srpId) {
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            return job.getTeile(srpId);
        }
        return null;
    }

    public Collection getTeileOhneLoeschflag(String jobId, String srpId) {
        Vector<Teil> cTeile = new Vector<Teil>();
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            Collection cTeileSrp = job.getTeile(srpId);
            if (cTeileSrp == null) break;
            for (Teil oTeil : cTeileSrp) {
                if (oTeil.getScoreAenderung() == 4) continue;
                cTeile.add(oTeil);
            }
            return cTeile;
        }
        return null;
    }

    public int getPosPlatzhalter(String jobId, String srpId) {
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            return job.getPosPlatzhalter(srpId);
        }
        return 0;
    }

    public void setPosPlatzhalter(String jobId, String srpId, int posPlatzhalter) {
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            job.setPosPlatzhalter(srpId, posPlatzhalter);
        }
    }

    public Teil existsTeil(String sachnummer, boolean bLokalTeil, String jobId, String srpId) {
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            return job.existsTeil(sachnummer, bLokalTeil, srpId);
        }
        return null;
    }

    public void addTeil(Teil oTeil, String jobId, String srpId) {
        oTeil.setJobId(jobId);
        oTeil.setSrpId(srpId);
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            job.addTeil(oTeil, srpId);
        }
    }

    protected void removeTeil(Teil oTeil, String jobId, String srpId) {
        for (ScorelisteJob job : this.mcJobs) {
            if (!job.getId().equals(jobId)) continue;
            job.removeTeil(oTeil, srpId);
        }
    }

    public void saveTeile(Collection cTeile, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"saveTeile");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Scoreliste.saveTeile");
            con.setAutoCommit(false);
            for (Teil oTeil : cTeile) {
                if (!oTeil.getMustSave()) continue;
                TeileListeDbAccess.saveTeilInListe(con, oTeil, this.msID, this.msNutzerID, sFirma, this.msFiliale, oTeil.getJobId(), oTeil.getSrpId());
            }
            Calendar rightNow = Calendar.getInstance();
            this.mdatAenderung = rightNow.getTime();
            this.saveAenderungsdatum(con, sFirma);
        }
        catch (SQLException ex) {
            if (con != null) {
                con.rollback();
            }
            throw ex;
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
                gObj.freeDBConnectionNutzer(con, "Scoreliste.saveTeile");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteParts(Collection<Teil> cPartsToDelete, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Deleting Parts from Scoreliste");
        Connection con = null;
        try {
            Teil oTeil;
            con = gObj.getDBConnection("Scoreliste.deleteParts");
            Iterator<Teil> iter = cPartsToDelete.iterator();
            while (iter.hasNext()) {
                oTeil = iter.next();
                if (!oTeil.isTeilVonScore()) continue;
                log.debug((Object)"Teil von Score: Setze Loeschflag");
                oTeil.setScoreAenderung(4);
                TeileListeDbAccess.saveTeilScoreStatus(con, oTeil, this.msID, this.msNutzerID, sFirma, this.msFiliale);
                iter.remove();
            }
            iter = cPartsToDelete.iterator();
            if (iter.hasNext()) {
                log.debug((Object)"Teil nicht von Score");
                oTeil = iter.next();
                String sJobId = oTeil.getJobId();
                String sSrpId = oTeil.getSrpId();
                log.debug((Object)("Job: " + sJobId + " SRP: " + sSrpId));
                Collection oldTeile = this.getTeile(sJobId, sSrpId);
                if (oldTeile == null || oldTeile.size() <= cPartsToDelete.size()) {
                    log.debug((Object)"auf den Platzhalter updaten");
                    Teil platzhalter = Teil.createScorePlatzhalter();
                    platzhalter.setPos(oTeil.getPosInt());
                    TeileListeDbAccess.saveTeilInListe(con, platzhalter, this.msID, this.msNutzerID, sFirma, this.msFiliale, sJobId, sSrpId);
                    this.setPosPlatzhalter(sJobId, sSrpId, oTeil.getPosInt());
                    iter.remove();
                }
            }
            log.debug((Object)"die restlichen Teile loeschen");
            TeileListeDbAccess.deleteTeileAusTeileliste(con, cPartsToDelete, this.msID, this.msNutzerID, sFirma, this.msFiliale, false, true);
        }
        finally {
            gObj.freeDBConnection(con, "Scoreliste.deleteParts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobSrp(Collection cTeile, String sFirma, String sOldJobId, String sOldSrpId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Updating Job and SRP");
        Connection con = null;
        try {
            int nPosPlatzhalter;
            con = gObj.getDBConnection("Scoreliste.updateJobSrp");
            String sNewJobId = null;
            String sNewSrpId = null;
            for (Teil oTeil : cTeile) {
                sNewJobId = oTeil.getJobId();
                sNewSrpId = oTeil.getSrpId();
                TeileListeDbAccess.updateTeilInListe(con, this.msID, this.msNutzerID, sFirma, this.msFiliale, false, oTeil.getJobId(), oTeil.getSrpId(), oTeil);
                this.removeTeil(oTeil, sOldJobId, sOldSrpId);
                this.addTeil(oTeil, sNewJobId, sNewSrpId);
            }
            Collection oldTeile = this.getTeile(sOldJobId, sOldSrpId);
            if (oldTeile == null || oldTeile.size() == 0) {
                log.debug((Object)"Platzhalter neu einfuegen");
                Teil platzhalter = Teil.createScorePlatzhalter();
                platzhalter.setPos((int)this.getNextFreePos(sFirma));
                TeileListeDbAccess.saveTeilInListe(con, platzhalter, this.msID, this.msNutzerID, sFirma, this.msFiliale, sOldJobId, sOldSrpId);
                this.setPosPlatzhalter(sOldJobId, sOldSrpId, platzhalter.getPosInt());
            }
            if ((nPosPlatzhalter = this.getPosPlatzhalter(sNewJobId, sNewSrpId)) > 0) {
                log.debug((Object)"Platzhalter loeschen");
                Teil platzhalter = Teil.createScorePlatzhalter();
                platzhalter.setPos(nPosPlatzhalter);
                Vector<Teil> cPartsToDelete = new Vector<Teil>();
                cPartsToDelete.add(platzhalter);
                TeileListeDbAccess.deleteTeileAusTeileliste(con, cPartsToDelete, this.msID, this.msNutzerID, sFirma, this.msFiliale, false, true);
                this.setPosPlatzhalter(sNewJobId, sNewSrpId, 0);
            }
        }
        finally {
            gObj.freeDBConnection(con, "Scoreliste.updateJobSrp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTeileInDB(String sFirma, String sJobId, String sSrpId) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("insertTeileInDB, Job: " + sJobId + " SRP: " + sSrpId));
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Scoreliste.insertTeileInDB");
            TeileListeDbAccess.insertTeile(con, this, sFirma, sJobId, sSrpId);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Scoreliste.insertTeileInDB");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean bNeuanlage, String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Storing Scoreliste");
        Connection con = null;
        try {
            boolean bInserted = false;
            while (!bInserted) {
                try {
                    con = gObj.getDBConnectionNutzer("Scoreliste.storeTeileliste");
                    TeileListeDbAccess.storeTeileliste(con, this, bNeuanlage, sFirma);
                    bInserted = true;
                }
                catch (DuplicateValueException ex) {}
            }
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Scoreliste.storeTeileliste");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Loading Partslist ID: " + this.msID + " User: " + this.msNutzerID));
        Connection con = null;
        ResultSet res = null;
        try {
            String sPrivat;
            con = gObj.getDBConnectionNutzer("Scoreliste.reload");
            res = TeileListeDbAccess.loadTeilelisteAllgemein(con, this.msID, this.msNutzerID, sFirma, sFiliale);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            this.msFiliale = sFiliale;
            this.msMarke = res.getString("Marke");
            this.mdatErstellung = WebetkUtils.getDateFromLong(res.getLong("Erzeugt"));
            this.mdatAenderung = WebetkUtils.getDateFromLong(res.getLong("Geaendert"));
            this.mlKundenNrLokal = null;
            String sKundenNrLokal = res.getString("KundennrLokal");
            if (sKundenNrLokal != null && sKundenNrLokal.length() > 0) {
                this.mlKundenNrLokal = new Long(sKundenNrLokal);
            }
            this.mbPrivat = (sPrivat = res.getString("Privat")) != null && sPrivat.equals("J");
            this.msDurchlaufId = res.getString("DurchlaufId");
            WebetkUtils.closeQuery(res);
            HashMap<String, ScorelisteJob> mapJobs = new HashMap<String, ScorelisteJob>();
            res = TeileListeDbAccess.loadJobs(con, this.msID, sFirma, sFiliale, this.msNutzerID);
            while (res != null && res.next()) {
                String sID = res.getString("id");
                String sBen = res.getString("ben");
                String sLock = res.getString("lockflag");
                boolean bLock = sLock != null && sLock.equals("J");
                log.debug((Object)("Job " + sID + " " + sBen + " geladen"));
                ScorelisteJob job = new ScorelisteJob();
                job.setId(sID);
                job.setBezeichnung(sBen);
                job.setLock(bLock);
                mapJobs.put(sID, job);
            }
            WebetkUtils.closeQuery(res);
            HashMap<String, ScorelisteSrp> mapSrps = new HashMap<String, ScorelisteSrp>();
            res = TeileListeDbAccess.loadSrps(con, this.msID, sFirma, sFiliale, this.msNutzerID);
            while (res != null && res.next()) {
                String sID = res.getString("id");
                String sBen = res.getString("ben");
                String sJobID = res.getString("jobid");
                String sLock = res.getString("lockflag");
                String sQuelle = res.getString("quelle");
                boolean bLock = sLock != null && sLock.equals("J");
                log.debug((Object)("SRP " + sID + " " + sBen + " geladen"));
                ScorelisteSrp srp = new ScorelisteSrp();
                srp.setId(sID);
                srp.setBezeichnung(sBen);
                srp.setLock(bLock);
                srp.setQuelle(sQuelle);
                mapSrps.put(sJobID + sID, srp);
            }
            WebetkUtils.closeQuery(res);
            res = TeileListeDbAccess.loadTeilelistePositionen(con, this.msID, this.msNutzerID, this.msLanguage, sFirma, sFiliale);
            this.mcTeile = new Vector();
            if (res != null) {
                ScorelisteJob oLastJob = null;
                ScorelisteSrp oLastSrp = null;
                int nPosGemerkt = -1;
                Teil objTeil = null;
                while (res.next()) {
                    boolean bLokalteil;
                    String sSachnummer = res.getString("SachNr").trim();
                    String sHgUg = res.getString("HgUg");
                    String sHg = "";
                    String sUg = "";
                    if (sHgUg != null) {
                        if ((sHgUg = sHgUg.trim()).length() == 4) {
                            sHg = sHgUg.substring(0, 2);
                            sUg = sHgUg.substring(2, 4);
                        } else if (sHgUg.length() > 2) {
                            sHg = sHgUg.substring(0, 2);
                            sUg = sHgUg.substring(2);
                        } else {
                            sHg = sHgUg;
                        }
                    }
                    int nPos = res.getInt("Pos");
                    String sMenge = res.getString("Menge");
                    String sBemerkung = res.getString("Bemerkung");
                    String sBenennung = res.getString("Benennung");
                    String sZusatz = res.getString("Zusatz");
                    boolean bl = bLokalteil = res.getString("Lokalteil") != null && res.getString("Lokalteil").equals("J");
                    if (nPosGemerkt == -1 || nPos != nPosGemerkt) {
                        nPosGemerkt = nPos;
                        objTeil = new Teil();
                        objTeil.setPos(nPos);
                        objTeil.setHG(sHg);
                        objTeil.setUG(sUg);
                        objTeil.setSachnummer(sSachnummer);
                        objTeil.setBenennung(sBenennung);
                        objTeil.setZusatz(sZusatz);
                        objTeil.setMenge(sMenge);
                        objTeil.setBemerkung(sBemerkung);
                        objTeil.appendMarke(res.getString("Marke"));
                        objTeil.setTeileart(res.getString("Teileart"));
                        objTeil.setProduktklasse(res.getString("ProduktKlasse"));
                        objTeil.setRuecksendepflicht(res.getString("Ruecksendepflicht"));
                        objTeil.setMAM(res.getInt("MAM"));
                        objTeil.setVVM(res.getInt("VVM"));
                        objTeil.setLVM(res.getInt("LVM"));
                        objTeil.setBVM(res.getInt("BVM"));
                        objTeil.setMengenEinheit(res.getString("Mengeneinheit"));
                        Double oDValue = null;
                        if (res.getString("Lagerbestand") != null) {
                            oDValue = new Double(res.getDouble("Lagerbestand"));
                        }
                        objTeil.setLagerbestand(oDValue);
                        if (res.getString("Minimalbestand") != null) {
                            oDValue = new Double(res.getDouble("Minimalbestand"));
                        }
                        objTeil.setMinimalbestand(oDValue);
                        Integer nIValue = null;
                        if (res.getString("Bedarfshinweis") != null) {
                            nIValue = new Integer(res.getInt("Bedarfshinweis"));
                        }
                        objTeil.setBedarfshinweis(nIValue);
                        String sValue = res.getString("Lagerort");
                        objTeil.setLagerort(sValue);
                        if (res.getString("AuMe") != null) {
                            oDValue = new Double(res.getDouble("AuMe"));
                        }
                        objTeil.setAuMe(oDValue);
                        double dValue = res.getDouble("Preis");
                        objTeil.setPreis(dValue);
                        if (res.getString("Rabatt") != null) {
                            oDValue = new Double(res.getDouble("Rabatt"));
                        }
                        objTeil.setRabatt(oDValue);
                        sValue = res.getString("Splitt");
                        objTeil.setSplitt(sValue);
                        sValue = res.getString("Transparenz");
                        objTeil.setTransparenz(sValue);
                        sValue = res.getString("Suffix");
                        objTeil.setSuffix(sValue);
                        sValue = res.getString("Dispocode");
                        objTeil.setDispo(sValue);
                        sValue = res.getString("Ruecksendepflicht");
                        objTeil.setRuecksendepflicht(sValue);
                        sValue = res.getString("MwSt");
                        if (sValue == null) {
                            objTeil.setMwSt(null);
                        } else {
                            objTeil.setMwSt(new Double(res.getDouble("MwSt")));
                        }
                        sValue = res.getString("AltteilSteuer");
                        if (sValue == null) {
                            objTeil.setAtSt(null);
                        } else {
                            objTeil.setAtSt(new Double(res.getDouble("AltteilSteuer")));
                        }
                        objTeil.setLokalteil(bLokalteil);
                        objTeil.setHatNotiz(res.getString("SachnrMitNotiz") != null);
                        objTeil.setScoreAenderung(res.getInt("Status"));
                        String sPruefen = res.getString("Pruefen");
                        boolean bPruefen = sPruefen != null && sPruefen.equals("J");
                        objTeil.setScorePruefen(bPruefen);
                        String sLock = res.getString("lockflag");
                        boolean bLock = sLock != null && sLock.equals("J");
                        objTeil.setScoreLock(bLock);
                        String sJobId = res.getString("JobId");
                        objTeil.setJobId(sJobId);
                        String sSrpId = res.getString("SrpId");
                        objTeil.setSrpId(sSrpId);
                        if (oLastJob == null || !oLastJob.getId().equals(sJobId)) {
                            ScorelisteJob job = (ScorelisteJob)mapJobs.get(sJobId);
                            this.mcJobs.add(job);
                            oLastJob = job;
                            oLastSrp = null;
                        }
                        if (oLastSrp == null || !oLastSrp.getId().equals(sSrpId)) {
                            ScorelisteSrp srp = (ScorelisteSrp)mapSrps.get(sJobId + sSrpId);
                            oLastJob.getSrps().add(srp);
                            oLastSrp = srp;
                        }
                        if (!objTeil.getSachnummer().equals("_empty_")) {
                            oLastSrp.getTeile().add(objTeil);
                            continue;
                        }
                        oLastSrp.setPosPlatzhalter(objTeil.getPosInt());
                        continue;
                    }
                    String sMarke = res.getString("Marke");
                    objTeil.appendMarke(sMarke);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Scoreliste.reload");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Scoreliste.reload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTeile(Collection cTeile, String sSprache, boolean bReplaceMenge, boolean bLoadPubldaten, String sNutzer, String sFirma, String sJobId, String sSrpId) throws SQLException, DatabaseBusyException, NoDataFoundException, InvalidDataException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"Entering Function");
        int nNextFreePos = 0;
        for (Teil objTeil : cTeile) {
            Teil objTeilAlt = this.existsTeil(objTeil.getSachnummer(), objTeil.getLokalteil(), sJobId, sSrpId);
            if (objTeilAlt != null) {
                log.info((Object)"es gibt das Teil schon");
                if (bReplaceMenge) {
                    objTeilAlt.setMenge(objTeil.getMenge());
                } else {
                    try {
                        double dMenge = new Double(objTeilAlt.getMenge());
                        objTeilAlt.setMenge(new Double(dMenge += 1.0).toString());
                    }
                    catch (Exception e) {
                        log.debug((Object)"Menge ist keine Zahl!");
                    }
                }
                objTeilAlt.setUpdate(true);
                objTeilAlt.setScoreAenderung(3);
                continue;
            }
            log.info((Object)"es gibt das Teil noch nicht");
            objTeil.setInsert(true);
            objTeil.setScoreAenderung(2);
            Collection cTeileInJobSrp = this.getTeile(sJobId, sSrpId);
            if (cTeileInJobSrp.size() == 0) {
                log.info((Object)"den Platzhalter auf das Teil updaten");
                objTeil.setUpdate(true);
                objTeil.setInsert(false);
                objTeil.setPos(this.getPosPlatzhalter(sJobId, sSrpId));
                this.setPosPlatzhalter(sJobId, sSrpId, 0);
            } else {
                nNextFreePos = nNextFreePos == 0 ? (int)this.getNextFreePos(sFirma) : ++nNextFreePos;
                objTeil.setPos(nNextFreePos);
            }
            if (!objTeil.getLokalteil() && bLoadPubldaten) {
                ResultSet res;
                Connection con;
                block13: {
                    log.info((Object)"Daten zum Teil laden");
                    con = null;
                    res = null;
                    try {
                        con = gObj.getDBConnection("Scoreliste.addTeile");
                        res = TeileListeDbAccess.loadTeil(con, objTeil.getSachnummer(), sSprache);
                        if (res == null || !res.next()) {
                            throw new NoDataFoundException();
                        }
                        objTeil.appendMarke(res.getString("Marke"));
                        objTeil.setTeileart(res.getString("Teileart"));
                        objTeil.setHG(res.getString("Hg"));
                        objTeil.setUG(res.getString("Ug"));
                        objTeil.setBenennung(res.getString("Benennung"));
                        objTeil.setZusatz(res.getString("Zusatz"));
                        objTeil.setMAM(res.getInt("MAM"));
                        objTeil.setFertigungshinweis(res.getString("FH"));
                        if (objTeil.checkMarke(this.msMarke)) break block13;
                        throw new InvalidDataException();
                    }
                    catch (Throwable throwable) {
                        WebetkUtils.closeQuery(res);
                        gObj.freeDBConnection(con, "Scoreliste.addTeile");
                        throw throwable;
                    }
                }
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Scoreliste.addTeile");
            }
            if (!bReplaceMenge) {
                objTeil.setMenge("1");
            }
            log.info((Object)("Teil hinzuf\u00fcgen Job: " + sJobId + " SRP " + sSrpId));
            this.addTeil(objTeil, sJobId, sSrpId);
        }
    }

    public String getDurchlaufId() {
        return this.msDurchlaufId;
    }

    public void setDurchlaufId(String sDurchlaufId) {
        this.msDurchlaufId = sDurchlaufId;
    }

    @Override
    public double ermittleSummeNetto() {
        this.mcTeile = this.getTeileOhneLoeschflag();
        return super.ermittleSummeNetto();
    }

    @Override
    public double ermittleSummeBrutto() {
        this.mcTeile = this.getTeileOhneLoeschflag();
        return super.ermittleSummeBrutto();
    }

    @Override
    public void doPubldatenAbgleich(String sFirma, String sFiliale) throws SQLException, DatabaseBusyException {
        Teileliste.doPubldatenAbgleich(sFirma, sFiliale, this.getID(), this.getNutzerID(), this.getTeile(), this.msLanguage);
    }

    public String getAlterEigentuemerId() {
        return this.msAlterEigentuemerId;
    }

    public void setAlterEigentuemerId(String alterEigentuemerId) {
        this.msAlterEigentuemerId = alterEigentuemerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTcKennzeichen(FzgSucheInfo oFzgSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("Scoreliste.loadTcKennzeichen");
            Vector cTeile = this.getTeile();
            Iterator iter = cTeile.iterator();
            while (iter != null && iter.hasNext()) {
                Teil oTeil = (Teil)iter.next();
                if (oTeil == null) continue;
                String sSachnummer = oTeil.getSachnummer();
                boolean bTC = this.ermittleTcKennzeichen(con, oFzgSucheInfo, sSachnummer, sLandkuerzel);
                oTeil.setTcKennzeichen(bTC);
            }
        }
        finally {
            gObj.freeDBConnection(con, "Scoreliste.loadTcKennzeichen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean ermittleTcKennzeichen(Connection con, FzgSucheInfo oFzgSucheInfo, String sSachnummer, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        block4: {
            block5: {
                res = null;
                try {
                    lModellspalte = oFzgSucheInfo.getModellspalte();
                    res = TeileListeDbAccess.loadTCKennzeichen(con, sSachnummer, lModellspalte, sLandkuerzel);
                    if (res == null || !res.next()) break block4;
                    sTCProddatRelevant = res.getString("Teil_TC_ProdDatRelevant");
                    if (!sTCProddatRelevant.equals("J")) ** GOTO lbl21
                    sProdDatumMin = oFzgSucheInfo.getProduktionsdatumMin();
                    sProdDatumMax = oFzgSucheInfo.getProduktionsdatumMax();
                    if (StringUtils.isEmpty(sProdDatumMin, true) || StringUtils.isEmpty(sProdDatumMax, true)) break block5;
                    sTC = BteAnzeigeDbAccess.ermittleTCKezBzglProddatum(con, sSachnummer, lModellspalte, sProdDatumMin, sProdDatumMax, sLandkuerzel);
                    var12_13 = sTC != null;
                }
                catch (Throwable var13_14) {
                    WebetkUtils.closeQuery(res);
                    throw var13_14;
                }
                WebetkUtils.closeQuery(res);
                return var12_13;
            }
            break block4;
lbl21:
            // 1 sources

            var9_10 = true;
            WebetkUtils.closeQuery(res);
            return var9_10;
        }
        var8_8 = false;
        WebetkUtils.closeQuery(res);
        return var8_8;
    }

    public String getMsDurchlaufId() {
        return this.msDurchlaufId;
    }

    public void setMsDurchlaufId(String msDurchlaufId) {
        this.msDurchlaufId = msDurchlaufId;
    }

    public String getMsFzgIdString() {
        return this.msFzgIdString;
    }

    public void setMsFzgIdString(String msFzgIdString) {
        this.msFzgIdString = msFzgIdString;
    }

    public Collection<ScorelisteJob> getMcJobs() {
        return this.mcJobs;
    }

    public void setMcJobs(Vector<ScorelisteJob> mcJobs) {
        this.mcJobs = mcJobs;
    }

    public String getMsAlterEigentuemerId() {
        return this.msAlterEigentuemerId;
    }

    public void setMsAlterEigentuemerId(String msAlterEigentuemerId) {
        this.msAlterEigentuemerId = msAlterEigentuemerId;
    }
}

