/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileliste;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.GenericTeil;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.TeileListeDbAccess;

@XmlRootElement(name="webetk.app.teileliste.Teil")
@XmlType(name="webetk.app.teileliste.Teil")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Teil
extends GenericTeil {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Teil.class);
    @XmlElements(value={@XmlElement(type=String.class)})
    private Vector<String> maMarke;
    @XmlElement
    private String msTeileart;
    @XmlElement
    private int mnPos;
    @XmlTransient
    private final DecimalFormat df5 = new DecimalFormat("00000");
    @XmlElement
    private String msMenge;
    @XmlElement
    private String msMengenEinheit;
    @XmlElement
    private String msBemerkung;
    @XmlElement
    private boolean mbInsert = false;
    @XmlElement
    private boolean mbUpdate = false;
    @XmlElement
    private boolean mbMustSave = false;
    @XmlElement
    private boolean mbLokalteil = false;
    @XmlElement
    private Double mdLagerbestand = null;
    @XmlElement
    private Double mdMinimalbestand = null;
    @XmlElement
    private Integer mnBedarfshinweis = null;
    @XmlElement
    private String msLagerort = null;
    @XmlElement
    private Double mdAuMe = null;
    @XmlElement
    private double mdPreis = 0.0;
    @XmlElement
    private Double mdRabatt = null;
    @XmlElement
    private String msSplitt = null;
    @XmlElement
    private String msTransparenz = null;
    @XmlElement
    private String msSuffix = null;
    @XmlElement
    private String msDispo = null;
    @XmlElement
    private Double mdMwSt = null;
    @XmlElement
    private Double mdAtSt = null;
    @XmlElement
    private int mnMAM = 0;
    @XmlElement
    private String msAuftragsnummer = null;
    @XmlElement
    private Long mlKundennummer = null;
    @XmlElement
    private boolean mbHatNotiz = false;
    @XmlElement
    private String msRabattSchluessel = null;
    @XmlElement
    private String msProduktklasse = null;
    @XmlElement
    private int mnVVM = 0;
    @XmlElement
    private int mnLVM = 0;
    @XmlElement
    private int mnBVM = 0;
    @XmlElement
    private String msMwstCode = null;
    @XmlElement
    private double mdHaendlerpreis = 0.0;
    @XmlElement
    private double mdUPE = 0.0;
    @XmlElement
    private String msPreisaenderKZ = null;
    @XmlElement
    private String msSonderpreisKZ = null;
    @XmlElement
    private double mdSNP = 0.0;
    @XmlElement
    private double mdNettoPreisDatei = 0.0;
    @XmlElement
    private double mdNachbelastungspauschale = 0.0;
    @XmlElement
    private String msZolltarifnummer = null;
    @XmlElement
    private Double mdSapPreis = null;
    @XmlElement
    private String msSapKodierungsstufe = null;
    @XmlElement
    private String msSapVerfuegbarkeit = null;
    @XmlElement
    private String msSapVerfuegbarkeitHinweis = null;
    @XmlElement
    private String msFertigungshinweis = null;
    @XmlElement
    private boolean mbScorePruefen = false;
    @XmlElement
    private boolean mbScoreLock = false;
    @XmlElement
    private int mnScoreAenderung;
    public static final int SCORE_KEIN_SCORE = 0;
    public static final int SCORE_VON_SCORE = 1;
    public static final int SCORE_NEU = 2;
    public static final int SCORE_GEAENDERT = 3;
    public static final int SCORE_GELOESCHT = 4;
    @XmlElement
    private String msJobId = null;
    @XmlElement
    private String msSrpId = null;
    @XmlElement
    private boolean mbTcKennzeichen = false;
    @XmlElement
    private String msFIString = null;
    @XmlElement
    private String msFIKuerzel = null;
    @XmlElement
    private boolean mbAspg = false;
    @XmlElement
    private boolean mbReach = false;
    @XmlElement
    private boolean mbStecker = false;
    @XmlElement
    private String mAspgTyp = "";
    @XmlElement
    private String mAspgRef = "";
    @XmlElement
    private String mAspgMenge = "";

    public Teil() {
    }

    public Teil(Teil oTeil) {
        this.msSachnummer = oTeil.msSachnummer;
        this.maMarke = oTeil.maMarke;
        this.msTeileart = oTeil.msTeileart;
        this.msHG = oTeil.msHG;
        this.msUG = oTeil.msUG;
        this.mnPos = oTeil.mnPos;
        this.msMenge = oTeil.msMenge;
        this.msBemerkung = oTeil.msBemerkung;
        this.msBenennung = oTeil.msBenennung;
        this.msZusatz = oTeil.msZusatz;
        this.mbInsert = oTeil.mbInsert;
        this.mbUpdate = oTeil.mbUpdate;
        this.mbMustSave = oTeil.mbMustSave;
        this.msMengenEinheit = oTeil.msMengenEinheit;
        this.mbLokalteil = oTeil.mbLokalteil;
        this.mdLagerbestand = oTeil.mdLagerbestand;
        this.mdMinimalbestand = oTeil.mdMinimalbestand;
        this.mnBedarfshinweis = oTeil.mnBedarfshinweis;
        this.msLagerort = oTeil.msLagerort;
        this.mdAuMe = oTeil.mdAuMe;
        this.mdPreis = oTeil.mdPreis;
        this.mdRabatt = oTeil.mdRabatt;
        this.msSplitt = oTeil.msSplitt;
        this.msTransparenz = oTeil.msTransparenz;
        this.msSuffix = oTeil.msSuffix;
        this.msDispo = oTeil.msDispo;
        this.mdMwSt = oTeil.mdMwSt;
        this.mdAtSt = oTeil.mdAtSt;
        this.mnMAM = oTeil.mnMAM;
        this.msAuftragsnummer = oTeil.msAuftragsnummer;
        this.mlKundennummer = oTeil.mlKundennummer;
        this.msRabattSchluessel = oTeil.msRabattSchluessel;
        this.msProduktklasse = oTeil.msProduktklasse;
        this.mnVVM = oTeil.mnVVM;
        this.mnLVM = oTeil.mnLVM;
        this.mnBVM = oTeil.mnBVM;
        this.msMwstCode = oTeil.msMwstCode;
        this.mdHaendlerpreis = oTeil.mdHaendlerpreis;
        this.mdUPE = oTeil.mdUPE;
        this.msPreisaenderKZ = oTeil.msPreisaenderKZ;
        this.msSonderpreisKZ = oTeil.msSonderpreisKZ;
        this.mdSNP = oTeil.mdSNP;
        this.mdNettoPreisDatei = oTeil.mdNettoPreisDatei;
        this.mdNachbelastungspauschale = oTeil.mdNachbelastungspauschale;
        this.msZolltarifnummer = oTeil.msZolltarifnummer;
        this.mdSapPreis = oTeil.mdSapPreis;
        this.msSapKodierungsstufe = oTeil.msSapKodierungsstufe;
        this.msSapVerfuegbarkeit = oTeil.msSapVerfuegbarkeit;
        this.msSapVerfuegbarkeitHinweis = oTeil.msSapVerfuegbarkeitHinweis;
        this.msFertigungshinweis = oTeil.msFertigungshinweis;
        this.mbHatNotiz = oTeil.mbHatNotiz;
        this.msFIString = oTeil.msFIString;
        this.msFIKuerzel = oTeil.msFIKuerzel;
        this.mbScorePruefen = oTeil.mbScorePruefen;
        this.mnScoreAenderung = oTeil.mnScoreAenderung;
        this.msJobId = oTeil.msJobId;
        this.msSrpId = oTeil.msSrpId;
        this.mbTcKennzeichen = oTeil.mbTcKennzeichen;
    }

    public boolean equals(Object oObj) {
        if (oObj == null) {
            return false;
        }
        if (!(oObj instanceof Teil)) {
            return false;
        }
        Teil oTeil = (Teil)oObj;
        boolean bIsEqualMarken = this.isEqualMarken(this.maMarke, oTeil.maMarke);
        boolean bEqual = (this.msSachnummer == null && oTeil.msSachnummer == null || this.msSachnummer != null && this.msSachnummer.equals(oTeil.msSachnummer)) && bIsEqualMarken && (this.msTeileart == null && oTeil.msTeileart == null || this.msTeileart != null && this.msTeileart.equals(oTeil.msTeileart)) && (this.msHG == null && oTeil.msHG == null || this.msHG != null && this.msHG.equals(oTeil.msHG)) && (this.msUG == null && oTeil.msUG == null || this.msUG != null && this.msUG.equals(oTeil.msUG)) && this.mnPos == oTeil.mnPos && (this.msMenge == null && oTeil.msMenge == null || this.msMenge != null && this.msMenge.equals(oTeil.msMenge)) && (this.msBemerkung == null && oTeil.msBemerkung == null || this.msBemerkung != null && this.msBemerkung.equals(oTeil.msBemerkung)) && (this.msBenennung == null && oTeil.msBenennung == null || this.msBenennung != null && this.msBenennung.equals(oTeil.msBenennung)) && (this.msZusatz == null && oTeil.msZusatz == null || this.msZusatz != null && this.msZusatz.equals(oTeil.msZusatz)) && this.mbInsert == oTeil.mbInsert && this.mbUpdate == oTeil.mbUpdate && this.mbMustSave == oTeil.mbMustSave && (this.msMengenEinheit == null && oTeil.msMengenEinheit == null || this.msMengenEinheit != null && this.msMengenEinheit.equals(oTeil.msMengenEinheit)) && this.mbLokalteil == oTeil.mbLokalteil && (this.mdLagerbestand == null && oTeil.mdLagerbestand == null || this.mdLagerbestand != null && this.mdLagerbestand.equals(oTeil.mdLagerbestand)) && (this.mdMinimalbestand == null && oTeil.mdMinimalbestand == null || this.mdMinimalbestand != null && this.mdMinimalbestand.equals(oTeil.mdMinimalbestand)) && (this.mnBedarfshinweis == null && oTeil.mnBedarfshinweis == null || this.mnBedarfshinweis != null && this.mnBedarfshinweis.equals(oTeil.mnBedarfshinweis)) && (this.msLagerort == null && oTeil.msLagerort == null || this.msLagerort != null && this.msLagerort.equals(oTeil.msLagerort)) && (this.mdAuMe == null && oTeil.mdAuMe == null || this.mdAuMe != null && this.mdAuMe.equals(oTeil.mdAuMe)) && this.mdPreis == oTeil.mdPreis && (this.mdRabatt == null && oTeil.mdRabatt == null || this.mdRabatt != null && this.mdRabatt.equals(oTeil.mdRabatt)) && this.mdRabatt == oTeil.mdRabatt && (this.msSplitt == null && oTeil.msSplitt == null || this.msSplitt != null && this.msSplitt.equals(oTeil.msSplitt)) && (this.msTransparenz == null && oTeil.msTransparenz == null || this.msTransparenz != null && this.msTransparenz.equals(oTeil.msTransparenz)) && (this.msSuffix == null && oTeil.msSuffix == null || this.msSuffix != null && this.msSuffix.equals(oTeil.msSuffix)) && (this.msDispo == null && oTeil.msDispo == null || this.msDispo != null && this.msDispo.equals(oTeil.msDispo)) && (this.mdMwSt == null && oTeil.mdMwSt == null || this.mdMwSt != null && this.mdMwSt.equals(oTeil.mdMwSt)) && (this.mdAtSt == null && oTeil.mdAtSt == null || this.mdAtSt != null && this.mdAtSt.equals(oTeil.mdAtSt)) && this.mnMAM == oTeil.mnMAM && (this.msAuftragsnummer == null && oTeil.msAuftragsnummer == null || this.msAuftragsnummer != null && this.msAuftragsnummer.equals(oTeil.msAuftragsnummer)) && (this.mlKundennummer == null && oTeil.mlKundennummer == null || this.mlKundennummer != null && this.mlKundennummer.equals(oTeil.mlKundennummer)) && (this.msRabattSchluessel == null && oTeil.msRabattSchluessel == null || this.msRabattSchluessel != null && this.msRabattSchluessel.equals(oTeil.msRabattSchluessel)) && (this.msProduktklasse == null && oTeil.msProduktklasse == null || this.msProduktklasse != null && this.msProduktklasse.equals(oTeil.msProduktklasse)) && this.mnVVM == oTeil.mnVVM && this.mnLVM == oTeil.mnLVM && this.mnBVM == oTeil.mnBVM && (this.msMwstCode == null && oTeil.msMwstCode == null || this.msMwstCode != null && this.msMwstCode.equals(oTeil.msMwstCode)) && this.mdHaendlerpreis == oTeil.mdHaendlerpreis && this.mdUPE == oTeil.mdUPE && (this.msPreisaenderKZ == null && oTeil.msPreisaenderKZ == null || this.msPreisaenderKZ != null && this.msPreisaenderKZ.equals(oTeil.msPreisaenderKZ)) && (this.msSonderpreisKZ == null && oTeil.msSonderpreisKZ == null || this.msSonderpreisKZ != null && this.msSonderpreisKZ.equals(oTeil.msSonderpreisKZ)) && this.mdSNP == oTeil.mdSNP && this.mdNettoPreisDatei == oTeil.mdNettoPreisDatei && this.mdNachbelastungspauschale == oTeil.mdNachbelastungspauschale && (this.msFIString == null && oTeil.msFIString == null || this.msFIString != null && this.msFIString.equals(oTeil.msFIString)) && (this.msZolltarifnummer == null && oTeil.msZolltarifnummer == null || this.msZolltarifnummer != null && this.msZolltarifnummer.equals(oTeil.msZolltarifnummer)) && (this.mdSapPreis == null && oTeil.mdSapPreis == null || this.mdSapPreis != null && this.mdSapPreis.equals(oTeil.mdSapPreis)) && (this.msSapKodierungsstufe == null && oTeil.msSapKodierungsstufe == null || this.msSapKodierungsstufe != null && this.msSapKodierungsstufe.equals(oTeil.msSapKodierungsstufe)) && (this.msSapVerfuegbarkeit == null && oTeil.msSapVerfuegbarkeit == null || this.msSapVerfuegbarkeit != null && this.msSapVerfuegbarkeit.equals(oTeil.msSapVerfuegbarkeit)) && (this.msSapVerfuegbarkeitHinweis == null && oTeil.msSapVerfuegbarkeitHinweis == null || this.msSapVerfuegbarkeitHinweis != null && this.msSapVerfuegbarkeitHinweis.equals(oTeil.msSapVerfuegbarkeitHinweis)) && (this.msFertigungshinweis == null && oTeil.msFertigungshinweis == null || this.msFertigungshinweis != null && this.msFertigungshinweis.equals(oTeil.msFertigungshinweis));
        return bEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.msSachnummer != null) {
            result = 37 * result + this.msSachnummer.hashCode();
        }
        return result;
    }

    public Teil(String sSachnummer) {
        this.msSachnummer = sSachnummer;
        this.maMarke = null;
        this.msTeileart = "";
        this.msHG = "";
        this.msUG = "";
        this.mnPos = 0;
        this.msMenge = "";
        this.msBemerkung = "";
        this.msBenennung = "";
        this.msZusatz = "";
        this.msMengenEinheit = "";
        this.mbLokalteil = false;
        this.mdLagerbestand = null;
        this.mdMinimalbestand = null;
        this.mnBedarfshinweis = null;
        this.msLagerort = null;
        this.mdAuMe = null;
        this.mdPreis = 0.0;
        this.mdRabatt = null;
        this.msSplitt = null;
        this.msTransparenz = null;
        this.msSuffix = null;
        this.msDispo = null;
        this.mdMwSt = null;
        this.mdAtSt = null;
        this.mbHatNotiz = false;
        this.msFIString = null;
        this.msFIKuerzel = null;
        this.mbScorePruefen = false;
        this.mnScoreAenderung = 0;
        this.msJobId = null;
        this.msSrpId = null;
        this.mbTcKennzeichen = false;
    }

    public Teil(String sSachnummer, String sMenge, String sBemerkung) {
        this.msSachnummer = sSachnummer;
        this.maMarke = null;
        this.msTeileart = "";
        this.msHG = "";
        this.msUG = "";
        this.mnPos = 0;
        this.msMenge = sMenge;
        this.msBemerkung = sBemerkung;
        this.msBenennung = "";
        this.msZusatz = "";
        this.msMengenEinheit = "";
        this.mbLokalteil = false;
        this.mdLagerbestand = null;
        this.mdMinimalbestand = null;
        this.mnBedarfshinweis = null;
        this.msLagerort = null;
        this.mdAuMe = null;
        this.mdPreis = 0.0;
        this.mdRabatt = null;
        this.msSplitt = null;
        this.msTransparenz = null;
        this.msSuffix = null;
        this.msDispo = null;
        this.mdMwSt = null;
        this.mdAtSt = null;
        this.mbHatNotiz = false;
        this.msFIString = null;
        this.msFIKuerzel = null;
        this.mbScorePruefen = false;
        this.mnScoreAenderung = 0;
        this.msJobId = null;
        this.msSrpId = null;
        this.mbTcKennzeichen = false;
    }

    public Teil(String sSachnummer, String sHg, String sUg, int nPos, String sMenge, String sBemerkung, String sBenennung, String sZusatz) {
        this.msSachnummer = sSachnummer;
        this.maMarke = null;
        this.msTeileart = "";
        this.msHG = sHg;
        this.msUG = sUg;
        this.mnPos = nPos;
        this.msMenge = sMenge;
        this.msBemerkung = sBemerkung;
        this.msBenennung = sBenennung;
        this.msZusatz = sZusatz;
        this.msMengenEinheit = "";
        this.mbLokalteil = false;
        this.mdLagerbestand = null;
        this.mdMinimalbestand = null;
        this.mnBedarfshinweis = null;
        this.msLagerort = null;
        this.mdAuMe = null;
        this.mdPreis = 0.0;
        this.mdRabatt = null;
        this.msSplitt = null;
        this.msTransparenz = null;
        this.msSuffix = null;
        this.msDispo = null;
        this.mdMwSt = null;
        this.mdAtSt = null;
        this.mbHatNotiz = false;
        this.msFIString = null;
        this.msFIKuerzel = null;
        this.mbScorePruefen = false;
        this.mnScoreAenderung = 0;
        this.msJobId = null;
        this.msSrpId = null;
        this.mbTcKennzeichen = false;
    }

    public Teil(String sSachnummer, String sHg, String sUg, int nPos, String sMenge, String sBemerkung, String sBenennung, String sZusatz, Double dSapPreis, String sSapKodierungsstufe, String sSapWaehrung, String sSapVerfuegbarkeit, String sSapVerfuegbarkeitHinweis) {
        this.msSachnummer = sSachnummer;
        this.maMarke = null;
        this.msTeileart = "";
        this.msHG = sHg;
        this.msUG = sUg;
        this.mnPos = nPos;
        this.msMenge = sMenge;
        this.msBemerkung = sBemerkung;
        this.msBenennung = sBenennung;
        this.msZusatz = sZusatz;
        this.msMengenEinheit = "";
        this.mbLokalteil = false;
        this.mdLagerbestand = null;
        this.mdMinimalbestand = null;
        this.mnBedarfshinweis = null;
        this.msLagerort = null;
        this.mdAuMe = null;
        this.mdPreis = 0.0;
        this.mdRabatt = null;
        this.msSplitt = null;
        this.msTransparenz = null;
        this.msSuffix = null;
        this.msDispo = null;
        this.mdMwSt = null;
        this.mdAtSt = null;
        this.mbHatNotiz = false;
        this.msFIString = null;
        this.msFIKuerzel = null;
        this.mdSapPreis = dSapPreis;
        this.msSapKodierungsstufe = sSapKodierungsstufe;
        this.msSapVerfuegbarkeit = sSapVerfuegbarkeit;
        this.msSapVerfuegbarkeitHinweis = sSapVerfuegbarkeitHinweis;
        this.mbScorePruefen = false;
        this.mnScoreAenderung = 0;
        this.msJobId = null;
        this.msSrpId = null;
        this.mbTcKennzeichen = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Teil(String sSachnummer, int nPos, String sMenge, String sBemerkung, String sSprache) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.msSachnummer = sSachnummer;
        this.mnPos = nPos;
        this.msMenge = sMenge;
        this.msBemerkung = sBemerkung;
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Loading Part: " + sSachnummer));
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Teil.Teil");
            res = TeileListeDbAccess.loadTeil(con, sSachnummer, sSprache);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            String sMarke = res.getString("Marke");
            this.appendMarke(sMarke);
            this.msTeileart = res.getString("Teileart");
            this.msProduktklasse = res.getString("ProduktKlasse");
            this.msHG = res.getString("Hg");
            this.msUG = res.getString("Ug");
            this.msBenennung = res.getString("Benennung");
            this.msZusatz = res.getString("Zusatz");
            this.mnMAM = res.getInt("MAM");
            this.mnVVM = res.getInt("VVM");
            this.mnLVM = res.getInt("LVM");
            this.mnBVM = res.getInt("BVM");
            this.msMengenEinheit = res.getString("Mengeneinheit");
            this.msFIString = null;
            this.msFIKuerzel = null;
            this.mbHatNotiz = false;
            this.mbScorePruefen = false;
            this.mnScoreAenderung = 0;
            this.msJobId = null;
            this.msSrpId = null;
            this.mbTcKennzeichen = false;
            String string = this.sIsDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null && res.getString("Teil_Diebstahlrelevant").equals("J") ? "J" : "N";
            while (res.next()) {
                sMarke = res.getString("Marke");
                this.appendMarke(sMarke);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teil.Teil");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teil.Teil");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreisInfo(String sFirma) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("loadPreisInfo: " + this.msSachnummer));
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionPreise("Teil.loadPreisInfo");
            res = TeileListeDbAccess.loadPreisInfo(con, this.msSachnummer, sFirma);
            if (res != null && res.next()) {
                double dEvp = res.getDouble("EVP");
                String sPreisProHundertKZ = res.getString("PreisKz");
                if (sPreisProHundertKZ != null && sPreisProHundertKZ.equals("%")) {
                    dEvp /= 100.0;
                }
                if (this.mdPreis == 0.0) {
                    this.mdPreis = dEvp;
                }
                this.mdUPE = dEvp;
                this.mdNachbelastungspauschale = res.getDouble("Nachbelastung");
                this.msRabattSchluessel = res.getString("RabattSchluessel");
                this.msPreisaenderKZ = res.getString("Preisanederung");
                this.mdSNP = res.getDouble("SNP");
                this.mdNettoPreisDatei = res.getDouble("NettoPreis");
                this.msSonderpreisKZ = res.getString("SNPKz");
                if (this.mdMwSt == null || this.mdMwSt == 0.0) {
                    this.mdMwSt = res.getString("MwSt") != null ? new Double(res.getDouble("MwSt")) : null;
                }
                this.msMwstCode = res.getString("MwStCode");
                this.msZolltarifnummer = res.getString("ZolltarifNr");
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionPreise(con, "Teil.loadPreisInfo");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionPreise(con, "Teil.loadPreisInfo");
    }

    public static Teil createScorePlatzhalter() {
        Teil oTeil = new Teil("_empty_");
        oTeil.setLokalteil(true);
        return oTeil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInListe(String sListenID, boolean bBestellliste, String sNutzerID, String sFirma, String sFiliale, String sJobId, String sSrpId) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"saveInListe");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teil.saveInListe");
            if (!bBestellliste) {
                TeileListeDbAccess.saveTeilInListe(con, this, sListenID, sNutzerID, sFirma, sFiliale, sJobId, sSrpId);
            } else {
                TeileListeDbAccess.saveTeilInBestellliste(con, this, sListenID, sFirma, sFiliale);
            }
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teil.saveInListe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInListe(String sListenID, String sNutzerID, String sFirma, String sFiliale, String sJobId, String sSrpId) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"saveInListe");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teil.saveInListe");
            TeileListeDbAccess.saveTeilInListe(con, this, sListenID, sNutzerID, sFirma, sFiliale, sJobId, sSrpId);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teil.saveInListe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAusListe(String sListenID, boolean bBestellliste, String sNutzerID, String sFirma, String sFiliale, boolean bScore) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)"deleteAusListe");
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Teil.deleteAusListe");
            if (!bBestellliste) {
                TeileListeDbAccess.deleteTeilAusListe(con, this, sListenID, sNutzerID, sFirma, sFiliale, bScore);
            } else {
                TeileListeDbAccess.deleteTeilAusBestellliste(con, this, sListenID, sFirma, sFiliale);
            }
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Teil.deleteAusListe");
        }
    }

    public Vector<String> getMarken() {
        return this.maMarke;
    }

    public void appendMarke(String sMarke) {
        if (this.maMarke == null) {
            this.maMarke = new Vector();
            this.maMarke.add(sMarke);
            return;
        }
        for (String sHelp : this.maMarke) {
            if (!sMarke.equalsIgnoreCase(sHelp)) continue;
            return;
        }
        this.maMarke.add(sMarke);
    }

    public void setMarken(Vector<String> aMarke) {
        this.maMarke = aMarke;
    }

    public String getTeileart() {
        if (this.msTeileart != null) {
            return this.msTeileart;
        }
        return "";
    }

    public void setTeileart(String sTeileart) {
        this.msTeileart = sTeileart;
    }

    public String getSachnummerGespreizt() {
        String sSachnummer = "";
        if (this.msSachnummer != null) {
            sSachnummer = !this.mbLokalteil ? WebetkUtils.formatiereSachnummer(this.msSachnummer) : this.msSachnummer;
        }
        return sSachnummer;
    }

    public String getTeilenummerGespreizt() {
        String sTeilenummer = this.getHG() + " " + this.getUG();
        if (this.msSachnummer != null) {
            sTeilenummer = !this.mbLokalteil ? sTeilenummer + " " + WebetkUtils.formatiereSachnummer(this.msSachnummer) : sTeilenummer + " " + this.msSachnummer;
        }
        return sTeilenummer;
    }

    @Override
    public String getTeilenummer() {
        String sTeilenummer = this.getHG() + this.getUG();
        if (this.msSachnummer != null) {
            sTeilenummer = sTeilenummer + this.msSachnummer;
        }
        return sTeilenummer;
    }

    public String getBemerkung() {
        if (this.msBemerkung != null) {
            return this.msBemerkung;
        }
        return "";
    }

    public void setBemerkung(String sBemerkung) {
        this.msBemerkung = sBemerkung;
    }

    public String getMenge() {
        if (this.msMenge != null) {
            return this.msMenge;
        }
        return "0.00";
    }

    public double getMengeDouble() {
        if (this.msMenge != null) {
            return Double.parseDouble(this.msMenge);
        }
        return 0.0;
    }

    public void setMenge(String sMenge) {
        this.msMenge = sMenge;
    }

    public void setMengenEinheit(String sMengenEinheit) {
        this.msMengenEinheit = sMengenEinheit;
    }

    public String getMengenEinheit() {
        if (this.msMengenEinheit != null) {
            return this.msMengenEinheit;
        }
        return "";
    }

    public String getPos() {
        return new Integer(this.mnPos).toString();
    }

    public String getPosWithLeadingZeros() {
        return this.df5.format(this.mnPos);
    }

    public int getPosInt() {
        return this.mnPos;
    }

    public void setPos(int nPos) {
        this.mnPos = nPos;
    }

    @Override
    public Hashtable<String, String> getHashtable() {
        Hashtable<String, String> objHashtable = new Hashtable<String, String>();
        objHashtable.put("Pos", this.getPos());
        objHashtable.put("SachNr", this.getSachnummer());
        objHashtable.put("Hg", this.getHG());
        objHashtable.put("Ug", this.getUG());
        objHashtable.put("TeileNr", this.getTeilenummerGespreizt());
        objHashtable.put("Benennung", this.getBenennung());
        objHashtable.put("Zusatz", this.getZusatz());
        objHashtable.put("Menge", this.getMenge());
        objHashtable.put("Bemerkung", this.getBemerkung());
        objHashtable.put("Kodierungsstufe", this.getSapKodierungsstufe());
        objHashtable.put("Preis", this.getSapPreisString());
        String sVerfuegbar = this.getSapVerfuegbarkeit();
        if (sVerfuegbar == null || sVerfuegbar.equals("")) {
            objHashtable.put("EMPTY", "J");
        } else {
            objHashtable.put(sVerfuegbar, "J");
        }
        objHashtable.put("VerfuegbarText", this.getSapVerfuegbarkeitHinweis());
        objHashtable.put("AspgTyp", this.getAspgTyp());
        objHashtable.put("AspgRef", this.getAspgRef());
        objHashtable.put("AspgMenge", this.getAspgMenge());
        objHashtable.put("FIString", this.getFIString());
        return objHashtable;
    }

    public boolean checkMarke(String sMarke) {
        if (this.msTeileart.equals("7") || this.msTeileart.equals("9")) {
            return true;
        }
        if (this.maMarke == null) {
            return true;
        }
        for (String sMarkeComp : this.maMarke) {
            if (!sMarkeComp.equalsIgnoreCase(sMarke)) continue;
            return true;
        }
        return false;
    }

    public boolean getLokalteil() {
        return this.mbLokalteil;
    }

    public void setLokalteil(boolean bLokalteil) {
        this.mbLokalteil = bLokalteil;
    }

    public Double getLagerbestand() {
        return this.mdLagerbestand;
    }

    public void setLagerbestand(Double dLagerbestand) {
        this.mdLagerbestand = dLagerbestand;
    }

    public Double getMinimalbestand() {
        return this.mdMinimalbestand;
    }

    public void setMinimalbestand(Double dMinimalbestand) {
        this.mdMinimalbestand = dMinimalbestand;
    }

    public Integer getBedarfshinweis() {
        return this.mnBedarfshinweis;
    }

    public void setBedarfshinweis(Integer nBedarfshinweis) {
        this.mnBedarfshinweis = nBedarfshinweis;
    }

    public String getLagerort() {
        return this.msLagerort;
    }

    public void setLagerort(String sLagerort) {
        this.msLagerort = sLagerort;
    }

    public Double getAuMe() {
        return this.mdAuMe;
    }

    public void setAuMe(Double dAuMe) {
        this.mdAuMe = dAuMe;
    }

    public double getPreis() {
        return this.mdPreis;
    }

    public void setPreis(double dPreis) {
        this.mdPreis = dPreis;
    }

    public Double getRabatt() {
        return this.mdRabatt;
    }

    public String getRabattString() {
        String sRabatt = "";
        double dRabatt = 0.0;
        if (this.mdRabatt == null) {
            return "";
        }
        dRabatt = this.mdRabatt;
        if (dRabatt > 0.0) {
            sRabatt = "+";
        }
        if ((sRabatt = sRabatt + WebetkUtils.getPriceString(dRabatt)).indexOf("-") == 0) {
            sRabatt = sRabatt.substring(1);
        }
        return sRabatt;
    }

    public void setRabatt(Double dRabatt) {
        this.mdRabatt = dRabatt;
    }

    public void setRabatt(String sRabatt) {
        if (sRabatt == null || sRabatt.length() == 0) {
            this.mdRabatt = null;
            return;
        }
        if (sRabatt.indexOf("-") < 0 && sRabatt.indexOf("+") < 0) {
            sRabatt = "-" + sRabatt;
        }
        this.mdRabatt = Double.valueOf(sRabatt);
    }

    public String getSplitt() {
        return this.msSplitt;
    }

    public void setSplitt(String sSplitt) {
        this.msSplitt = sSplitt;
    }

    public String getTransparenz() {
        return this.msTransparenz;
    }

    public void setTransparenz(String sTransparenz) {
        this.msTransparenz = sTransparenz;
    }

    public String getSuffix() {
        return this.msSuffix;
    }

    public void setSuffix(String sSuffix) {
        this.msSuffix = sSuffix;
    }

    public String getDispo() {
        return this.msDispo;
    }

    public void setDispo(String sDispo) {
        this.msDispo = sDispo;
    }

    public double getMwSt() {
        if (this.mdMwSt == null) {
            return 0.0;
        }
        return this.mdMwSt;
    }

    public Double getMwStDouble() {
        return this.mdMwSt;
    }

    public void setMwSt(Double dMwSt) {
        this.mdMwSt = dMwSt;
    }

    public double getAtSt() {
        if (this.mdAtSt == null) {
            return 0.0;
        }
        return this.mdAtSt;
    }

    public Double getAtStDouble() {
        return this.mdAtSt;
    }

    public void setAtSt(Double dAtSt) {
        this.mdAtSt = dAtSt;
    }

    public String getAuftragsnummer() {
        return this.msAuftragsnummer;
    }

    public void setAuftragsnummer(String sAuftragsnummer) {
        this.msAuftragsnummer = sAuftragsnummer;
    }

    public Long getKundennummer() {
        return this.mlKundennummer;
    }

    public void setKundennummer(Long lKundennummer) {
        this.mlKundennummer = lKundennummer;
    }

    public double getSonderpreis() {
        return this.mdSNP;
    }

    public void setSonderpreis(double dSNP) {
        this.mdSNP = dSNP;
    }

    public double getNettoPreisDatei() {
        return this.mdNettoPreisDatei;
    }

    public String getRabattSchluessel() {
        return this.msRabattSchluessel;
    }

    public void setRabattSchluessel(String sRabattSchluessel) {
        this.msRabattSchluessel = sRabattSchluessel;
    }

    public String getProduktklasse() {
        return this.msProduktklasse;
    }

    public void setProduktklasse(String sProduktklasse) {
        this.msProduktklasse = sProduktklasse;
    }

    public int getVVM() {
        return this.mnVVM;
    }

    public void setVVM(int nVVM) {
        this.mnVVM = nVVM;
    }

    public int getLVM() {
        return this.mnLVM;
    }

    public void setLVM(int nLVM) {
        this.mnLVM = nLVM;
    }

    public int getBVM() {
        return this.mnBVM;
    }

    public void setBVM(int nBVM) {
        this.mnBVM = nBVM;
    }

    public int getMAM() {
        return this.mnMAM;
    }

    public void setMAM(int nMAM) {
        this.mnMAM = nMAM;
    }

    public String getMwstCode() {
        return this.msMwstCode;
    }

    public void setMwstCode(String sMwstCode) {
        this.msMwstCode = sMwstCode;
    }

    public boolean getHoheMwst() {
        return this.msMwstCode != null && this.msMwstCode.equals("2");
    }

    public double getUPE() {
        return this.mdUPE;
    }

    public void setUPE(double dUPE) {
        this.mdUPE = dUPE;
    }

    public double getHaendlerpreis() {
        return this.mdHaendlerpreis;
    }

    public void setHaendlerpreis(double dHaendlerpreis) {
        this.mdHaendlerpreis = dHaendlerpreis;
    }

    public String getPreisaenderKZ() {
        return this.msPreisaenderKZ;
    }

    public void setPreisaenderKZ(String sPreisaenderKZ) {
        this.msPreisaenderKZ = sPreisaenderKZ;
    }

    public String getSonderpreisKZ() {
        return this.msSonderpreisKZ;
    }

    public void setSonderpreisKZ(String sSonderpreisKZ) {
        this.msSonderpreisKZ = sSonderpreisKZ;
    }

    public double getNachbelastungspauschale() {
        return this.mdNachbelastungspauschale;
    }

    public void setNachbelastungspauschale(double dNachbelastungspauschale) {
        this.mdNachbelastungspauschale = dNachbelastungspauschale;
    }

    public String getZolltarifnummer() {
        return this.msZolltarifnummer;
    }

    public void setZolltarifnummer(String sZolltarifnummer) {
        this.msZolltarifnummer = sZolltarifnummer;
    }

    public boolean getInsert() {
        return this.mbInsert;
    }

    public void setInsert(boolean bInsert) {
        this.mbInsert = bInsert;
    }

    public boolean getUpdate() {
        return this.mbUpdate;
    }

    public void setUpdate(boolean bUpdate) {
        this.mbUpdate = bUpdate;
    }

    public boolean getMustSave() {
        return this.mbMustSave;
    }

    public void setMustSave(boolean bMustSave) {
        this.mbMustSave = bMustSave;
    }

    public double ermittleNetto() {
        double dRabatt = 0.0;
        if (this.mdRabatt != null) {
            dRabatt = this.mdRabatt;
        }
        double dNetto = this.mdPreis + this.mdPreis * dRabatt / 100.0;
        dNetto = Math.floor(dNetto * 100.0 + 0.5) / 100.0;
        return Math.floor((dNetto *= this.getMengeDouble()) * 100.0 + 0.5) / 100.0;
    }

    private double ermittleNettoOhneRabatt() {
        double dNetto = this.mdPreis * this.getMengeDouble();
        return Math.floor(dNetto * 100.0 + 0.5) / 100.0;
    }

    public double ermittleMwSt() {
        double dResult = 0.0;
        double dMwSt = 0.0;
        if (this.mdMwSt != null) {
            dMwSt = this.mdMwSt;
        }
        dResult = this.ermittleNetto() * dMwSt / 100.0;
        if (this.msTeileart != null && this.msTeileart.equals("2")) {
            dResult += this.ermittleAtSt();
        }
        return Math.floor(dResult * 100.0 + 0.5) / 100.0;
    }

    public double ermittleMwStOhneAT() {
        double dResult = 0.0;
        double dMwSt = 0.0;
        if (this.mdMwSt != null) {
            dMwSt = this.mdMwSt;
        }
        dResult = this.ermittleNetto() * dMwSt / 100.0;
        return Math.floor(dResult * 100.0 + 0.5) / 100.0;
    }

    public double ermittleAtSt() {
        double dResult = 0.0;
        double dAtSt = 0.0;
        if (this.mdAtSt != null) {
            dAtSt = this.mdAtSt;
        }
        dResult = this.msTeileart.equals("2") ? this.ermittleNettoOhneRabatt() * dAtSt / 1000.0 : 0.0;
        return Math.floor(dResult * 100.0 + 0.5) / 100.0;
    }

    public double ermittleBrutto() {
        double dBrutto = this.ermittleNetto() + this.ermittleMwSt();
        return Math.floor(dBrutto * 100.0 + 0.5) / 100.0;
    }

    public Double getSapPreis() {
        return this.mdSapPreis;
    }

    public void setSapPreis(Double dSapPreis) {
        this.mdSapPreis = dSapPreis;
    }

    public String getSapPreisString() {
        if (this.mdSapPreis == null) {
            return "";
        }
        return WebetkUtils.getPriceString(this.mdSapPreis);
    }

    public String getSapKodierungsstufe() {
        if (this.msSapKodierungsstufe == null) {
            return "";
        }
        return this.msSapKodierungsstufe;
    }

    public void setSapKodierungsstufe(String sSapKodierungsstufe) {
        this.msSapKodierungsstufe = sSapKodierungsstufe;
    }

    public String getSapVerfuegbarkeit() {
        if (this.msSapVerfuegbarkeit == null) {
            return "";
        }
        return this.msSapVerfuegbarkeit;
    }

    public void setSapVerfuegbarkeit(String sSapVerfuegbarkeit) {
        this.msSapVerfuegbarkeit = sSapVerfuegbarkeit;
    }

    public String getSapVerfuegbarkeitHinweis() {
        if (this.msSapVerfuegbarkeitHinweis == null) {
            return "";
        }
        return this.msSapVerfuegbarkeitHinweis;
    }

    public void setSapVerfuegbarkeitHinweis(String sSapVerfuegbarkeitHinweis) {
        this.msSapVerfuegbarkeitHinweis = sSapVerfuegbarkeitHinweis;
    }

    public String getFertigungshinweis() {
        return this.msFertigungshinweis;
    }

    public void setFertigungshinweis(String sFertigungshinweis) {
        this.msFertigungshinweis = sFertigungshinweis;
    }

    public boolean getHatNotiz() {
        return this.mbHatNotiz;
    }

    public void setHatNotiz(boolean bHatNotiz) {
        this.mbHatNotiz = bHatNotiz;
    }

    public boolean isEqualMarken(Collection<String> aMarke1, Collection<String> aMarke2) {
        boolean bGefunden;
        if (aMarke1 == null) {
            aMarke1 = new Vector<String>();
        }
        if (aMarke2 == null) {
            aMarke2 = new Vector<String>();
        }
        if (aMarke1.size() != aMarke2.size()) {
            return false;
        }
        Iterator<String> iterMarke1 = null;
        Iterator<String> iterMarke2 = null;
        iterMarke1 = aMarke1.iterator();
        while (iterMarke1.hasNext()) {
            bGefunden = false;
            String sMarke1 = iterMarke1.next();
            for (String sMarke2 : aMarke2) {
                if (!sMarke1.equalsIgnoreCase(sMarke2)) continue;
                bGefunden = true;
            }
            if (bGefunden) continue;
            return false;
        }
        iterMarke2 = aMarke2.iterator();
        while (iterMarke2.hasNext()) {
            bGefunden = false;
            String sMarke2 = iterMarke2.next();
            for (String sMarke1 : aMarke1) {
                if (!sMarke2.equalsIgnoreCase(sMarke1)) continue;
                bGefunden = true;
            }
            if (bGefunden) continue;
            return false;
        }
        return true;
    }

    public boolean isScorePruefen() {
        return this.mbScorePruefen;
    }

    public void setScorePruefen(boolean bScorePruefen) {
        this.mbScorePruefen = bScorePruefen;
    }

    public boolean isScoreLock() {
        return this.mbScoreLock;
    }

    public void setScoreLock(boolean bScoreLock) {
        this.mbScoreLock = bScoreLock;
    }

    public int getScoreAenderung() {
        return this.mnScoreAenderung;
    }

    public void setScoreAenderung(int nScoreAenderung) {
        if (this.mnScoreAenderung == 2 && nScoreAenderung == 3) {
            return;
        }
        this.mnScoreAenderung = nScoreAenderung;
    }

    public boolean isTeilVonScore() {
        return this.mnScoreAenderung == 1 || this.mnScoreAenderung == 3;
    }

    public String getJobId() {
        return this.msJobId;
    }

    public void setJobId(String sJobId) {
        this.msJobId = sJobId;
    }

    public String getSrpId() {
        return this.msSrpId;
    }

    public void setSrpId(String sSrpId) {
        this.msSrpId = sSrpId;
    }

    public String getFIString() {
        if (this.msFIString == null) {
            return "";
        }
        return this.msFIString;
    }

    public void setFIString(String sFIString) {
        this.msFIString = sFIString;
    }

    public String getFIKuerzel() {
        return this.msFIKuerzel;
    }

    public void setFIKuerzel(String sFIKuerzel) {
        this.msFIKuerzel = sFIKuerzel;
    }

    public boolean isTcKennzeichen() {
        return this.mbTcKennzeichen;
    }

    public void setTcKennzeichen(boolean bTcKennzeichen) {
        this.mbTcKennzeichen = bTcKennzeichen;
    }

    public boolean isAspg() {
        return this.mbAspg;
    }

    public void setAspg(boolean mbAspg) {
        this.mbAspg = mbAspg;
    }

    public boolean isReach() {
        return this.mbReach;
    }

    public void setReach(boolean mbReach) {
        this.mbReach = mbReach;
    }

    public boolean isStecker() {
        return this.mbStecker;
    }

    public void setStecker(boolean mbStecker) {
        this.mbStecker = mbStecker;
    }

    public String getAspgTyp() {
        if (this.mAspgTyp == null) {
            return "";
        }
        return this.mAspgTyp;
    }

    public void setAspgTyp(String mAspgTyp) {
        this.mAspgTyp = mAspgTyp;
    }

    public String getAspgRef() {
        if (this.mAspgRef == null) {
            return "";
        }
        return this.mAspgRef;
    }

    public void setAspgRef(String mAspgRef) {
        this.mAspgRef = mAspgRef;
    }

    public String getAspgMenge() {
        if (this.mAspgMenge == null) {
            return "";
        }
        return this.mAspgMenge;
    }

    public void setAspgMenge(String mAspgMenge) {
        this.mAspgMenge = mAspgMenge;
    }

    public Vector<String> getMaMarke() {
        return this.maMarke;
    }

    public void setMaMarke(Vector<String> maMarke) {
        this.maMarke = maMarke;
    }

    public String getMsTeileart() {
        return this.msTeileart;
    }

    public void setMsTeileart(String msTeileart) {
        this.msTeileart = msTeileart;
    }

    public int getMnPos() {
        return this.mnPos;
    }

    public void setMnPos(int mnPos) {
        this.mnPos = mnPos;
    }

    public DecimalFormat getDf5() {
        return this.df5;
    }

    public String getMsMenge() {
        return this.msMenge;
    }

    public void setMsMenge(String msMenge) {
        this.msMenge = msMenge;
    }

    public String getMsMengenEinheit() {
        return this.msMengenEinheit;
    }

    public void setMsMengenEinheit(String msMengenEinheit) {
        this.msMengenEinheit = msMengenEinheit;
    }

    public String getMsBemerkung() {
        return this.msBemerkung;
    }

    public void setMsBemerkung(String msBemerkung) {
        this.msBemerkung = msBemerkung;
    }

    public boolean isMbInsert() {
        return this.mbInsert;
    }

    public void setMbInsert(boolean mbInsert) {
        this.mbInsert = mbInsert;
    }

    public boolean isMbUpdate() {
        return this.mbUpdate;
    }

    public void setMbUpdate(boolean mbUpdate) {
        this.mbUpdate = mbUpdate;
    }

    public boolean isMbMustSave() {
        return this.mbMustSave;
    }

    public void setMbMustSave(boolean mbMustSave) {
        this.mbMustSave = mbMustSave;
    }

    public boolean isMbLokalteil() {
        return this.mbLokalteil;
    }

    public void setMbLokalteil(boolean mbLokalteil) {
        this.mbLokalteil = mbLokalteil;
    }

    public Double getMdLagerbestand() {
        return this.mdLagerbestand;
    }

    public void setMdLagerbestand(Double mdLagerbestand) {
        this.mdLagerbestand = mdLagerbestand;
    }

    public Double getMdMinimalbestand() {
        return this.mdMinimalbestand;
    }

    public void setMdMinimalbestand(Double mdMinimalbestand) {
        this.mdMinimalbestand = mdMinimalbestand;
    }

    public Integer getMnBedarfshinweis() {
        return this.mnBedarfshinweis;
    }

    public void setMnBedarfshinweis(Integer mnBedarfshinweis) {
        this.mnBedarfshinweis = mnBedarfshinweis;
    }

    public String getMsLagerort() {
        return this.msLagerort;
    }

    public void setMsLagerort(String msLagerort) {
        this.msLagerort = msLagerort;
    }

    public Double getMdAuMe() {
        return this.mdAuMe;
    }

    public void setMdAuMe(Double mdAuMe) {
        this.mdAuMe = mdAuMe;
    }

    public double getMdPreis() {
        return this.mdPreis;
    }

    public void setMdPreis(double mdPreis) {
        this.mdPreis = mdPreis;
    }

    public Double getMdRabatt() {
        return this.mdRabatt;
    }

    public void setMdRabatt(Double mdRabatt) {
        this.mdRabatt = mdRabatt;
    }

    public String getMsSplitt() {
        return this.msSplitt;
    }

    public void setMsSplitt(String msSplitt) {
        this.msSplitt = msSplitt;
    }

    public String getMsTransparenz() {
        return this.msTransparenz;
    }

    public void setMsTransparenz(String msTransparenz) {
        this.msTransparenz = msTransparenz;
    }

    public String getMsSuffix() {
        return this.msSuffix;
    }

    public void setMsSuffix(String msSuffix) {
        this.msSuffix = msSuffix;
    }

    public String getMsDispo() {
        return this.msDispo;
    }

    public void setMsDispo(String msDispo) {
        this.msDispo = msDispo;
    }

    public Double getMdMwSt() {
        return this.mdMwSt;
    }

    public void setMdMwSt(Double mdMwSt) {
        this.mdMwSt = mdMwSt;
    }

    public Double getMdAtSt() {
        return this.mdAtSt;
    }

    public void setMdAtSt(Double mdAtSt) {
        this.mdAtSt = mdAtSt;
    }

    public int getMnMAM() {
        return this.mnMAM;
    }

    public void setMnMAM(int mnMAM) {
        this.mnMAM = mnMAM;
    }

    public String getMsAuftragsnummer() {
        return this.msAuftragsnummer;
    }

    public void setMsAuftragsnummer(String msAuftragsnummer) {
        this.msAuftragsnummer = msAuftragsnummer;
    }

    public Long getMlKundennummer() {
        return this.mlKundennummer;
    }

    public void setMlKundennummer(Long mlKundennummer) {
        this.mlKundennummer = mlKundennummer;
    }

    public boolean isMbHatNotiz() {
        return this.mbHatNotiz;
    }

    public void setMbHatNotiz(boolean mbHatNotiz) {
        this.mbHatNotiz = mbHatNotiz;
    }

    public String getMsRabattSchluessel() {
        return this.msRabattSchluessel;
    }

    public void setMsRabattSchluessel(String msRabattSchluessel) {
        this.msRabattSchluessel = msRabattSchluessel;
    }

    public String getMsProduktklasse() {
        return this.msProduktklasse;
    }

    public void setMsProduktklasse(String msProduktklasse) {
        this.msProduktklasse = msProduktklasse;
    }

    public int getMnVVM() {
        return this.mnVVM;
    }

    public void setMnVVM(int mnVVM) {
        this.mnVVM = mnVVM;
    }

    public int getMnLVM() {
        return this.mnLVM;
    }

    public void setMnLVM(int mnLVM) {
        this.mnLVM = mnLVM;
    }

    public int getMnBVM() {
        return this.mnBVM;
    }

    public void setMnBVM(int mnBVM) {
        this.mnBVM = mnBVM;
    }

    public String getMsMwstCode() {
        return this.msMwstCode;
    }

    public void setMsMwstCode(String msMwstCode) {
        this.msMwstCode = msMwstCode;
    }

    public double getMdHaendlerpreis() {
        return this.mdHaendlerpreis;
    }

    public void setMdHaendlerpreis(double mdHaendlerpreis) {
        this.mdHaendlerpreis = mdHaendlerpreis;
    }

    public double getMdUPE() {
        return this.mdUPE;
    }

    public void setMdUPE(double mdUPE) {
        this.mdUPE = mdUPE;
    }

    public String getMsPreisaenderKZ() {
        return this.msPreisaenderKZ;
    }

    public void setMsPreisaenderKZ(String msPreisaenderKZ) {
        this.msPreisaenderKZ = msPreisaenderKZ;
    }

    public String getMsSonderpreisKZ() {
        return this.msSonderpreisKZ;
    }

    public void setMsSonderpreisKZ(String msSonderpreisKZ) {
        this.msSonderpreisKZ = msSonderpreisKZ;
    }

    public double getMdSNP() {
        return this.mdSNP;
    }

    public void setMdSNP(double mdSNP) {
        this.mdSNP = mdSNP;
    }

    public double getMdNettoPreisDatei() {
        return this.mdNettoPreisDatei;
    }

    public void setMdNettoPreisDatei(double mdNettoPreisDatei) {
        this.mdNettoPreisDatei = mdNettoPreisDatei;
    }

    public double getMdNachbelastungspauschale() {
        return this.mdNachbelastungspauschale;
    }

    public void setMdNachbelastungspauschale(double mdNachbelastungspauschale) {
        this.mdNachbelastungspauschale = mdNachbelastungspauschale;
    }

    public String getMsZolltarifnummer() {
        return this.msZolltarifnummer;
    }

    public void setMsZolltarifnummer(String msZolltarifnummer) {
        this.msZolltarifnummer = msZolltarifnummer;
    }

    public Double getMdSapPreis() {
        return this.mdSapPreis;
    }

    public void setMdSapPreis(Double mdSapPreis) {
        this.mdSapPreis = mdSapPreis;
    }

    public String getMsSapKodierungsstufe() {
        return this.msSapKodierungsstufe;
    }

    public void setMsSapKodierungsstufe(String msSapKodierungsstufe) {
        this.msSapKodierungsstufe = msSapKodierungsstufe;
    }

    public String getMsSapVerfuegbarkeit() {
        return this.msSapVerfuegbarkeit;
    }

    public void setMsSapVerfuegbarkeit(String msSapVerfuegbarkeit) {
        this.msSapVerfuegbarkeit = msSapVerfuegbarkeit;
    }

    public String getMsSapVerfuegbarkeitHinweis() {
        return this.msSapVerfuegbarkeitHinweis;
    }

    public void setMsSapVerfuegbarkeitHinweis(String msSapVerfuegbarkeitHinweis) {
        this.msSapVerfuegbarkeitHinweis = msSapVerfuegbarkeitHinweis;
    }

    public String getMsFertigungshinweis() {
        return this.msFertigungshinweis;
    }

    public void setMsFertigungshinweis(String msFertigungshinweis) {
        this.msFertigungshinweis = msFertigungshinweis;
    }

    public boolean isMbScorePruefen() {
        return this.mbScorePruefen;
    }

    public void setMbScorePruefen(boolean mbScorePruefen) {
        this.mbScorePruefen = mbScorePruefen;
    }

    public boolean isMbScoreLock() {
        return this.mbScoreLock;
    }

    public void setMbScoreLock(boolean mbScoreLock) {
        this.mbScoreLock = mbScoreLock;
    }

    public int getMnScoreAenderung() {
        return this.mnScoreAenderung;
    }

    public void setMnScoreAenderung(int mnScoreAenderung) {
        this.mnScoreAenderung = mnScoreAenderung;
    }

    public static int getScoreKeinScore() {
        return 0;
    }

    public static int getScoreVonScore() {
        return 1;
    }

    public static int getScoreNeu() {
        return 2;
    }

    public static int getScoreGeaendert() {
        return 3;
    }

    public static int getScoreGeloescht() {
        return 4;
    }

    public String getMsJobId() {
        return this.msJobId;
    }

    public void setMsJobId(String msJobId) {
        this.msJobId = msJobId;
    }

    public String getMsSrpId() {
        return this.msSrpId;
    }

    public void setMsSrpId(String msSrpId) {
        this.msSrpId = msSrpId;
    }

    public boolean isMbTcKennzeichen() {
        return this.mbTcKennzeichen;
    }

    public void setMbTcKennzeichen(boolean mbTcKennzeichen) {
        this.mbTcKennzeichen = mbTcKennzeichen;
    }

    public String getMsFIString() {
        return this.msFIString;
    }

    public void setMsFIString(String msFIString) {
        this.msFIString = msFIString;
    }

    public String getMsFIKuerzel() {
        return this.msFIKuerzel;
    }

    public void setMsFIKuerzel(String msFIKuerzel) {
        this.msFIKuerzel = msFIKuerzel;
    }

    public boolean isMbAspg() {
        return this.mbAspg;
    }

    public void setMbAspg(boolean mbAspg) {
        this.mbAspg = mbAspg;
    }

    public boolean isMbReach() {
        return this.mbReach;
    }

    public void setMbReach(boolean mbReach) {
        this.mbReach = mbReach;
    }

    public boolean isMbStecker() {
        return this.mbStecker;
    }

    public void setMbStecker(boolean mbStecker) {
        this.mbStecker = mbStecker;
    }

    public String getmAspgTyp() {
        return this.mAspgTyp;
    }

    public void setmAspgTyp(String mAspgTyp) {
        this.mAspgTyp = mAspgTyp;
    }

    public String getmAspgRef() {
        return this.mAspgRef;
    }

    public void setmAspgRef(String mAspgRef) {
        this.mAspgRef = mAspgRef;
    }

    public String getmAspgMenge() {
        return this.mAspgMenge;
    }

    public void setmAspgMenge(String mAspgMenge) {
        this.mAspgMenge = mAspgMenge;
    }
}

