/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teileliste;

import java.io.Serializable;
import java.util.Comparator;
import webetk.app.teileliste.Teil;

public class TeilComparator
implements Comparator<Teil>,
Serializable {
    private static final long serialVersionUID = -5294317507970069666L;
    public static final int POS = 0;
    public static final int TEILENUMMER = 1;
    public static final int TEILEBENENNUNG = 2;
    public static final int FI_KUERZEL = 3;
    public static final int LAGERORT = 4;
    public static final int BEMERKUNG = 5;
    public static final int AUFTRAGSNR = 6;
    public static final int KUNDENNR = 7;
    public static final int RECHNUNGSTRANSPARENZ = 8;
    public static final int RECHNUNGSTRANSPARENZ_UND_POS = 80;
    public static final int FIKUERZEL_RECHNUNGSTRANSPARENZ_UND_POS = 38;
    public static final String KEINE_RECHNUNGSTRANSPARENZ = "\u00ff\u00ff\u00ff\u00ff";
    public static final String KEIN_FIKUERZEL = "\u00ff";
    private int feld;
    private boolean bAsc;

    TeilComparator(int feld, boolean bAsc) {
        this.feld = feld;
        this.bAsc = bAsc;
    }

    @Override
    public int compare(Teil o1, Teil o2) {
        Teil t1 = o1;
        Teil t2 = o2;
        switch (this.feld) {
            case 0: {
                return this.compareInts(t1.getPosInt(), t2.getPosInt());
            }
            case 1: {
                return this.compareStrings(t1.getTeilenummer(), t2.getTeilenummer());
            }
            case 2: {
                return this.compareStrings(t1.getBenennung(), t2.getBenennung());
            }
            case 3: {
                return this.compareStrings(t1.getFIKuerzel(), t2.getFIKuerzel());
            }
            case 4: {
                return this.compareStrings(t1.getLagerort(), t2.getLagerort());
            }
            case 5: {
                return this.compareStrings(t1.getBemerkung(), t2.getBemerkung());
            }
            case 6: {
                return this.compareStrings(t1.getAuftragsnummer(), t2.getAuftragsnummer());
            }
            case 7: {
                return this.compareLongs(t1.getKundennummer(), t2.getKundennummer());
            }
            case 8: {
                return this.compareStrings(t1.getTransparenz() == null || t1.getTransparenz().trim().length() == 0 ? KEINE_RECHNUNGSTRANSPARENZ : t1.getTransparenz(), t2.getTransparenz() == null || t2.getTransparenz().trim().length() == 0 ? KEINE_RECHNUNGSTRANSPARENZ : t2.getTransparenz());
            }
            case 80: {
                return this.compareStrings((t1.getTransparenz() == null || t1.getTransparenz().trim().length() == 0 ? KEINE_RECHNUNGSTRANSPARENZ : t1.getTransparenz()) + t1.getPosWithLeadingZeros(), (t2.getTransparenz() == null || t2.getTransparenz().trim().length() == 0 ? KEINE_RECHNUNGSTRANSPARENZ : t2.getTransparenz()) + t2.getPosWithLeadingZeros());
            }
            case 38: {
                return this.compareStrings((t1.getFIKuerzel() == null || t1.getFIKuerzel().trim().length() == 0 ? KEIN_FIKUERZEL : t1.getFIKuerzel()) + (t1.getTransparenz() == null || t1.getTransparenz().trim().length() == 0 ? KEINE_RECHNUNGSTRANSPARENZ : t1.getTransparenz()) + t1.getPosWithLeadingZeros(), (t2.getFIKuerzel() == null || t2.getFIKuerzel().trim().length() == 0 ? KEIN_FIKUERZEL : t2.getFIKuerzel()) + (t2.getTransparenz() == null || t2.getTransparenz().trim().length() == 0 ? KEINE_RECHNUNGSTRANSPARENZ : t2.getTransparenz()) + t2.getPosWithLeadingZeros());
            }
        }
        return 0;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            if (this.bAsc) {
                return -1;
            }
            return 1;
        }
        if (s2 == null) {
            if (this.bAsc) {
                return 1;
            }
            return -1;
        }
        if (this.bAsc) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    private int compareInts(int n1, int n2) {
        if (this.bAsc) {
            return n1 - n2;
        }
        return n2 - n1;
    }

    private int compareLongs(Long l1, Long l2) {
        if (l1 == null && l2 == null) {
            return 0;
        }
        if (l1 == null) {
            if (this.bAsc) {
                return -1;
            }
            return 1;
        }
        if (l2 == null) {
            if (this.bAsc) {
                return 1;
            }
            return -1;
        }
        if (this.bAsc) {
            return l1.compareTo(l2);
        }
        return l2.compareTo(l1);
    }
}

