/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teilevwdgred;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.TeileVwdgRedAccess;

public class Teileverwendung {
    private String msUeberschrift;
    private Collection mcZeilen;

    public Teileverwendung(String sSachNr, String sMospIDs, String sSprache) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.loadUeberschrift(sSachNr, sSprache);
        this.loadVerwendungsZeilen(sSachNr, sSprache, sMospIDs);
    }

    public Collection getZeilen() {
        return this.mcZeilen;
    }

    public String getUeberschrift() {
        return this.msUeberschrift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUeberschrift(String sSachNr, String sSprache) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects gObj;
        block3: {
            gObj = ServerGlobalObjects.getInstance();
            con = null;
            res = null;
            try {
                con = gObj.getDBConnection("Teileverwendung.loadUeberschrift");
                res = TeileVwdgRedAccess.selectTeil(con, sSachNr, sSprache);
                this.msUeberschrift = "";
                if (res == null || !res.next()) break block3;
                this.msUeberschrift = res.getString("HG");
                this.msUeberschrift = this.msUeberschrift + " ";
                this.msUeberschrift = this.msUeberschrift + res.getString("UG");
                this.msUeberschrift = this.msUeberschrift + " ";
                String sSachnr = res.getString("Sachnummer");
                this.msUeberschrift = this.msUeberschrift + WebetkUtils.formatiereSachnummer(sSachnr);
                this.msUeberschrift = this.msUeberschrift + "  ";
                this.msUeberschrift = this.msUeberschrift + res.getString("Ben");
                String sZusatz = res.getString("Zusatz");
                if (sZusatz != null) {
                    this.msUeberschrift = this.msUeberschrift + " ";
                    this.msUeberschrift = this.msUeberschrift + sZusatz;
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                gObj.freeDBConnection(con, "Teileverwendung.loadUeberschrift");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileverwendung.loadUeberschrift");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVerwendungsZeilen(String sSachNr, String sSprache, String sMospIDs) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Teileverwendung.loadVerwendungsZeilen");
            res = TeileVwdgRedAccess.selectVerwendungen(con, sSachNr, sSprache, sMospIDs);
            this.mcZeilen = new Vector();
            if (res == null || !res.next()) {
                throw new NoDataFoundException("No values found");
            }
            int nLfdNr = 0;
            while (res != null) {
                Hashtable<String, String> objHashtable = new Hashtable<String, String>();
                String sValue = res.getString("Baureihe");
                objHashtable.put("Baureihe", sValue);
                sValue = res.getString("Modell");
                objHashtable.put("Modell", sValue);
                sValue = res.getString("Karosserie");
                objHashtable.put("Karosserie", sValue);
                sValue = res.getString("Region");
                objHashtable.put("Region", sValue);
                if ((++nLfdNr - 1) % 15 == 0) {
                    objHashtable.put("hatUeberschrift", "J");
                }
                this.mcZeilen.add(objHashtable);
                if (res.next()) continue;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Teileverwendung.loadVerwendungsZeilen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "Teileverwendung.loadVerwendungsZeilen");
    }
}

