/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.suche;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.app.SucheInfo;
import webetk.app.basesuche.BaseBegriffSuche;
import webetk.db.SQLStatements;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="BegriffSucheZub")
@XmlType(name="webetk.app.zub.suche.BegriffSucheZub")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BegriffSuche
extends BaseBegriffSuche
implements Serializable {
    private static final long serialVersionUID = 1L;

    public BegriffSuche() {
    }

    public BegriffSuche(String sBegriff) throws InvalidInitializationException {
        super(sBegriff);
    }

    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        return 0;
    }

    public String getSuchString(String spaltenName, String prefix, boolean upperCaseSuche) {
        return this.getSuchString(spaltenName, prefix, upperCaseSuche, false);
    }

    public String getSuchString(String spaltenName, String prefix, boolean upperCaseSuche, boolean turkish) {
        String conditionString;
        StringBuffer buf = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            buf.append(prefix).append(" ");
        }
        buf.append("(");
        StringBuffer stmtBuf = new StringBuffer();
        String spalte = upperCaseSuche ? "upper(" + spaltenName + ")" : spaltenName;
        Iterator it = this.mcBegriffePlus.iterator();
        while (it.hasNext()) {
            if (stmtBuf.length() > 0) {
                stmtBuf.append(" AND ");
            }
            conditionString = ((String)it.next()).toString();
            if (upperCaseSuche && !turkish) {
                stmtBuf.append(SQLStatements.Allgemein.instance.getLikeInsensitive(spaltenName, conditionString.replace('*', '%'), false));
                continue;
            }
            if (turkish) {
                stmtBuf.append(SQLStatements.Allgemein.instance.getLikeTr(spaltenName, conditionString.replace('*', '%').toUpperCase(new Locale("tr", "TR")), false));
                continue;
            }
            stmtBuf.append(spalte).append(" like '");
            stmtBuf.append(conditionString.replace('*', '%')).append("'");
        }
        it = this.mcBegriffeMinus.iterator();
        while (it.hasNext()) {
            if (stmtBuf.length() > 0) {
                stmtBuf.append(" AND ");
            }
            conditionString = ((String)it.next()).toString();
            if (upperCaseSuche && !turkish) {
                stmtBuf.append(SQLStatements.Allgemein.instance.getNotLikeInsensitive(spaltenName, conditionString.replace('*', '%'), false));
                continue;
            }
            if (turkish) {
                stmtBuf.append(SQLStatements.Allgemein.instance.getNotLikeTr(spaltenName, conditionString.replace('*', '%').toUpperCase(new Locale("tr", "TR")), false));
                continue;
            }
            stmtBuf.append(spalte).append(" NOT like '");
            stmtBuf.append((upperCaseSuche ? conditionString.toUpperCase() : conditionString).replace('*', '%')).append("'");
        }
        StringBuffer oderBuffer = new StringBuffer();
        Iterator it2 = this.mcBegriffeOder.iterator();
        while (it2.hasNext()) {
            if (oderBuffer.length() == 0 && stmtBuf.length() != 0) {
                oderBuffer.append(" AND (");
            } else if (oderBuffer.length() == 0) {
                oderBuffer.append("(");
            } else if (oderBuffer.length() != 0) {
                oderBuffer.append(" OR ");
            }
            String conditionString2 = ((String)it2.next()).toString();
            if (upperCaseSuche && !turkish) {
                oderBuffer.append(SQLStatements.Allgemein.instance.getLikeInsensitive(spaltenName, conditionString2.replace('*', '%'), false));
                continue;
            }
            if (turkish) {
                oderBuffer.append(SQLStatements.Allgemein.instance.getLikeTr(spaltenName, conditionString2.replace('*', '%').toUpperCase(new Locale("tr", "TR")), false));
                continue;
            }
            oderBuffer.append(spalte).append(" like '").append(conditionString2.replace('*', '%')).append("'");
        }
        if (oderBuffer.length() > 0) {
            oderBuffer.append(")");
        }
        buf.append(stmtBuf.toString()).append(oderBuffer.toString());
        buf.append(")");
        return buf.toString();
    }
}

