/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.technisch;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.app.zub.technisch.RefaArbeit;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EinbauInfo
implements Serializable,
Cloneable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    int mId;
    String mKomplexitaet;
    String mLesart;
    float mMechanischerAufwand;
    float mElektrischerAufwand;
    float mProgrammierAufwand;
    float mLackierAufwand;
    float mSonstigerAufwand;
    float mArbeitsAufwand;
    float mGesamtAufwand;
    ArrayList<RefaArbeit> refaArbeitenList;

    public EinbauInfo() {
    }

    public float getElektrischerAufwand() {
        if (this.mLesart != null && this.mLesart.equals("PROZENT")) {
            return this.getMinZuProzent(this.mElektrischerAufwand);
        }
        return this.mElektrischerAufwand;
    }

    public void setElektrischerAufwand(float elektrischerAufwand) {
        this.mElektrischerAufwand = elektrischerAufwand;
    }

    public float getGesamtAufwand() {
        return this.mGesamtAufwand;
    }

    public void setGesamtAufwand(float gesamtAufwand) {
        this.mGesamtAufwand = gesamtAufwand;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int id) {
        this.mId = id;
    }

    public String getKomplexitaet() {
        return this.mKomplexitaet;
    }

    public void setKomplexitaet(String komplexitaet) {
        this.mKomplexitaet = komplexitaet;
    }

    public float getLackierAufwand() {
        return this.mLackierAufwand;
    }

    public void setLackierAufwand(float lackierAufwand) {
        this.mLackierAufwand = lackierAufwand;
    }

    public String getLesart() {
        return this.mLesart;
    }

    public void setLesart(String lesart) {
        this.mLesart = lesart;
    }

    public float getMechanischerAufwand() {
        if (this.mLesart != null && this.mLesart.equals("PROZENT")) {
            return this.getMinZuProzent(this.mMechanischerAufwand);
        }
        return this.mMechanischerAufwand;
    }

    public void setMechanischerAufwand(float mechanischerAufwand) {
        this.mMechanischerAufwand = mechanischerAufwand;
    }

    public float getProgrammierAufwand() {
        if (this.mLesart != null && this.mLesart.equals("PROZENT")) {
            return this.getMinZuProzent(this.mProgrammierAufwand);
        }
        return this.mProgrammierAufwand;
    }

    public void setProgrammierAufwand(float programmierAufwand) {
        this.mProgrammierAufwand = programmierAufwand;
    }

    private long getMinZuProzent(float prozent) {
        double minuten = 0.0;
        minuten = this.mGesamtAufwand / 100.0f * prozent;
        return Math.round(minuten);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.mId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EinbauInfo other = (EinbauInfo)obj;
        return this.mId == other.mId;
    }

    public EinbauInfo(int id, String komplexitaet, String lesart, float mechanischerAufwand, float elektrischerAufwand, float programmierAufwand, float lackierAufwand, float arbeitsAufwand, float gesamtAufwand) {
        this.mId = id;
        this.mKomplexitaet = komplexitaet;
        this.mLesart = lesart;
        this.mMechanischerAufwand = mechanischerAufwand;
        this.mElektrischerAufwand = elektrischerAufwand;
        this.mProgrammierAufwand = programmierAufwand;
        this.mLackierAufwand = lackierAufwand;
        this.mArbeitsAufwand = arbeitsAufwand;
        this.mGesamtAufwand = gesamtAufwand;
    }

    public EinbauInfo(ArrayList refaArbeitenList) {
        this.mId = 0;
        this.mKomplexitaet = "";
        this.mLesart = "";
        this.mMechanischerAufwand = 0.0f;
        this.mElektrischerAufwand = 0.0f;
        this.mProgrammierAufwand = 0.0f;
        this.mLackierAufwand = 0.0f;
        this.mArbeitsAufwand = 0.0f;
        this.mGesamtAufwand = 0.0f;
        this.refaArbeitenList = refaArbeitenList;
    }

    public EinbauInfo(int id) {
        this.mId = id;
    }

    public Object clone() throws CloneNotSupportedException {
        EinbauInfo info = new EinbauInfo();
        info.setId(this.getId());
        info.setKomplexitaet(this.getKomplexitaet());
        info.setLesart(this.getLesart());
        info.setMechanischerAufwand(this.getMechanischerAufwand());
        info.setElektrischerAufwand(this.getElektrischerAufwand());
        info.setProgrammierAufwand(this.getProgrammierAufwand());
        info.setLackierAufwand(this.getLackierAufwand());
        info.setGesamtAufwand(this.getGesamtAufwand());
        info.setRefaArbeitenList(this.getRefaArbeitenList());
        return info;
    }

    public float getSonstigerAufwand() {
        return this.mSonstigerAufwand;
    }

    public void setSonstigerAufwand(float sonstigerAufwand) {
        this.mSonstigerAufwand = sonstigerAufwand;
    }

    public float getArbeitsAufwand() {
        return this.mArbeitsAufwand;
    }

    public void setArbeitsAufwand(float mArbeitsAufwand) {
        this.mArbeitsAufwand = mArbeitsAufwand;
    }

    public ArrayList<RefaArbeit> getRefaArbeitenList() {
        if (this.refaArbeitenList == null) {
            this.refaArbeitenList = new ArrayList();
        }
        return this.refaArbeitenList;
    }

    public void setRefaArbeitenList(ArrayList refaArbeitenList) {
        this.refaArbeitenList = refaArbeitenList;
    }

    public void addRefaArbeit(RefaArbeit refaArbeit) {
        if (this.refaArbeitenList == null) {
            this.refaArbeitenList = new ArrayList();
        }
        this.refaArbeitenList.add(refaArbeit);
    }

    public int getGesamtRefaArbeitsmenge() {
        int gesamteAWMenge = 0;
        for (int i = 0; i < this.refaArbeitenList.size(); ++i) {
            gesamteAWMenge += this.refaArbeitenList.get(i).getMenge();
        }
        return gesamteAWMenge;
    }
}

