/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.verwaltung;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.verwaltung.Angebot;
import webetk.app.zub.verwaltung.KonfigurationsPosition;

@XmlRootElement(name="KonfigurationZub")
@XmlType(name="webetk.app.zub.verwaltung.Konfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Konfiguration
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    public static final int NULL = 0;
    protected int anfrageId;
    protected int vorgangsId;
    protected int konfigurationsId;
    protected String konfigurationsName;
    protected double aufabschlag;
    protected int konfigurationsIdVorlage;
    protected ArrayList<Bnb> selectedBnbsMitVarianten = new ArrayList();
    protected int mVarianteId;
    protected String mAlternativeBildPos;
    protected List<String> mOptionaleProdukte = new ArrayList<String>();
    protected String letzteSicht;
    protected List<KonfigurationsPosition> positionen = new ArrayList<KonfigurationsPosition>();
    protected Angebot angebot;

    public Konfiguration() {
        this(0, 0);
    }

    public Konfiguration(int anfrageId, int vorgangsId) {
        this.anfrageId = anfrageId;
        this.vorgangsId = vorgangsId;
        this.konfigurationsId = 0;
        this.konfigurationsIdVorlage = 0;
        this.letzteSicht = null;
        this.mAlternativeBildPos = null;
        this.mOptionaleProdukte = new ArrayList<String>();
        this.selectedBnbsMitVarianten = new ArrayList();
    }

    public Konfiguration(Konfiguration vorlage) {
        this.anfrageId = vorlage.getAnfrageId();
        this.vorgangsId = vorlage.getVorgangsId();
        this.konfigurationsId = 0;
        this.konfigurationsIdVorlage = vorlage.getKonfigurationsId();
        this.letzteSicht = null;
        this.positionen = vorlage.getPositionen();
        this.mOptionaleProdukte = vorlage.getOptionaleProdukte();
        this.mAlternativeBildPos = vorlage.getAlternativeBildPos();
        this.selectedBnbsMitVarianten = vorlage.getSelectedBnbsMitVarianten();
        this.angebot = null;
    }

    public boolean isReadOnly() {
        return this.angebot != null;
    }

    public int getAnfrageId() {
        return this.anfrageId;
    }

    public void setAnfrageId(int anfrageId) {
        this.anfrageId = anfrageId;
    }

    public int getVorgangsId() {
        return this.vorgangsId;
    }

    public void setVorgangsId(int vorgangsId) {
        this.vorgangsId = vorgangsId;
    }

    public Angebot getAngebot() {
        return this.angebot;
    }

    public void setAngebot(Angebot angebot) {
        this.angebot = angebot;
    }

    public boolean hasKonfigurationsId() {
        return this.konfigurationsId != 0;
    }

    public int getKonfigurationsId() {
        return this.konfigurationsId;
    }

    public void setKonfigurationsId(int konfigurationsId) {
        this.konfigurationsId = konfigurationsId;
    }

    public int getKonfigurationsIdVorlage() {
        return this.konfigurationsIdVorlage;
    }

    public void setKonfigurationsIdVorlage(int konfigurationsIdVorlage) {
        this.konfigurationsIdVorlage = konfigurationsIdVorlage;
    }

    public String getLetzteSicht() {
        return this.letzteSicht;
    }

    public void setLetzteSicht(String letzteSicht) {
        this.letzteSicht = letzteSicht;
    }

    public List getPositionen() {
        return this.positionen;
    }

    public KonfigurationsPosition getPosition(int index) {
        return this.positionen.get(index);
    }

    public void setPositionen(List positionen) {
        this.positionen = positionen;
    }

    public void addPosition(KonfigurationsPosition position) {
        if (this.positionen == null) {
            this.positionen = new ArrayList<KonfigurationsPosition>();
        }
        this.positionen.add(position);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.konfigurationsId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Konfiguration other = (Konfiguration)obj;
        return this.konfigurationsId == other.konfigurationsId;
    }

    public String getKonfigurationsName() {
        return this.konfigurationsName;
    }

    public void setKonfigurationsName(String konfigurationsName) {
        this.konfigurationsName = konfigurationsName;
    }

    public double getAufabschlag() {
        return this.aufabschlag;
    }

    public void setAufabschlag(double aufabschlag) {
        this.aufabschlag = (float)Math.round(aufabschlag * 100.0) / 100.0f;
    }

    public String getAlternativeBildPos() {
        return this.mAlternativeBildPos;
    }

    public void setAlternativeBildPos(String alternativeBildPos) {
        this.mAlternativeBildPos = alternativeBildPos;
    }

    public List<String> getOptionaleProdukte() {
        return this.mOptionaleProdukte;
    }

    public void setOptionaleProdukte(List<String> optionaleProdukte) {
        this.mOptionaleProdukte = optionaleProdukte;
    }

    public void setOptionaleProdukte(String bildPosString) {
        ArrayList<String> optionaleProdukte = new ArrayList<String>();
        if (bildPosString != null && bildPosString.length() > 0) {
            String[] produktBnbListe = bildPosString.split(",");
            for (int i = 0; i < produktBnbListe.length; ++i) {
                optionaleProdukte.add(produktBnbListe[i]);
            }
        }
        this.setOptionaleProdukte(optionaleProdukte);
    }

    public ArrayList getSelectedBnbsMitVarianten() {
        return this.selectedBnbsMitVarianten;
    }

    public void setSelectedBnbsMitVarianten(ArrayList bnbVarianten) {
        this.selectedBnbsMitVarianten = bnbVarianten;
    }
}

