/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.LanguageUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.aspg.Teil;
import webetk.db.SQLStatements;

public class AspgDbAccess {
    private static Logger log = Logger.getLogger(AspgDbAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Teil> loadAspgTeile(ArrayList cAspgTeile, String sSprache) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        PreparedStatement stat = null;
        ArrayList<Teil> cTeileErgebnis = new ArrayList<Teil>();
        try {
            con = globs.getDBConnection("webetk.db.aspg");
            String statement = SQLStatements.Aspg.instance.LOAD_ASPG_TEILE();
            for (int i = 0; i < cAspgTeile.size(); ++i) {
                Teil teil = (Teil)cAspgTeile.get(i);
                int menge = Integer.parseInt(teil.getMenge());
                ResultSet rs = null;
                cTeileErgebnis.add(teil);
                stat = con.prepareStatement(statement);
                stat.setString(1, teil.getSachnummer());
                stat.setString(2, "AS");
                log.debug((Object)("Executing: " + statement + " Sachnr: " + teil.getSachnummer() + " AS"));
                rs = stat.executeQuery();
                while (rs.next()) {
                    Teil pgTeil = new Teil(rs.getString(1), Integer.toString(rs.getInt(2) * menge), "AS");
                    cTeileErgebnis.add(pgTeil);
                    pgTeil.setAspgTyp("K");
                    pgTeil.setAspgRef(teil.getSachnummer());
                    pgTeil.setAspgMenge(Integer.toString(rs.getInt(2)));
                }
            }
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.aspg");
            }
        }
        return cTeileErgebnis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Teil> loadStecker(ArrayList<Teil> cSteckerTeil, String sSprache) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        PreparedStatement stat = null;
        ArrayList<Teil> cTeileErgebnis = new ArrayList<Teil>();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        try {
            con = globs.getDBConnection("webetk.db.aspg");
            String statement = SQLStatements.Aspg.instance.LOAD_STECKER();
            for (int i = 0; i < cSteckerTeil.size(); ++i) {
                Teil teil = cSteckerTeil.get(i);
                ResultSet rs = null;
                stat = con.prepareStatement(statement);
                stat.setString(1, teil.getSachnummer());
                stat.setString(2, teil.getKzgruppe());
                stat.setString(3, sISO);
                stat.setString(4, sRegISO);
                log.debug((Object)("Executing: " + statement + " Sachnr: " + teil.getSachnummer() + " KZ-Gruppe: " + teil.getKzgruppe() + " ISO: " + sISO + " RegISO: " + sRegISO));
                rs = stat.executeQuery();
                while (rs.next()) {
                    cTeileErgebnis.add(new Teil(rs.getString(1), rs.getString(2), rs.getString(3), Integer.toString(rs.getInt(5)), "ST", rs.getString(4), rs.getString(6), rs.getString(9)));
                }
            }
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.aspg");
            }
        }
        return cTeileErgebnis;
    }
}

