/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class FuellmengenDbAccess {
    private static Logger log = Logger.getLogger(FuellmengenDbAccess.class);

    public static ResultSet retrieveFuellmengen(Connection con, String sLang, Collection<String> cTypen, String sZulassungsmonat, String sBaujahr) throws SQLException, NoDataFoundException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Fuellmengen.instance.RETRIEVE_FUELLMENGEN();
            sLang = sLang.equals("de") || sLang.equals("en") || sLang.equals("fr") || sLang.equals("enUS") || sLang.equals("nl") || sLang.equals("it") || sLang.equals("es") || sLang.equals("sv") || sLang.equals("ja") ? sLang.toLowerCase() : "en";
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "SPRACHE", sLang);
            int index = 0;
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(cTypen.size()));
            for (String sTypen : cTypen) {
                StringUtils.setPreparedStatementParams(++index, sTypen);
            }
            String sProduktionsdatum = sBaujahr + sZulassungsmonat;
            StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            StringUtils.setPreparedStatementParams(++index, sProduktionsdatum);
            PreparedStatement ps = con.prepareStatement(sSQLStatement, 1004, 1008);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            if (res == null || !res.isBeforeFirst()) {
                throw new NoDataFoundException("No values found");
            }
            return res;
        }
        String sSQLStatement = SQLStatements.Fuellmengen.instance.RETRIEVE_FUELLMENGEN();
        String sTypen = FuellmengenDbAccess.concatCollection(cTypen);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPEN", sTypen);
        String sProduktionsdatum = sBaujahr + sZulassungsmonat;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTIONSDATUM_YYYYMM", sProduktionsdatum);
        sLang = sLang.equals("de") || sLang.equals("en") || sLang.equals("fr") || sLang.equals("enUS") || sLang.equals("nl") || sLang.equals("it") || sLang.equals("es") || sLang.equals("sv") || sLang.equals("ja") ? sLang.toLowerCase() : "en";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SPRACHE", sLang);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement(1004, 1008);
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.isBeforeFirst()) {
            throw new NoDataFoundException("No values found");
        }
        return res;
    }

    private static String concatCollection(Collection cCollection) {
        String sString = "";
        if (cCollection == null) {
            return sString;
        }
        Iterator iterator = cCollection.iterator();
        while (iterator.hasNext()) {
            if (sString.length() > 0) {
                sString = sString + ", ";
            }
            sString = sString + "'" + (String)iterator.next() + "'";
        }
        return sString;
    }
}

