/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.auswertung.User;
import webetk.app.konfiguration.Konfiguration;
import webetk.db.SQLStatements;
import webetk.db.zub.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class KonfigurationDbAccess {
    private static Logger log = Logger.getLogger(KonfigurationDbAccess.class);

    public static ResultSet loadFirmen(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FIRMEN();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet existiertEineFirmaFilialeNutzer(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_EINEFIRMAFILIALENUTZER();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadFilialen(Connection con, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FILIALEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FILIALEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static boolean checkUser(Connection con, String sFirmaId, String sNutzerId, String sPasswort) throws SQLException, DatabaseBusyException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_EXIST_USER();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
            ps.setString(2, sNutzerId);
            sPasswort = StringUtils.maskiereHochkommaFuerDb(sPasswort);
            ps.setString(3, sPasswort);
            ResultSet res = ps.executeQuery();
            if (res == null || !res.next()) {
                return false;
            }
            String sCount = res.getString(1);
            WebetkUtils.closeQuery(res);
            return !sCount.equals("0");
        }
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_EXIST_USER();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KENNUNG", sNutzerId);
        sPasswort = StringUtils.maskiereHochkommaFuerDb(sPasswort);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PASSWORT", sPasswort);
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.next()) {
            return false;
        }
        String sCount = res.getString(1);
        WebetkUtils.closeQuery(res);
        return !sCount.equals("0");
    }

    public static ResultSet loadKonfiguration(Connection con, String sFirma, String sFiliale) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.LOAD_KONFIGURATION();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
            ps.setString(1, sFirma);
            sFiliale = StringUtils.maskiereHochkommaFuerDb(sFiliale);
            ps.setString(2, sFiliale);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.LOAD_KONFIGURATION();
        sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        sFiliale = StringUtils.maskiereHochkommaFuerDb(sFiliale);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFiliale);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static void saveKonfiguration(Connection con, String sFirma, String sFiliale, Konfiguration oKonfig) throws SQLException {
        try {
            con.setAutoCommit(false);
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_KONFIGURATION();
            sSQLStatement = KonfigurationDbAccess.setSQLStatement(sSQLStatement, sFirma, sFiliale, oKonfig);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            int countUpdate = stmt.executeUpdate(sSQLStatement);
            if (countUpdate == 0) {
                sSQLStatement = SQLStatements.Firmenkonfiguration.instance.INSERT_KONFIGURATION();
                sSQLStatement = KonfigurationDbAccess.setSQLStatement(sSQLStatement, sFirma, sFiliale, oKonfig);
                stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
            }
            stmt.close();
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    private static String setSQLStatement(String sSQLStatement, String sFirma, String sFiliale, Konfiguration oKonfig) {
        String sHaendleranschriftZeile1 = oKonfig.getHaendleranschriftZeile1();
        sHaendleranschriftZeile1 = sHaendleranschriftZeile1 == null || sHaendleranschriftZeile1.trim().equals("") ? "null" : "'" + sHaendleranschriftZeile1 + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMENNAME", sHaendleranschriftZeile1);
        String sHaendleranschriftZeile2 = oKonfig.getHaendleranschriftZeile2();
        sHaendleranschriftZeile2 = sHaendleranschriftZeile2 == null || sHaendleranschriftZeile2.trim().equals("") ? "null" : "'" + sHaendleranschriftZeile2 + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ZUSATZ", sHaendleranschriftZeile2);
        String sHaendleranschriftZeile3 = oKonfig.getHaendleranschriftZeile3();
        sHaendleranschriftZeile3 = sHaendleranschriftZeile3 == null || sHaendleranschriftZeile3.trim().equals("") ? "null" : "'" + sHaendleranschriftZeile3 + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "STRASSE", sHaendleranschriftZeile3);
        String sHaendleranschriftPLZ = oKonfig.getHaendleranschriftPLZ();
        sHaendleranschriftPLZ = sHaendleranschriftPLZ == null || sHaendleranschriftPLZ.trim().equals("") ? "null" : "'" + sHaendleranschriftPLZ + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PLZ", sHaendleranschriftPLZ);
        String sHaendleranschriftOrt = oKonfig.getHaendleranschriftOrt();
        sHaendleranschriftOrt = sHaendleranschriftOrt == null || sHaendleranschriftOrt.trim().equals("") ? "null" : "'" + sHaendleranschriftOrt + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ORT", sHaendleranschriftOrt);
        String sHaendleranschriftTelefon = oKonfig.getHaendleranschriftTelefon();
        sHaendleranschriftTelefon = sHaendleranschriftTelefon == null || sHaendleranschriftTelefon.trim().equals("") ? "null" : "'" + sHaendleranschriftTelefon + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TELEFON", sHaendleranschriftTelefon);
        String sMailserver = oKonfig.getMailserver();
        sMailserver = sMailserver == null || sMailserver.trim().equals("") ? "null" : "'" + sMailserver + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MAILSERVER", sMailserver);
        String sAbwicklung = oKonfig.getAbwicklung();
        sAbwicklung = sAbwicklung == null || sAbwicklung.trim().equals("") ? "null" : "'" + sAbwicklung + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ABWICKLUNG", sAbwicklung);
        String sBestandFiliale = oKonfig.getBestandFiliale();
        sBestandFiliale = sBestandFiliale == null || sBestandFiliale.trim().equals("") ? "null" : "'" + sBestandFiliale + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BESTAND_FILIALE", sBestandFiliale);
        String sDatenabgleich = oKonfig.getDatenabgleich();
        sDatenabgleich = sDatenabgleich == null || sDatenabgleich.trim().equals("") ? "null" : "'" + sDatenabgleich + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATENABGLEICH", sDatenabgleich);
        String sHaendlernummerPKW = oKonfig.getHaendlernummerPKW();
        sHaendlernummerPKW = sHaendlernummerPKW == null || sHaendlernummerPKW.trim().equals("") ? "null" : "'" + sHaendlernummerPKW + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PKW", sHaendlernummerPKW);
        String sHaendlernummerMotorrad = oKonfig.getHaendlernummerMotorrad();
        sHaendlernummerMotorrad = sHaendlernummerMotorrad == null || sHaendlernummerMotorrad.trim().equals("") ? "null" : "'" + sHaendlernummerMotorrad + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOTOTRRAD", sHaendlernummerMotorrad);
        String sMWStSatzNiedrig = oKonfig.getMWStSatzNiedrig();
        sMWStSatzNiedrig = sMWStSatzNiedrig == null || sMWStSatzNiedrig.trim().equals("") ? "null" : sMWStSatzNiedrig;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MWST_NIEDRIG", sMWStSatzNiedrig);
        String sMWStSatzHoch = oKonfig.getMWStSatzHoch();
        sMWStSatzHoch = sMWStSatzHoch == null || sMWStSatzHoch.trim().equals("") ? "null" : sMWStSatzHoch;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MWST_HOCH", sMWStSatzHoch);
        String sMWStSatzAltteile = oKonfig.getMWStSatzAltteile();
        sMWStSatzAltteile = sMWStSatzAltteile == null || sMWStSatzAltteile.trim().equals("") ? "null" : sMWStSatzAltteile;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MWST_ALTTEILE", sMWStSatzAltteile);
        String sMWStSatz3 = oKonfig.getMWStSatz3();
        sMWStSatz3 = sMWStSatz3 == null || sMWStSatz3.trim().equals("") ? "null" : sMWStSatz3;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MWST_3", sMWStSatz3);
        String sMWStSatz4 = oKonfig.getMWStSatz4();
        sMWStSatz4 = sMWStSatz4 == null || sMWStSatz4.trim().equals("") ? "null" : sMWStSatz4;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MWST_4", sMWStSatz4);
        String sRechnungsnummer = oKonfig.getRechnungsnummer();
        sRechnungsnummer = sRechnungsnummer == null || sRechnungsnummer.trim().equals("") ? "null" : sRechnungsnummer;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "RECHNUNGNR", sRechnungsnummer);
        String sStandardBarVerkaufsNummer = oKonfig.getStandardBarVerkaufsNummer();
        sStandardBarVerkaufsNummer = sStandardBarVerkaufsNummer == null || sStandardBarVerkaufsNummer.trim().equals("") ? "null" : sStandardBarVerkaufsNummer;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BARVERKAUFNR", sStandardBarVerkaufsNummer);
        String sStandardAuftrtagsNummer = oKonfig.getStandardAuftragsNummer();
        sStandardAuftrtagsNummer = sStandardAuftrtagsNummer == null || sStandardAuftrtagsNummer.trim().equals("") ? "null" : "'" + sStandardAuftrtagsNummer + "'";
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "AUFTRAGSNR", sStandardAuftrtagsNummer);
        String sStandardKundenNummer = oKonfig.getStandardKundenNummer();
        sStandardKundenNummer = sStandardKundenNummer == null || sStandardKundenNummer.trim().equals("") ? "null" : sStandardKundenNummer;
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KUNDENNR", sStandardKundenNummer);
        String sDMSSchnittstelleVerwenden = oKonfig.getDMSSchnittstelleVerwenden();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HS_VERWENDEN", sDMSSchnittstelleVerwenden);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFiliale);
        return sSQLStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDMSVerwenden(Connection con, String sFirmaId, String sFilialeId) throws SQLException, DatabaseBusyException {
        boolean bDMSVerwenden = false;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_DMS_VERWENDEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            sFilialeId = StringUtils.maskiereHochkommaFuerDb(sFilialeId);
            ps.setString(2, sFilialeId);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = null;
            try {
                String sDMSVerwenden;
                res = ps.executeQuery(sSQLStatement);
                if (res != null && res.next() && (sDMSVerwenden = res.getString("DMSVerwenden")) != null && sDMSVerwenden.equals("J")) {
                    bDMSVerwenden = true;
                }
            }
            finally {
                WebetkUtils.closeQuery(res);
            }
            return bDMSVerwenden;
        }
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_DMS_VERWENDEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sFilialeId = StringUtils.maskiereHochkommaFuerDb(sFilialeId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFilialeId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = null;
        try {
            String sDMSVerwenden;
            res = stmt.executeQuery(sSQLStatement);
            if (res != null && res.next() && (sDMSVerwenden = res.getString("DMSVerwenden")) != null && sDMSVerwenden.equals("J")) {
                bDMSVerwenden = true;
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
        return bDMSVerwenden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrementRechungsnummer(Connection con, String sFirma, String sFiliale) throws SQLException, NoDataFoundException {
        try {
            if (HtmlUtils.isConnectionSourceOracle(con)) {
                con.setAutoCommit(false);
                ResultSet res = null;
                String sSQLStatementSelect = SQLStatements.Firmenkonfiguration.instance.SELECT_RECHNUNGSNUMMER_FOR_UPDATE();
                PreparedStatement ps = con.prepareStatement(sSQLStatementSelect);
                sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
                ps.setString(1, sFirma);
                sFiliale = StringUtils.maskiereHochkommaFuerDb(sFiliale);
                ps.setString(2, sFiliale);
                log.debug((Object)("Executing: " + sSQLStatementSelect));
                res = ps.executeQuery();
                if (res == null || !res.next()) {
                    throw new NoDataFoundException();
                }
                long lRechungsnummer = res.getLong("RechnungsNr");
                if (res != null) {
                    res.close();
                }
                ps.close();
                String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_RECHNUNGSNUMMER();
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFiliale);
                String sRechungsnummer = Long.toString(++lRechungsnummer);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "RECHNUNGSNR", sRechungsnummer);
                log.debug((Object)("Executing: " + sSQLStatement));
                Statement stmt = con.createStatement();
                stmt.executeUpdate(sSQLStatement);
                stmt.close();
                long l = lRechungsnummer;
                return l;
            }
            con.setAutoCommit(false);
            Statement stmtSelect = null;
            ResultSet res = null;
            String sSQLStatementSelect = SQLStatements.Firmenkonfiguration.instance.SELECT_RECHNUNGSNUMMER_FOR_UPDATE();
            sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma);
            sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "FIRMA", sFirma);
            sFiliale = StringUtils.maskiereHochkommaFuerDb(sFiliale);
            sSQLStatementSelect = StringUtils.substituteString(sSQLStatementSelect, "FILIALE", sFiliale);
            log.debug((Object)("Executing: " + sSQLStatementSelect));
            stmtSelect = con.createStatement();
            res = stmtSelect.executeQuery(sSQLStatementSelect);
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            long lRechungsnummer = res.getLong("RechnungsNr");
            if (res != null) {
                res.close();
            }
            stmtSelect.close();
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_RECHNUNGSNUMMER();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirma);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFiliale);
            String sRechungsnummer = Long.toString(++lRechungsnummer);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "RECHNUNGSNR", sRechungsnummer);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sSQLStatement);
            stmt.close();
            long l = lRechungsnummer;
            return l;
        }
        finally {
            con.commit();
            con.setAutoCommit(true);
        }
    }

    public static int updateBezeichnung(Connection con, String sNeueBezeichnung, String sID) throws SQLException {
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_FIRMENBEZEICHNUNG();
        sNeueBezeichnung = StringUtils.maskiereHochkommaFuerDb(sNeueBezeichnung);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEZEICHNUNG", sNeueBezeichnung);
        sID = StringUtils.maskiereHochkommaFuerDb(sID);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sID);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        int result = stmt.executeUpdate(sSQLStatement);
        return result;
    }

    public static int createFiliale(Connection con, String sId, String sBezeichnung, String sFirmaId, String sIso, String sRegiso) throws SQLException {
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.INSERT_FILIALE();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sId = StringUtils.maskiereHochkommaFuerDb(sId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        sBezeichnung = StringUtils.maskiereHochkommaFuerDb(sBezeichnung);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sBezeichnung);
        sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sRegiso = StringUtils.maskiereHochkommaFuerDb(sRegiso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegiso);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        int result = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return result;
    }

    public static int deleteFiliale(Connection con, String sId, String sFirmaId) throws SQLException {
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_FILIALE();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sId = StringUtils.maskiereHochkommaFuerDb(sId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        int result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ALL_AUFTRAEGE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ALL_TEILELISTEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ALL_TEILELISTEN_POSITIONEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ALL_TEILELISTEN_SI();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ALL_BESTELLLISTEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ALL_BESTELLLISTEN_POSITIONEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_ZUB_KONFIGURATION();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_KONFIGURATION();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sId);
        log.debug((Object)("Executing: " + sSQLStatement));
        stmt = con.createStatement();
        result = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        PreparedStatement ps = con.prepareStatement(SQLStatements.Admin.instance.DELETE_ARBEITEN_VOLLST());
        ps.setString(1, sFirmaId);
        ps.setString(2, sId);
        result = ps.executeUpdate();
        ps.close();
        return result;
    }

    public static int updateFiliale(Connection con, String sId, String sBezeichnung, String sFirmaId, String sIso, String sRegiso) throws SQLException {
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_FILIALE();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sId = StringUtils.maskiereHochkommaFuerDb(sId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sId);
        sBezeichnung = StringUtils.maskiereHochkommaFuerDb(sBezeichnung);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sBezeichnung);
        sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sRegiso = StringUtils.maskiereHochkommaFuerDb(sRegiso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegiso);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        int result = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return result;
    }

    public static ResultSet loadFilialenSprachen(Connection con, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FILIALEN_SPRACHEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FILIALEN_SPRACHEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadAnzahlNutzer(String sFirmaId, String sKriterium, List<String> aUserIdsToIgnore) throws SQLException, DatabaseBusyException {
        ResultSet result;
        Connection con;
        ServerGlobalObjects globs;
        block16: {
            int n;
            Statement stmt;
            block14: {
                block15: {
                    globs = ServerGlobalObjects.getInstance();
                    log.debug((Object)"Now Accessing Database");
                    con = null;
                    stmt = null;
                    result = null;
                    con = globs.getDBConnectionNutzer("konfiguration.AdminToolDbAccess.loadAnzahlNutzer");
                    if (!HtmlUtils.isConnectionSourceOracle(con)) break block14;
                    String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_ANZAHL_NUTZER();
                    int index = 0;
                    StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sFirmaId));
                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aUserIdsToIgnore.size()));
                    for (String sUserIdsToIgnore : aUserIdsToIgnore) {
                        StringUtils.setPreparedStatementParams(++index, sUserIdsToIgnore);
                    }
                    StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sKriterium));
                    StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sKriterium));
                    log.debug((Object)("Executing: " + sSQLStatement));
                    PreparedStatement ps = con.prepareStatement(sSQLStatement);
                    ps = StringUtils.setParameters(ps);
                    result = ps.executeQuery();
                    if (!result.next()) break block15;
                    int sUserIdsToIgnore = result.getInt("NutzerAnzahl");
                    WebetkUtils.closeQuery(result);
                    if (con != null) {
                        globs.freeDBConnectionNutzer(con, "loadAnzahlNutzer");
                    }
                    return sUserIdsToIgnore;
                }
                int sUserIdsToIgnore = -1;
                WebetkUtils.closeQuery(result);
                if (con != null) {
                    globs.freeDBConnectionNutzer(con, "loadAnzahlNutzer");
                }
                return sUserIdsToIgnore;
            }
            try {
                String ignoreUser;
                String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_ANZAHL_NUTZER();
                if (aUserIdsToIgnore != null && !aUserIdsToIgnore.isEmpty()) {
                    StringBuilder sb = new StringBuilder("'");
                    sb.append(aUserIdsToIgnore.get(0));
                    sb.append("'");
                    for (int ii = 1; ii < aUserIdsToIgnore.size(); ++ii) {
                        sb.append(", '");
                        sb.append(aUserIdsToIgnore.get(ii));
                        sb.append("'");
                    }
                    ignoreUser = sb.toString();
                } else {
                    ignoreUser = "NULL";
                }
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "IGNORE_USER", ignoreUser);
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirmaId));
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "KRIT", StringUtils.maskiereHochkommaFuerDb(sKriterium));
                log.debug((Object)("Executing: " + sSQLStatement));
                stmt = con.createStatement();
                result = stmt.executeQuery(sSQLStatement);
                if (!result.next()) break block16;
                n = result.getInt("NutzerAnzahl");
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(result);
                if (con != null) {
                    globs.freeDBConnectionNutzer(con, "loadAnzahlNutzer");
                }
                throw throwable;
            }
            WebetkUtils.closeQuery(result);
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loadAnzahlNutzer");
            }
            return n;
        }
        int n = -1;
        WebetkUtils.closeQuery(result);
        if (con != null) {
            globs.freeDBConnectionNutzer(con, "loadAnzahlNutzer");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> loadMatchingNutzer(String sFirmaId, String sKriterium, List<String> aUserIdsToIgnore) throws SQLException, DatabaseBusyException {
        ArrayList<String[]> arrayList;
        ResultSet result;
        Statement stmt;
        Connection con;
        ServerGlobalObjects globs;
        block12: {
            globs = ServerGlobalObjects.getInstance();
            log.debug((Object)"Now Accessing Database");
            con = null;
            stmt = null;
            result = null;
            con = globs.getDBConnectionNutzer("konfiguration.AdminToolDbAccess.loadMatchingNutzer");
            if (!HtmlUtils.isConnectionSourceOracle(con)) break block12;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_MATCHING_NUTZER();
            int index = 0;
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sFirmaId));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aUserIdsToIgnore.size()));
            for (String sUserIdsToIgnore : aUserIdsToIgnore) {
                StringUtils.setPreparedStatementParams(++index, sUserIdsToIgnore);
            }
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sKriterium));
            StringUtils.setPreparedStatementParams(++index, StringUtils.maskiereHochkommaFuerDb(sKriterium));
            log.debug((Object)("Executing: " + sSQLStatement));
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            result = ps.executeQuery();
            ArrayList<String[]> list = new ArrayList<String[]>();
            while (result.next()) {
                list.add(new String[]{result.getString("NutzerId"), result.getString("NutzerName")});
            }
            ArrayList<String[]> arrayList2 = list;
            WebetkUtils.closeQuery(result);
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loadMatchingNutzer");
            }
            return arrayList2;
        }
        try {
            String ignoreUser;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_MATCHING_NUTZER();
            if (aUserIdsToIgnore != null && !aUserIdsToIgnore.isEmpty()) {
                StringBuilder sb = new StringBuilder("'");
                sb.append(aUserIdsToIgnore.get(0));
                sb.append("'");
                for (int ii = 1; ii < aUserIdsToIgnore.size(); ++ii) {
                    sb.append(", '");
                    sb.append(aUserIdsToIgnore.get(ii));
                    sb.append("'");
                }
                ignoreUser = sb.toString();
            } else {
                ignoreUser = "NULL";
            }
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IGNORE_USER", ignoreUser);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", StringUtils.maskiereHochkommaFuerDb(sFirmaId));
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "KRIT", StringUtils.maskiereHochkommaFuerDb(sKriterium));
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            result = stmt.executeQuery(sSQLStatement);
            ArrayList<String[]> list = new ArrayList<String[]>();
            while (result.next()) {
                list.add(new String[]{result.getString("NutzerId"), result.getString("NutzerName")});
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(result);
            if (con != null) {
                globs.freeDBConnectionNutzer(con, "loadMatchingNutzer");
            }
            throw throwable;
        }
        WebetkUtils.closeQuery(result);
        if (con != null) {
            globs.freeDBConnectionNutzer(con, "loadMatchingNutzer");
        }
        return arrayList;
    }

    public static ResultSet loadNutzer(Connection con, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_NUTZER();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_NUTZER();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNutzer(Connection con, String sFirmaId, String sNutzerId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_SINGLE_NUTZER();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
            ps.setString(2, sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_SINGLE_NUTZER();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NUTZERID", sNutzerId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNutzerByFilialId(Connection con, String sDefaultFiliale, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_USER_BY_DEFAULT_FILIALE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sDefaultFiliale = StringUtils.maskiereHochkommaFuerDb(sDefaultFiliale);
            ps.setString(1, sDefaultFiliale);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_USER_BY_DEFAULT_FILIALE();
        sDefaultFiliale = StringUtils.maskiereHochkommaFuerDb(sDefaultFiliale);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sDefaultFiliale);
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadDefaultFilialePasswort(Connection con, String sFirmaId, String sNutzerId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_USERINFO();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
            ps.setString(2, sNutzerId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_USERINFO();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sNutzerId = StringUtils.maskiereHochkommaFuerDb(sNutzerId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USER", sNutzerId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBerechtigungen(Connection con, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_BERECHTIGUNEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_BERECHTIGUNEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadSprachen(Connection con, String sIso, String sRegIso) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_SPRACHEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "S");
            sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
            ps.setString(2, sIso);
            sRegIso = StringUtils.maskiereHochkommaFuerDb(sRegIso);
            ps.setString(3, sRegIso);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_SPRACHEN();
        sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sRegIso = StringUtils.maskiereHochkommaFuerDb(sRegIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadFunktionsrechte(Connection con, String sIso, String sRegIso) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FUNKTIONSRECHTE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, "R");
            sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
            ps.setString(2, sIso);
            sRegIso = StringUtils.maskiereHochkommaFuerDb(sRegIso);
            ps.setString(3, sRegIso);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_FUNKTIONSRECHTE();
        sIso = StringUtils.maskiereHochkommaFuerDb(sIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sRegIso = StringUtils.maskiereHochkommaFuerDb(sRegIso);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNutzerFunktionsrechte(Connection con, String sFirmaId, String sUserId, String sISO, String sRegISO) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_NUTZER_FUNKTIONSRECHTE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
            ps.setString(2, sUserId);
            ps.setString(3, "R");
            sISO = StringUtils.maskiereHochkommaFuerDb(sISO);
            ps.setString(4, sISO);
            sRegISO = StringUtils.maskiereHochkommaFuerDb(sRegISO);
            ps.setString(5, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_NUTZER_FUNKTIONSRECHTE();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA_ID", sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USER_ID", sUserId);
        sISO = StringUtils.maskiereHochkommaFuerDb(sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sRegISO = StringUtils.maskiereHochkommaFuerDb(sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadNutzerBerechtigungen(Connection con, String sFirmaId, String sUserId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_NUTZER_BERECHTIGUNGEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(2, sFirmaId);
            sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
            ps.setString(1, sUserId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_NUTZER_BERECHTIGUNGEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USER", sUserId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static int deleteNutzer(Connection con, String sUserId, String sFirmaId) throws SQLException {
        int res = 0;
        String[] sSQLStatements = new String[]{SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_BERECHTIGUNGEN(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_FUNKTIONSRECHTE(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_EINSTELLUNGEN(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_EINSTELLUNGEN_REGION(), SQLStatements.Firmenkonfiguration.instance.DELETE_ZUB_NUTZER(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_TEILELISTEPOS(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_TEILELISTE(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_TEILELISTE_SENDEINFO(), SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_TEILEINFO()};
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        for (int i = 0; i < sSQLStatements.length; ++i) {
            String sSQLStatement = sSQLStatements[i];
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sUserId);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
            stmt.close();
        }
        return res;
    }

    public static boolean existNutzerId(Connection con, String sFirmaId, String sUserId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_EXIST_USER_ID();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            ps.setString(1, sFirmaId);
            sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
            ps.setString(2, sUserId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            if (res == null || !res.next()) {
                return false;
            }
            String sCount = res.getString(1);
            WebetkUtils.closeQuery(res);
            return !sCount.equals("0");
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_EXIST_USER_ID();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KENNUNG", sUserId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        if (res == null || !res.next()) {
            return false;
        }
        String sCount = res.getString(1);
        WebetkUtils.closeQuery(res);
        return !sCount.equals("0");
    }

    public static int storeNutzer(Connection con, String sFirmaId, String sUserId, String sUserName, String sPassword, String sDefaultFiliale, String sBearbeiterNummer) throws SQLException {
        String sSQLStatement;
        int res = 0;
        if (KonfigurationDbAccess.existNutzerId(con, sFirmaId, sUserId)) {
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_NUTZER();
            PreparedStatement textPs = con.prepareStatement(sSQLStatement);
            textPs.setString(1, sUserName);
            textPs.setString(2, sPassword);
            textPs.setString(3, sDefaultFiliale);
            try {
                int bNr = Integer.parseInt(sBearbeiterNummer);
                textPs.setInt(4, bNr);
            }
            catch (NumberFormatException e) {
                textPs.setNull(4, 5);
            }
            textPs.setString(5, sFirmaId);
            textPs.setString(6, sUserId);
            textPs.execute();
            textPs.close();
        } else {
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
            sUserName = StringUtils.maskiereHochkommaFuerDb(sUserName);
            sPassword = StringUtils.maskiereHochkommaFuerDb(sPassword);
            sDefaultFiliale = StringUtils.maskiereHochkommaFuerDb(sDefaultFiliale);
            sBearbeiterNummer = sBearbeiterNummer == null ? "null" : sBearbeiterNummer;
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.STORE_NUTZER();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERNAME", sUserName);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PASSWORD", sPassword);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sDefaultFiliale);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "BEARBEITERNUMMER", sBearbeiterNummer);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
            stmt.close();
        }
        if (KonfigurationDbAccess.existiertKonfigZub(con, sDefaultFiliale, sFirmaId)) {
            PreparedStatement stat = con.prepareStatement(SQLStatements.Firmenkonfiguration.instance.UPDATE_MARKTID_NUTZER_VON_FILIALE());
            stat.setString(1, sDefaultFiliale);
            stat.setString(2, sFirmaId);
            stat.setString(3, sUserId);
            stat.executeUpdate();
            stat.close();
        }
        return res;
    }

    public static boolean existiertKonfigZub(Connection con, String filialeId, String firmaId) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.EXISTIERT_FILIAL_ZUB();
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        stat.setString(1, firmaId);
        stat.setString(2, filialeId);
        res = stat.executeQuery();
        if (res.next() && res.getInt(1) > 0) {
            return true;
        }
        res.close();
        stat.close();
        return false;
    }

    public static int storeNutzerBerechtigungen(Connection con, String sFirmaId, String sUserId, Vector cBerechtigungen) throws SQLException {
        int res = 0;
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_BERECHTIGUNGEN();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sUserId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res += stmt.executeUpdate(sSQLStatement);
        for (int i = 0; i < cBerechtigungen.size(); ++i) {
            String[] sArtWert = (String[])cBerechtigungen.get(i);
            String sArt = sArtWert[0];
            String sWert = sArtWert[1];
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.STORE_NUTZER_BERECHTIGUNGEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "WERT", sWert);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
        }
        stmt.close();
        return res;
    }

    public static int storeNutzerFunktionsrechte(Connection con, String sFirmaId, String sUserId, Vector cFunktionsrechte) throws SQLException {
        int res = 0;
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.DELETE_NUTZER_FUNKTIONSRECHTE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ID", sUserId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res += stmt.executeUpdate(sSQLStatement);
        for (int i = 0; i < cFunktionsrechte.size(); ++i) {
            String sRecht = (String)cFunktionsrechte.get(i);
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.STORE_NUTZER_FUNKTIONSRECHTE();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "RECHT", sRecht);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
        }
        stmt.close();
        return res;
    }

    public static void moveTeilelisten(Connection con, String sFirmaId, String sUserId, String sFilialIdNeu, String sFilialIdAlt) throws SQLException {
        int res = 0;
        try {
            con.setAutoCommit(false);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
            sFilialIdNeu = StringUtils.maskiereHochkommaFuerDb(sFilialIdNeu);
            sFilialIdAlt = StringUtils.maskiereHochkommaFuerDb(sFilialIdAlt);
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.MOVE_TEILELISTENPOS();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID_NEU", sFilialIdNeu);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID_ALT", sFilialIdAlt);
            log.debug((Object)("Executing: " + sSQLStatement));
            Statement stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.MOVE_TEILELISTENSI();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID_NEU", sFilialIdNeu);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID_ALT", sFilialIdAlt);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.MOVE_TEILELISTEN();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID_NEU", sFilialIdNeu);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID_ALT", sFilialIdAlt);
            log.debug((Object)("Executing: " + sSQLStatement));
            stmt = con.createStatement();
            res += stmt.executeUpdate(sSQLStatement);
            stmt.close();
            con.commit();
        }
        catch (SQLException ex) {
            con.rollback();
            throw ex;
        }
        finally {
            con.setAutoCommit(true);
        }
    }

    public static int changeDefaultFiliale(Connection con, String sFirmaId, String sUserId, String sFilialId) throws SQLException {
        int res = 0;
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sUserId = StringUtils.maskiereHochkommaFuerDb(sUserId);
        sFilialId = StringUtils.maskiereHochkommaFuerDb(sFilialId);
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.UPDATE_DEFAULT_FILIALE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "USERID", sUserId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sFilialId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeUpdate(sSQLStatement);
        stmt.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existLists(Connection con, String sFilialId, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            boolean res = false;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_BESTELLLISTE_POSITIONEN();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            sFilialId = StringUtils.maskiereHochkommaFuerDb(sFilialId);
            ps.setString(1, sFirmaId);
            ps.setString(2, sFilialId);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet resultset = null;
            try {
                resultset = ps.executeQuery();
                if (resultset.next()) {
                    res = true;
                }
            }
            finally {
                WebetkUtils.closeQuery(resultset);
            }
            sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_TEILELISTE_POSITIONEN();
            PreparedStatement ps1 = con.prepareStatement(sSQLStatement);
            sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
            sFilialId = StringUtils.maskiereHochkommaFuerDb(sFilialId);
            ps1.setString(1, sFirmaId);
            ps1.setString(2, sFilialId);
            log.debug((Object)("Executing: " + sSQLStatement));
            try {
                resultset = ps1.executeQuery();
                if (resultset.next()) {
                    res = true;
                }
            }
            finally {
                WebetkUtils.closeQuery(resultset);
            }
            return res;
        }
        boolean res = false;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_BESTELLLISTE_POSITIONEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sFilialId = StringUtils.maskiereHochkommaFuerDb(sFilialId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sFilialId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = null;
        ResultSet resultset = null;
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(sSQLStatement);
            if (resultset.next()) {
                res = true;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resultset);
            throw throwable;
        }
        WebetkUtils.closeQuery(resultset);
        sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_TEILELISTE_POSITIONEN();
        sFirmaId = StringUtils.maskiereHochkommaFuerDb(sFirmaId);
        sFilialId = StringUtils.maskiereHochkommaFuerDb(sFilialId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMAID", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALID", sFilialId);
        log.debug((Object)("Executing: " + sSQLStatement));
        try {
            stmt = con.createStatement();
            resultset = stmt.executeQuery(sSQLStatement);
            if (resultset.next()) {
                res = true;
            }
        }
        finally {
            WebetkUtils.closeQuery(resultset);
        }
        return res;
    }

    public static ResultSet getFilialeInfo(Connection con, String sFirmaId, String sFilialId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_INFO_FILIALE();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sFirmaId);
            ps.setString(2, sFilialId);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_INFO_FILIALE();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FILIALE", sFilialId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hatFirmaNurEineFiliale(Connection con, String sFirmaId) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_COUNT_FILIALEN_IN_FIRMA();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sFirmaId);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = null;
            int nCount = 0;
            try {
                res = ps.executeQuery();
                if (res.next()) {
                    nCount = res.getInt("countFiliale");
                }
            }
            finally {
                WebetkUtils.closeQuery(res);
            }
            return nCount == 1;
        }
        String sSQLStatement = SQLStatements.Firmenkonfiguration.instance.RETRIEVE_COUNT_FILIALEN_IN_FIRMA();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "FIRMA", sFirmaId);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = null;
        ResultSet res = null;
        int nCount = 0;
        try {
            stmt = con.createStatement();
            res = stmt.executeQuery(sSQLStatement);
            if (res.next()) {
                nCount = res.getInt("countFiliale");
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        return nCount == 1;
    }

    public static int getAnzahlLogins(Connection con, String sFirmaId, String sUserId) throws SQLException {
        String sSQLString = SQLStatements.LoginInfo.instance.LOAD_SINGLE_USER_LOGIN_INFO();
        PreparedStatement textPs = con.prepareStatement(sSQLString);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        ResultSet result = textPs.executeQuery();
        if (result.next()) {
            int temp = result.getInt("AnzahlLogins");
            result.close();
            return temp;
        }
        result.close();
        return 0;
    }

    public static void insertLoginInfo(Connection con, String sFirmaId, String sUserId) throws SQLException {
        String sSQLString = SQLStatements.LoginInfo.instance.INSERT_NEW_LOGIN_INFO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String sDate = sdf.format(new Date());
        long lDate = Long.parseLong(sDate);
        PreparedStatement textPs = con.prepareStatement(sSQLString);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.setLong(3, lDate);
        textPs.execute();
    }

    public static void updateLoginInfo(Connection con, String sFirmaId, String sUserId, boolean login) throws SQLException {
        String sSQLString = null;
        PreparedStatement textPs = null;
        if (login) {
            sSQLString = SQLStatements.LoginInfo.instance.UPDATE_LOGIN_INFO();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            String sDate = sdf.format(new Date());
            long lDate = Long.parseLong(sDate);
            textPs = con.prepareStatement(sSQLString);
            textPs.setBigDecimal(1, new BigDecimal(lDate));
            textPs.setString(2, sFirmaId);
            textPs.setString(3, sUserId);
        } else {
            sSQLString = SQLStatements.LoginInfo.instance.UPDATE_LOGIN_INFO_LOGOUT();
            textPs = con.prepareStatement(sSQLString);
            textPs.setString(1, sFirmaId);
            textPs.setString(2, sUserId);
        }
        textPs.execute();
    }

    public static List<User> getLoggedInUsers(Connection con, String sFirmaId, List<String> pUsersToIgnore) throws SQLException {
        String ignoreUser;
        String sSQLStatement = SQLStatements.LoginInfo.instance.GET_LOGGEDIN_USERS();
        if (pUsersToIgnore != null && !pUsersToIgnore.isEmpty()) {
            StringBuilder sb = new StringBuilder("'");
            sb.append(pUsersToIgnore.get(0));
            sb.append("'");
            for (int ii = 1; ii < pUsersToIgnore.size(); ++ii) {
                sb.append(", '");
                sb.append(pUsersToIgnore.get(ii));
                sb.append("'");
            }
            ignoreUser = sb.toString();
        } else {
            ignoreUser = "NULL";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "IGNORE_USER", ignoreUser);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        ResultSet result = textPs.executeQuery();
        ArrayList<User> users = new ArrayList<User>();
        while (result.next()) {
            Date lastLogin = null;
            try {
                lastLogin = sdf.parse(result.getString("LastLogin"));
            }
            catch (ParseException e) {
                log.debug((Object)"lastLogin ist kein Datum", (Throwable)e);
            }
            users.add(new User(false, result.getString("UserId"), result.getString("UserName"), lastLogin, result.getInt("AnzahlLogins"), result.getString("DefaultFiliale")));
        }
        return users;
    }

    public static List<User> getInactiveUsers(Connection con, String sFirmaId, List<String> pUserIdsToIgnore, long lDateSince) throws SQLException {
        String ignoreUser;
        String sSQLStatement = SQLStatements.LoginInfo.instance.GET_INACTIVE_USERS();
        if (pUserIdsToIgnore != null && !pUserIdsToIgnore.isEmpty()) {
            StringBuilder sb = new StringBuilder("'");
            sb.append(pUserIdsToIgnore.get(0));
            sb.append("'");
            for (int ii = 1; ii < pUserIdsToIgnore.size(); ++ii) {
                sb.append(", '");
                sb.append(pUserIdsToIgnore.get(ii));
                sb.append("'");
            }
            ignoreUser = sb.toString();
        } else {
            ignoreUser = "NULL";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "IGNORE_USER", ignoreUser);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setLong(2, lDateSince);
        ResultSet result = textPs.executeQuery();
        ArrayList<User> users = new ArrayList<User>();
        while (result.next()) {
            Date lastLogin = null;
            try {
                lastLogin = sdf.parse(result.getString("LastLogin"));
            }
            catch (ParseException e) {
                log.debug((Object)"lastLogin ist kein Datum", (Throwable)e);
            }
            catch (NullPointerException e) {
                log.debug((Object)"lastLogin ist nicht gesetzt", (Throwable)e);
            }
            users.add(new User(false, result.getString("UserId"), result.getString("UserName"), lastLogin, result.getInt("AnzahlLogins"), result.getString("DefaultFiliale")));
        }
        return users;
    }

    public static List<String> loadTableConfiguration(Connection con, String sFirmaId, String sUserId, String sTabelle, String sZusatz) throws SQLException {
        String sSQLStatement = SQLStatements.TabellenKonfiguration.instance.LOAD_KONFIG();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.setString(3, sTabelle);
        if (sZusatz != null) {
            textPs.setString(4, sZusatz);
        } else {
            textPs.setNull(4, 12);
        }
        ResultSet result = textPs.executeQuery();
        ArrayList<String> list = new ArrayList<String>();
        int column = 0;
        while (result.next()) {
            if (result.getInt("Spalte") != column) {
                log.warn((Object)("Fehler in der Spaltenindizierung in " + sTabelle + " " + (sZusatz == null ? "" : " " + sZusatz)));
            }
            list.add(result.getString("Name"));
            ++column;
        }
        return list;
    }

    public static void deleteTableConfiguration(Connection con, String sFirmaId, String sUserId, String sTabelle, String sZusatz) throws SQLException {
        String sSQLStatement = SQLStatements.TabellenKonfiguration.instance.DELETE_KONFIG();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.setString(3, sTabelle);
        if (sZusatz != null) {
            textPs.setString(4, sZusatz);
        } else {
            textPs.setNull(4, 12);
        }
        textPs.executeUpdate();
    }

    public static void insertTableConfiguration(Connection con, ArrayList<String> tableConfig, String sFirmaId, String sUserId, String sTabelle, String sZusatz) throws SQLException {
        String sSQLStatement = SQLStatements.TabellenKonfiguration.instance.INSERT_SPALTE();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.setString(3, sTabelle);
        if (sZusatz != null) {
            textPs.setString(4, sZusatz);
        } else {
            textPs.setNull(4, 12);
        }
        for (int columnIndex = 0; columnIndex < tableConfig.size(); ++columnIndex) {
            String columnName = tableConfig.get(columnIndex);
            textPs.setString(5, columnName);
            textPs.setInt(6, columnIndex);
            textPs.executeUpdate();
        }
    }

    public static List loadAbsenderUndEmpfaenger(Connection con, String sFirmaId, String sUserId) throws SQLException {
        String sSQLStatement = SQLStatements.MailOptions.instance.LOAD_ABSENDER_UND_EMPFAENGER();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        ResultSet result = textPs.executeQuery();
        ArrayList<String[]> options = new ArrayList<String[]>();
        while (result.next()) {
            String[] element = new String[]{result.getString("Kriterium"), result.getString("Wert")};
            options.add(element);
        }
        return options;
    }

    public static void deleteAbsender(Connection con, String sFirmaId, String sUserId) throws SQLException {
        String sSQLStatement = SQLStatements.MailOptions.instance.DELETE_ABSENDER();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.executeUpdate();
    }

    public static void insertAbsender(Connection con, String sFirmaId, String sUserId, String sEmailAbsender, String sNameAbsender) throws SQLException {
        String sSQLStatement = SQLStatements.MailOptions.instance.INSERT_ABSENDER();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.setString(4, sFirmaId);
        textPs.setString(5, sUserId);
        textPs.setString(3, sEmailAbsender);
        textPs.setString(6, sNameAbsender);
        textPs.executeUpdate();
    }

    public static void deleteEmpfaenger(Connection con, String sFirmaId, String sUserId) throws SQLException {
        String sSQLStatement = SQLStatements.MailOptions.instance.DELETE_EMPAENGER();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.executeUpdate();
    }

    public static void insertEmpfaenger(Connection con, String sFirmaId, String sUserId, String sEmailEmpfaenger) throws SQLException {
        String sSQLStatement = SQLStatements.MailOptions.instance.INSERT_EMPFAENGER();
        PreparedStatement textPs = con.prepareStatement(sSQLStatement);
        textPs.setString(1, sFirmaId);
        textPs.setString(2, sUserId);
        textPs.setString(3, sEmailEmpfaenger);
        textPs.executeUpdate();
    }
}

