/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.psi.client;

import com.bmw.tetis.eba.psi.AppEntry;
import com.bmw.tetis.eba.psi.PsiException;
import com.bmw.tetis.eba.psi.PsiParser;
import com.bmw.tetis.eba.psi.PsiUser;
import com.bmw.tetis.psi.client.ClientAppEntry;
import com.bmw.tetis.psi.client.IAppEntry;
import com.bmw.tetis.psi.client.IAppEntryListener;
import com.bmw.tetis.psi.client.IClientPsi;
import com.bmw.tetis.psi.common.ConsoleLogger;
import com.bmw.tetis.psi.common.ETKBindAssistant;
import com.bmw.tetis.psi.common.IPsiApplet;
import com.bmw.tetis.psi.common.IPsiApplication;
import com.bmw.tetis.psi.common.IPsiBusyController;
import com.bmw.tetis.psi.common.LookupService;
import com.bmw.tetis.psi.common.PsiCommunicationException;
import com.bmw.tetis.psi.common.RmiBindAssistant;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ClientPsi
extends UnicastRemoteObject
implements IClientPsi,
IPsiApplication {
    private Map appListener = new HashMap();
    private String psiInfo;
    private PsiParser psiParser;
    private LookupService lookup;
    private IPsiBusyController busyController;
    private RmiBindAssistant bindAssistant;
    private ConsoleLogger logger = new ConsoleLogger("ETK CLIENT");

    public ClientPsi(Properties properties, IPsiBusyController iPsiBusyController) throws PsiCommunicationException, RemoteException {
        this.busyController = iPsiBusyController;
        if (this.bindAssistant == null) {
            this.bindAssistant = new ETKBindAssistant(properties, this.logger);
        }
        this.init();
    }

    protected void init() throws PsiCommunicationException, RemoteException {
        this.bindAssistant.bindObject(this);
    }

    public void addAppEntryListener(String string, IAppEntryListener iAppEntryListener) {
        this.appListener.put(string, iAppEntryListener);
    }

    public String getPsiInfo(String string) throws PsiCommunicationException {
        try {
            this.psiInfo = this.getLookup().isRemoteAvailable() ? this.getApplet().getPsiInfo() : string;
        }
        catch (Exception exception) {
            this.logger.log(1, "PSI could not be requested from the Applet - use old value. " + exception.getMessage());
            this.psiInfo = string;
        }
        try {
            this.psiParser = new PsiParser(this.psiInfo);
            this.psiParser.setAppName("ETKApplet");
            this.psiParser.setPsiCallUrl("dummy");
            this.psiParser.parse();
        }
        catch (PsiException psiException) {
            throw new PsiCommunicationException((Exception)((Object)psiException));
        }
        return this.psiInfo;
    }

    public PsiUser getUser() throws PsiCommunicationException {
        return this.psiParser.getUser();
    }

    public List getAppEntries(String string) {
        AppEntry[] appEntryArray = this.psiParser.getAppEntries(string);
        ArrayList<ClientAppEntry> arrayList = new ArrayList<ClientAppEntry>();
        for (int i = 0; i < appEntryArray.length; ++i) {
            ClientAppEntry clientAppEntry = new ClientAppEntry(this);
            clientAppEntry.setEntryName(appEntryArray[i].getEntryName());
            clientAppEntry.setLinkName(appEntryArray[i].getLinkName());
            arrayList.add(clientAppEntry);
        }
        return arrayList;
    }

    public IAppEntry getHomeEntry() {
        ClientAppEntry clientAppEntry = new ClientAppEntry(this);
        clientAppEntry.setEntryName("HOME");
        clientAppEntry.setLinkName("HOME");
        return clientAppEntry;
    }

    public void invoke(Map map) throws RemoteException, PsiCommunicationException {
        IAppEntryListener iAppEntryListener;
        String string = (String)map.get("entryName");
        if (string != null) {
            iAppEntryListener = (IAppEntryListener)this.appListener.get(string);
            if (iAppEntryListener == null) {
                throw new PsiCommunicationException("Listener for EntryName \"" + string + "\" could not be found");
            }
        } else {
            throw new PsiCommunicationException("Parameter for entryName was not set");
        }
        iAppEntryListener.invoke(map);
    }

    IPsiApplet getApplet() throws PsiCommunicationException {
        if (this.busyController != null) {
            return (IPsiApplet)this.getLookup().getRemote(this.busyController);
        }
        throw new PsiCommunicationException("PsiBusyController not set");
    }

    private LookupService getLookup() {
        if (this.lookup == null) {
            int n = -1;
            String string = this.bindAssistant.getAppStartUrl();
            if (this.bindAssistant.isPortPoolUsed()) {
                string = string + "&clientPsiPort=" + this.bindAssistant.getBindPort();
            } else {
                n = this.bindAssistant.getPartnerBindPort();
            }
            this.lookup = new LookupService(n, "cmd /c start iexplore \"" + string + "\"", "psiApplet");
            this.lookup.setRemoteApp("Applet");
            this.lookup.setLogger(this.logger);
        }
        return this.lookup;
    }

    public String getPsessId() throws PsiCommunicationException {
        if (this.getLookup().isRemoteAvailable()) {
            try {
                return this.getApplet().getPsessId();
            }
            catch (RemoteException remoteException) {
                throw new PsiCommunicationException(remoteException);
            }
        }
        return null;
    }

    public void handshake(int n) throws RemoteException, PsiCommunicationException {
        this.bindAssistant.setPartnerBindPort(n);
        this.lookup.setPort(n);
    }

    public String getPortInfo() {
        return "Client PSI Port: " + this.bindAssistant.getBindPort() + " <<>> " + "ASAP-Applet Port:" + this.bindAssistant.getPartnerBindPort();
    }
}

