/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.adapter;

import com.bmw.gki.adapter.ccmessages.CCDataLogic;
import com.bmw.gki.ka.exception.GKIException;
import com.bmw.gki.ka.exception.PreProductionAccessException;
import com.bmw.gki.ka.util.PreProdHolder;
import com.bmw.gki.ka.util.PreProdLogEntry;
import com.bmw.gki.klib.api.BSIBerechnungsbasis;
import com.bmw.gki.klib.api.SchluesselVariante;
import com.bmw.gki.klib.api.exception.KSDAccessException;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.klib.api.exception.NoSIPackageException;
import com.bmw.gki.klib.api.exception.SystemException;
import com.bmw.gki.klib.api.exception.VinNotFoundException;
import com.bmw.gki.klib.api.exception.WrongVinFormatException;
import com.bmw.gki.klib.config.GKISettings;
import com.bmw.gki.klib.data.apitransformation.SIDataMapper;
import com.bmw.gki.klib.data.ksd.ExtAttribute;
import com.bmw.gki.klib.data.ksd.FgnrKreisInfo;
import com.bmw.gki.klib.data.ksd.battery.BatteryData;
import com.bmw.gki.klib.data.ksd.bsi.BSIDatensatzfehlerhaftException;
import com.bmw.gki.klib.data.ksd.bsi.BSIServicePaket;
import com.bmw.gki.klib.data.ksd.cbs.BOSAWNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSNummer;
import com.bmw.gki.klib.data.ksd.cbs.BOSVerknuepfung;
import com.bmw.gki.klib.data.ksd.cbs.BOSVorziehwert;
import com.bmw.gki.klib.data.ksd.cc.CCMessage;
import com.bmw.gki.klib.data.ksd.cc.CheckControlRetrievalException;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelData;
import com.bmw.gki.klib.data.ksd.ilevel.ILevelKeyData;
import com.bmw.gki.klib.data.ksd.key.FgnrPraefix;
import com.bmw.gki.klib.data.ksd.navi.NaviDVDData;
import com.bmw.gki.klib.external.KSDDataRetrieverIF;
import com.bmw.gki.klib.external.SIContractDataIF;
import com.bmw.gki.klib.external.cache.BOSAWNummerReader;
import com.bmw.gki.klib.external.cache.BOSNummerReader;
import com.bmw.gki.klib.external.cache.BOSVerknuepfungReader;
import com.bmw.gki.klib.external.cache.BOSVorziehwertReader;
import com.bmw.gki.klib.external.cache.BatteryReader;
import com.bmw.gki.klib.external.cache.CCMessageReader;
import com.bmw.gki.klib.external.cache.ExtendedAttributeTranslator;
import com.bmw.gki.klib.external.cache.FgnrPraefixReader;
import com.bmw.gki.klib.external.cache.ILevelReader;
import com.bmw.gki.klib.external.cache.KSDCache;
import com.bmw.gki.klib.external.cache.LeadTypeReader;
import com.bmw.gki.klib.external.cache.NaviDVDReader;
import com.bmw.gki.klib.external.cache.RegionReader;
import com.bmw.gki.klib.external.cache.SchluesselFilterReader;
import com.bmw.gki.klib.external.cache.SchluesselVarianteReader;
import com.bmw.gki.klib.external.cache.ServicePaketKSD;
import com.bmw.gki.klib.logic.LeittypBaustandException;
import com.starag.ksd.api.ServicesKSD;
import com.starag.ksd.data.SIContractData;
import com.starag.ksd.data.VehicleBaseDataKSD;
import com.starag.ksd.exception.KSDDataInvalidException;
import com.starag.ksd.exception.KSDFileInvalidException;
import com.starag.ksd.exception.KSDFileNotFoundException;
import com.starag.ksd.exception.LanguageInvalidException;
import com.starag.ksd.exception.NoSIContractException;
import com.starag.ksd.exception.RecordNotFoundException;
import com.starag.ksd.exception.VINInvalidException;
import com.starag.ksd.exception.VINNotFoundException;
import com.starag.ksd.exception.ValueInvalidException;
import java.io.FileNotFoundException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sql.DataSource;

public class KSDDataRetriever
implements KSDDataRetrieverIF {
    private GKISettings settings;
    private String dataPathCC = null;
    private static final SimpleDateFormat dateFormatterDE;
    private static final SimpleDateFormat dateFormatterISO;

    public KSDDataRetriever(GKISettings settings) {
        this.settings = settings;
    }

    public static String replaceCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos + 1);
    }

    private String checkAndReplaceVinForLeadType(String vin) {
        String replacedVin = vin;
        if (vin != null && vin.length() >= 7) {
            char char7 = vin.charAt(6);
            switch (char7) {
                case 'C': {
                    replacedVin = KSDDataRetriever.replaceCharAt(replacedVin, 6, '3');
                    break;
                }
                case 'G': {
                    replacedVin = KSDDataRetriever.replaceCharAt(replacedVin, 6, '7');
                    break;
                }
                case 'A': {
                    replacedVin = KSDDataRetriever.replaceCharAt(replacedVin, 6, '1');
                    break;
                }
                case 'E': {
                    replacedVin = KSDDataRetriever.replaceCharAt(replacedVin, 6, '5');
                }
            }
        }
        return replacedVin;
    }

    public KSDDataRetriever() {
    }

    private static void printClassLocation(Class<?> clazz) {
        try {
            CodeSource codeSource;
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                URL location = codeSource.getLocation();
                System.out.println("********************************************************************************************\nLocation (Adapter) of " + clazz + " -> " + location + "\n********************************************************************************************");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSettings(GKISettings settings) {
        this.settings = settings;
    }

    public ExtAttribute retrieveExtendedAttribute(Locale locale, String name, String value) throws GKIException {
        String displayValue;
        ExtendedAttributeTranslator trans = new ExtendedAttributeTranslator(locale);
        ExtAttribute extendedAttribute = new ExtAttribute();
        extendedAttribute.setName(name);
        extendedAttribute.setValue(value);
        String displayName = trans.findDisplayValue(name);
        if (displayName != null) {
            extendedAttribute.setDisplayName(displayName);
        }
        if ((displayValue = trans.findDisplayValue(name + "." + value)) == null) {
            displayValue = trans.findDisplayValue(value);
        }
        if (displayValue != null) {
            extendedAttribute.setDisplayValue(displayValue);
        }
        return extendedAttribute;
    }

    public List<BSIServicePaket> retrieveServicePackage(String fgnr, Locale locale, float totalDistance) throws GKIException {
        if (fgnr != null && fgnr.length() >= 7) {
            fgnr = fgnr.substring(fgnr.length() - 7, fgnr.length());
            Vector sb = null;
            try {
                sb = ServicesKSD.retrieveSIContractData((String)fgnr, (Locale)locale, (float)totalDistance);
            }
            catch (KSDDataInvalidException e) {
                String message = "KSD returns a KSDDataInvalidException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (VINInvalidException e) {
                String message = "KSD returns a VINInvalidException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (NoSIContractException e) {
                String message = "KSD returns a NoSIContractException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (LanguageInvalidException e) {
                String message = "KSD returns a LanguageInvalidException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (KSDFileNotFoundException e) {
                String message = "KSD returns a KSDFileNotFoundException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (KSDFileInvalidException e) {
                String message = "KSD returns a KSDFileInvalidException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (RecordNotFoundException e) {
                String message = "KSD returns a RecordNotFoundException ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            catch (Exception e) {
                String message = "KSD returns a Exception ";
                throw new NoSIPackageException(message, (Throwable)e);
            }
            boolean isSSISACode = true;
            ArrayList<BSIServicePaket> sbtList = new ArrayList<BSIServicePaket>();
            for (SIContractData siContractData : sb) {
                BSIServicePaket res;
                try {
                    siContractData.getOptEquipmentCode();
                }
                catch (NoSuchMethodError e) {
                    isSSISACode = false;
                }
                if ((res = this.mapToServicePackageType(siContractData, locale.getLanguage(), isSSISACode)) == null) continue;
                sbtList.add(res);
            }
            return sbtList;
        }
        return null;
    }

    private BSIServicePaket mapToServicePackageType(SIContractData ksdData, String language, boolean isSSISACodeSupported) {
        if (ksdData == null) {
            return null;
        }
        try {
            return SIDataMapper.createBSIServicePackage((SIContractDataIF)new SIContractDataAdapter(ksdData), (String)language, (boolean)isSSISACodeSupported);
        }
        catch (NoSuchMethodError nsme) {
            return this.mapToServicePackageType(ksdData, language);
        }
    }

    private BSIServicePaket mapToServicePackageType(SIContractData ksdData, String language) {
        if (ksdData == null) {
            return null;
        }
        try {
            return SIDataMapper.createBSIServicePackage((SIContractDataIF)new SIContractDataAdapter(ksdData), (String)language);
        }
        catch (NoSuchMethodError nsme) {
            return this.mapToOldServicePackageType(ksdData, language);
        }
    }

    public BSIServicePaket mapToOldServicePackageType(SIContractData ksdData, String language) {
        if (ksdData == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        BSIServicePaket bsip = new BSIServicePaket(ksdData.getContractType(), new Integer(ksdData.getDuration()), new Integer((int)ksdData.getDistanceKM()), this.parseDate(formatter.format(ksdData.getStartDate())), this.parseDate(formatter.format(ksdData.getEndDate())), ksdData.getSiDescription(), ksdData.getHerkunftKZ(), ksdData.getVertragsArt());
        return bsip;
    }

    private Date parseDate(String dateString) {
        Date result = null;
        try {
            result = dateFormatterDE.parse(dateString);
        }
        catch (ParseException e) {
            try {
                result = dateFormatterISO.parse(dateString);
            }
            catch (ParseException e2) {
                throw new SystemException("dateformat.invalid", e, new String[]{dateString});
            }
        }
        return result;
    }

    public BOSVorziehwert findCBSAdvancedValues(BOSNummer bosNr, String regionCode) throws GKIException {
        return BOSVorziehwertReader.find((String)regionCode, (BOSNummer)bosNr);
    }

    public Map<String, CCMessage> retrieveCheckControlMessages(String pESeries, Locale pLocale, Set<?> pCCIds) throws CheckControlRetrievalException {
        Map<String, CCMessage> ccMap = this.retrieveCheckControlMessages(pESeries, pLocale, pCCIds, true);
        return ccMap;
    }

    private Map<String, CCMessage> retrieveCheckControlMessages(String pESeries, Locale pLocale, Set<?> pCCIds, boolean retry) throws CheckControlRetrievalException {
        CCDataLogic.getInstance().setCCPath(this.dataPathCC);
        Map<String, CCMessage> result = null;
        try {
            String mappedPESeries;
            if (pESeries == null) {
                pESeries = new String("(empty)");
            }
            result = CCDataLogic.retrieveCCData(pESeries.trim(), pLocale, pCCIds);
            if (retry && (result == null || result.isEmpty()) && KSDCache.getInstance().isPreProduction() && (mappedPESeries = CCMessageReader.find(pESeries)) != null) {
                return this.retrieveCheckControlMessages(mappedPESeries, pLocale, pCCIds, false);
            }
        }
        catch (FileNotFoundException e) {
            String message = "File not found: " + e.getMessage();
            throw new CheckControlRetrievalException(message, (Throwable)e);
        }
        catch (KSDDataException e) {
            throw new CheckControlRetrievalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static boolean isNullOrEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    private FgnrKreisInfo getLeadType(String fgnr) throws VINNotFoundException, VINInvalidException, KSDFileNotFoundException, KSDFileInvalidException, RecordNotFoundException, ValueInvalidException, LeittypBaustandException {
        FgnrKreisInfo info = null;
        try {
            VehicleBaseDataKSD data = ServicesKSD.retrieveVehicleBaseDataKSD((String)fgnr);
            info = new FgnrKreisInfo();
            info.setBaustand(Integer.parseInt(data.getBuildDate()));
            if (data.getEngineeringSeries() != null) {
                info.setEngineeringSeries(data.getEngineeringSeries().trim());
            }
            info.setLeittyp(data.getLeadType());
            info.setLeittypEingabeArt(0);
            info.setTypschluessel(data.getModelCode());
            info.setTypschluesselEingabeArt(0);
            if (data.getModelDesignation() != null) {
                info.setModelBezeichnung(data.getModelDesignation().trim());
            }
            if (info != null && KSDDataRetriever.isNullOrEmptyString(info.getEngineeringSeries()) && KSDDataRetriever.isNullOrEmptyString(info.getModelBezeichnung())) {
                System.out.println("**************************************************************");
                System.out.println("getLeadType: EngineeringSeries and  ModelDesignation are empty");
                System.out.println("**************************************************************");
                if (KSDCache.getInstance().isPreProduction()) {
                    System.out.println("**************************************************************");
                    System.out.println("getLeadType: KSDCache.getInstance().isPreProduction() =true   ");
                    System.out.println("**************************************************************");
                    throw new LeittypBaustandException("leadtype not found for:  " + fgnr);
                }
            }
        }
        catch (VINInvalidException e) {
            System.out.println("**************************************************************");
            System.out.println("getLeadType: " + ((Object)((Object)e)).getClass().getName());
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw e;
        }
        catch (KSDFileNotFoundException e) {
            System.out.println("**************************************************************");
            System.out.println("getLeadType: " + ((Object)((Object)e)).getClass().getName());
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw e;
        }
        catch (KSDFileInvalidException e) {
            System.out.println("**************************************************************");
            System.out.println("getLeadType: " + ((Object)((Object)e)).getClass().getName());
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw e;
        }
        catch (RecordNotFoundException e) {
            System.out.println("**************************************************************");
            System.out.println("getLeadType: " + ((Object)((Object)e)).getClass().getName());
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw e;
        }
        catch (ValueInvalidException e) {
            System.out.println("**************************************************************");
            System.out.println("getLeadType: " + ((Object)((Object)e)).getClass().getName());
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw e;
        }
        return info;
    }

    public FgnrKreisInfo retrieveLeadtypeBuilddate(String fgnr) throws GKIException {
        FgnrKreisInfo info = null;
        try {
            info = this.getLeadType(fgnr);
            return info;
        }
        catch (KSDFileNotFoundException e) {
            System.out.println("**************************************************************");
            System.out.println("KSDAdapter: KSDFileNotFoundException: ");
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw new KSDAccessException("ksd file not found", (Throwable)e);
        }
        catch (KSDFileInvalidException e) {
            System.out.println("**************************************************************");
            System.out.println("KSDAccessException: KSDFileInvalidException: ");
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw new KSDAccessException("ksd file invalid", (Throwable)e);
        }
        catch (VINNotFoundException e) {
            throw new VinNotFoundException("vin not found " + fgnr, (Throwable)e);
        }
        catch (VINInvalidException e) {
            System.out.println("**************************************************************");
            System.out.println("KSDAdapter: VINInvalidException: ");
            e.printStackTrace();
            System.out.println("**************************************************************");
            throw new WrongVinFormatException("vin is invalid " + fgnr, (Throwable)e);
        }
        catch (Exception e) {
            try {
                String replacedVin = this.checkAndReplaceVinForLeadType(fgnr);
                if (!replacedVin.equals(fgnr)) {
                    System.out.println("**************************************************************");
                    System.out.println("KSDAdapter: requested VIN: " + fgnr + " replaced Vin: " + replacedVin);
                    System.out.println("**************************************************************");
                    info = this.getLeadType(replacedVin);
                    return info;
                }
                throw e;
            }
            catch (Exception exRep) {
                if (KSDCache.getInstance().isPreProduction()) {
                    String message = "Lead type not found vin: " + fgnr + " please define mapping for type " + KSDDataRetriever.getTyp(fgnr) + " (leadttype.properties)";
                    try {
                        String replacedVin = this.checkAndReplaceVinForLeadType(fgnr);
                        if (!replacedVin.equals(fgnr)) {
                            System.out.println("**************************************************************");
                            System.out.println("KSDAdapter: PreProduction requested VIN: " + fgnr + " replaced Vin: " + replacedVin);
                            System.out.println("**************************************************************");
                            message = message + " -- replaced VIN: " + replacedVin;
                            info = LeadTypeReader.getFgnrKreisInfo(replacedVin);
                            return info;
                        }
                        info = LeadTypeReader.getFgnrKreisInfo(fgnr);
                        return info;
                    }
                    catch (PreProductionAccessException exP) {
                        PreProdHolder.addLogEntry(new PreProdLogEntry("ERROR", "CODE_LEAD_TYPE_NOT_FOUND", message));
                        throw new LeittypBaustandException("leadtype not found for:  " + fgnr, (Throwable)((Object)exP));
                    }
                }
                System.out.println("**************************************************************");
                System.out.println("KSDAdapter: " + exRep.getClass().getName() + ":");
                e.printStackTrace();
                System.out.println("**************************************************************");
                throw new LeittypBaustandException("leadtype not found for:  " + fgnr, (Throwable)e);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                throw new LeittypBaustandException("leadtype not found for:  " + fgnr, (Throwable)e);
            }
        }
    }

    public BOSAWNummer findCBSFlatRateNumber(String leadtype, BOSNummer cbsNumber, int builddate) throws GKIException {
        return BOSAWNummerReader.find((String)leadtype, (BOSNummer)cbsNumber, (int)builddate);
    }

    public boolean existsCBSFlatRateNumber(String leadtype, int builddate) {
        return BOSAWNummerReader.exists((String)leadtype, (int)builddate);
    }

    public BOSNummer findCBSNumber(int cbsNumber) throws GKIException {
        return BOSNummerReader.find((int)cbsNumber);
    }

    public BOSAWNummer findCBSFaltRateNumber(String leadtype, String flatrate, int builddate) throws GKIException {
        return BOSAWNummerReader.find((String)leadtype, (String)flatrate, (int)builddate);
    }

    public BOSNummer findCBSNumberOnCBSFaltRateNumber(String leadtype, String flatrate, int builddate) throws GKIException {
        return BOSAWNummerReader.find((String)leadtype, (String)flatrate, (int)builddate).getBosNr();
    }

    public Vector<BOSVerknuepfung> findCBSConnected(String region, String leadtype, BOSNummer cbsNumber, int builddate) {
        return BOSVerknuepfungReader.find((String)region, (String)leadtype, (BOSNummer)cbsNumber, (int)builddate);
    }

    public String findRegion(Locale locale) {
        return RegionReader.find((Locale)locale);
    }

    public String[] retrieveAllRegions(Locale locale) {
        return RegionReader.getRegions();
    }

    public FgnrPraefix findVinPrefix(int id) throws GKIException {
        return FgnrPraefixReader.find((String)("" + id));
    }

    public SchluesselVariante filterKeyVariant(SchluesselVariante kv, int builddate) {
        return SchluesselFilterReader.filter((SchluesselVariante)kv, (int)builddate);
    }

    public SchluesselVariante findKeyVariant(int id) {
        return SchluesselVarianteReader.find((int)id);
    }

    public byte[] mapToKeyReaderFormat(byte[] serviceCall) {
        return null;
    }

    public ILevelData retrieveILevel(ILevelKeyData codes, String eserie) throws KSDDataException {
        if (codes != null && eserie != null) {
            return ILevelReader.getInstance().find(codes, eserie);
        }
        return null;
    }

    public NaviDVDData retrieveNaviDVD(Integer code) {
        return NaviDVDReader.getInstance().find(code);
    }

    public NaviDVDData retrieveNaviDVD(String brand, Integer code) {
        return NaviDVDReader.getInstance().find(brand, code);
    }

    public String retrieveBattery(BatteryData codes, Locale locale) throws KSDDataException {
        return BatteryReader.getInstance().find(codes, locale);
    }

    public BSIBerechnungsbasis retrieveSICalculation(String vertragstyp) throws BSIDatensatzfehlerhaftException {
        return new ServicePaketKSD().ermittelnBerechnungsbasis(vertragstyp);
    }

    public BSIBerechnungsbasis retrieveCalculationBase(String vertragstyp) throws BSIDatensatzfehlerhaftException {
        return this.retrieveSICalculation(vertragstyp);
    }

    public Vector<SIContractDataAdapter> retrieveSIContractData(String vin, Locale locale, float totalDistance) throws GKIException {
        try {
            Vector tmpContracts = ServicesKSD.retrieveSIContractData((String)vin, (Locale)locale, (float)totalDistance);
            Vector<SIContractDataAdapter> retVals = new Vector<SIContractDataAdapter>();
            for (SIContractData element : tmpContracts) {
                retVals.add(new SIContractDataAdapter(element));
            }
            return retVals;
        }
        catch (Exception e) {
            throw new GKIException("ServicesKSD.retrieveSIContractData", (Throwable)e);
        }
    }

    private static String getTyp(String fgnr) {
        String typ = "";
        if (fgnr != null && fgnr.length() >= 7) {
            typ = fgnr.substring(3, 7);
        }
        return typ;
    }

    public void setKSDDataSource(DataSource dataSource) {
        try {
            ServicesKSD.setDataSource((DataSource)dataSource);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setKSDPath(String path) {
        ServicesKSD.setKsdCdPath((String)path);
        this.dataPathCC = path + "/SAM/CC";
    }

    public String[] findSupportedRegionVariants(int id) {
        return null;
    }

    public BOSAWNummer findCBSFaltRate() {
        return null;
    }

    static {
        KSDDataRetriever.printClassLocation(KSDDataRetriever.class);
        dateFormatterDE = new SimpleDateFormat("dd.MM.yyyy");
        dateFormatterISO = new SimpleDateFormat("yyyy-MM-dd");
    }

    private static class SIContractDataAdapter
    implements SIContractDataIF {
        private SIContractData contractData;

        public SIContractDataAdapter(SIContractData contractData) {
            this.contractData = contractData;
        }

        public String getContractType() {
            return this.contractData.getContractType();
        }

        public long getDistanceKM() {
            return this.contractData.getDistanceKM();
        }

        public int getDuration() {
            return this.contractData.getDuration();
        }

        public Date getEndDate() {
            return this.contractData.getEndDate();
        }

        public String getHerkunftKZ() {
            return this.contractData.getHerkunftKZ();
        }

        public String getSiDescription() {
            return this.contractData.getSiDescription();
        }

        public Date getStartDate() {
            return this.contractData.getStartDate();
        }

        public String getVertragsArt() {
            return this.contractData.getVertragsArt();
        }

        public Date getCashUpStartDate() {
            return this.contractData.getCashUpStartDate();
        }

        public long getEndKm() {
            return this.contractData.getEndKM();
        }

        public long getStartKm() {
            return this.contractData.getStartKM();
        }

        public String getSAOptionCode() {
            String saCode = null;
            try {
                saCode = this.contractData.getOptEquipmentCode();
            }
            catch (Exception e) {
                System.out.println("getSAOptionCode throws exception: " + e.getMessage());
            }
            return saCode;
        }
    }
}

