/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.adapter.ccmessages;

import com.bmw.gki.adapter.ccmessages.PAKRawReader;
import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.logging.GKILogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CCDataReader {
    private static Log log = GKILogManager.getInstance().getLogger(CCDataReader.class);
    private Map<String, Hashtable<String, String>> mccDataCache = new HashMap<String, Hashtable<String, String>>();
    private String ccDataPath;

    public CCDataReader(String ccDataPath) {
        this.ccDataPath = ccDataPath;
    }

    private void readCCData(String fileName, Locale locale) throws FileNotFoundException, KSDDataException {
        RandomAccessFile mRaf;
        try {
            mRaf = new RandomAccessFile(fileName, "r");
        }
        catch (IOException e) {
            fileName = this.ccDataPath + "/CC.PROPERTIES";
            mRaf = new RandomAccessFile(fileName, "r");
        }
        try {
            PAKRawReader pakReader = new PAKRawReader(fileName);
            boolean isCompressed = pakReader.readPackFileCode(mRaf);
            if (isCompressed) {
                pakReader.readHeader(mRaf);
                byte[] buffer = pakReader.readPackFile(mRaf);
                Hashtable<String, String> mCCDataHashtable = pakReader.readBufferAsUnicodeTable(buffer);
                this.mccDataCache.put(locale.toString(), mCCDataHashtable);
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException(fileName);
        }
        catch (KSDDataException e) {
            throw new KSDDataException(fileName);
        }
        finally {
            if (mRaf != null) {
                try {
                    mRaf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private PropertyResourceBundle readCCDataAsProperty(String fileNameProperty) throws FileNotFoundException {
        PropertyResourceBundle propertyResourceBundle;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileNameProperty);
            propertyResourceBundle = new PropertyResourceBundle(fis);
        }
        catch (IOException e) {
            throw new FileNotFoundException(fileNameProperty);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return propertyResourceBundle;
    }

    private String correctFilename(Locale locale) {
        String fileName = this.ccDataPath + "/CC_" + locale.getLanguage().toUpperCase();
        if (locale == Locale.UK || locale == Locale.US || locale.getCountry() == "CN" || locale.getCountry() == "TW") {
            fileName = fileName + "_" + locale.getCountry().toUpperCase();
        }
        fileName = fileName + ".PROPERTIES";
        return fileName;
    }

    public String getCCData(String key, Locale locale) throws FileNotFoundException, KSDDataException {
        boolean isCompressed = true;
        boolean wasInCache = true;
        String sRet = "";
        String correctedFilename = this.correctFilename(locale);
        ResourceBundle propertyBundle = null;
        Hashtable<String, String> hashMCC = this.mccDataCache.get(locale.toString());
        if (hashMCC == null) {
            wasInCache = false;
            this.readCCData(correctedFilename, locale);
            hashMCC = this.mccDataCache.get(locale.toString());
            if (hashMCC == null) {
                propertyBundle = this.readCCDataAsProperty(correctedFilename);
                isCompressed = false;
            }
        }
        if (isCompressed) {
            try {
                sRet = hashMCC.get(key);
            }
            catch (NullPointerException e) {}
        } else {
            try {
                if (propertyBundle == null) {
                    return "<empty>";
                }
                sRet = propertyBundle.getString(key);
            }
            catch (NullPointerException e) {
            }
            catch (MissingResourceException e) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return sRet;
    }

    protected Map<String, Hashtable<String, String>> getDataCache() {
        return this.mccDataCache;
    }

    public static void main(String[] argc) {
        String lineSeparator = System.getProperty("line.separator");
        String delimeter = "\t";
        CCDataReader ccDataReader = new CCDataReader(argc[0]);
        String[] allLoc = new String[]{"de", "el", "en_gb", "en_us", "es", "fr", "hu", "it", "ja", "ko", "nl", "pl", "pt", "ru", "sv", "tr", "zh_cn", "zh_tw"};
        try {
            for (String sLocale : allLoc) {
                Locale locale = new Locale(sLocale);
                ccDataReader.readCCData(ccDataReader.correctFilename(locale), locale);
            }
            Map<String, Hashtable<String, String>> dataCache = ccDataReader.getDataCache();
            for (String sLocale : allLoc) {
                Hashtable<String, String> localeHashTable = dataCache.get(sLocale);
                File decryptedFile = new File(argc[0] + "\\CC_DECRYPTED_" + sLocale.toUpperCase() + ".properties");
                FileWriter fw = new FileWriter(decryptedFile);
                Set<String> keySet = localeHashTable.keySet();
                ArrayList<String> lSet = new ArrayList<String>(keySet);
                Collections.sort(lSet);
                for (String key : lSet) {
                    fw.write(key + delimeter + localeHashTable.get(key) + lineSeparator);
                }
                System.out.println("Written Locale " + sLocale + " to " + decryptedFile);
                fw.close();
            }
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
    }
}

