/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.gki.adapter.ccmessages;

import com.bmw.gki.klib.api.exception.KSDDataException;
import com.bmw.gki.klib.util.StringHelper;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PAKRawReader {
    private final int PAK_BLOCK_SIZE = 16384;
    private static final String PAKFILE_CODE = "PAK";
    private String mDefaultCharset = "ISO-8859-1";
    private long mBlockSize = 0L;
    private long mMaxPackSize = 0L;
    private long mOrgFileSize = 0L;
    private long mIndexCount = 0L;
    private long[] marrDataPos = null;
    private String fileName;

    PAKRawReader(String fileName) {
        this.fileName = fileName;
    }

    public boolean readPackFileCode(RandomAccessFile mRaf) throws IOException {
        boolean ret = false;
        byte[] packfileCode = new byte[3];
        mRaf.read(packfileCode);
        String sPackFileCode = new String(packfileCode, 0, 3);
        ret = sPackFileCode.equals(PAKFILE_CODE);
        return ret;
    }

    public boolean readHeader(RandomAccessFile mRaf) throws IOException {
        boolean ret = false;
        this.mBlockSize = mRaf.readUnsignedByte();
        this.mBlockSize |= (long)(mRaf.readUnsignedByte() << 8);
        this.mBlockSize |= (long)(mRaf.readUnsignedByte() << 16);
        this.mBlockSize |= (long)(mRaf.readUnsignedByte() << 24);
        this.mMaxPackSize = mRaf.readUnsignedByte();
        this.mMaxPackSize |= (long)(mRaf.readUnsignedByte() << 8);
        this.mMaxPackSize |= (long)(mRaf.readUnsignedByte() << 16);
        this.mMaxPackSize |= (long)(mRaf.readUnsignedByte() << 24);
        this.mOrgFileSize = mRaf.readUnsignedByte();
        this.mOrgFileSize |= (long)(mRaf.readUnsignedByte() << 8);
        this.mOrgFileSize |= (long)(mRaf.readUnsignedByte() << 16);
        this.mOrgFileSize |= (long)(mRaf.readUnsignedByte() << 24);
        this.mIndexCount = mRaf.readUnsignedByte();
        this.mIndexCount |= (long)(mRaf.readUnsignedByte() << 8);
        this.mIndexCount |= (long)(mRaf.readUnsignedByte() << 16);
        this.mIndexCount |= (long)(mRaf.readUnsignedByte() << 24);
        this.marrDataPos = new long[(int)this.mIndexCount];
        int i = 0;
        while ((long)i < this.mIndexCount) {
            this.marrDataPos[i] = mRaf.readUnsignedByte();
            int n = i;
            this.marrDataPos[n] = this.marrDataPos[n] | (long)(mRaf.readUnsignedByte() << 8);
            int n2 = i;
            this.marrDataPos[n2] = this.marrDataPos[n2] | (long)(mRaf.readUnsignedByte() << 16);
            int n3 = i++;
            this.marrDataPos[n3] = this.marrDataPos[n3] | (long)(mRaf.readUnsignedByte() << 24);
        }
        ret = true;
        return ret;
    }

    public byte[] readPackFile(RandomAccessFile mRaf) throws IOException, KSDDataException {
        byte[] buffer = null;
        try {
            byte[] dataBlock = new byte[16384];
            byte[] decompData = null;
            byte[] fourByteData = new byte[4];
            int dataBlockLen = 16384;
            int destLength = 16384;
            int numberOfBytes = 0;
            long fpOffset = 0L;
            if (this.mOrgFileSize == 0L) {
                throw new KSDDataException(this.fileName);
            }
            buffer = new byte[(int)this.mOrgFileSize];
            for (int i = 0; i < this.marrDataPos.length; ++i) {
                dataBlockLen = i + 1 < this.marrDataPos.length ? (int)(this.marrDataPos[i + 1] - this.marrDataPos[i]) - 4 : 16384;
                mRaf.seek(this.marrDataPos[i]);
                mRaf.read(fourByteData);
                numberOfBytes = mRaf.read(dataBlock, 0, dataBlockLen);
                if (numberOfBytes <= 0) continue;
                decompData = new byte[destLength];
                Inflater decompresser = new Inflater();
                decompresser.setInput(dataBlock, 0, numberOfBytes);
                int resultLength = decompresser.inflate(decompData);
                decompresser.end();
                byte[] tmp = new byte[resultLength];
                System.arraycopy(decompData, 0, tmp, 0, resultLength);
                decompData = null;
                decompData = new byte[tmp.length];
                System.arraycopy(tmp, 0, decompData, 0, tmp.length);
                tmp = null;
                if (fpOffset + (long)decompData.length > (long)buffer.length) {
                    throw new KSDDataException(this.fileName);
                }
                System.arraycopy(decompData, 0, buffer, (int)fpOffset, decompData.length);
                fpOffset += (long)decompData.length;
            }
        }
        catch (DataFormatException e) {
            throw new KSDDataException(this.fileName);
        }
        catch (IOException e) {
            throw e;
        }
        return buffer;
    }

    public Hashtable<String, String> readBufferAsUnicodeTable(byte[] buffer) {
        Hashtable<String, String> mCCDataHashtable;
        block13: {
            mCCDataHashtable = null;
            try {
                String[] s = new String(buffer, this.mDefaultCharset).split("\r\n");
                if (s.length <= 0) break block13;
                mCCDataHashtable = new Hashtable<String, String>(s.length);
                for (int n = 0; n < s.length; ++n) {
                    String[] s2 = s[n].split("=");
                    if (s2[1].endsWith(";")) {
                        s2[1] = s2[1].substring(0, s2[1].length() - 1);
                    }
                    if (s2[1].indexOf("\\u") >= 0) {
                        String sByte = "";
                        for (int m = 0; m < s2[1].length(); ++m) {
                            if (s2[1].charAt(m) == ';') {
                                sByte = sByte + "003B";
                                continue;
                            }
                            if (s2[1].charAt(m) == '\\' || s2[1].charAt(m) == 'u') continue;
                            sByte = sByte + s2[1].charAt(m);
                        }
                        if (sByte.length() % 2 == 0) {
                            byte[] byData = new byte[sByte.length() / 2];
                            int nIdx = 0;
                            boolean bDataOk = true;
                            for (int j = 0; j < sByte.length(); j += 2) {
                                try {
                                    int iTmp = Integer.parseInt(sByte.substring(j, j + 2), 16);
                                    byData[nIdx] = (byte)(0xFF & iTmp);
                                }
                                catch (NumberFormatException e) {
                                    bDataOk = false;
                                    break;
                                }
                                ++nIdx;
                            }
                            if (bDataOk) {
                                s2[1] = StringHelper.toUnicode((byte[])byData, (boolean)true);
                            }
                        }
                    }
                    if (s2.length != 2 || s2[0].length() <= 0) continue;
                    mCCDataHashtable.put(s2[0], s2[1]);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return mCCDataHashtable;
    }

    public Hashtable<String, String> readBufferAsHashTable(byte[] buffer) {
        Hashtable<String, String> mHashTable = null;
        String[] s = new String(buffer).split("\r\n");
        if (s.length > 0) {
            mHashTable = new Hashtable<String, String>(s.length);
            for (int n = 0; n < s.length; ++n) {
                String[] s2 = s[n].split("=");
                if (s2.length != 2 || s2[0].length() <= 0) continue;
                mHashTable.put(s2[0], s2[1]);
            }
        }
        return mHashTable;
    }
}

