/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import transbase.jdbc.Connection;
import transbase.jdbc.TBJDBCLog;
import transbase.tbx.TBException;
import transbase.tbx.TBURL;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXCursorIf;
import transbase.tbx.TBXObjectFactory;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.types.helpers.CharEncodingFactory;

public class ConnectionControl {
    private TBXConnectionIf connection = null;
    private TBXTransactionIf transaction = null;
    private TBXObjectFactory layer = null;
    private String user;
    private Vector openCursors = new Vector();
    private int autoCommitMode;
    private boolean escapeProcessing = true;
    private Connection mJDBCConnection = null;
    private CharEncodingFactory mCharEncodingFactory;
    private TBJDBCLog mLog;
    private Hashtable usedCursorNames = new Hashtable();
    private boolean autoCommitEnabled = true;
    private int mConsistencyLevel = 3;
    protected static final int CMT_ADMINISTRATIVE = 0;
    protected static final int CMT_METADATAQUERY = 1;
    protected static final int CMT_SELECTQUERY = 2;
    protected static final int CMT_UPDATEQUERY = 3;
    protected static final int CMT_CLOSECURSOR = 4;

    public ConnectionControl(Connection connection, TBXObjectFactory tBXObjectFactory, String string, CharEncodingFactory charEncodingFactory, TBJDBCLog tBJDBCLog) throws SQLException {
        this.mLog = tBJDBCLog;
        this.mCharEncodingFactory = charEncodingFactory;
        this.mJDBCConnection = connection;
        this.connection = connection.getTBXConnection();
        this.layer = tBXObjectFactory;
        this.user = string;
        this.transaction = tBXObjectFactory.getTransaction(this.mLog);
    }

    protected Connection getJDBCConnection() {
        return this.mJDBCConnection;
    }

    protected CharEncodingFactory getCharEncodingFactory() {
        return this.mCharEncodingFactory;
    }

    protected void setAutoCommitMode(int n) {
        this.autoCommitMode = n;
    }

    protected void setDefaultEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    protected boolean getDefaultEscapeProcessing() {
        return this.escapeProcessing;
    }

    protected TBXTransactionIf getTransaction() throws SQLException {
        return this.transaction;
    }

    protected TBXConnectionIf getConnection() throws SQLException {
        return this.connection;
    }

    protected TBXObjectFactory getObjectFactory() throws SQLException {
        return this.layer;
    }

    protected void setAutoCommit(boolean bl) throws SQLException {
        if (!this.autoCommitEnabled && bl) {
            this.autoCommitEnabled = bl;
            this.tryAutoCommit(0);
        }
        this.autoCommitEnabled = bl;
    }

    protected boolean getAutoCommit() throws SQLException {
        return this.autoCommitEnabled;
    }

    protected void tryAutoCommit(int n) throws SQLException {
        block2: {
            block3: {
                boolean bl;
                boolean bl2 = this.autoCommitMode == 1 || this.autoCommitMode == 2 && n == 3;
                boolean bl3 = bl = this.transaction.getTaState() == 32 && this.transaction.isTBXAborted();
                if (!this.autoCommitEnabled) break block2;
                if (bl) break block3;
                if (this.transaction.getTaState() != 4 || !bl2 && this.openCursors.size() != 0) break block2;
            }
            this.commit();
        }
    }

    protected void commit() throws SQLException {
        try {
            this.closeAllOpenCursors();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.transaction.commit();
            throw throwable;
        }
        this.transaction.commit();
        this.transaction = this.layer.getTransaction(this.mLog);
        this.transaction.setConsistency(this.mConsistencyLevel);
    }

    protected void rollback() throws SQLException {
        if (this.isClosed()) {
            throw new TBException(30020);
        }
        try {
            this.closeAllOpenCursors();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.transaction.abort();
            throw throwable;
        }
        this.transaction.abort();
        this.transaction = this.layer.getTransaction(this.mLog);
        this.transaction.setConsistency(this.mConsistencyLevel);
    }

    protected void rollbackOutband() throws SQLException {
        if (this.isClosed()) {
            throw new TBException(30020);
        }
        try {
            this.closeAllOpenCursors();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.transaction.abortOutband();
            throw throwable;
        }
        this.transaction.abortOutband();
        this.transaction = this.layer.getTransaction(this.mLog);
        this.transaction.setConsistency(this.mConsistencyLevel);
    }

    private void closeAllOpenCursors() throws SQLException {
        Vector vector = this.openCursors;
        synchronized (vector) {
            int n = this.openCursors.size();
            for (int i = n - 1; i >= 0; --i) {
                TBXCursorIf tBXCursorIf = (TBXCursorIf)((Object[])this.openCursors.elementAt(i))[0];
                tBXCursorIf.close(false);
                this.removeCursor(tBXCursorIf);
            }
        }
    }

    protected void close(boolean bl) throws SQLException {
        if (!this.isClosed()) {
            if (this.getAutoCommit()) {
                this.commit();
            } else if (bl) {
                this.rollback();
            }
            this.connection.close();
        }
    }

    protected boolean isClosed() throws SQLException {
        return this.connection.getDbState() == 1;
    }

    protected void addCursor(TBXCursorIf tBXCursorIf, String string) throws SQLException {
        Vector vector = this.openCursors;
        synchronized (vector) {
            if (string != null && !string.equals("") && this.getCursorByName(string, false) != null) {
                throw TBException.getTBException(30022, new String[]{string});
            }
            this.openCursors.addElement(new Object[]{tBXCursorIf, string});
        }
    }

    private int getCursorPos(String string) {
        Vector vector = this.openCursors;
        synchronized (vector) {
            int n;
            for (n = 0; n < this.openCursors.size(); ++n) {
                Object[] objectArray = (Object[])this.openCursors.elementAt(n);
                if (!((String)objectArray[1]).equalsIgnoreCase(string)) continue;
                int n2 = n;
                return n2;
            }
            n = -1;
            return n;
        }
    }

    protected TBXCursorIf getCursorByName(String string, boolean bl) throws SQLException {
        Vector vector = this.openCursors;
        synchronized (vector) {
            int n = this.getCursorPos(string);
            if (n == -1) {
                if (bl) {
                    throw TBException.getTBException(30023, new String[]{string});
                }
                TBXCursorIf tBXCursorIf = null;
                return tBXCursorIf;
            }
            TBXCursorIf tBXCursorIf = (TBXCursorIf)((Object[])this.openCursors.elementAt(n))[0];
            return tBXCursorIf;
        }
    }

    protected void removeCursor(TBXCursorIf tBXCursorIf) throws SQLException {
        Vector vector = this.openCursors;
        synchronized (vector) {
            for (int i = 0; i < this.openCursors.size(); ++i) {
                Object[] objectArray = (Object[])this.openCursors.elementAt(i);
                if ((TBXCursorIf)objectArray[0] != tBXCursorIf) continue;
                this.openCursors.removeElementAt(i);
                return;
            }
        }
    }

    protected String getURL() throws SQLException {
        TBURL tBURL = this.connection.getUrl();
        if (tBURL != null) {
            return tBURL.getUrl();
        }
        return "";
    }

    protected String getUserName() throws SQLException {
        return this.user;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        if (this.transaction.getTaState() == 4) {
            this.commit();
        }
        if (n == 1) {
            n = 2;
        }
        switch (n) {
            case 8: {
                this.mConsistencyLevel = 3;
                this.transaction.setConsistency(3);
                break;
            }
            case 4: {
                this.mConsistencyLevel = 2;
                this.transaction.setConsistency(2);
                break;
            }
            case 2: {
                this.mConsistencyLevel = 1;
                this.transaction.setConsistency(1);
                break;
            }
            default: {
                this.mConsistencyLevel = 3;
                this.transaction.setConsistency(3);
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        int n = this.transaction.getConsistency();
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = 8;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 2;
            }
        }
        return n2;
    }

    protected void finalize() throws Throwable {
        this.mLog.logJDBCMethodCall(this, "finalize", null);
        this.close(true);
        this.mLog.logJDBCReturnValue(this, "finalize", null);
    }
}

