/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import transbase.jdbc.Connection;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.Statement;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBTypeMapEntry;
import transbase.jdbc.TBTypeProperties;
import transbase.jdbc.Version;
import transbase.tbx.TBConst;
import transbase.tbx.types.TypeInfo;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final String foreignKeySQLQuery = " select null as PKTABLE_CAT, null as PKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.tarsegno) as PKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.tarsegno  and c.cpos = ref.tarcpos) as PKCOLUMN_NAME,  null as FKTABLE_CAT, null as FKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.srcsegno) as FKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.srcsegno  and c.cpos = ref.srccpos) as FKCOLUMN_NAME,  sc.ckey as KEY_SEQ, case ref.updact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as UPDATE_RULE , case ref.delact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as DELETE_RULE, null as FK_NAME, null as PK_NAME,  7 as DEFERRABILITY from sysrefconstraint ref JOIN syscolumn sc on  ref.tarsegno = sc.tsegno and ref.tarcpos = sc.cpos";
    private Connection connection;
    private ConnectionControl connectionControl;
    private TBJDBCLog mLog;
    private Boolean mIsCaseSensitiveDB = null;
    private static final String[][] tableTypeMap = new String[][]{{"R", "TABLE"}, {"r", "TABLE"}, {"V", "VIEW"}, {"v", "SYSTEM VIEW"}, {"S", "SYSTEM TABLE"}};

    public DatabaseMetaData(Connection connection, ConnectionControl connectionControl, TBJDBCLog tBJDBCLog) throws SQLException {
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{connection});
        this.connection = connection;
        this.connectionControl = connectionControl;
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    protected boolean isCaseSensitiveDB() throws SQLException {
        if (this.mIsCaseSensitiveDB == null) {
            String string = "select count(*) from systable where tname = 'SYSTABLE'";
            java.sql.Statement statement = this.connection.createStatement();
            ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string);
            resultSet.next();
            int n = resultSet.getInt(1);
            this.mIsCaseSensitiveDB = new Boolean(n == 0);
        }
        return this.mIsCaseSensitiveDB;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "allProceduresAreCallable", null);
        this.mLog.logJDBCReturnValue(this, "allProceduresAreCallable", new Boolean(false));
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "allTablesAreSelectable", null);
        this.mLog.logJDBCReturnValue(this, "allTablesAreSelectable", new Boolean(false));
        return false;
    }

    public String getURL() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getURL", null);
        String string = this.connection.connectionControl.getURL();
        this.mLog.logJDBCReturnValue(this, "getURL", string);
        return string;
    }

    public String getUserName() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getUserName", null);
        String string = this.connection.connectionControl.getUserName();
        this.mLog.logJDBCReturnValue(this, "getUserName", string);
        return string;
    }

    public boolean isReadOnly() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isReadOnly", null);
        this.mLog.logJDBCReturnValue(this, "isReadOnly", new Boolean(false));
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "nullsAreSortedHigh", null);
        this.mLog.logJDBCReturnValue(this, "nullsAreSortedHigh", new Boolean(false));
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "nullsAreSortedLow", null);
        this.mLog.logJDBCReturnValue(this, "nullsAreSortedLow", new Boolean(true));
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "nullsAreSortedAtStart", null);
        this.mLog.logJDBCReturnValue(this, "nullsAreSortedAtStart", new Boolean(false));
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "nullsAreSortedAtEnd", null);
        this.mLog.logJDBCReturnValue(this, "nullsAreSortedAtEnd", new Boolean(false));
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDatabaseProductName", null);
        String string = this.connectionControl.getConnection().getDatabaseVersionString();
        this.mLog.logJDBCReturnValue(this, "getDatabaseProductName", string);
        return string;
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDatabaseProductVersion", null);
        String string = this.connectionControl.getConnection().getDatabaseVersion();
        this.mLog.logJDBCReturnValue(this, "getDatabaseProductVersion", string);
        return string;
    }

    public String getDriverName() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDriverName", null);
        String string = "TransBase JDBC driver";
        this.mLog.logJDBCReturnValue(this, "getDriverName", string);
        return string;
    }

    public String getDriverVersion() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDriverVersion", null);
        String string = Version.getVersionString();
        this.mLog.logJDBCReturnValue(this, "getDriverVersion", string);
        return string;
    }

    public int getDriverMajorVersion() {
        this.mLog.logJDBCMethodCall(this, "getDriverMajorVersion", null);
        int n = Version.getMajorVersion();
        this.mLog.logJDBCReturnValue(this, "getDriverMajorVersion", new Integer(n));
        return n;
    }

    public int getDriverMinorVersion() {
        this.mLog.logJDBCMethodCall(this, "getDriverMinorVersion", null);
        int n = Version.getMinorVersion();
        this.mLog.logJDBCReturnValue(this, "getDriverMinorVersion", new Integer(0));
        return n;
    }

    public boolean usesLocalFiles() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "usesLocalFiles", null);
        this.mLog.logJDBCReturnValue(this, "usesLocalFiles", new Boolean(false));
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "usesLocalFilePerTable", null);
        this.mLog.logJDBCReturnValue(this, "usesLocalFilePerTable", new Boolean(false));
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsMixedCaseIdentifiers", null);
        boolean bl = this.isCaseSensitiveDB();
        this.mLog.logJDBCReturnValue(this, "supportsMixedCaseIdentifiers", new Boolean(bl));
        return bl;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "storesUpperCaseIdentifiers", null);
        boolean bl = !this.isCaseSensitiveDB();
        this.mLog.logJDBCReturnValue(this, "storesUpperCaseIdentifiers", new Boolean(bl));
        return bl;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "storesLowerCaseIdentifiers", null);
        this.mLog.logJDBCReturnValue(this, "storesLowerCaseIdentifiers", new Boolean(false));
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "storesMixedCaseIdentifiers", null);
        this.mLog.logJDBCReturnValue(this, "storesMixedCaseIdentifiers", new Boolean(false));
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsMixedCaseQuotedIdentifiers", null);
        this.mLog.logJDBCReturnValue(this, "supportsMixedCaseQuotedIdentifiers", new Boolean(true));
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "storesUpperCaseQuotedIdentifiers", null);
        this.mLog.logJDBCReturnValue(this, "storesUpperCaseQuotedIdentifiers", new Boolean(false));
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "storesLowerCaseQuotedIdentifiers", null);
        this.mLog.logJDBCReturnValue(this, "storesLowerCaseQuotedIdentifiers", new Boolean(false));
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "storesMixedCaseQuotedIdentifiers", null);
        this.mLog.logJDBCReturnValue(this, "storesMixedCaseQuotedIdentifiers", new Boolean(false));
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getIdentifierQuoteString", null);
        this.mLog.logJDBCReturnValue(this, "getIdentifierQuoteString", new String("\""));
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getSQLKeywords", null);
        String string = "access,binchar,bitand,bitnot,bitor,bits,blob,blobaccess,bool,cache,character_len,closure,construct,contains,countbit,currentdate,datetime,dba,dd,delim,diff,disk,exclusive,fi,fill,findbit,flush,fulltext,gentree,hh,if,ikaccess,inclusive,index,leaf,levels,lisp,load,lock,makebit,matches,mi,mo,money,ms,off,password,positional,relation,replace,replicate,resource,sensitive,sorted,spool,ss,string,subrange,subset,syskey,tab,tbmode,timespan,tinyint,ungroup,unload,unlock,weekday,without,yy";
        this.mLog.logJDBCReturnValue(this, "getSQLKeywords", string);
        return string;
    }

    public String getNumericFunctions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getNumericFunctions", null);
        String string = "";
        this.mLog.logJDBCReturnValue(this, "getNumericFunctions", string);
        return string;
    }

    public String getStringFunctions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getStringFunctions", null);
        String string = "concat,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,space,substring,ucase";
        this.mLog.logJDBCReturnValue(this, "getStringFunctions", string);
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getSystemFunctions", null);
        String string = "database,ifnull,user";
        this.mLog.logJDBCReturnValue(this, "getSystemFunctions", string);
        return string;
    }

    public String getTimeDateFunctions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTimeDateFunctions", null);
        String string = "curdate,curtime,dayname,dayofmonth,dayofweek,hour,minute,month,monthname,now,quarter,second,timestampadd,timestampdiff,year";
        this.mLog.logJDBCReturnValue(this, "getTimeDateFunctions", string);
        return string;
    }

    public String getSearchStringEscape() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getSearchStringEscape", null);
        String string = "\\";
        this.mLog.logJDBCReturnValue(this, "getSearchStringEscape", string);
        return string;
    }

    public String getExtraNameCharacters() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getExtraNameCharacters", null);
        String string = "";
        this.mLog.logJDBCReturnValue(this, "getExtraNameCharacters", string);
        return string;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsAlterTableWithAddColumn", null);
        this.mLog.logJDBCReturnValue(this, "supportsAlterTableWithAddColumn", new Boolean(true));
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsAlterTableWithDropColumn", null);
        this.mLog.logJDBCReturnValue(this, "supportsAlterTableWithDropColumn", new Boolean(false));
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsColumnAliasing", null);
        this.mLog.logJDBCReturnValue(this, "supportsColumnAliasing", new Boolean(true));
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "nullPlusNonNullIsNull", null);
        this.mLog.logJDBCReturnValue(this, "nullPlusNonNullIsNull", new Boolean(true));
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsConvert", null);
        this.mLog.logJDBCReturnValue(this, "supportsConvert", new Boolean(true));
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsConvert", new Object[]{new Integer(n), new Integer(n2)});
        int[][] nArrayArray = new int[][]{{-6, 5, 4, 6, 7, 2, 8}, {1, 12, -3, -2}, {91, 92, 93}};
        for (int i = 0; i < nArrayArray.length; ++i) {
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < nArrayArray[i].length; ++j) {
                bl = bl || nArrayArray[i][j] == n;
                bl2 = bl2 || nArrayArray[i][j] == n2;
            }
            if (!bl || !bl2) continue;
            this.mLog.logJDBCReturnValue(this, "supportsConvert", new Boolean(true));
            return true;
        }
        this.mLog.logJDBCReturnValue(this, "supportsConvert", new Boolean(false));
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsTableCorrelationNames", null);
        this.mLog.logJDBCReturnValue(this, "supportsTableCorrelationNames", new Boolean(true));
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsDifferentTableCorrelationNames", null);
        this.mLog.logJDBCReturnValue(this, "supportsDifferentTableCorrelationNames", new Boolean(false));
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsExpressionsInOrderBy", null);
        this.mLog.logJDBCReturnValue(this, "supportsExpressionsInOrderBy", new Boolean(false));
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsOrderByUnrelated", null);
        this.mLog.logJDBCReturnValue(this, "supportsOrderByUnrelated", new Boolean(false));
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsGroupBy", null);
        this.mLog.logJDBCReturnValue(this, "supportsGroupBy", new Boolean(true));
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsGroupByUnrelated", null);
        this.mLog.logJDBCReturnValue(this, "supportsGroupByUnrelated", new Boolean(false));
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsGroupByBeyondSelect", null);
        this.mLog.logJDBCReturnValue(this, "supportsGroupByBeyondSelect", new Boolean(false));
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsLikeEscapeClause", null);
        this.mLog.logJDBCReturnValue(this, "supportsLikeEscapeClause", new Boolean(true));
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsMultipleResultSets", null);
        this.mLog.logJDBCReturnValue(this, "supportsMultipleResultSets", new Boolean(false));
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsMultipleTransactions", null);
        this.mLog.logJDBCReturnValue(this, "supportsMultipleTransactions", new Boolean(true));
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsNonNullableColumns", null);
        this.mLog.logJDBCReturnValue(this, "supportsNonNullableColumns", new Boolean(true));
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsMinimumSQLGrammar", null);
        this.mLog.logJDBCReturnValue(this, "supportsMinimumSQLGrammar", new Boolean(true));
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCoreSQLGrammar", null);
        this.mLog.logJDBCReturnValue(this, "supportsCoreSQLGrammar", new Boolean(true));
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsExtendedSQLGrammar", null);
        this.mLog.logJDBCReturnValue(this, "supportsExtendedSQLGrammar", new Boolean(true));
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsAnsi92EntryLevelSQL", null);
        this.mLog.logJDBCReturnValue(this, "supportsAnsi92EntryLevelSQL", new Boolean(true));
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsAnsi92IntermediateSQL", null);
        this.mLog.logJDBCReturnValue(this, "supportsAnsi92IntermediateSQL", new Boolean(true));
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsAnsi92FullSQL", null);
        this.mLog.logJDBCReturnValue(this, "supportsAnsi92FullSQL", new Boolean(false));
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsIntegrityEnhancementFacility", null);
        this.mLog.logJDBCReturnValue(this, "supportsIntegrityEnhancementFacility", new Boolean(false));
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsOuterJoins", null);
        this.mLog.logJDBCReturnValue(this, "supportsOuterJoins", new Boolean(true));
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsFullOuterJoins", null);
        this.mLog.logJDBCReturnValue(this, "supportsFullOuterJoins", new Boolean(true));
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsLimitedOuterJoins", null);
        this.mLog.logJDBCReturnValue(this, "supportsLimitedOuterJoins", new Boolean(true));
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getSchemaTerm", null);
        String string = "schema";
        this.mLog.logJDBCReturnValue(this, "getSchemaTerm", string);
        return string;
    }

    public String getProcedureTerm() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getProcedureTerm", null);
        String string = "procedure";
        this.mLog.logJDBCReturnValue(this, "getProcedureTerm", string);
        return string;
    }

    public String getCatalogTerm() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCatalogTerm", null);
        String string = "catalog";
        this.mLog.logJDBCReturnValue(this, "getCatalogTerm", string);
        return string;
    }

    public boolean isCatalogAtStart() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isCatalogAtStart", null);
        this.mLog.logJDBCReturnValue(this, "isCatalogAtStart", new Boolean(true));
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCatalogSeparator", null);
        String string = "";
        this.mLog.logJDBCReturnValue(this, "getCatalogSeparator", string);
        return string;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSchemasInDataManipulation", null);
        this.mLog.logJDBCReturnValue(this, "supportsSchemasInDataManipulation", new Boolean(false));
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSchemasInProcedureCalls", null);
        this.mLog.logJDBCReturnValue(this, "supportsSchemasInProcedureCalls", new Boolean(false));
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSchemasInTableDefinitions", null);
        this.mLog.logJDBCReturnValue(this, "supportsSchemasInTableDefinitions", new Boolean(false));
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSchemasInIndexDefinitions", null);
        this.mLog.logJDBCReturnValue(this, "supportsSchemasInIndexDefinitions", new Boolean(false));
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSchemasInPrivilegeDefinitions", null);
        this.mLog.logJDBCReturnValue(this, "supportsSchemasInPrivilegeDefinitions", new Boolean(false));
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCatalogsInDataManipulation", null);
        this.mLog.logJDBCReturnValue(this, "supportsCatalogsInDataManipulation", new Boolean(false));
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCatalogsInProcedureCalls", null);
        this.mLog.logJDBCReturnValue(this, "supportsCatalogsInProcedureCalls", new Boolean(false));
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCatalogsInTableDefinitions", null);
        this.mLog.logJDBCReturnValue(this, "supportsCatalogsInTableDefinitions", new Boolean(false));
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCatalogsInIndexDefinitions", null);
        this.mLog.logJDBCReturnValue(this, "supportsCatalogsInIndexDefinitions", new Boolean(false));
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCatalogsInPrivilegeDefinitions", null);
        this.mLog.logJDBCReturnValue(this, "supportsCatalogsInPrivilegeDefinitions", new Boolean(false));
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsPositionedDelete", null);
        this.mLog.logJDBCReturnValue(this, "supportsPositionedDelete", new Boolean(true));
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsPositionedUpdate", null);
        this.mLog.logJDBCReturnValue(this, "supportsPositionedUpdate", new Boolean(true));
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSelectForUpdate", null);
        this.mLog.logJDBCReturnValue(this, "supportsSelectForUpdate", new Boolean(true));
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsStoredProcedures", null);
        this.mLog.logJDBCReturnValue(this, "supportsStoredProcedures", new Boolean(true));
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSubqueriesInComparisons", null);
        this.mLog.logJDBCReturnValue(this, "supportsSubqueriesInComparisons", new Boolean(true));
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSubqueriesInExists", null);
        this.mLog.logJDBCReturnValue(this, "supportsSubqueriesInExists", new Boolean(true));
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSubqueriesInIns", null);
        this.mLog.logJDBCReturnValue(this, "supportsSubqueriesInIns", new Boolean(true));
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsSubqueriesInQuantifieds", null);
        this.mLog.logJDBCReturnValue(this, "supportsSubqueriesInQuantifieds", new Boolean(true));
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsCorrelatedSubqueries", null);
        this.mLog.logJDBCReturnValue(this, "supportsCorrelatedSubqueries", new Boolean(true));
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsUnion", null);
        this.mLog.logJDBCReturnValue(this, "supportsUnion", new Boolean(true));
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsUnionAll", null);
        this.mLog.logJDBCReturnValue(this, "supportsUnionAll", new Boolean(true));
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsOpenCursorsAcrossCommit", null);
        this.mLog.logJDBCReturnValue(this, "supportsOpenCursorsAcrossCommit", new Boolean(false));
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsOpenCursorsAcrossRollback", null);
        this.mLog.logJDBCReturnValue(this, "supportsOpenCursorsAcrossRollback", new Boolean(false));
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsOpenStatementsAcrossCommit", null);
        this.mLog.logJDBCReturnValue(this, "supportsOpenStatementsAcrossCommit", new Boolean(true));
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsOpenStatementsAcrossRollback", null);
        this.mLog.logJDBCReturnValue(this, "supportsOpenStatementsAcrossRollback", new Boolean(true));
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxBinaryLiteralLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxBinaryLiteralLength", new Integer(0));
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxCharLiteralLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxCharLiteralLength", new Integer(0));
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxColumnNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxColumnNameLength", new Integer(31));
        return 31;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxColumnsInGroupBy", null);
        this.mLog.logJDBCReturnValue(this, "getMaxColumnsInGroupBy", new Integer(0));
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxColumnsInIndex", null);
        this.mLog.logJDBCReturnValue(this, "getMaxColumnsInIndex", new Integer(0));
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxColumnsInOrderBy", null);
        this.mLog.logJDBCReturnValue(this, "getMaxColumnsInOrderBy", new Integer(0));
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxColumnsInSelect", null);
        this.mLog.logJDBCReturnValue(this, "getMaxColumnsInSelect", new Integer(256));
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxColumnsInTable", null);
        this.mLog.logJDBCReturnValue(this, "getMaxColumnsInTable", new Integer(256));
        return 256;
    }

    public int getMaxConnections() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxConnections", null);
        this.mLog.logJDBCReturnValue(this, "getMaxConnections", new Integer(20));
        return 20;
    }

    public int getMaxCursorNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxCursorNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxCursorNameLength", new Integer(31));
        return 31;
    }

    public int getMaxIndexLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxIndexLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxIndexLength", new Integer(0));
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxSchemaNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxSchemaNameLength", new Integer(18));
        return 18;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxProcedureNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxProcedureNameLength", new Integer(128));
        return 128;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxCatalogNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxCatalogNameLength", new Integer(0));
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxRowSize", null);
        this.mLog.logJDBCReturnValue(this, "getMaxRowSize", new Integer(0));
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "doesMaxRowSizeIncludeBlobs", null);
        this.mLog.logJDBCReturnValue(this, "doesMaxRowSizeIncludeBlobs", new Boolean(false));
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxStatementLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxStatementLength", new Integer(0));
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxStatements", null);
        this.mLog.logJDBCReturnValue(this, "getMaxStatements", new Integer(10));
        return 10;
    }

    public int getMaxTableNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxTableNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxTableNameLength", new Integer(31));
        return 31;
    }

    public int getMaxTablesInSelect() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxTablesInSelect", null);
        this.mLog.logJDBCReturnValue(this, "getMaxTablesInSelect", new Integer(0));
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxUserNameLength", null);
        this.mLog.logJDBCReturnValue(this, "getMaxUserNameLength", new Integer(40));
        return 40;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDefaultTransactionIsolation", null);
        this.mLog.logJDBCReturnValue(this, "getDefaultTransactionIsolation", new Integer(8));
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsTransactions", null);
        this.mLog.logJDBCReturnValue(this, "supportsTransactions", new Boolean(true));
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsTransactionIsolationLevel", new Object[]{new Integer(n)});
        switch (n) {
            case 2: 
            case 4: 
            case 8: {
                this.mLog.logJDBCReturnValue(this, "supportsTransactionIsolationLevel", new Boolean(true));
                return true;
            }
        }
        this.mLog.logJDBCReturnValue(this, "supportsTransactionIsolationLevel", new Boolean(false));
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsDataDefinitionAndDataManipulationTransactions", null);
        this.mLog.logJDBCReturnValue(this, "supportsDataDefinitionAndDataManipulationTransactions", new Boolean(true));
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsDataManipulationTransactionsOnly", null);
        this.mLog.logJDBCReturnValue(this, "supportsDataManipulationTransactionsOnly", new Boolean(false));
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "dataDefinitionCausesTransactionCommit", null);
        this.mLog.logJDBCReturnValue(this, "dataDefinitionCausesTransactionCommit", new Boolean(false));
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "dataDefinitionIgnoredInTransactions", null);
        this.mLog.logJDBCReturnValue(this, "dataDefinitionIgnoredInTransactions", new Boolean(false));
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getProcedures", new Object[]{string, string2, string3});
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery("select null as PROCEDURE_CAT, null as PROCEDURE_SCHEM,  sqlname as PROCEDURE_NAME, null, null, null, comment as REMARKS, IF resulttype='V' THEN 1 ELSE 2 FI as PROCEDURE_TYPE  from sysexternalmethod");
        this.mLog.logJDBCReturnValue(this, "getProcedures", resultSet);
        return resultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getProcedureColumns", new Object[]{string, string2, string3, string4});
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery("select null as PROCEDURE_CAT, null as PROCEDURE_SCHEM,  '' as PROCEDURE_NAME, '' as COLUMN_NAME, 0 as COLUMN_TYPE,  null as DATA_TYPE, null as TYPE_NAME, 0 as \"PRECISION\", 0 as LENGTH,  0 as SCALE, 0 as RADIX, 2 as NULLABLE, '' as REMARKS from systable  where true = false ");
        this.mLog.logJDBCReturnValue(this, "getProcedureColumns", resultSet);
        return resultSet;
    }

    private String[] translateTableTypes(String[] stringArray) {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < tableTypeMap.length; ++i) {
                if (!tableTypeMap[i][1].equalsIgnoreCase(stringArray[n].trim())) continue;
                vector.addElement(tableTypeMap[i][0]);
            }
        }
        String[] stringArray2 = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[n] = (String)vector.elementAt(n);
        }
        return stringArray2;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String[] stringArray2;
        this.mLog.logJDBCMethodCall(this, "getTables", new Object[]{string, string2, string3, stringArray});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "" && !string2.equals("%");
        boolean bl3 = string3 != null && !string3.equals("%");
        boolean bl4 = stringArray != null;
        boolean bl5 = false;
        String string4 = "select null as TABLE_CAT, null as TABLE_SCHEM,  tname as TABLE_NAME, case ttype when 'R' then 'TABLE' when 'r' then 'TABLE'  when 'V' then 'VIEW' when 'v' then 'SYSTEM VIEW' when 'S' then 'SYSTEM TABLE' else '' end as TABLE_TYPE, '' as REMARKS from systable";
        if (bl || bl2 || bl3 || bl4) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" where ");
        }
        if (bl || bl2) {
            if (bl5) {
                string4 = String.valueOf(String.valueOf(string4)).concat(" and ");
            }
            string4 = String.valueOf(String.valueOf(string4)).concat(" true = false ");
            bl5 = true;
        }
        if (bl3) {
            if (bl5) {
                string4 = String.valueOf(String.valueOf(string4)).concat(" and ");
            }
            string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" tname like '").append(string3).append("' "))))));
            bl5 = true;
        }
        if (bl4) {
            if (bl5) {
                string4 = String.valueOf(String.valueOf(string4)).concat(" and ");
            }
            string4 = String.valueOf(String.valueOf(string4)).concat("ttype in (");
            stringArray2 = this.translateTableTypes(stringArray);
            for (int i = 0; i < stringArray2.length; ++i) {
                if (i > 0) {
                    string4 = String.valueOf(String.valueOf(string4)).concat(", ");
                }
                string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("'").append(stringArray2[i]).append("'"))))));
            }
            string4 = String.valueOf(String.valueOf(string4)).concat(")");
            bl5 = true;
        }
        string4 = String.valueOf(String.valueOf(string4)).concat(" order by 4, 2, 3 ");
        stringArray2 = this.connection.createStatement();
        ResultSet resultSet = ((Statement)stringArray2).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getTables", resultSet);
        return resultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getSchemas", null);
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery("select '' as TABLE_SCHEM  from systable where true=false");
        this.mLog.logJDBCReturnValue(this, "getSchemas", resultSet);
        return resultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCatalogs", null);
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery("select '' as TABLE_CAT  from systable where true = false");
        this.mLog.logJDBCReturnValue(this, "getCatalogs", resultSet);
        return resultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTableTypes", null);
        java.sql.Statement statement = this.connection.createStatement();
        String string = "select distinct TABLE_TYPE from ( (select 'TABLE' as TABLE_TYPE from systable)  union  (select 'VIEW' as TABLE_TYPE from systable)  union  (select 'SYSTEM VIEW' as TABLE_TYPE from systable)  union  (select 'SYSTEM TABLE' as TABLE_TYPE from systable)  ) order by 1 ";
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string);
        this.mLog.logJDBCReturnValue(this, "getTableTypes", resultSet);
        return resultSet;
    }

    private String buildTypeTranslation(String string) throws SQLException {
        String string2 = " case ";
        Hashtable hashtable = TBTypeProperties.getTypeUpMap();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                TBTypeMapEntry tBTypeMapEntry = (TBTypeMapEntry)vector.elementAt(i);
                string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" when ").append(tBTypeMapEntry.getTBTypeInfo().getTypeLikeExpr(string).toLowerCase()).append(" then ").append(tBTypeMapEntry.getJDBCType()).append("\n"))))));
            }
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(" else 1111 end ");
        return string2;
    }

    private String buildTypePrecTranslation(String string) throws SQLException {
        String string2 = " case ";
        int[] nArray = TBConst.getTBTableTypes();
        for (int i = 0; i < nArray.length; ++i) {
            TypeInfo typeInfo = TypeInfo.createTypeInfo(nArray[i], null);
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" when ").append(typeInfo.getTypeLikeExpr(string).toLowerCase()).append(" then ").append(typeInfo.getTypeColSizeExpr(string)).append("\n"))))));
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(" else 0 end ");
        return string2;
    }

    private String buildTypeNameTranslation(String string) throws SQLException {
        String string2 = " case ";
        int[] nArray = TBConst.getTBTableTypes();
        for (int i = 0; i < nArray.length; ++i) {
            TypeInfo typeInfo = TypeInfo.createTypeInfo(nArray[i], null);
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" when ").append(typeInfo.getTypeLikeExpr(string).toLowerCase()).append(" then '").append(typeInfo.getTypeName()).append("'\n"))))));
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" else ").append(string).append(" end "))))));
        return string2;
    }

    private String buildTypeDecDigitsTranslation(String string) throws SQLException {
        String string2 = " case ";
        int[] nArray = TBConst.getTBTableTypes();
        for (int i = 0; i < nArray.length; ++i) {
            TypeInfo typeInfo = TypeInfo.createTypeInfo(nArray[i], null);
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" when ").append(typeInfo.getTypeLikeExpr(string).toLowerCase()).append(" then ").append(typeInfo.getTypeDecDigitExpr(string)).append("\n"))))));
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(" else 0 end ");
        return string2;
    }

    private String buildTypePrecRadTranslation(String string) throws SQLException {
        String string2 = " case ";
        int[] nArray = TBConst.getTBTableTypes();
        for (int i = 0; i < nArray.length; ++i) {
            TypeInfo typeInfo = TypeInfo.createTypeInfo(nArray[i], null);
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" when ").append(typeInfo.getTypeLikeExpr(string).toLowerCase()).append(" then ").append(typeInfo.getNumPrecRadix()).append("\n"))))));
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(" else 10 end ");
        return string2;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumns", new Object[]{string, string2, string3, string4});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "" && !string2.equals("%");
        boolean bl3 = string3 != null;
        boolean bl4 = string4 != null;
        boolean bl5 = false;
        String string5 = String.valueOf(String.valueOf(new StringBuffer("select TABLE_CAT, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, \nTYPE_NAME, COLUMN_SIZE, BUFFER_LENGTH, DECIMAL_DIGITS, NUM_PREC_RADIX, \nNULLABLE, REMARKS, COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB, \nCOLUMN_SIZE as CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE from (\nselect '' as TABLE_CAT, '' as TABLE_SCHEM, \nt.tname as TABLE_NAME, c.cname as COLUMN_NAME, \n").append(this.buildTypeTranslation("c.ctype")).append(" as DATA_TYPE, \n").append(this.buildTypeNameTranslation("c.ctype")).append(" as TYPE_NAME, \n").append(this.buildTypePrecTranslation("c.ctype")).append(" as COLUMN_SIZE, null as BUFFER_LENGTH, \n").append(this.buildTypeDecDigitsTranslation("c.ctype")).append(" as DECIMAL_DIGITS, \n").append(this.buildTypePrecRadTranslation("c.ctype")).append(" as NUM_PREC_RADIX, case (c.notnull)").append(" when 'NULL' then ").append(2).append(" when 'Y' then ").append(0).append(" when 'N' then ").append(1).append(" else ").append(2).append(" end as NULLABLE, '' as REMARKS, ").append(" null as COLUMN_DEF, null as SQL_DATA_TYPE, null as SQL_DATETIME_SUB, c.cpos as ORDINAL_POSITION, ").append(" case (c.notnull)").append(" when 'NULL' then '' ").append(" when 'N' then 'YES' ").append(" when 'Y' then 'NO' else '' end as IS_NULLABLE").append(" from systable t, syscolumn c where c.tsegno = t.segno").append(" ) ")));
        if (bl || bl2 || bl3 || bl4) {
            string5 = String.valueOf(String.valueOf(string5)).concat(" where ");
        }
        if (bl || bl2) {
            if (bl5) {
                string5 = String.valueOf(String.valueOf(string5)).concat(" and ");
            }
            string5 = String.valueOf(String.valueOf(string5)).concat(" true = false ");
            bl5 = true;
        }
        if (bl3) {
            if (bl5) {
                string5 = String.valueOf(String.valueOf(string5)).concat(" and ");
            }
            string5 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" TABLE_NAME like '").append(string3).append("' "))))));
            bl5 = true;
        }
        if (bl4) {
            if (bl5) {
                string5 = String.valueOf(String.valueOf(string5)).concat(" and ");
            }
            string5 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" COLUMN_NAME like '").append(string4).append("' "))))));
            bl5 = true;
        }
        string5 = String.valueOf(String.valueOf(string5)).concat(" order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string5);
        this.mLog.logJDBCReturnValue(this, "getColumns", resultSet);
        return resultSet;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnPrivileges", new Object[]{string, string2, string3, string4});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "";
        boolean bl3 = string4 != null;
        String string5 = String.valueOf(String.valueOf(new StringBuffer(" and ( t.segno = tp.tsegno and t.tname like '").append(string3).append("' ")));
        if (bl3) {
            string5 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" and sc.cname like '").append(string4).append("' "))))));
        }
        if (bl || bl2) {
            string5 = String.valueOf(String.valueOf(string5)).concat(" and true = false ");
        }
        string5 = String.valueOf(String.valueOf(string5)).concat(") ");
        String string6 = String.valueOf(String.valueOf(new StringBuffer("select null as TABLE_CAT, null as TABLE_SCHEM, TABLE_NAME, COLUMN_NAME,  if GRANTOR_ID = null then null else (select u.username from sysuser u where u.userid = GRANTOR_ID) fi as GRANTOR,  if GRANTEE_ID = null then null else (select u.username from sysuser u where u.userid = GRANTEE_ID) fi as GRANTEE,  \"PRIVILEGE\", IS_GRANTABLE from (  (select t.tname as TABLE_NAME, sc.cname as COLUMN_NAME,  tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID,  'SELECT' as \"PRIVILEGE\", if tp.sel_priv = 'G' then 'YES' else 'NO' fi  as IS_GRANTABLE from systable t, systablepriv tp inner join  syscolumn sc on (tp.tsegno = sc.tsegno) left outer  join syscolumnpriv scp on (scp.tsegno = sc.tsegno and scp.cpos = sc.cpos)  where (tp.sel_priv = 'G' or tp.sel_priv = 'Y') ").append(string5).append(")").append(" union ").append(" (select t.tname as TABLE_NAME, sc.cname as COLUMN_NAME, ").append(" tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID, ").append(" 'INSERT' as \"PRIVILEGE\", if tp.ins_priv = 'G' then 'YES' else 'NO' fi ").append(" as IS_GRANTABLE from systable t, systablepriv tp inner join ").append(" syscolumn sc on (tp.tsegno = sc.tsegno) left outer ").append(" join syscolumnpriv scp on (scp.tsegno = sc.tsegno and scp.cpos = sc.cpos) ").append(" where (tp.ins_priv = 'G' or tp.ins_priv = 'Y') ").append(string5).append(")").append(" union ").append(" (select t.tname as TABLE_NAME, sc.cname as COLUMN_NAME, ").append(" tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID, ").append(" 'DELETE' as \"PRIVILEGE\", if tp.del_priv = 'G' then 'YES' else 'NO' fi ").append(" as IS_GRANTABLE from systable t, systablepriv tp inner join ").append(" syscolumn sc on (tp.tsegno = sc.tsegno) left outer ").append(" join syscolumnpriv scp on (scp.tsegno = sc.tsegno and scp.cpos = sc.cpos) ").append(" where (tp.del_priv = 'G' or tp.del_priv = 'Y') ").append(string5).append(")").append(" union ").append(" (select t.tname as TABLE_NAME, sc.cname as COLUMN_NAME, ").append(" if tp.upd_priv = 'S' then scp.grantor else tp.grantor fi as GRANTOR_ID, ").append(" if tp.upd_priv = 'S' then scp.grantee else tp.grantee fi as GRANTEE_ID, ").append(" 'UPDATE' as \"PRIVILEGE\", if tp.upd_priv = 'S' then ").append(" if scp.upd_priv ='G' then 'YES' else 'NO' fi else ").append(" if tp.upd_priv = 'G' then 'YES' else 'NO' fi fi ").append(" as IS_GRANTABLE from systable t, systablepriv tp inner join ").append(" syscolumn sc on (tp.tsegno = sc.tsegno) left outer ").append(" join syscolumnpriv scp on (scp.tsegno = sc.tsegno and scp.cpos = sc.cpos) ").append(" where ((tp.upd_priv = 'G' or tp.upd_priv = 'Y') or ").append(" (tp.upd_priv = 'S' and (scp.upd_priv = 'G' or scp.upd_priv = 'Y'))) ").append(string5).append(")").append(" ) order by COLUMN_NAME, \"PRIVILEGE\"")));
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string6);
        this.mLog.logJDBCReturnValue(this, "getColumnPrivileges", resultSet);
        return resultSet;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTablePrivileges", new Object[]{string, string2, string3});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "" && !string2.equals("%");
        boolean bl3 = string3 != null;
        String string4 = " and (t.segno = tp.tsegno ";
        if (bl3) {
            string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" and t.tname like '").append(string3).append("' "))))));
        }
        if (bl || bl2) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" and true = false ");
        }
        string4 = String.valueOf(String.valueOf(string4)).concat(" )");
        String string5 = String.valueOf(String.valueOf(new StringBuffer("select TABLE_CAT, TABLE_SCHEM, TABLE_NAME, if GRANTOR_ID = null then null else  (select u.username from  sysuser u where u.userid = GRANTOR_ID) fi as GRANTOR, (select u.username from  sysuser u where u.userid = GRANTEE_ID) as GRANTEE, \"PRIVILEGE\", IS_GRANTABLE from ( (select null as TABLE_CAT, null as TABLE_SCHEM,  t.tname as TABLE_NAME, tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID,  'SELECT' as \"PRIVILEGE\", if tp.sel_priv = 'G' then 'YES' else 'NO' fi as IS_GRANTABLE  from systable t, systablepriv tp where (tp.sel_priv = 'G' or tp.sel_priv = 'Y') ").append(string4).append(")").append(" union ").append("(select null as TABLE_CAT, null as TABLE_SCHEM, ").append(" t.tname as TABLE_NAME, tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID, ").append(" 'INSERT' as PRIVILEGE, if tp.ins_priv = 'G' then 'YES' else 'NO' fi as IS_GRANTABLE ").append(" from systable t, systablepriv tp where (tp.ins_priv = 'G' or tp.ins_priv = 'Y') ").append(string4).append(")").append(" union ").append("(select null as TABLE_CAT, null as TABLE_SCHEM, ").append(" t.tname as TABLE_NAME, tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID, ").append(" 'DELETE' as PRIVILEGE, if tp.del_priv = 'G' then 'YES' else 'NO' fi as IS_GRANTABLE ").append(" from systable t, systablepriv tp where (tp.del_priv = 'G' or tp.del_priv = 'Y') ").append(string4).append(")").append(" union ").append("(select null as TABLE_CAT, null as TABLE_SCHEM, ").append(" t.tname as TABLE_NAME, tp.grantor as GRANTOR_ID, tp.grantee as GRANTEE_ID, ").append(" 'UPDATE' as PRIVILEGE, if tp.upd_priv = 'G' then 'YES' else 'NO' fi as IS_GRANTABLE ").append(" from systable t, systablepriv tp where (tp.upd_priv = 'G' or tp.upd_priv = 'Y') ").append(string4).append(")").append(") ")));
        string5 = String.valueOf(String.valueOf(string5)).concat(" order by TABLE_SCHEM, TABLE_NAME, \"PRIVILEGE\" ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string5);
        this.mLog.logJDBCReturnValue(this, "getTablePrivileges", resultSet);
        return resultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBestRowIdentifier", new Object[]{string, string2, string3, new Integer(n), new Boolean(bl)});
        boolean bl2 = string != null && string != "";
        boolean bl3 = string2 != null && string2 != "";
        String string4 = String.valueOf(String.valueOf(new StringBuffer("select 2 as SCOPE, sc.cname as COLUMN_NAME, \n").append(this.buildTypeTranslation("sc.ctype")).append(" as DATA_TYPE,\n").append(this.buildTypeNameTranslation("sc.ctype")).append(" as TYPE_NAME, \n").append(this.buildTypePrecTranslation("sc.ctype")).append(" as COLUMN_SIZE, 0 as BUFFER_LENGTH, ").append(this.buildTypeDecDigitsTranslation("sc.ctype")).append(" as DECIMAL_DIGITS, ").append(1).append(" as PSEUDO_COLUMN ").append(" from systable t, syscolumn sc where t.segno = sc.tsegno and ").append(" ((sc.ckey > 0) or (t.ttype in ('v', 'V')))").append(" and t.tname = '").append(string3).append("' order by 1")));
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getBestRowIdentifier", resultSet);
        return resultSet;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getVersionColumns", new Object[]{string, string2, string3});
        String string4 = " select null as SCOPE, '' as COLUMN_NAME, null as DATA_TYPE,  null as TYPE_NAME, null as COLUMN_SIZE, null as BUFFER_LENGTH,  null as DECIMAL_DIGITS, 0 as  PSEUDO_COLUMN  from systable where true = false ";
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getVersionColumns", resultSet);
        return resultSet;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getPrimaryKeys", new Object[]{string, string2, string3});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "";
        String string4 = String.valueOf(String.valueOf(new StringBuffer(" select null as TABLE_CAT, null as TABLE_SCHEM, t.tname as  TABLE_NAME, sc.cname as COLUMN_NAME, sc.ckey as KEY_SEQ,  sr.constraintname as PK_NAME  from systable t, syscolumn sc, sysconstraint sr  where t.segno = sc.tsegno and (sc.ckey <> 0)  and t.tname = '").append(string3).append("' and t.segno = sr.segno and ").append(" sr.constrainttext like 'PRIMARY KEY %'")));
        if (bl2 || bl) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" and true = false ");
        }
        string4 = String.valueOf(String.valueOf(string4)).concat(" order by 4 ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getPrimaryKeys", resultSet);
        return resultSet;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getImportedKeys", new Object[]{string, string2, string3});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "" && string2 != "%";
        String string4 = String.valueOf(String.valueOf(new StringBuffer("select PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY from (  select null as PKTABLE_CAT, null as PKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.tarsegno) as PKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.tarsegno  and c.cpos = ref.tarcpos) as PKCOLUMN_NAME,  null as FKTABLE_CAT, null as FKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.srcsegno) as FKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.srcsegno  and c.cpos = ref.srccpos) as FKCOLUMN_NAME,  sc.ckey as KEY_SEQ, case ref.updact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as UPDATE_RULE , case ref.delact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as DELETE_RULE, null as FK_NAME, null as PK_NAME,  7 as DEFERRABILITY from sysrefconstraint ref JOIN syscolumn sc on  ref.tarsegno = sc.tsegno and ref.tarcpos = sc.cpos ) where FKTABLE_NAME = '").append(string3).append("' ")));
        if (bl || bl2) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" and true = false ");
        }
        string4 = String.valueOf(String.valueOf(string4)).concat(" order by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getImportedKeys", resultSet);
        return resultSet;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getExportedKeys", new Object[]{string, string2, string3});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "" && string2 != "%";
        String string4 = String.valueOf(String.valueOf(new StringBuffer("select PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY from (  select null as PKTABLE_CAT, null as PKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.tarsegno) as PKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.tarsegno  and c.cpos = ref.tarcpos) as PKCOLUMN_NAME,  null as FKTABLE_CAT, null as FKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.srcsegno) as FKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.srcsegno  and c.cpos = ref.srccpos) as FKCOLUMN_NAME,  sc.ckey as KEY_SEQ, case ref.updact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as UPDATE_RULE , case ref.delact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as DELETE_RULE, null as FK_NAME, null as PK_NAME,  7 as DEFERRABILITY from sysrefconstraint ref JOIN syscolumn sc on  ref.tarsegno = sc.tsegno and ref.tarcpos = sc.cpos ) where PKTABLE_NAME = '").append(string3).append("' ")));
        if (bl || bl2) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" and true = false ");
        }
        string4 = String.valueOf(String.valueOf(string4)).concat(" order by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getExportedKeys", resultSet);
        return resultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCrossReference", new Object[]{string, string2, string3, string4, string5, string6});
        boolean bl = string != null && string != "";
        boolean bl2 = string2 != null && string2 != "";
        boolean bl3 = string4 != null && string4 != "";
        boolean bl4 = string5 != null && string5 != "";
        String string7 = String.valueOf(String.valueOf(new StringBuffer("select PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY from (  select null as PKTABLE_CAT, null as PKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.tarsegno) as PKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.tarsegno  and c.cpos = ref.tarcpos) as PKCOLUMN_NAME,  null as FKTABLE_CAT, null as FKTABLE_SCHEM,  (select t.tname from systable t where t.segno = ref.srcsegno) as FKTABLE_NAME,  (select c.cname from syscolumn c where c.tsegno = ref.srcsegno  and c.cpos = ref.srccpos) as FKCOLUMN_NAME,  sc.ckey as KEY_SEQ, case ref.updact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as UPDATE_RULE , case ref.delact  when 'NO ACTION' then 3 when 'CASCADE' then 0 when 'SET NULL' then 2 when 'SET DEFAULT' then 4 else null  end as DELETE_RULE, null as FK_NAME, null as PK_NAME,  7 as DEFERRABILITY from sysrefconstraint ref JOIN syscolumn sc on  ref.tarsegno = sc.tsegno and ref.tarcpos = sc.cpos ) where PKTABLE_NAME = '").append(string3).append("' and ").append(" FKTABLE_NAME = '").append(string6).append("' ")));
        if (bl || bl2 || bl3 || bl4) {
            string7 = String.valueOf(String.valueOf(string7)).concat(" and true = false ");
        }
        string7 = String.valueOf(String.valueOf(string7)).concat(" order by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string7);
        this.mLog.logJDBCReturnValue(this, "getCrossReference", resultSet);
        return resultSet;
    }

    private String replaceSingleQuote(String string) {
        if (string != null) {
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("'")) {
                    string3 = "''";
                }
                string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string3)));
            }
            return string2;
        }
        return string;
    }

    public ResultSet getTypeInfo() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTypeInfo", null);
        String string = " select TRIM(tn cast char(*)) as TYPE_NAME, dt as DATA_TYPE, pr as \"PRECISION\", \n TRIM(lp cast char(*)) as LITERAL_PREFIX, TRIM(ls cast char(*)) as LITERAL_SUFFIX, \n TRIM(cp cast char(*)) as CREATE_PARAMS, \n nul as NULLABLE, cs as CASE_SENSITIVE, src as SEARCHABLE, \n ua as UNSIGNED_ATTRIBUTE, fps as FIXED_PREC_SCALE, ai as AUTO_INCREMENT, \n TRIM(ltn cast char(*)) as LOCAL_TYPE_NAME, mins as MINIMUM_SCALE, maxs as MAXIMUM_SCALE, \n null as SQL_DATA_TYPE, null as SQL_DATETIME_SUB, npr as NUM_PREC_RADIX from ( \n";
        Vector vector = TBTypeProperties.getTypeDownMap();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TBTypeMapEntry tBTypeMapEntry = (TBTypeMapEntry)vector.elementAt(i);
            TypeInfo typeInfo = tBTypeMapEntry.getTBTypeInfo();
            String string2 = this.replaceSingleQuote(typeInfo.getLiteralPrefix());
            String string3 = this.replaceSingleQuote(typeInfo.getLiteralSuffix());
            String string4 = typeInfo.getCreateParams();
            String string5 = typeInfo.getLocalTypeName();
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" (select '").append(typeInfo.getTypeName()).append("' as tn, \n").append(tBTypeMapEntry.getJDBCType()).append(" as dt, \n").append(typeInfo.getPrecision()).append(" as pr, \n").append(string2.equals("") ? "null" : String.valueOf(String.valueOf(new StringBuffer("'").append(string2).append("'")))).append(" as lp, \n").append(string3.equals("") ? "null" : String.valueOf(String.valueOf(new StringBuffer("'").append(string3).append("'")))).append(" as ls, \n").append(string4.equals("") ? "null" : String.valueOf(String.valueOf(new StringBuffer("'").append(string4).append("'")))).append(" as cp, \n").append(typeInfo.getNullable()).append(" as nul, \n").append(typeInfo.getCaseSensitive()).append(" as cs, \n").append(typeInfo.getSearchable()).append(" as src, \n").append(typeInfo.getUnsignedAttribute()).append(" as ua, \n").append(typeInfo.getFixedPrecScale()).append(" as fps, \n").append(typeInfo.getAutoIncrement()).append(" as ai, \n").append(string5.equals("") ? "null" : String.valueOf(String.valueOf(new StringBuffer("'").append(string5).append("'")))).append(" as ltn, \n").append(typeInfo.getMinimumScale()).append(" as mins, \n").append(typeInfo.getMaximumScale()).append(" as maxs, \n").append(typeInfo.getNumPrecRadix()).append(" as npr, \n").append(i).append(" as priority ").append(" from systable where upper(tname) = 'SYSTABLE' and ttype = 'v')"))))));
            if (i >= n - 1) continue;
            string = String.valueOf(String.valueOf(string)).concat("\n union \n");
        }
        string = String.valueOf(String.valueOf(string)).concat(") group by dt, priority, tn, pr, \nlp, ls, cp, nul, cs, src, \nua, fps, ai, ltn, mins, \nmaxs, npr");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string);
        this.mLog.logJDBCReturnValue(this, "getTypeInfo", resultSet);
        return resultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getIndexInfo", new Object[]{string, string2, string3, new Boolean(bl), new Boolean(bl2)});
        boolean bl3 = string != null && string != "";
        boolean bl4 = string2 != null && string2 != "";
        String string4 = String.valueOf(String.valueOf(new StringBuffer(" select null as TABLE_CAT, null as TABLE_SCHEM, t.tname as TABLE_NAME,  (if i.isuniq='N' then true else false fi) as NON_UNIQUE, null as  INDEX_QUALIFIER, i.iname as INDEX_NAME, 1 as TYPE,  i.weight as ORDINAL_POSITION, c.cname as COLUMN_NAME, 'A' as ASC_OR_DESC,  0 as CARDINALITY, 0 as PAGES, null as FILTER_CONDITION from  sysindex i, systable t, syscolumn c where i.tsegno = t.segno and  i.tsegno = c.tsegno and i.cpos = c.cpos and t.tname = '").append(string3).append("' ")));
        if (bl) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" and i.isuniq = 'Y' ");
        }
        if (bl3 || bl4) {
            string4 = String.valueOf(String.valueOf(string4)).concat(" and true = false ");
        }
        string4 = String.valueOf(String.valueOf(string4)).concat("order by 4,7,6,8 ");
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery(string4);
        this.mLog.logJDBCReturnValue(this, "getIndexInfo", resultSet);
        return resultSet;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsResultSetType", new Object[]{new Integer(n)});
        boolean bl = n == 1003 || n == 1004;
        this.mLog.logJDBCReturnValue(this, "supportsResultSetType", new Boolean(bl));
        return bl;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsResultSetConcurrency", new Object[]{new Integer(n), new Integer(n2)});
        boolean bl = this.supportsResultSetType(n) && n2 == 1007;
        this.mLog.logJDBCReturnValue(this, "supportsResultSetConcurrency", new Boolean(bl));
        return bl;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "ownUpdatesAreVisible", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "ownUpdatesAreVisible", new Boolean(bl));
        return bl;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "ownDeletesAreVisible", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "ownDeletesAreVisible", new Boolean(bl));
        return bl;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "ownInsertsAreVisible", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "ownInsertsAreVisible", new Boolean(bl));
        return bl;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "othersUpdatesAreVisible", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "othersUpdatesAreVisible", new Boolean(bl));
        return bl;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "othersDeletesAreVisible", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "othersDeletesAreVisible", new Boolean(bl));
        return bl;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "othersInsertsAreVisible", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "othersInsertsAreVisible", new Boolean(bl));
        return bl;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updatesAreDetected", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "updatesAreDetected", new Boolean(bl));
        return bl;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "deletesAreDetected", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "deletesAreDetected", new Boolean(bl));
        return bl;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "insertsAreDetected", new Object[]{new Integer(n)});
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "insertsAreDetected", new Boolean(bl));
        return bl;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "supportsBatchUpdates", null);
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "supportsBatchUpdates", new Boolean(bl));
        return bl;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getUDTs", new Object[]{string, string2, string3, nArray});
        java.sql.Statement statement = this.connection.createStatement();
        ResultSet resultSet = ((Statement)statement).executeMetadataQuery("select null as TYPE_CAT, null as TYPE_SCHEM,  '' as TYPE_NAME, '' as CLASS_NAME, cast (2001 as char(*)) as DATA_TYPE, '' as REMARKS from systable where true=false");
        this.mLog.logJDBCReturnValue(this, "getUDTs", resultSet);
        return resultSet;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }
}

