/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.ResultSetMetaData;
import transbase.jdbc.SQLWarningQueue;
import transbase.jdbc.Statement;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBTypeMapEntry;
import transbase.jdbc.TBTypeProperties;
import transbase.tbx.TBException;
import transbase.tbx.TBXCursor;
import transbase.tbx.TBXCursorIf;
import transbase.tbx.types.helpers.TSpec;
import transbase.tbx.util.TBXMaxRowCursor;

public class ResultSet
implements java.sql.ResultSet {
    private static final String className = "transbase.jdbc.ResultSet";
    private ConnectionControl connectionControl;
    private TBXCursorIf cursor;
    private boolean wasNull = false;
    private int maxRows;
    private int maxFieldSize;
    private String cursorName;
    private Vector streams = new Vector();
    private boolean allFetched = false;
    private int mTotalRows = -1;
    private boolean isMetaDataResult = false;
    private boolean isClosed = false;
    private SQLWarningQueue mWarningQueue = new SQLWarningQueue();
    private Statement mParentStatement;
    private int mFetchDirection;
    private int mFetchSize;
    private int mType;
    private int mConcurrencyType;
    private TBJDBCLog mLog;

    public ResultSet(ConnectionControl connectionControl, TBXCursor tBXCursor, int n, int n2, String string, Statement statement, TBJDBCLog tBJDBCLog) throws SQLException {
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{connectionControl, tBXCursor, new Integer(n), new Integer(n2), string});
        this.connectionControl = connectionControl;
        this.maxRows = n;
        this.cursor = n > 0 ? new TBXMaxRowCursor(tBXCursor, n) : tBXCursor;
        this.connectionControl.addCursor(this.cursor, string);
        this.maxFieldSize = n2;
        this.cursorName = string;
        this.mParentStatement = statement;
        this.setFetchDirection(this.mParentStatement.getFetchDirection());
        this.mFetchSize = this.mParentStatement.getFetchSize();
        this.mType = this.mParentStatement.getResultSetType();
        this.mConcurrencyType = this.mParentStatement.getResultSetConcurrency();
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    protected void setMetaDataResult(boolean bl) {
        this.isMetaDataResult = bl;
    }

    private boolean chkNull(int n) throws SQLException {
        this.wasNull = this.cursor.isNull(n);
        return this.wasNull;
    }

    private boolean containsBlobColumns() throws SQLException {
        int n = this.cursor.getColumnCount();
        for (int i = 1; i < n; ++i) {
            if (this.cursor.getColumnTBType(i) != 13) continue;
            return true;
        }
        return false;
    }

    private void clearStreamPool() throws SQLException {
        int n = this.streams.size();
        for (int i = n - 1; i >= 0; --i) {
            try {
                ((InputStream)this.streams.elementAt(i)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streams.removeElementAt(i);
        }
    }

    public boolean next() throws SQLException {
        boolean bl;
        this.mLog.logJDBCMethodCall(this, "next", null);
        this.clearStreamPool();
        boolean bl2 = bl = !this.allFetched;
        if (bl) {
            bl = this.cursor.next();
        }
        if (!(bl || this.isScrollable() || this.allFetched)) {
            this.cursor.close(true);
            this.connectionControl.removeCursor(this.cursor);
            this.connectionControl.tryAutoCommit(4);
            this.allFetched = true;
        }
        this.mLog.logJDBCReturnValue(this, "next", new Boolean(bl));
        return bl;
    }

    public void close() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "close", null);
        if (!this.isClosed && !this.cursor.isClosed()) {
            this.cursor.close(true);
            this.connectionControl.removeCursor(this.cursor);
            this.connectionControl.tryAutoCommit(4);
        }
        this.isClosed = true;
        this.allFetched = true;
        this.mLog.logJDBCReturnValue(this, "close", null);
    }

    public boolean wasNull() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "wasNull", null);
        boolean bl = this.wasNull;
        this.mLog.logJDBCReturnValue(this, "wasNull", new Boolean(bl));
        return bl;
    }

    public String getString(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getString", new Object[]{new Integer(n)});
        String string = null;
        if (!this.chkNull(n)) {
            string = this.cursor.getObject(n).getString();
        }
        this.mLog.logJDBCReturnValue(this, "getString", string);
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBoolean", new Object[]{new Integer(n)});
        boolean bl = false;
        if (!this.chkNull(n)) {
            bl = this.cursor.getObject(n).getBoolean();
        }
        this.mLog.logJDBCReturnValue(this, "getBoolean", new Boolean(bl));
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getByte", new Object[]{new Integer(n)});
        byte by = 0;
        if (!this.chkNull(n)) {
            by = this.cursor.getObject(n).getByte();
        }
        this.mLog.logJDBCReturnValue(this, "getByte", new Byte(by));
        return by;
    }

    public short getShort(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getShort", new Object[]{new Integer(n)});
        short s = 0;
        if (!this.chkNull(n)) {
            s = this.cursor.getObject(n).getShort();
        }
        this.mLog.logJDBCReturnValue(this, "getShort", new Short(s));
        return s;
    }

    public int getInt(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getInt", new Object[]{new Integer(n)});
        int n2 = 0;
        if (!this.chkNull(n)) {
            n2 = this.cursor.getObject(n).getInt();
        }
        this.mLog.logJDBCReturnValue(this, "getInt", new Integer(n2));
        return n2;
    }

    public long getLong(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getLong", new Object[]{new Integer(n)});
        long l = 0L;
        if (!this.chkNull(n)) {
            l = this.cursor.getObject(n).getLong();
        }
        this.mLog.logJDBCReturnValue(this, "getLong", new Long(l));
        return l;
    }

    public float getFloat(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getFloat", new Object[]{new Integer(n)});
        float f = 0.0f;
        if (!this.chkNull(n)) {
            f = this.cursor.getObject(n).getFloat();
        }
        this.mLog.logJDBCReturnValue(this, "getFloat", new Float(f));
        return f;
    }

    public double getDouble(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDouble", new Object[]{new Integer(n)});
        double d = 0.0;
        if (!this.chkNull(n)) {
            d = this.cursor.getObject(n).getDouble();
        }
        this.mLog.logJDBCReturnValue(this, "getDouble", new Double(d));
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBigDecimal", new Object[]{new Integer(n), new Integer(n2)});
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        this.mLog.logJDBCReturnValue(this, "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBytes", new Object[]{new Integer(n)});
        byte[] byArray = null;
        if (!this.chkNull(n)) {
            byArray = this.cursor.getObject(n).getBytes();
        }
        this.mLog.logJDBCReturnValue(this, "getBytes", byArray);
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDate", new Object[]{new Integer(n)});
        Date date = null;
        if (!this.chkNull(n)) {
            date = this.cursor.getObject(n).getDate();
        }
        this.mLog.logJDBCReturnValue(this, "getDate", date);
        return date;
    }

    public Time getTime(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTime", new Object[]{new Integer(n)});
        Time time = this.getTime(n, Calendar.getInstance());
        this.mLog.logJDBCReturnValue(this, "getTime", time);
        return time;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTimestamp", new Object[]{new Integer(n)});
        Timestamp timestamp = null;
        if (!this.chkNull(n)) {
            timestamp = this.cursor.getObject(n).getTimestamp();
        }
        this.mLog.logJDBCReturnValue(this, "getTimestamp", timestamp);
        return timestamp;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getAsciiStream", new Object[]{new Integer(n)});
        InputStream inputStream = null;
        if (!this.chkNull(n)) {
            inputStream = this.cursor.getObject(n).getAsciiStream();
        }
        this.streams.addElement(inputStream);
        this.mLog.logJDBCReturnValue(this, "getAsciiStream", inputStream);
        return inputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getUnicodeStream", new Object[]{new Integer(n)});
        InputStream inputStream = null;
        if (!this.chkNull(n)) {
            inputStream = this.cursor.getObject(n).getUnicodeStream();
        }
        this.streams.addElement(inputStream);
        this.mLog.logJDBCReturnValue(this, "getUnicodeStream", inputStream);
        return inputStream;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBinaryStream", new Object[]{new Integer(n)});
        InputStream inputStream = null;
        if (!this.chkNull(n)) {
            inputStream = this.cursor.getObject(n).getBinaryStream();
        }
        this.streams.addElement(inputStream);
        this.mLog.logJDBCReturnValue(this, "getBinaryStream", inputStream);
        return inputStream;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getWarnings", null);
        SQLWarning sQLWarning = this.mWarningQueue.getWarnings();
        this.mLog.logJDBCReturnValue(this, "getWarnings", sQLWarning);
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getWarnings", null);
        this.mWarningQueue.clearWarnings();
        this.mLog.logJDBCReturnValue(this, "getWarnings", null);
    }

    protected SQLWarningQueue getWarningQueue() {
        return this.mWarningQueue;
    }

    public String getCursorName() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCursorName", null);
        this.mLog.logJDBCReturnValue(this, "getCursorName", this.cursorName);
        return this.cursorName;
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMetaData", null);
        if (this.isClosed) {
            throw new TBException(30004);
        }
        ResultSetMetaData resultSetMetaData = new ResultSetMetaData(this.cursor.getQueryDescriptor(), this.mLog);
        this.mLog.logJDBCReturnValue(this, "getMetaData", resultSetMetaData);
        return resultSetMetaData;
    }

    public Object getObject(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getObject", new Object[]{new Integer(n)});
        Object object = null;
        if (!this.chkNull(n)) {
            TSpec tSpec = this.cursor.getTSpec(n);
            TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToJDBC(tSpec);
            if (tBTypeMapEntry == null) {
                object = this.cursor.getObject(n);
            } else {
                int n2 = tBTypeMapEntry.getJDBCType();
                switch (n2) {
                    case -1: 
                    case 1: 
                    case 12: {
                        object = this.getString(n);
                        break;
                    }
                    case 2: 
                    case 3: {
                        object = this.getBigDecimal(n);
                        break;
                    }
                    case -7: {
                        object = new Boolean(this.getBoolean(n));
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        object = new Integer(this.getInt(n));
                        break;
                    }
                    case -5: {
                        object = new Long(this.getLong(n));
                        break;
                    }
                    case 7: {
                        object = new Float(this.getFloat(n));
                        break;
                    }
                    case 6: 
                    case 8: {
                        object = new Double(this.getDouble(n));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        object = this.getBytes(n);
                        break;
                    }
                    case 91: {
                        object = this.getDate(n);
                        break;
                    }
                    case 92: {
                        object = this.getTime(n);
                        break;
                    }
                    case 93: {
                        object = this.getTimestamp(n);
                    }
                }
            }
        }
        this.mLog.logJDBCReturnValue(this, "getObject", object);
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "findColumn", new Object[]{string});
        for (int i = 1; i <= this.cursor.getColumnCount(); ++i) {
            if (!this.cursor.getColumnName(i).equals(string)) continue;
            this.mLog.logJDBCReturnValue(this, "findColumn", new Integer(i));
            return i;
        }
        throw TBException.getTBException(30007, string);
    }

    protected void finalize() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "finalize", null);
        if (!this.cursor.isClosed()) {
            this.cursor.close(false);
            this.connectionControl.removeCursor(this.cursor);
        }
        this.mLog.logJDBCReturnValue(this, "finalize", null);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCharacterStream", new Object[]{new Integer(n)});
        Reader reader = null;
        if (!this.chkNull(n)) {
            reader = this.cursor.getObject(n).getCharacterStream();
        }
        this.mLog.logJDBCReturnValue(this, "getCharacterStream", reader);
        return reader;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBigDecimal", new Object[]{new Integer(n)});
        BigDecimal bigDecimal = null;
        if (!this.chkNull(n)) {
            bigDecimal = this.cursor.getObject(n).getBigDecimal();
        }
        this.mLog.logJDBCReturnValue(this, "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isBeforeFirst", null);
        this.testScrollable();
        boolean bl = this.cursor.isBeforeFirst();
        this.mLog.logJDBCReturnValue(this, "isBeforeFirst", new Boolean(bl));
        return bl;
    }

    public boolean isAfterLast() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isAfterLast", null);
        this.testScrollable();
        boolean bl = this.cursor.isAfterLast();
        this.mLog.logJDBCReturnValue(this, "isAfterLast", new Boolean(bl));
        return bl;
    }

    public boolean isFirst() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isFirst", null);
        this.testScrollable();
        boolean bl = this.cursor.isFirst();
        this.mLog.logJDBCReturnValue(this, "isFirst", new Boolean(bl));
        return bl;
    }

    public boolean isLast() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isLast", null);
        this.testScrollable();
        boolean bl = this.cursor.isLast();
        this.mLog.logJDBCReturnValue(this, "isLast", new Boolean(bl));
        return bl;
    }

    public void beforeFirst() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "beforeFirst", null);
        this.testScrollable();
        this.clearStreamPool();
        this.cursor.beforeFirst();
        this.mLog.logJDBCReturnValue(this, "beforeFirst", null);
    }

    public void afterLast() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "afterLast", null);
        this.testScrollable();
        this.clearStreamPool();
        this.cursor.afterLast();
        this.mLog.logJDBCReturnValue(this, "afterLast", null);
    }

    public boolean first() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "first", null);
        this.testScrollable();
        boolean bl = this.absolute(1);
        this.mLog.logJDBCReturnValue(this, "first", new Boolean(bl));
        return bl;
    }

    public boolean last() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "last", null);
        this.testScrollable();
        boolean bl = this.absolute(-1);
        this.mLog.logJDBCReturnValue(this, "last", new Boolean(bl));
        return bl;
    }

    public int getRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getRow", null);
        int n = this.cursor.getRow();
        this.mLog.logJDBCReturnValue(this, "getRow", new Integer(n));
        return n;
    }

    public boolean absolute(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "absolute", new Object[]{new Integer(n)});
        this.testScrollable();
        this.clearStreamPool();
        boolean bl = this.cursor.absolute(n);
        this.mLog.logJDBCReturnValue(this, "absolute", new Boolean(bl));
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "relative", new Object[]{new Integer(n)});
        this.testScrollable();
        this.clearStreamPool();
        boolean bl = this.cursor.relative(n);
        this.mLog.logJDBCReturnValue(this, "relative", new Boolean(bl));
        return bl;
    }

    public boolean previous() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "previous", null);
        this.testScrollable();
        this.clearStreamPool();
        boolean bl = this.cursor.previous();
        this.mLog.logJDBCReturnValue(this, "previous", new Boolean(bl));
        return bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        short s;
        this.mLog.logJDBCMethodCall(this, "setFetchDirection", new Object[]{new Integer(n)});
        this.mFetchDirection = n;
        switch (n) {
            case 1000: {
                s = 1;
                break;
            }
            case 1001: {
                s = 0;
                break;
            }
            default: {
                s = -1;
            }
        }
        this.cursor.setFetchDirection(s);
        this.mLog.logJDBCReturnValue(this, "setFetchDirection", null);
    }

    public int getFetchDirection() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getFetchDirection", null);
        this.mLog.logJDBCReturnValue(this, "getFetchDirection", new Integer(this.mFetchDirection));
        return this.mFetchDirection;
    }

    private int getMaxRows() {
        return this.maxRows;
    }

    public void setFetchSize(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setFetchSize", new Object[]{new Integer(n)});
        int n2 = this.getMaxRows();
        if (n < 0 || n2 > 0 && n > n2) {
            throw TBException.getTBException(30202, new String[]{Integer.toString(n)});
        }
        this.mFetchSize = n;
        this.mLog.logJDBCReturnValue(this, "setFetchSize", null);
    }

    public int getFetchSize() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getFetchSize", null);
        this.mLog.logJDBCReturnValue(this, "getFetchSize", new Integer(this.mFetchSize));
        return this.mFetchSize;
    }

    public int getType() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getType", null);
        this.mLog.logJDBCReturnValue(this, "getType", new Integer(this.mType));
        return this.mType;
    }

    public int getConcurrency() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getConcurrency", null);
        this.mLog.logJDBCReturnValue(this, "getConcurrency", new Integer(this.mConcurrencyType));
        return this.mConcurrencyType;
    }

    public boolean rowUpdated() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "rowUpdated", null);
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "rowUpdated", new Boolean(bl));
        return bl;
    }

    public boolean rowInserted() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "rowInserted", null);
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "rowInserted", new Boolean(bl));
        return bl;
    }

    public boolean rowDeleted() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "rowDeleted", null);
        boolean bl = false;
        this.mLog.logJDBCReturnValue(this, "rowDeleted", new Boolean(bl));
        return bl;
    }

    public void updateNull(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateNull", new Object[]{new Integer(n)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateNull", null);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateBoolean", new Object[]{new Integer(n), new Boolean(bl)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateBoolean", null);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateByte", new Object[]{new Integer(n), new Byte(by)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateByte", null);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateShort", new Object[]{new Integer(n), new Short(s)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateShort", null);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateInt", new Object[]{new Integer(n), new Integer(n2)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateInt", null);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateLong", new Object[]{new Integer(n), new Long(l)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateLong", null);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateFloat", new Object[]{new Integer(n), new Float(f)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateFloat", null);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateDouble", new Object[]{new Integer(n), new Double(d)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateDouble", null);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateBigDecimal", new Object[]{new Integer(n), bigDecimal});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateBigDecimal", null);
    }

    public void updateString(int n, String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateString", new Object[]{new Integer(n), string});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateString", null);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateBytes", new Object[]{new Integer(n), byArray});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateBytes", null);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateDate", new Object[]{new Integer(n), date});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateDate", null);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateTime", new Object[]{new Integer(n), time});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateTime", null);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateTimestamp", new Object[]{new Integer(n), timestamp});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateTimestamp", null);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateAsciiStream", new Object[]{new Integer(n), inputStream, new Integer(n2)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateAsciiStream", null);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateBinaryStream", new Object[]{new Integer(n), inputStream, new Integer(n2)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateBinaryStream", null);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateCharacterStream", new Object[]{new Integer(n), reader, new Integer(n2)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateCharacterStream", null);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateObject", new Object[]{new Integer(n), object, new Integer(n2)});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateObject", null);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateObject", new Object[]{new Integer(n), object});
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateObject", null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "insertRow", null);
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "insertRow", null);
    }

    public void updateRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "updateRow", null);
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "updateRow", null);
    }

    public void deleteRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "deleteRow", null);
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "deleteRow", null);
    }

    public void refreshRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "refreshRow", null);
        this.mLog.logJDBCReturnValue(this, "refreshRow", null);
    }

    public void cancelRowUpdates() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "cancelRowUpdates", null);
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "cancelRowUpdates", null);
    }

    public void moveToInsertRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "moveToInsertRow", null);
        this.testUpdatable();
        this.mLog.logJDBCReturnValue(this, "moveToInsertRow", null);
    }

    public void moveToCurrentRow() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "moveToCurrentRow", null);
        this.testScrollable();
        this.mLog.logJDBCReturnValue(this, "moveToCurrentRow", null);
    }

    public java.sql.Statement getStatement() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getStatement", null);
        Statement statement = this.mParentStatement;
        this.mLog.logJDBCReturnValue(this, "getStatement", statement);
        return statement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getObject", new Object[]{new Integer(n), map});
        Object var4_3 = null;
        this.mLog.logJDBCReturnValue(this, "getObject", var4_3);
        return var4_3;
    }

    public Ref getRef(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getRef", new Object[]{new Integer(n)});
        Ref ref = null;
        if (!this.chkNull(n)) {
            ref = this.cursor.getObject(n).getRef();
        }
        this.mLog.logJDBCReturnValue(this, "getRef", ref);
        return ref;
    }

    public Blob getBlob(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBlob", new Object[]{new Integer(n)});
        Blob blob = null;
        if (!this.chkNull(n)) {
            blob = this.cursor.getObject(n).getBlob();
        }
        this.mLog.logJDBCReturnValue(this, "getBlob", blob);
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getClob", new Object[]{new Integer(n)});
        Clob clob = null;
        if (!this.chkNull(n)) {
            clob = this.cursor.getObject(n).getClob();
        }
        this.mLog.logJDBCReturnValue(this, "getClob", clob);
        return clob;
    }

    public Array getArray(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getArray", new Object[]{new Integer(n)});
        Array array = null;
        if (!this.chkNull(n)) {
            array = this.cursor.getObject(n).getArray();
        }
        this.mLog.logJDBCReturnValue(this, "getArray", array);
        return array;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDate", new Object[]{new Integer(n), calendar});
        Date date = this.getDate(n);
        this.mLog.logJDBCReturnValue(this, "getDate", date);
        return date;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTime", new Object[]{new Integer(n), calendar});
        Time time = null;
        if (!this.chkNull(n)) {
            time = this.cursor.getObject(n).getTime(calendar);
        }
        this.mLog.logJDBCReturnValue(this, "getTime", time);
        return time;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTimestamp", new Object[]{new Integer(n), calendar});
        Timestamp timestamp = this.getTimestamp(n);
        this.mLog.logJDBCReturnValue(this, "getTimestamp", timestamp);
        return timestamp;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    protected static void testFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw TBException.getTBException(30200, Integer.toString(n));
        }
    }

    private void testUpdatable() throws SQLException {
        if (this.getConcurrency() == 1007) {
            throw new TBException(30207);
        }
    }

    private boolean isScrollable() throws SQLException {
        int n = this.getType();
        return n == 1004 || n == 1005;
    }

    private void testScrollable() throws SQLException {
        if (!this.isScrollable()) {
            throw new TBException(30204);
        }
    }

    protected static String getTypeDesc(int n) {
        switch (n) {
            case 1003: {
                return "'forward only'";
            }
            case 1004: {
                return "'scroll insensitive'";
            }
            case 1005: {
                return "'scroll sensitive'";
            }
        }
        return Integer.toString(n);
    }

    protected static String getConcurrencyDesc(int n) {
        switch (n) {
            case 1007: {
                return "'read only'";
            }
            case 1008: {
                return "'updatable'";
            }
        }
        return Integer.toString(n);
    }
}

