/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.SQLException;
import java.util.Vector;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBTypeMapEntry;
import transbase.jdbc.TBTypeProperties;
import transbase.tbx.types.TypeInfo;
import transbase.tbx.types.helpers.QueryDescriptor;
import transbase.tbx.types.helpers.TSpec;

public class ResultSetMetaData
implements java.sql.ResultSetMetaData {
    public static final int columnNoNulls = 0;
    public static final int columnNullable = 0;
    public static final int columnNullableUnknown = 1;
    private QueryDescriptor mQueryDescriptor;
    private Vector mInfoVector = new Vector();
    private TBJDBCLog mLog;

    public ResultSetMetaData(QueryDescriptor queryDescriptor, TBJDBCLog tBJDBCLog) throws SQLException {
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{queryDescriptor});
        this.mQueryDescriptor = queryDescriptor;
        int n = this.mQueryDescriptor.getAttrNo();
        this.mInfoVector.setSize(this.getColumnCount());
        for (int i = 1; i <= n; ++i) {
            TypeInfo typeInfo = TypeInfo.createTypeInfo(queryDescriptor.getTspec(i));
            this.mInfoVector.setElementAt(typeInfo, i - 1);
        }
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    private TypeInfo getTypeInfo(int n) throws SQLException {
        return (TypeInfo)this.mInfoVector.elementAt(n - 1);
    }

    public int getColumnCount() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnCount", null);
        int n = this.mQueryDescriptor.getAttrNo();
        this.mLog.logJDBCReturnValue(this, "getColumnCount", new Integer(n));
        return n;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isAutoIncrement", new Object[]{new Integer(n)});
        boolean bl = this.getTypeInfo(n).getAutoIncrement();
        this.mLog.logJDBCReturnValue(this, "isAutoIncrement", new Boolean(bl));
        return bl;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isCaseSensitive", new Object[]{new Integer(n)});
        boolean bl = this.getTypeInfo(n).getCaseSensitive();
        this.mLog.logJDBCReturnValue(this, "isCaseSensitive", new Boolean(bl));
        return bl;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isSearchable", new Object[]{new Integer(n)});
        int n2 = this.getTypeInfo(n).getSearchable();
        boolean bl = n2 != 0;
        this.mLog.logJDBCReturnValue(this, "isSearchable", new Boolean(bl));
        return bl;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isCurrency", new Object[]{new Integer(n)});
        int n2 = this.getColumnType(n);
        boolean bl = this.getTypeInfo(n).getFixedPrecScale();
        this.mLog.logJDBCReturnValue(this, "isCurrency", new Boolean(bl));
        return bl;
    }

    public int isNullable(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isNullable", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "isNullable", new Integer(1));
        return 1;
    }

    public boolean isSigned(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isSigned", new Object[]{new Integer(n)});
        int n2 = this.getColumnType(n);
        boolean bl = !this.getTypeInfo(n).getUnsignedAttribute();
        this.mLog.logJDBCReturnValue(this, "isSigned", new Boolean(bl));
        return bl;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2;
        this.mLog.logJDBCMethodCall(this, "getColumnDisplaySize", new Object[]{new Integer(n)});
        TypeInfo typeInfo = this.getTypeInfo(n);
        int n3 = typeInfo.getTypeCode();
        switch (n3) {
            case 3: {
                n2 = this.getPrecision(n) + (this.getScale(n) > 0 ? 1 : 0);
                break;
            }
            default: {
                n2 = typeInfo.getPrecision();
            }
        }
        if (n2 == 0) {
            n2 = 10;
        }
        this.mLog.logJDBCReturnValue(this, "getColumnDisplaySize", new Integer(n2));
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnLabel", new Object[]{new Integer(n)});
        String string = this.mQueryDescriptor.getFieldName(n);
        this.mLog.logJDBCReturnValue(this, "getColumnLabel", string);
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnName", new Object[]{new Integer(n)});
        String string = this.mQueryDescriptor.getFieldName(n);
        this.mLog.logJDBCReturnValue(this, "getColumnName", string);
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getSchemaName", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "getSchemaName", "");
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getPrecision", new Object[]{new Integer(n)});
        int n2 = this.getTypeInfo(n).getPrecision();
        this.mLog.logJDBCReturnValue(this, "getPrecision", new Integer(n2));
        return n2;
    }

    public int getScale(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getScale", new Object[]{new Integer(n)});
        int n2 = this.getTypeInfo(n).getScale();
        this.mLog.logJDBCReturnValue(this, "getScale", new Integer(n2));
        return n2;
    }

    public String getTableName(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTableName", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "getTableName", "");
        return "";
    }

    public String getCatalogName(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCatalogName", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "getCatalogName", "");
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnType", new Object[]{new Integer(n)});
        TSpec tSpec = this.mQueryDescriptor.getTspec(n);
        int n2 = 1111;
        TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToJDBC(tSpec);
        if (tBTypeMapEntry != null) {
            n2 = tBTypeMapEntry.getJDBCType();
        }
        this.mLog.logJDBCReturnValue(this, "getColumnType", new Integer(n2));
        return n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnTypeName", new Object[]{new Integer(n)});
        String string = "";
        string = this.getTypeInfo(n).getTypeName();
        this.mLog.logJDBCReturnValue(this, "getColumnTypeName", string);
        return string;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isReadOnly", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "isReadOnly", new Boolean(false));
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isWritable", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "isWritable", new Boolean(true));
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isDefinitelyWritable", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "isDefinitelyWritable", new Boolean(true));
        return this.isWritable(n);
    }

    public String getColumnClassName(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getColumnClassName", new Object[]{new Integer(n)});
        this.mLog.logJDBCReturnValue(this, "getColumnClassName", null);
        return null;
    }
}

