/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import transbase.tbx.TBLog;

public class TBJDBCLog
extends TBLog {
    private static final int LOG_JDBC_CALL = 100;
    private static final int LOG_JDBC_RETURN = 101;
    private static boolean JDBCCallLogging = true;
    private static boolean JDBCReturnValues = true;
    private boolean myJDBCCallLogging = JDBCCallLogging;
    private boolean myJDBCReturnValues = JDBCReturnValues;
    private boolean controledByDatasource = false;

    public void setMyJDBCCallLogging(boolean bl) {
        this.myJDBCCallLogging = bl;
        this.logSwitchChanged(100, bl);
    }

    public void setMyJDBCReturnValueLogging(boolean bl) {
        this.myJDBCReturnValues = bl;
        this.logSwitchChanged(101, bl);
    }

    public static void setJDBCCallLogging(boolean bl) {
        JDBCCallLogging = bl;
    }

    public static void setJDBCReturnValueLogging(boolean bl) {
        JDBCReturnValues = bl;
    }

    public void logJDBCReturnValue(Object object, String string, Object object2) {
        if (!JDBCReturnValues || !this.loggingEnabled()) {
            return;
        }
        String string2 = "TB JDBC RETURN: ";
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(object.toString()))).append(string == null ? "" : ".".concat(String.valueOf(String.valueOf(string)))).append(" returns ").append(object2 == null ? "<void or null>" : object2.toString()))))));
        this.println(string2);
    }

    public void logJDBCMethodCall(Object object, String string, Object[] objectArray) {
        this.resetLog();
        if (!JDBCCallLogging || !this.loggingEnabled()) {
            return;
        }
        String string2 = "TB JDBC CALL  : ";
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(object.toString()))).append(string == null ? "" : ".".concat(String.valueOf(String.valueOf(string)))).append("("))))));
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = objectArray[i] == null ? String.valueOf(String.valueOf(string2)).concat("<null>") : String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(objectArray[i].toString())));
                if (i >= objectArray.length - 1) continue;
                string2 = String.valueOf(String.valueOf(string2)).concat(", ");
            }
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(")");
        this.println(string2);
    }

    public void logSwitchChanged(int n, boolean bl) {
        if (n >= 100) {
            String string = "TB LOGMETHOD: ";
            switch (n) {
                case 100: {
                    string = String.valueOf(String.valueOf(string)).concat("logging of JDBC method calls");
                    break;
                }
                case 101: {
                    string = String.valueOf(String.valueOf(string)).concat("logging of JDBC method return values");
                }
            }
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(bl ? " enabled" : " disabled")));
            this.println(string);
        } else {
            super.logSwitchChanged(n, bl);
        }
    }

    public void resetLog() {
        if (!this.controledByDatasource) {
            PrintStream printStream = DriverManager.getLogStream();
            if (printStream == null) {
                super.setLogStream(null);
            } else {
                super.setLogStream(new PrintWriter(printStream, true));
            }
        }
    }

    public void setDSLogStream(PrintWriter printWriter) {
        this.controledByDatasource = printWriter != null;
        this.setLogStream(printWriter);
    }
}

