/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.DatabaseMetaData;
import transbase.jdbc.SQLParser;
import transbase.jdbc.TBTypeMapEntry;
import transbase.jdbc.TBTypeProperties;
import transbase.tbx.TBException;
import transbase.tbx.TBURL;
import transbase.tbx.types.TBDatetime;

public class TBNativeSQL {
    private static Hashtable keyWords = new Hashtable();
    private static final int keyEscape = 1;
    private static final int keyFn = 2;
    private static final int keyD = 3;
    private static final int keyT = 4;
    private static final int keyTs = 5;
    private static final int keyPar = 6;
    private static final int keyCall = 7;
    private static final int keyOj = 8;
    private static final int fnConcat = 100;
    private static final int fnLocate = 101;
    private static final int fnSubstring = 102;
    private static final int fnLength = 103;
    private static final int fnUcase = 104;
    private static final int fnLcase = 105;
    private static final int fnLtrim = 106;
    private static final int fnRtrim = 107;
    private static final int fnReplace = 108;
    private static final int fnRepeat = 109;
    private static final int fnSpace = 110;
    private static final int fnRight = 111;
    private static final int fnLeft = 112;
    private static final int fnInsert = 113;
    private static final int fnNow = 200;
    private static final int fnDayofmonth = 201;
    private static final int fnHour = 202;
    private static final int fnMinute = 203;
    private static final int fnMonth = 204;
    private static final int fnSecond = 205;
    private static final int fnYear = 206;
    private static final int fnDayofweek = 207;
    private static final int fnQuarter = 208;
    private static final int fnMonthname = 209;
    private static final int fnDayname = 210;
    private static final int fnCurdate = 211;
    private static final int fnCurtime = 212;
    private static final int fnTimestampadd = 213;
    private static final int fnTimestampdiff = 214;
    private static final int fnIfnull = 300;
    private static final int fnUser = 301;
    private static final int fnDatabase = 302;
    private static final int fnConvert = 400;
    private static final String standardEscapeCharacter = "\\";
    private String escapeCharacter;
    private Vector openingBrackets = new Vector();
    private String javaSQL;
    private String nativeSQL = "";
    private boolean inString = false;
    private boolean inComment = false;
    private int escapeBracketCount = 0;
    private String currentBuffer = "";
    private String lastToken = "";
    private ConnectionControl mConnectionControl;
    private DatabaseMetaData mDatabaseMetaData = null;

    public TBNativeSQL(SQLParser sQLParser, ConnectionControl connectionControl) throws SQLException {
        this.mConnectionControl = connectionControl;
        this.javaSQL = sQLParser.getOriginalStatement();
        this.escapeCharacter = this.getEscapeCharacter();
        this.scan(sQLParser);
    }

    public TBNativeSQL(String string, ConnectionControl connectionControl) throws SQLException {
        this.mConnectionControl = connectionControl;
        this.javaSQL = string;
        this.escapeCharacter = this.getEscapeCharacter();
        this.scan(new SQLParser(string));
    }

    public TBNativeSQL(String string, String string2, ConnectionControl connectionControl) throws SQLException {
        this.mConnectionControl = connectionControl;
        this.javaSQL = string;
        this.escapeCharacter = string2;
        this.scan(new SQLParser(string));
    }

    public String getNativeSQL() {
        return this.nativeSQL;
    }

    private int keyVal(String string) {
        Integer n = (Integer)keyWords.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    private String evaluateEscapeSequence(String string) throws SQLException {
        string = string.trim();
        int n = string.indexOf(" ");
        String string2 = "";
        String string3 = "";
        if (n >= 0) {
            string2 = string.substring(0, n).toLowerCase();
            string3 = string.substring(n + 1, string.length()).trim();
        }
        String string4 = "";
        int n2 = this.keyVal(string2);
        switch (n2) {
            case 1: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                int n3;
                int n4 = string3.length();
                if (!string3.substring(0, 1).equals("'") || !string3.substring(n4 - 1, n4).equals("'")) {
                    throw TBException.getTBException(30013, new String[]{string});
                }
                string3 = string3.substring(1, n4 - 1);
                int n5 = n2 == 3 ? 91 : (n3 = n2 == 4 ? 92 : 93);
                if (n3 == 93 && string3.trim().indexOf(32) < 0) {
                    n3 = string3.indexOf(45) > 0 ? 91 : 92;
                }
                try {
                    string4 = TBDatetime.getFromLiteral(string3, n3).getTBLiteral();
                    break;
                }
                catch (Exception exception) {
                    throw TBException.getTBException(30013, new String[]{string});
                }
            }
            case 2: {
                string4 = this.evaluateFunctionSequence(string3);
                break;
            }
            case 6: {
                n = string3.indexOf("=");
                if (n < 0) {
                    throw TBException.getTBException(30013, new String[]{string});
                }
                string3 = string3.substring(n + 1, string3.length()).trim();
                n = string3.indexOf("(");
                string3 = n >= 0 ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string3.substring(0, n + 1)))).append("?").append(string3.substring(n + 1, string3.length()).trim().startsWith(")") ? "" : ",").append(string3.substring(n + 1, string3.length()).trim()))) : String.valueOf(String.valueOf(string3)).concat("(?)");
                string4 = new TBNativeSQL(string3, this.escapeCharacter, this.mConnectionControl).getNativeSQL();
                break;
            }
            case 7: {
                if (string3.indexOf("(") == -1) {
                    string = String.valueOf(String.valueOf(string)).concat("()");
                }
                string4 = new TBNativeSQL(string, this.escapeCharacter, this.mConnectionControl).getNativeSQL();
                break;
            }
            case 8: {
                string4 = new TBNativeSQL(string3, this.escapeCharacter, this.mConnectionControl).getNativeSQL();
                break;
            }
            default: {
                throw TBException.getTBException(30013, new String[]{string});
            }
        }
        return String.valueOf(String.valueOf(new StringBuffer(" ").append(string4).append(" ")));
    }

    private String evaluateFunctionSequence(String string) throws SQLException {
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "'()-\n,", true);
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string5 = stringTokenizer.nextToken();
            if (!bl2 && string5.equals("'")) {
                boolean bl3 = bl = !bl;
            }
            if (!bl2 && !bl && string5.equals("-") && string4.equals("-")) {
                bl2 = true;
            }
            if (string5.equals("\n") && bl2) {
                bl2 = false;
            }
            if (!bl2 && !bl && string5.equals("(")) {
                if (n == 0) {
                    string3 = string2;
                    string2 = "";
                }
                ++n;
            }
            if (!bl2 && !bl && string5.equals(")") && --n == 0) {
                if (stringTokenizer.hasMoreTokens()) {
                    throw TBException.getTBException(30013, new String[]{string});
                }
                if (string2.substring(1, string2.length()).trim().length() > 0) {
                    n2 = vector.size();
                    vector.setSize(n2 + 1);
                    string2 = string2.substring(1, string2.length());
                    vector.setElementAt(string2.trim(), n2);
                    string2 = "";
                }
            }
            if (!bl2 && !bl && string5.equals(",") && n == 1) {
                n2 = vector.size();
                vector.setSize(n2 + 1);
                string2 = string2.substring(1, string2.length());
                vector.setElementAt(string2.trim(), n2);
                string2 = "";
            }
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string5)));
            string4 = string5;
        }
        this.convertParameters(vector);
        return this.convertFunction(string3, vector);
    }

    private void convertParameters(Vector vector) throws SQLException {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            vector.setElementAt(new TBNativeSQL(string, this.escapeCharacter, this.mConnectionControl).getNativeSQL(), i);
        }
    }

    private void checkParameters(Vector vector, int n, String string) throws SQLException {
        if (vector.size() != n) {
            throw TBException.getTBException(30017, new String[]{string, Integer.toString(vector.size()), Integer.toString(n)});
        }
    }

    private String getParameter(Vector vector, int n) {
        return (String)vector.elementAt(n);
    }

    private String convertFunction(String string, Vector vector) throws SQLException {
        string = string.trim().toLowerCase();
        int n = this.keyVal(string);
        String string2 = "";
        switch (n) {
            case 100: {
                this.checkParameters(vector, 2, "CONCAT");
                string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getParameter(vector, 0)))).append(" + ").append(this.getParameter(vector, 1))));
                break;
            }
            case 101: {
                if (vector.size() == 3) {
                    string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnPosition(this.getParameter(vector, 0), TBNativeSQL.fnSubstring(this.getParameter(vector, 1), this.getParameter(vector, 2)))).append(" + ((").append(this.getParameter(vector, 2)).append(")-1))")));
                    break;
                }
                this.checkParameters(vector, 2, "LOCATE");
                string2 = TBNativeSQL.fnPosition(this.getParameter(vector, 0), this.getParameter(vector, 1));
                break;
            }
            case 102: {
                this.checkParameters(vector, 3, "SUBSTRING");
                string2 = TBNativeSQL.fnSubstring(this.getParameter(vector, 0), this.getParameter(vector, 1), this.getParameter(vector, 2));
                break;
            }
            case 103: {
                this.checkParameters(vector, 1, "LENGTH");
                string2 = TBNativeSQL.fnSizeOf(this.getParameter(vector, 0));
                break;
            }
            case 104: {
                this.checkParameters(vector, 1, "UPPER");
                string2 = TBNativeSQL.fnUpper(this.getParameter(vector, 0));
                break;
            }
            case 105: {
                this.checkParameters(vector, 1, "LOWER");
                string2 = TBNativeSQL.fnLower(this.getParameter(vector, 0));
                break;
            }
            case 106: {
                this.checkParameters(vector, 1, "LTRIM");
                string2 = TBNativeSQL.fnTrim(this.getParameter(vector, 0), false);
                break;
            }
            case 107: {
                this.checkParameters(vector, 1, "RTRIM");
                string2 = TBNativeSQL.fnTrim(this.getParameter(vector, 0), true);
                break;
            }
            case 108: {
                this.checkParameters(vector, 3, "REPLACE");
                string2 = TBNativeSQL.fnReplace(this.getParameter(vector, 0), this.getParameter(vector, 1), this.getParameter(vector, 2));
                break;
            }
            case 109: {
                this.checkParameters(vector, 2, "REPEAT");
                string2 = TBNativeSQL.fnReplicate(this.getParameter(vector, 0), this.getParameter(vector, 1));
                break;
            }
            case 110: {
                this.checkParameters(vector, 1, "SPACE");
                string2 = TBNativeSQL.fnReplicate("' '", this.getParameter(vector, 0));
                break;
            }
            case 111: {
                this.checkParameters(vector, 2, "RIGHT");
                string2 = TBNativeSQL.fnSubstring(this.getParameter(vector, 0), String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnSizeOf(this.getParameter(vector, 0))).append(") - ").append(this.getParameter(vector, 1)).append(" + 1"))));
                break;
            }
            case 112: {
                this.checkParameters(vector, 2, "LEFT");
                string2 = TBNativeSQL.fnSubstring(this.getParameter(vector, 0), "1", this.getParameter(vector, 1));
                break;
            }
            case 113: {
                this.checkParameters(vector, 4, "INSERT");
                string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnSubstring(this.getParameter(vector, 0), "1", String.valueOf(String.valueOf(new StringBuffer("(").append(this.getParameter(vector, 1)).append(")-1"))))).append(") + (").append(this.getParameter(vector, 3)).append(") + (").append(TBNativeSQL.fnSubstring(this.getParameter(vector, 0), String.valueOf(String.valueOf(new StringBuffer("(").append(this.getParameter(vector, 1)).append(") + (").append(this.getParameter(vector, 2)).append(")"))))).append(")")));
                break;
            }
            case 200: {
                this.checkParameters(vector, 0, "NOW");
                string2 = TBNativeSQL.fnCurrentdate();
                break;
            }
            case 201: {
                this.checkParameters(vector, 1, "DAYOFMONTH");
                string2 = TBNativeSQL.fnDDof(this.getParameter(vector, 0));
                break;
            }
            case 202: {
                this.checkParameters(vector, 1, "HOUR");
                string2 = TBNativeSQL.fnHHof(this.getParameter(vector, 0));
                break;
            }
            case 203: {
                this.checkParameters(vector, 1, "MINUTE");
                string2 = TBNativeSQL.fnMIof(this.getParameter(vector, 0));
                break;
            }
            case 204: {
                this.checkParameters(vector, 1, "MONTH");
                string2 = TBNativeSQL.fnMOof(this.getParameter(vector, 0));
                break;
            }
            case 205: {
                this.checkParameters(vector, 1, "SECOND");
                string2 = TBNativeSQL.fnSSof(this.getParameter(vector, 0));
                break;
            }
            case 206: {
                this.checkParameters(vector, 1, "YEAR");
                string2 = TBNativeSQL.fnYYof(this.getParameter(vector, 0));
                break;
            }
            case 207: {
                this.checkParameters(vector, 1, "DAYOFWEEK");
                string2 = TBNativeSQL.fnSundayBasedWeekday(this.getParameter(vector, 0));
                break;
            }
            case 209: {
                this.checkParameters(vector, 1, "MONTHNAME");
                string2 = TBNativeSQL.fnMonthname(this.getParameter(vector, 0));
                break;
            }
            case 210: {
                this.checkParameters(vector, 1, "DAYNAME");
                string2 = TBNativeSQL.fnDayname(this.getParameter(vector, 0));
                break;
            }
            case 208: {
                this.checkParameters(vector, 1, "QUARTER");
                string2 = TBNativeSQL.fnQuarter(this.getParameter(vector, 0));
                break;
            }
            case 211: {
                this.checkParameters(vector, 0, "CURDATE");
                string2 = TBNativeSQL.fnCurdate();
                break;
            }
            case 212: {
                this.checkParameters(vector, 0, "CURTIME");
                string2 = TBNativeSQL.fnCurtime();
                break;
            }
            case 213: {
                this.checkParameters(vector, 3, "TIMESTAMPADD");
                string2 = this.fnTimestampadd(this.getParameter(vector, 0), this.getParameter(vector, 1), this.getParameter(vector, 2), true);
                break;
            }
            case 214: {
                this.checkParameters(vector, 3, "TIMESTAMPDIFF");
                string2 = this.fnTimestampadd(this.getParameter(vector, 0), this.getParameter(vector, 1), this.getParameter(vector, 2), false);
                break;
            }
            case 300: {
                this.checkParameters(vector, 2, "IFNULL");
                string2 = this.fnCoalesce(this.getParameter(vector, 0), this.getParameter(vector, 1));
                break;
            }
            case 301: {
                this.checkParameters(vector, 0, "USER");
                string2 = "USER";
                break;
            }
            case 302: {
                string2 = String.valueOf(String.valueOf(new StringBuffer("'").append(this.getDatabaseName()).append("'")));
                break;
            }
            case 400: {
                this.checkParameters(vector, 2, "CONVERT");
                string2 = this.fnCast(this.getParameter(vector, 0), this.getParameter(vector, 1));
                break;
            }
            default: {
                throw TBException.getTBException(30018, new String[]{string});
            }
        }
        return String.valueOf(String.valueOf(new StringBuffer(" ").append(string2).append(" ")));
    }

    private String getDatabaseName() throws SQLException {
        if (this.mDatabaseMetaData == null) {
            this.mDatabaseMetaData = (DatabaseMetaData)this.mConnectionControl.getJDBCConnection().getMetaData();
        }
        String string = this.mDatabaseMetaData.getURL();
        TBURL tBURL = new TBURL(string);
        return tBURL.getDatabase().toLowerCase();
    }

    private void scan(SQLParser sQLParser) throws SQLException {
        boolean bl = false;
        while (sQLParser.hasMoreTokens()) {
            int n = sQLParser.getTokenType();
            String string = sQLParser.nextToken();
            if (n == 4 && string.equalsIgnoreCase("like")) {
                bl = true;
            }
            if (n == 3) {
                string = this.evaluateEscapeSequence(string.substring(1, string.length() - 1));
            }
            if (bl) {
                if (n == 1) {
                    string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.getEscapeClause()).append(" ")));
                    bl = false;
                } else if (!(n == 5 || string.equalsIgnoreCase("sensitive") || string.equalsIgnoreCase("insensitive") || string.equalsIgnoreCase("like"))) {
                    throw TBException.getTBException(30016, new String[]{this.javaSQL});
                }
            }
            this.nativeSQL = String.valueOf(String.valueOf(this.nativeSQL)).concat(String.valueOf(String.valueOf(string)));
        }
    }

    private String getEscapeClause() {
        if (this.escapeCharacter.equals(standardEscapeCharacter)) {
            return "";
        }
        return String.valueOf(String.valueOf(new StringBuffer(" escape '").append(this.escapeCharacter).append("' ")));
    }

    private String getEscapeCharacter() throws SQLException {
        String string = this.javaSQL.trim();
        int n = string.length();
        if (string.length() == 0 || !string.substring(n - 1, n).equals("}")) {
            return standardEscapeCharacter;
        }
        for (int i = n - 2; i >= 0; --i) {
            if (!string.substring(i, i + 1).equals("{")) continue;
            String string2 = string.substring(i + 1, n - 1).trim();
            if (string2.length() < 6 || !string2.substring(0, 6).toLowerCase().equals("escape")) {
                return standardEscapeCharacter;
            }
            String string3 = string2.substring(6, string2.length()).trim();
            if (string3.length() != 3 || !string3.substring(0, 1).equals("'") || !string3.substring(2, 3).equals("'")) {
                throw TBException.getTBException(30013, new String[]{"escape"});
            }
            return string3.substring(1, 2);
        }
        return standardEscapeCharacter;
    }

    private static String fnPosition(String string, String string2) {
        return String.valueOf(String.valueOf(new StringBuffer("POSITION (").append(string).append(" IN ").append(string2).append(")")));
    }

    private static String fnSubstring(String string, String string2) {
        return String.valueOf(String.valueOf(new StringBuffer("SUBSTRING (").append(string).append(" FROM ").append(string2).append(")")));
    }

    private static String fnSubstring(String string, String string2, String string3) {
        return String.valueOf(String.valueOf(new StringBuffer("SUBSTRING (").append(string).append(" FROM ").append(string2).append(" FOR ").append(string3).append(")")));
    }

    private static String fnSizeOf(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("SIZE OF (").append(string).append(")")));
    }

    private static String fnUpper(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("UPPER (").append(string).append(")")));
    }

    private static String fnLower(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("LOWER (").append(string).append(")")));
    }

    private static String fnTrim(String string, boolean bl) {
        return String.valueOf(String.valueOf(new StringBuffer("TRIM (").append(bl ? "TRAILING" : "LEADING").append(" FROM ").append(string).append(")")));
    }

    private static String fnReplace(String string, String string2, String string3) {
        return String.valueOf(String.valueOf(new StringBuffer("REPLACE (").append(string2).append(" BY ").append(string3).append(" IN ").append(string).append(")")));
    }

    private static String fnReplicate(String string, String string2) {
        return String.valueOf(String.valueOf(new StringBuffer("REPEAT (").append(string).append(", ").append(string2).append(")")));
    }

    private static String fnCurrentdate() {
        return "CURRENTDATE";
    }

    private static String fnDDof(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("DD OF (").append(string).append(")")));
    }

    private static String fnYYof(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("YY OF (").append(string).append(")")));
    }

    private static String fnMOof(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("MO OF (").append(string).append(")")));
    }

    private static String fnHHof(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("HH OF (").append(string).append(")")));
    }

    private static String fnMIof(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("MI OF (").append(string).append(")")));
    }

    private static String fnSSof(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("SS OF (").append(string).append(")")));
    }

    private static String fnWeekday(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("WEEKDAY OF (").append(string).append(")")));
    }

    private static String fnSundayBasedWeekday(String string) {
        String string2 = String.valueOf(String.valueOf(new StringBuffer("((").append(TBNativeSQL.fnWeekday(string)).append(") + 1)")));
        return string2;
    }

    private static String fnQuarter(String string) {
        String string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnMOof(string)).append(")")));
        return String.valueOf(String.valueOf(new StringBuffer("(CASE WHEN ").append(string2).append(" between 1 and 3 THEN 1 ").append("WHEN ").append(string2).append(" between 4 and 6 THEN 2 ").append("WHEN ").append(string2).append(" between 7 and 9 THEN 3 ").append("WHEN ").append(string2).append(" between 10 and 12 THEN 4 ").append("ELSE null END)")));
    }

    private static String fnDayname(String string) {
        String string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnWeekday(string)).append(")")));
        return String.valueOf(String.valueOf(new StringBuffer("(CASE ").append(string2).append(" WHEN 0 THEN 'Sunday' ").append(" WHEN 1 THEN 'Monday' ").append(" WHEN 2 THEN 'Tuesday' ").append(" WHEN 3 THEN 'Wednesday' ").append(" WHEN 4 THEN 'Thursday' ").append(" WHEN 5 THEN 'Friday' ").append(" WHEN 6 THEN 'Saturday' ").append(" ELSE null END)")));
    }

    private static String fnMonthname(String string) {
        String string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnMOof(string)).append(")")));
        return String.valueOf(String.valueOf(new StringBuffer("(CASE ").append(string2).append(" WHEN 1 THEN 'January' ").append(" WHEN 2 THEN 'February' ").append(" WHEN 3 THEN 'March' ").append(" WHEN 4 THEN 'April' ").append(" WHEN 5 THEN 'May' ").append(" WHEN 6 THEN 'June' ").append(" WHEN 7 THEN 'July' ").append(" WHEN 8 THEN 'August' ").append(" WHEN 9 THEN 'September' ").append(" WHEN 10 THEN 'October' ").append(" WHEN 11 THEN 'November' ").append(" WHEN 12 THEN 'December' ").append(" ELSE null END)")));
    }

    private static String fnCurdate() {
        return String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnCurrentdate()).append(" CAST DATETIME [YY:DD])")));
    }

    private static String fnCurtime() {
        return String.valueOf(String.valueOf(new StringBuffer("(").append(TBNativeSQL.fnCurrentdate()).append(" CAST DATETIME [HH:SS])")));
    }

    private String getTBDateQual(String string) throws SQLException {
        if ((string = string.toUpperCase().trim()).equals("SQL_TSI_FRAC_SECOND")) {
            return "MS";
        }
        if (string.equals("SQL_TSI_SECOND")) {
            return "SS";
        }
        if (string.equals("SQL_TSI_MINUTE")) {
            return "MI";
        }
        if (string.equals("SQL_TSI_HOUR")) {
            return "HH";
        }
        if (string.equals("SQL_TSI_DAY")) {
            return "DD";
        }
        if (string.equals("SQL_TSI_WEEK")) {
            return "WEEK";
        }
        if (string.equals("SQL_TSI_MONTH")) {
            return "MO";
        }
        if (string.equals("SQL_TSI_QUARTER")) {
            return "QUARTER";
        }
        if (string.equals("SQL_TSI_YEAR")) {
            return "YEAR";
        }
        throw TBException.getTBException(30013, new String[]{string});
    }

    private String fnTimestampadd(String string, String string2, String string3, boolean bl) throws SQLException {
        String string4 = this.getTBDateQual(string);
        if (string4.equals("WEEK")) {
            string4 = "DD";
            string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(string2).append(")*7")));
        }
        if (string4.equals("QUARTER")) {
            string4 = "MO";
            string2 = String.valueOf(String.valueOf(new StringBuffer("(").append(string2).append(")*3")));
        }
        String string5 = String.valueOf(String.valueOf(new StringBuffer("TIMESPAN [").append(string4).append("] (").append(string2).append(")")));
        return String.valueOf(String.valueOf(new StringBuffer("((").append(string3).append(")").append(bl ? " + " : " - ").append(string5).append(")")));
    }

    private String fnCoalesce(String string, String string2) {
        return String.valueOf(String.valueOf(new StringBuffer("COALESCE(").append(string).append(", ").append(string2).append(")")));
    }

    private String fnCast(String string, String string2) throws SQLException {
        TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToTB(TBTypeProperties.getSQLType(string2));
        if (tBTypeMapEntry == null) {
            throw TBException.getTBException(30019, new String[]{string2});
        }
        String string3 = tBTypeMapEntry.getTBTypeInfo().getFullTypeDesc();
        return String.valueOf(String.valueOf(new StringBuffer("CAST (").append(string).append(" AS ").append(string3).append(")")));
    }

    static {
        keyWords.put("escape", new Integer(1));
        keyWords.put("fn", new Integer(2));
        keyWords.put("d", new Integer(3));
        keyWords.put("t", new Integer(4));
        keyWords.put("ts", new Integer(5));
        keyWords.put("?", new Integer(6));
        keyWords.put("call", new Integer(7));
        keyWords.put("oj", new Integer(8));
        keyWords.put("concat", new Integer(100));
        keyWords.put("locate", new Integer(101));
        keyWords.put("substring", new Integer(102));
        keyWords.put("length", new Integer(103));
        keyWords.put("ucase", new Integer(104));
        keyWords.put("lcase", new Integer(105));
        keyWords.put("ltrim", new Integer(106));
        keyWords.put("rtrim", new Integer(107));
        keyWords.put("replace", new Integer(108));
        keyWords.put("repeat", new Integer(109));
        keyWords.put("space", new Integer(110));
        keyWords.put("right", new Integer(111));
        keyWords.put("left", new Integer(112));
        keyWords.put("insert", new Integer(113));
        keyWords.put("now", new Integer(200));
        keyWords.put("dayofmonth", new Integer(201));
        keyWords.put("hour", new Integer(202));
        keyWords.put("minute", new Integer(203));
        keyWords.put("month", new Integer(204));
        keyWords.put("second", new Integer(205));
        keyWords.put("year", new Integer(206));
        keyWords.put("dayofweek", new Integer(207));
        keyWords.put("dayname", new Integer(210));
        keyWords.put("monthname", new Integer(209));
        keyWords.put("quarter", new Integer(208));
        keyWords.put("curdate", new Integer(211));
        keyWords.put("curtime", new Integer(212));
        keyWords.put("timestampadd", new Integer(213));
        keyWords.put("timestampdiff", new Integer(214));
        keyWords.put("ifnull", new Integer(300));
        keyWords.put("user", new Integer(301));
        keyWords.put("database", new Integer(302));
        keyWords.put("convert", new Integer(400));
    }
}

