/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import transbase.jdbc.JDBCTSpec;
import transbase.jdbc.TBTypeMapEntry;
import transbase.tbx.TBException;
import transbase.tbx.types.TypeToClass;
import transbase.tbx.types.helpers.CharEncodingFactory;
import transbase.tbx.types.helpers.TBObject;
import transbase.tbx.types.helpers.TSpec;

public class TBTypeProperties {
    private static Vector mDownMap = new Vector();
    private static Hashtable mUpMap = new Hashtable();
    public static final Object[][] jdbcIdentifiers;
    public static final int JAVA_OTHER = 0;
    public static final int JAVA_STRING = 1;
    public static final int JAVA_BIGDECIMAL = 2;
    public static final int JAVA_BOOLEAN = 3;
    public static final int JAVA_INTEGER = 4;
    public static final int JAVA_LONG = 5;
    public static final int JAVA_FLOAT = 6;
    public static final int JAVA_DOUBLE = 7;
    public static final int JAVA_BYTE_ARRAY = 8;
    public static final int JAVA_DATE = 9;
    public static final int JAVA_TIME = 10;
    public static final int JAVA_TIMESTAMP = 11;
    public static final int JAVA_BYTE = 12;
    public static final int JAVA_SHORT = 13;

    public static Vector getTypeDownMap() {
        return mDownMap;
    }

    public static Hashtable getTypeUpMap() {
        return mUpMap;
    }

    public static TBTypeMapEntry mapToTB(int n) {
        int n2 = mDownMap.size();
        for (int i = 0; i < n2; ++i) {
            TBTypeMapEntry tBTypeMapEntry = (TBTypeMapEntry)mDownMap.elementAt(i);
            if (tBTypeMapEntry.getJDBCType() != n) continue;
            return tBTypeMapEntry;
        }
        return null;
    }

    public static TBTypeMapEntry mapToJDBC(TSpec tSpec) {
        Vector vector = (Vector)mUpMap.get(new Integer(tSpec.getType()));
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            TBTypeMapEntry tBTypeMapEntry = (TBTypeMapEntry)vector.elementAt(i);
            if (tBTypeMapEntry.isGenericMapping()) {
                return tBTypeMapEntry;
            }
            TSpec tSpec2 = tBTypeMapEntry.getTypeSpec();
            if (tSpec.getHighf() != tSpec2.getHighf() || tSpec.getLowf() != tSpec2.getLowf() || tSpec.getPrecision() != tSpec2.getPrecision() || tSpec.getScale() != tSpec2.getScale() || tSpec.getStrPrec() != tSpec2.getStrPrec()) continue;
            return tBTypeMapEntry;
        }
        return null;
    }

    public static TBObject getPreferedTBObject(int n, CharEncodingFactory charEncodingFactory) throws SQLException {
        TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToTB(n);
        if (tBTypeMapEntry == null) {
            throw TBException.getTBException(30037, TBTypeProperties.getJDBCTypeName(n));
        }
        int n2 = tBTypeMapEntry.getTBType();
        return TypeToClass.getInstance(n2, charEncodingFactory);
    }

    public static int getSQLType(String string) {
        string = string.trim().toUpperCase();
        for (int i = 0; i < jdbcIdentifiers.length; ++i) {
            if (!((String)jdbcIdentifiers[i][1]).equals(string)) continue;
            return (Integer)jdbcIdentifiers[i][0];
        }
        return 1111;
    }

    public static String getJDBCTypeName(int n) {
        for (int i = 0; i < jdbcIdentifiers.length; ++i) {
            if ((Integer)jdbcIdentifiers[i][0] != n) continue;
            return (String)jdbcIdentifiers[i][1];
        }
        return "OTHER";
    }

    public static int getJavaClassCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 1;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 7;
        }
        if (object instanceof byte[]) {
            return 8;
        }
        if (object instanceof Date) {
            return 9;
        }
        if (object instanceof Time) {
            return 10;
        }
        if (object instanceof Timestamp) {
            return 11;
        }
        if (object instanceof Byte) {
            return 12;
        }
        if (object instanceof Short) {
            return 13;
        }
        return 0;
    }

    static {
        mDownMap.addElement(new TBTypeMapEntry(-6, 5, null));
        mDownMap.addElement(new TBTypeMapEntry(-6, 3, new JDBCTSpec(3, 0, 0, 3, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(5, 6, null));
        mDownMap.addElement(new TBTypeMapEntry(5, 3, new JDBCTSpec(3, 0, 0, 5, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(4, 1, null));
        mDownMap.addElement(new TBTypeMapEntry(4, 3, new JDBCTSpec(3, 0, 0, 10, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(-5, 3, new JDBCTSpec(3, 0, 0, 30, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(2, 3, null));
        mDownMap.addElement(new TBTypeMapEntry(3, 3, null));
        mDownMap.addElement(new TBTypeMapEntry(8, 2, null));
        mDownMap.addElement(new TBTypeMapEntry(6, 2, null));
        mDownMap.addElement(new TBTypeMapEntry(7, 7, null));
        mDownMap.addElement(new TBTypeMapEntry(1, 4, null));
        mDownMap.addElement(new TBTypeMapEntry(1, 12, null));
        mDownMap.addElement(new TBTypeMapEntry(12, 29, null));
        mDownMap.addElement(new TBTypeMapEntry(12, 4, new JDBCTSpec(4, 0, 0, 0, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(12, 12, new JDBCTSpec(12, 0, 0, 0, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(91, 8, new JDBCTSpec(8, 4, 6, 0, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(92, 8, new JDBCTSpec(8, 1, 3, 0, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(93, 8, new JDBCTSpec(8, 0, 6, 0, 0, 0)));
        mDownMap.addElement(new TBTypeMapEntry(-4, 13, null));
        mDownMap.addElement(new TBTypeMapEntry(-7, 11, null));
        mDownMap.addElement(new TBTypeMapEntry(-7, 5, null));
        Vector<TBTypeMapEntry> vector = new Vector<TBTypeMapEntry>();
        vector.addElement(new TBTypeMapEntry(-6, 5, null));
        mUpMap.put(new Integer(5), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(5, 6, null));
        mUpMap.put(new Integer(6), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(4, 1, null));
        mUpMap.put(new Integer(1), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(2, 3, null));
        mUpMap.put(new Integer(3), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(7, 7, null));
        mUpMap.put(new Integer(7), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(8, 2, null));
        mUpMap.put(new Integer(2), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(12, 4, new JDBCTSpec(4, 0, 0, 0, 0, 0)));
        vector.addElement(new TBTypeMapEntry(1, 4, null));
        mUpMap.put(new Integer(4), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(12, 29, null));
        mUpMap.put(new Integer(29), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(91, 8, new JDBCTSpec(8, 4, 6, 0, 0, 0)));
        vector.addElement(new TBTypeMapEntry(92, 8, new JDBCTSpec(8, 1, 3, 0, 0, 0)));
        vector.addElement(new TBTypeMapEntry(93, 8, new JDBCTSpec(8, 0, 6, 0, 0, 0)));
        mUpMap.put(new Integer(8), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(-7, 11, null));
        mUpMap.put(new Integer(11), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(12, 12, new JDBCTSpec(12, 0, 0, 0, 0, 0)));
        vector.addElement(new TBTypeMapEntry(1, 12, null));
        mUpMap.put(new Integer(12), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(-4, 13, null));
        mUpMap.put(new Integer(13), vector);
        vector = new Vector();
        vector.addElement(new TBTypeMapEntry(0, 15, null));
        mUpMap.put(new Integer(15), vector);
        jdbcIdentifiers = new Object[][]{{new Integer(-5), new String("BIGINT")}, {new Integer(-2), new String("BINARY")}, {new Integer(-7), new String("BIT")}, {new Integer(1), new String("CHAR")}, {new Integer(91), new String("DATE")}, {new Integer(3), new String("DECIMAL")}, {new Integer(8), new String("DOUBLE")}, {new Integer(6), new String("FLOAT")}, {new Integer(4), new String("INTEGER")}, {new Integer(-4), new String("LONGVARBINARY")}, {new Integer(-1), new String("LONGVARCHAR")}, {new Integer(7), new String("REAL")}, {new Integer(5), new String("SMALLINT")}, {new Integer(92), new String("TIME")}, {new Integer(93), new String("TIMESTAMP")}, {new Integer(-6), new String("TINYINT")}, {new Integer(-3), new String("VARBINARY")}, {new Integer(12), new String("VARCHAR")}};
    }
}

