/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx;

import java.sql.SQLException;
import transbase.tbx.TBError;
import transbase.tbx.TBStringParameters;

public class TBException
extends SQLException {
    private static final int PREFIX_SERVER = 0;
    private static final int PREFIX_CLIENT = 1;
    private static final int PREFIX_OUTBAND = 2;
    private boolean mHardErrorHandled = false;
    private boolean mIgnoreOnRequests = false;

    public TBException(int n) {
        super(TBException.prefixMessage(n, TBError.getErrorMsg(n), 1), TBError.getSQLState(n), n);
    }

    public TBException(int n, String string) {
        super(string, TBError.getSQLState(n), n);
    }

    public static TBException getTBException(int n, String string) {
        TBStringParameters tBStringParameters = new TBStringParameters(1);
        tBStringParameters.putStringParameter(0, string);
        return TBException.getTBException(n, tBStringParameters);
    }

    public static TBException getTBException(int n, String[] stringArray) {
        TBStringParameters tBStringParameters = new TBStringParameters(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            tBStringParameters.putStringParameter(i, stringArray[i]);
        }
        return TBException.getTBException(n, tBStringParameters);
    }

    public static TBException getTBException(int n, TBStringParameters tBStringParameters) {
        String string = TBError.getErrorMsg(n, tBStringParameters);
        string = TBException.prefixMessage(n, string, 1);
        return new TBException(n, string);
    }

    public boolean isHardError() {
        int n = this.getErrorCode();
        return n > 0 && n < 5000 || n == 30211;
    }

    public static TBException getTBServerException(int n, String string) {
        String string2 = TBException.prefixMessage(n, string, 0);
        return new TBException(n, string2);
    }

    public static TBException getTBOutbandException(int n, String string) {
        String string2 = TBException.prefixMessage(n, string, 2);
        return new TBException(n, string2);
    }

    private static String prefixMessage(int n, String string, int n2) {
        String string2;
        switch (n2) {
            case 1: {
                string2 = "TB Java Client error <";
                break;
            }
            case 0: {
                string2 = "TB Java Server error <";
                break;
            }
            case 2: {
                string2 = "TB Java Outband error <";
                break;
            }
            default: {
                string2 = "TB Java Client error <";
            }
        }
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n)).concat(">: "))));
        return String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string)));
    }

    public boolean getHardErrorHandled() {
        return this.mHardErrorHandled;
    }

    public void setHardErrorHandled(boolean bl) {
        this.mHardErrorHandled = bl;
    }

    public boolean getIgnoreOnRequests() {
        return this.mIgnoreOnRequests;
    }

    public void setIgnoreOnRequests(boolean bl) {
        this.mIgnoreOnRequests = bl;
    }
}

