/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class TBURL {
    private boolean isOldStyle = false;
    private boolean isValid = false;
    private boolean isTransbase = false;
    private String url = "";
    private String protocol = "";
    private String subprotocol = "";
    private String host = "";
    private String database = "";
    private int port = -1;
    private int tbServerPort = -1;
    private Properties mProperties = new Properties();

    public TBURL(String string) {
        if (string != null) {
            this.url = string;
            this.isValid = this.evaluateURLString(string);
            this.isTransbase = this.subprotocol.toLowerCase().equals("transbase") || this.subprotocol.toLowerCase().equals("default:connection");
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isTransbase() {
        return this.isTransbase;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSubProtocol() {
        return this.subprotocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getPort() {
        return this.port >= 0 ? this.port : 2024;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public int getTbServerPort() {
        int n = this.tbServerPort >= 0 ? this.tbServerPort : this.getPort() + 1;
        return n;
    }

    public void setTbServerPort(int n) {
        this.tbServerPort = n;
    }

    private void addProperty(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "= \t");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        this.mProperties.setProperty(string2, string3);
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    private boolean evaluateURLString(String string) {
        this.port = 2024;
        this.tbServerPort = 2025;
        try {
            String string2 = String.valueOf(String.valueOf("jdbc".toLowerCase())).concat(":");
            int n = string2.length();
            if (string.length() < n || !string.substring(0, n).toLowerCase().equals(string2)) {
                boolean bl = false;
                return bl;
            }
            this.protocol = "jdbc";
            String string3 = string.substring(n, string.length());
            string2 = "default:connection".toLowerCase();
            n = string2.length();
            if (string3.length() >= n && string3.substring(0, n).toLowerCase().equals(string2)) {
                this.subprotocol = "default:connection";
                ((Hashtable)this.mProperties).put("user", "");
                ((Hashtable)this.mProperties).put("password", "");
                ((Hashtable)this.mProperties).put("tbxlayer", "transbase.tbx.coman.TBXComanObjectFactory");
                boolean bl = true;
                return bl;
            }
            string2 = String.valueOf(String.valueOf("transbase".toLowerCase())).concat(":");
            n = string2.length();
            if (string3.length() < n || !string3.substring(0, n).toLowerCase().equals(string2)) {
                boolean bl = false;
                return bl;
            }
            this.subprotocol = "transbase";
            string3 = string3.substring(n, string3.length());
            this.isOldStyle = !string3.substring(0, 2).equals("//");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";", false);
            string3 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                this.addProperty(stringTokenizer.nextToken());
            }
            if (this.isOldStyle) {
                stringTokenizer = new StringTokenizer(string3, "@", false);
                this.database = stringTokenizer.nextToken();
                this.host = stringTokenizer.nextToken();
            } else {
                string3 = string3.substring(2, string3.length());
                stringTokenizer = new StringTokenizer(string3, "/", false);
                string3 = stringTokenizer.nextToken();
                this.database = stringTokenizer.nextToken();
                stringTokenizer = new StringTokenizer(string3, ":", false);
                this.host = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    this.port = Integer.parseInt(stringTokenizer.nextToken());
                }
                this.tbServerPort = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : this.getPort() + 1;
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHost());
    }

    public Socket getSocket() throws IOException, UnknownHostException {
        return new Socket(this.getInetAddress(), this.getPort());
    }

    public Socket getTbServerSocket() throws IOException, UnknownHostException {
        return new Socket(this.getInetAddress(), this.getTbServerPort());
    }

    public Socket getSocket(int n) throws IOException, UnknownHostException {
        return new Socket(this.getInetAddress(), n);
    }
}

