/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.coman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import transbase.tbx.coman.TBXComanOutputStream;
import transbase.tbx.coman.TBXComanSecurityManager;
import transbase.tbx.tuple.TBAttrDatetime;
import transbase.tbx.tuple.TBAttrTimespan;
import transbase.tbx.types.TBDatetime;
import transbase.tbx.types.TBNumeric;
import transbase.tbx.types.TBTimespan;

public final class TBXComanClassLoader
extends ClassLoader {
    private static final native Class getclass(String var0);

    private static final native Class getjars(String var0);

    public static final TBXComanOutputStream initJVM(boolean bl) {
        TBXComanOutputStream tBXComanOutputStream = new TBXComanOutputStream(bl);
        System.setOut(new PrintStream(tBXComanOutputStream));
        System.setErr(System.out);
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new TBXComanSecurityManager());
        }
        return tBXComanOutputStream;
    }

    public static final void exitJVM() {
        System.exit(1);
    }

    public final Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (clazz == null) {
            clazz = this.findLoadedClass(string);
        }
        if (clazz == null && (string.startsWith("java.") || string.startsWith("com.sun.tools.") || string.startsWith("transbase."))) {
            clazz = this.getParent().loadClass(string);
        }
        if (clazz == null) {
            clazz = TBXComanClassLoader.getclass(string);
        }
        if (clazz == null) {
            clazz = this.getParent().loadClass(string);
        }
        if (clazz == null) {
            clazz = this.findSystemClass(string);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public final Class findClass(String string) {
        return this.findLoadedClass(string);
    }

    public static final byte[] describe(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(new DataOutputStream(byteArrayOutputStream));
        throwable.printStackTrace(printStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected final void finalize() {
        System.out.println("finalize TBXComanClassLoader ".concat(String.valueOf(String.valueOf(this))));
    }

    public static final void cleanup(TBXComanClassLoader tBXComanClassLoader) {
        if (tBXComanClassLoader != null) {
            tBXComanClassLoader = null;
        }
        System.gc();
    }

    public final Class defineClass(String string, byte[] byArray, int n) {
        TBXComanClassLoader tBXComanClassLoader = new TBXComanClassLoader();
        return tBXComanClassLoader.defineClass(string, byArray, 0, n);
    }

    public final Class loadClassFromJar(String string, byte[] byArray) {
        try {
            JarInputStream jarInputStream = new JarInputStream(new DataInputStream(new ByteArrayInputStream(byArray)));
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null && !jarEntry.getName().equals(String.valueOf(String.valueOf(string)).concat(".class"))) {
                jarEntry = jarInputStream.getNextJarEntry();
            }
            if (jarEntry != null) {
                int n = 0;
                byte[] byArray2 = new byte[1000000];
                while ((byArray2[n++] = (byte)((InflaterInputStream)jarInputStream).read()) != -1) {
                }
                Class clazz = this.defineClass(string, byArray2, n - 1);
                return clazz;
            }
            Class clazz = null;
            return clazz;
        }
        catch (ZipException zipException) {
            Class clazz = null;
            return clazz;
        }
        catch (IOException iOException) {
            Class clazz = null;
            return clazz;
        }
    }

    public static final BigDecimal createBigDecimal(byte[] byArray) throws SQLException {
        TBNumeric tBNumeric = new TBNumeric();
        tBNumeric.setBcdArray(byArray);
        return tBNumeric.getBigDecimal();
    }

    public static final byte[] convertBigDecimal(BigDecimal bigDecimal) throws SQLException {
        TBNumeric tBNumeric = new TBNumeric();
        tBNumeric.setBigDecimal(bigDecimal);
        return tBNumeric.getBcdArray();
    }

    public static final Timestamp createDatetime0(int n, short[] sArray) throws SQLException {
        TBDatetime tBDatetime = new TBDatetime(n, sArray);
        return tBDatetime.getTimestamp();
    }

    public static final Date createDatetime1(int n, short[] sArray) throws SQLException {
        TBDatetime tBDatetime = new TBDatetime(n, sArray);
        return tBDatetime.getDate();
    }

    public static final Time createDatetime2(int n, short[] sArray) throws SQLException {
        TBDatetime tBDatetime = new TBDatetime(n, sArray);
        return tBDatetime.getTime();
    }

    public static final byte[] convertDatetime(Date date) throws SQLException {
        TBDatetime tBDatetime = new TBDatetime();
        tBDatetime.setDate(date);
        TBAttrDatetime tBAttrDatetime = new TBAttrDatetime(tBDatetime);
        return tBAttrDatetime.getInternalValue();
    }

    public static final byte[] convertDatetime(Time time) throws SQLException {
        TBDatetime tBDatetime = new TBDatetime();
        tBDatetime.setTime(time);
        TBAttrDatetime tBAttrDatetime = new TBAttrDatetime(tBDatetime);
        return tBAttrDatetime.getInternalValue();
    }

    public static final byte[] convertDatetime(Timestamp timestamp) throws SQLException {
        TBDatetime tBDatetime = new TBDatetime();
        tBDatetime.setTimestamp(timestamp);
        TBAttrDatetime tBAttrDatetime = new TBAttrDatetime(tBDatetime);
        return tBAttrDatetime.getInternalValue();
    }

    public static final Timestamp createTimespan0(int n, int[] nArray) throws SQLException {
        TBTimespan tBTimespan = new TBTimespan(n, nArray);
        return new Timestamp(tBTimespan.getDate().getTime() + tBTimespan.getTime().getTime());
    }

    public static final Date createTimespan1(int n, int[] nArray) throws SQLException {
        TBTimespan tBTimespan = new TBTimespan(n, nArray);
        return new Date(tBTimespan.getDate().getTime() + tBTimespan.getTime().getTime());
    }

    public static Time createTimespan2(int n, int[] nArray) throws SQLException {
        TBTimespan tBTimespan = new TBTimespan(n, nArray);
        return new Time(tBTimespan.getDate().getTime() + tBTimespan.getTime().getTime());
    }

    public static final byte[] convertTimespan(Date date) throws SQLException {
        TBTimespan tBTimespan = new TBTimespan();
        tBTimespan.setDate(date);
        TBAttrTimespan tBAttrTimespan = new TBAttrTimespan(tBTimespan);
        return tBAttrTimespan.getInternalValue();
    }

    public static final byte[] convertTimespan(Time time) throws SQLException {
        TBTimespan tBTimespan = new TBTimespan();
        tBTimespan.setTime(time);
        TBAttrTimespan tBAttrTimespan = new TBAttrTimespan(tBTimespan);
        return tBAttrTimespan.getInternalValue();
    }

    public static final byte[] convertTimespan(Timestamp timestamp) throws SQLException {
        TBTimespan tBTimespan = new TBTimespan();
        tBTimespan.setTimestamp(timestamp);
        TBAttrTimespan tBAttrTimespan = new TBAttrTimespan(tBTimespan);
        return tBAttrTimespan.getInternalValue();
    }
}

