/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.coman;

import java.io.OutputStream;

public final class TBXComanOutputStream
extends OutputStream {
    private static int bufsize = 512;
    private int count;
    private byte[] buf;
    private boolean redirect;

    public TBXComanOutputStream(boolean bl) {
        this.redirect = bl;
        if (bl) {
            this.buf = new byte[bufsize];
            this.count = 0;
        }
    }

    public void write(int n) {
        if (this.redirect) {
            this.buf[this.count++] = (byte)(n & 0xFF);
            if (this.count == bufsize || n == 10) {
                this.flush();
                this.count = 0;
            }
        }
    }

    public void flush() {
        if (this.redirect) {
            this.tbflush(this.buf, this.count);
            this.count = 0;
        }
    }

    public void close() {
        if (this.redirect && this.count > 0) {
            this.flush();
        }
        this.buf = null;
    }

    private final native void tbflush(byte[] var1, int var2);
}

