/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.java;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.TBIdVector;
import transbase.tbx.TBLog;
import transbase.tbx.TBStreamInterface;
import transbase.tbx.TBURL;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.java.GlobMtaId;
import transbase.tbx.java.TBFeatures;
import transbase.tbx.java.TBXJavaTransaction;
import transbase.tbx.java.requests.TBReqAppl;
import transbase.tbx.java.requests.TBReqCommvers;
import transbase.tbx.java.requests.TBReqConn;
import transbase.tbx.java.requests.TBReqDbProperty;
import transbase.tbx.java.requests.TBReqDconn;
import transbase.tbx.java.requests.TBReqDelAppl;
import transbase.tbx.java.requests.TBReqKernel;
import transbase.tbx.java.requests.TBReqLogin;
import transbase.tbx.java.requests.TBReqRunContext;
import transbase.tbx.java.requests.TBReqTstmp;
import transbase.tbx.java.requests.TBReqVersion;
import transbase.tbx.requests.TBRequest;
import transbase.tbx.stypes.TBType24;
import transbase.tbx.stypes.TBTypeError;
import transbase.tbx.stypes.TBTypeLo;
import transbase.tbx.stypes.TBTypeM;
import transbase.tbx.stypes.TBTypePd;
import transbase.tbx.stypes.TBTypeTo;
import transbase.tbx.stypes.TBTypeTs;
import transbase.tbx.types.helpers.CharEncodingFactory;

public class TBXJavaConnection
implements TBXConnectionIf {
    public static final int CH_TB_KERNEL = 0;
    public static final int CH_TB_SERVER = 1;
    private static final int SO_TIMEOUT = 0;
    private static final int SO_LINGER = 50;
    private static final boolean SO_LINGER_ENABLED = true;
    private static final int SO_SNDBUF = 65536;
    private static final int SO_RCVBUF = 65536;
    private static final boolean NO_DELAY = false;
    private CharEncodingFactory mCharEncodingFactory;
    private TBURL url;
    private Socket socket;
    private Socket multiplexerSocket = null;
    private TBURL multiplexerUrl = null;
    private boolean isMultiplexed = false;
    private boolean isConnected = true;
    private boolean talkingWithMultiplexer = false;
    private boolean usesFirewall = false;
    private int dbState = 1;
    private boolean isSingle;
    private TBType24 internalPort;
    private TBTypePd remoteProcessId;
    private TBTypeM remoteMachineType;
    private TBTypeTo tbxTimeout = new TBTypeTo(30);
    private TBTypeLo contextID = new TBTypeLo(-1);
    private int commVersion = 0;
    private TBFeatures mTBFeatures = null;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private TBIdVector quids = new TBIdVector(10, 11032);
    private TBXJavaTransaction transaction = null;
    protected TBLog mLog;
    private boolean mIsExecuting;
    private Socket tbServerSocket = null;
    private DataOutputStream tbServerOutputStream = null;
    private DataInputStream tbServerInputStream = null;
    private Object tbServerStreamSema = new Object();

    public TBXJavaConnection(TBURL tBURL, String string, TBLog tBLog) throws SQLException {
        this.mLog = tBLog;
        this.mCharEncodingFactory = new CharEncodingFactory();
        try {
            block33: {
                try {
                    Object object;
                    TBRequest tBRequest;
                    this.url = tBURL;
                    try {
                        this.socket = tBURL.getSocket();
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw TBException.getTBException(10036, tBURL.getHost());
                    }
                    catch (IOException iOException) {
                        throw TBException.getTBException(30209, iOException.getMessage());
                    }
                    this.switchStreams(false);
                    TBReqKernel tBReqKernel = new TBReqKernel(this);
                    this.dbState = 5;
                    boolean bl = this.usesFirewall = tBReqKernel.getPort().getValue() == 0;
                    if (!this.usesFirewall) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            throw TBException.getTBException(30209, iOException.getMessage());
                        }
                    }
                    this.isMultiplexed = tBReqKernel.isMultiplexed();
                    this.internalPort = tBReqKernel.getPort();
                    this.remoteProcessId = tBReqKernel.getDBpid();
                    this.remoteMachineType = tBReqKernel.getType();
                    int n = tBReqKernel.getApln().getValue();
                    if (this.isMultiplexed) {
                        this.multiplexerUrl = new TBURL(this.url.getUrl());
                        if (!this.usesFirewall) {
                            this.multiplexerUrl.setPort(this.internalPort.getValue());
                            try {
                                this.multiplexerSocket = this.multiplexerUrl.getSocket();
                                this.setSocketOptions(this.multiplexerSocket);
                            }
                            catch (UnknownHostException unknownHostException) {
                                throw TBException.getTBException(10036, this.multiplexerUrl.getHost());
                            }
                            catch (IOException iOException) {
                                throw TBException.getTBException(30209, iOException.getMessage());
                            }
                        } else {
                            this.multiplexerSocket = this.socket;
                        }
                        this.switchStreams(true);
                        tBRequest = new TBReqRunContext(this, tBURL.getDatabase(), this.contextID, this.tbxTimeout);
                        this.internalPort = ((TBReqRunContext)tBRequest).getPort();
                        this.remoteProcessId = ((TBReqRunContext)tBRequest).getPid();
                        this.contextID = ((TBReqRunContext)tBRequest).getContextID();
                        if (((TBReqRunContext)tBRequest).isDedicated()) {
                            this.isMultiplexed = false;
                            try {
                                this.multiplexerSocket.close();
                            }
                            catch (Exception exception) {
                                throw new SQLException(exception.getMessage());
                            }
                        } else {
                            object = new TBReqCommvers(this, 0);
                            this.commVersion = ((TBReqCommvers)object).getCommVersion();
                            this.mTBFeatures = ((TBReqCommvers)object).getFeatures();
                        }
                    }
                    try {
                        this.url.setPort(this.internalPort.getValue());
                        this.socket = this.url.getSocket();
                        this.setSocketOptions(this.socket);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw TBException.getTBException(10036, tBURL.getHost());
                    }
                    catch (IOException iOException) {
                        throw TBException.getTBException(30209, iOException.getMessage());
                    }
                    this.switchStreams(false);
                    tBRequest = new TBReqConn(this, this.url.getDatabase());
                    this.isSingle = ((TBReqConn)tBRequest).isSingle();
                    if (!this.isMultiplexed) {
                        object = new TBReqCommvers(this, 0);
                        this.commVersion = ((TBReqCommvers)object).getCommVersion();
                        this.mTBFeatures = ((TBReqCommvers)object).getFeatures();
                    }
                    object = GlobMtaId.getSemaphore();
                    synchronized (object) {
                        if (!GlobMtaId.isInitialized()) {
                            try {
                                GlobMtaId.init(tBURL.getInetAddress().getAddress(), n);
                            }
                            catch (UnknownHostException unknownHostException) {
                                throw TBException.getTBException(10036, this.multiplexerUrl.getHost());
                            }
                        }
                    }
                    this.dbState = 2;
                    if ((string == null || string.length() == 0) && this.mTBFeatures.supportsFeature(1)) {
                        TBReqDbProperty tBReqDbProperty = new TBReqDbProperty(this, "codepage");
                        this.mCharEncodingFactory = new CharEncodingFactory(Integer.parseInt(tBReqDbProperty.getParameterValue()));
                        break block33;
                    }
                    this.mCharEncodingFactory = new CharEncodingFactory(string);
                }
                catch (SQLException sQLException) {
                    try {
                        this.socket.close();
                        this.multiplexerSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw sQLException;
                }
            }
            Object var11_20 = null;
        }
        catch (Throwable throwable) {
            Object var11_21 = null;
            this.freeConnection();
            throw throwable;
        }
        this.freeConnection();
    }

    private void setSocketOptions(Socket socket) throws SocketException {
        try {
            socket.setSoLinger(true, 50);
        }
        catch (Exception exception) {
            this.mLog.println("TBXJavaConnection.setSocketOptions: Setting SO_LINGER caused an error, using system default: ".concat(String.valueOf(String.valueOf(socket.getSoLinger()))));
        }
        try {
            socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            this.mLog.println("TBXJavaConnection.setSocketOptions: Setting SO_TIMEOUT caused an error, using system default: ".concat(String.valueOf(String.valueOf(socket.getSoTimeout()))));
        }
    }

    protected void needConnection() throws SQLException {
        if (this.isMultiplexed && !this.isConnected) {
            this.switchStreams(true);
            TBReqRunContext tBReqRunContext = new TBReqRunContext(this, "", this.contextID, this.tbxTimeout);
            this.internalPort = tBReqRunContext.getPort();
            this.remoteProcessId = tBReqRunContext.getPid();
            try {
                this.url.setPort(this.internalPort.getValue());
                this.socket = this.url.getSocket();
                this.setSocketOptions(this.socket);
            }
            catch (UnknownHostException unknownHostException) {
                throw TBException.getTBException(10036, this.url.getHost());
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30209, iOException.getMessage());
            }
            this.isConnected = true;
            this.switchStreams(false);
        }
    }

    protected void freeConnection() throws SQLException {
        if (this.isMultiplexed && this.isConnected && this.transaction == null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30209, iOException.getMessage());
            }
            this.isConnected = false;
        }
    }

    public void send(TBStreamInterface tBStreamInterface) throws SQLException {
        this.mIsExecuting = true;
        SQLException sQLException = null;
        try {
            block5: {
                if (!this.talkingWithMultiplexer) {
                    this.needConnection();
                }
                try {
                    tBStreamInterface.writeTBStream(this.outputStream, this);
                }
                catch (SQLException sQLException2) {
                    if (!(sQLException2 instanceof TBException) || !((TBException)sQLException2).getIgnoreOnRequests()) break block5;
                    sQLException = (TBException)sQLException2;
                }
            }
            TBTypeError tBTypeError = sQLException == null ? new TBTypeError() : new TBTypeError(sQLException.getErrorCode(), sQLException.getMessage());
            tBTypeError.writeTBStream(this.outputStream, this);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            this.mIsExecuting = false;
            throw TBException.getTBException(30209, iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receive(TBStreamInterface tBStreamInterface) throws SQLException {
        try {
            try {
                TBException tBException;
                TBTypeError tBTypeError;
                block11: {
                    tBTypeError = new TBTypeError();
                    tBTypeError.readTBStream(this.inputStream, this);
                    if (tBTypeError.getErrorCode() != 0) {
                        TBException tBException2 = TBException.getTBServerException(tBTypeError.getErrorCode(), tBTypeError.getErrorMessage());
                        this.handleHardError(tBException2);
                        throw tBException2;
                    }
                    tBException = null;
                    try {
                        tBStreamInterface.readTBStream(this.inputStream, this);
                    }
                    catch (SQLException sQLException) {
                        if (!(sQLException instanceof TBException) || !((TBException)sQLException).getIgnoreOnRequests()) break block11;
                        tBException = (TBException)sQLException;
                    }
                }
                tBTypeError.readTBStream(this.inputStream, this);
                if (tBTypeError.getErrorCode() != 0) {
                    TBException tBException3 = TBException.getTBServerException(tBTypeError.getErrorCode(), tBTypeError.getErrorMessage());
                    this.handleHardError(tBException3);
                    throw tBException3;
                }
                if (tBException != null) {
                    this.handleHardError(tBException);
                    throw tBException;
                }
                Object var6_10 = null;
                this.mIsExecuting = false;
                if (this.talkingWithMultiplexer) return;
            }
            catch (TBException tBException) {
                if (tBException.getErrorCode() != 30036) throw tBException;
                this.kill();
                throw tBException;
            }
            catch (EOFException eOFException) {
                throw TBException.getTBException(30209, "EOF on communication channel: ".concat(String.valueOf(String.valueOf(eOFException.getMessage()))));
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30209, iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.mIsExecuting = false;
            if (this.talkingWithMultiplexer) throw throwable;
            this.freeConnection();
            throw throwable;
        }
        this.freeConnection();
    }

    public Object getServerStreamSema() {
        return this.tbServerStreamSema;
    }

    protected void needTbServerConnection() throws SQLException {
        if (this.tbServerSocket == null) {
            try {
                boolean bl;
                this.tbServerSocket = this.url.getTbServerSocket();
                this.setSocketOptions(this.tbServerSocket);
                this.tbServerOutputStream = new DataOutputStream(new BufferedOutputStream(this.tbServerSocket.getOutputStream(), 65536));
                this.tbServerInputStream = new DataInputStream(new BufferedInputStream(this.tbServerSocket.getInputStream(), 65536));
                TBReqAppl tBReqAppl = new TBReqAppl(this);
                int n = tBReqAppl.getPort();
                boolean bl2 = bl = n == 0;
                if (!bl) {
                    this.tbServerSocket.close();
                    this.tbServerSocket = this.url.getSocket(n);
                    this.setSocketOptions(this.tbServerSocket);
                    this.tbServerOutputStream = new DataOutputStream(new BufferedOutputStream(this.tbServerSocket.getOutputStream(), 65536));
                    this.tbServerInputStream = new DataInputStream(new BufferedInputStream(this.tbServerSocket.getInputStream(), 65536));
                }
                if (this.getCommVersion() > 0) {
                    TBReqCommvers tBReqCommvers = new TBReqCommvers(this, 1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw TBException.getTBException(10036, this.url.getHost());
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30210, iOException.getMessage());
            }
        }
    }

    protected void freeTbServerConnection() throws SQLException {
        try {
            block4: {
                try {
                    if (this.tbServerSocket == null) break block4;
                    this.tbServerSocket.close();
                }
                catch (IOException iOException) {
                    throw TBException.getTBException(30210, iOException.getMessage());
                }
            }
            Object var3_1 = null;
            this.tbServerSocket = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.tbServerSocket = null;
            throw throwable;
        }
    }

    public void requestTBServer(TBStreamInterface tBStreamInterface) throws SQLException {
        if (this.tbServerSocket == null) {
            this.needTbServerConnection();
        }
        try {
            this.sendTBServer(tBStreamInterface);
            this.receiveTBServer(tBStreamInterface);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.freeTbServerConnection();
            throw throwable;
        }
        this.freeTbServerConnection();
    }

    public void sendTBServer(TBStreamInterface tBStreamInterface) throws SQLException {
        try {
            tBStreamInterface.writeTBStream(this.tbServerOutputStream, this);
            TBTypeError tBTypeError = new TBTypeError();
            tBTypeError.writeTBStream(this.tbServerOutputStream, this);
            this.tbServerOutputStream.flush();
        }
        catch (IOException iOException) {
            throw TBException.getTBException(30210, iOException.getMessage());
        }
    }

    public void receiveTBServer(TBStreamInterface tBStreamInterface) throws SQLException {
        try {
            TBTypeError tBTypeError = new TBTypeError();
            tBTypeError.readTBStream(this.tbServerInputStream, this);
            if (tBTypeError.getErrorCode() != 0) {
                TBException tBException = TBException.getTBOutbandException(tBTypeError.getErrorCode(), tBTypeError.getErrorMessage());
                throw tBException;
            }
            tBStreamInterface.readTBStream(this.tbServerInputStream, this);
            tBTypeError.readTBStream(this.tbServerInputStream, this);
            if (tBTypeError.getErrorCode() != 0) {
                TBException tBException = TBException.getTBOutbandException(tBTypeError.getErrorCode(), tBTypeError.getErrorMessage());
                throw tBException;
            }
        }
        catch (EOFException eOFException) {
            throw TBException.getTBException(30210, "EOF on communication channel: ".concat(String.valueOf(String.valueOf(eOFException.getMessage()))));
        }
        catch (IOException iOException) {
            throw TBException.getTBException(30210, iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void handleHardError(TBException tBException) {
        if (!tBException.isHardError()) return;
        if (this.transaction == null) return;
        if (this.transaction.getTaid() < 0) return;
        if (tBException.getHardErrorHandled()) return;
        int n = this.transaction.getTaid();
        try {
            try {
                this.transaction.abortTBX();
            }
            catch (SQLException sQLException) {
                Object var5_4 = null;
                tBException.setHardErrorHandled(true);
                this.mLog.println("The following Error is raised only internally:");
                TBException.getTBException(11029, Integer.toString(n));
                return;
            }
            Object var5_3 = null;
            tBException.setHardErrorHandled(true);
            this.mLog.println("The following Error is raised only internally:");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            tBException.setHardErrorHandled(true);
            this.mLog.println("The following Error is raised only internally:");
            TBException.getTBException(11029, Integer.toString(n));
            throw throwable;
        }
        TBException.getTBException(11029, Integer.toString(n));
    }

    private void switchStreams(boolean bl) throws SQLException {
        try {
            if (bl) {
                this.outputStream = new DataOutputStream(new BufferedOutputStream(this.multiplexerSocket.getOutputStream(), 65536));
                this.inputStream = new DataInputStream(new BufferedInputStream(this.multiplexerSocket.getInputStream(), 65536));
            } else if (this.isConnected) {
                this.outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
                this.inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
            }
        }
        catch (IOException iOException) {
            throw TBException.getTBException(30209, iOException.getMessage());
        }
        this.talkingWithMultiplexer = bl;
    }

    public int getCommVersion() {
        return this.commVersion;
    }

    public int getDbState() throws SQLException {
        return this.dbState;
    }

    public synchronized void login(String string, String string2) throws SQLException {
        if (this.dbState == 5) {
            throw new TBException(11011);
        }
        if (this.transaction != null && this.transaction.getTaid() >= 0) {
            throw TBException.getTBException(11027, new String[]{String.valueOf(String.valueOf(Integer.toString(this.transaction.getTaid()))).concat(" (login) "), this.getUrl().getUrl()});
        }
        if (!this.isSingle() && GlobMtaId.getGlobMtaId().getApId() == 0) {
            throw new TBException(11014);
        }
        GlobMtaId.updateMtaLn();
        TBReqLogin tBReqLogin = new TBReqLogin(this, string, string2, GlobMtaId.getGlobMtaId());
        this.dbState = 4;
    }

    public synchronized void testLogged() throws SQLException {
        if (this.dbState != 4) {
            throw TBException.getTBException(16005, this.url.getUrl());
        }
    }

    public synchronized void bindTransaction(TBXJavaTransaction tBXJavaTransaction) throws SQLException {
        if (this.transaction != null && this.transaction.getTaid() != tBXJavaTransaction.getTaid() && this.transaction.getTaid() >= 0) {
            throw TBException.getTBException(11027, new String[]{String.valueOf(String.valueOf(Integer.toString(this.transaction.getTaid()))).concat(" (bindTransaction) "), this.url.getUrl()});
        }
        this.transaction = tBXJavaTransaction;
    }

    public synchronized void freeTransaction(TBXJavaTransaction tBXJavaTransaction) throws SQLException {
        if (this.transaction != null) {
            if (this.transaction.getTaid() == tBXJavaTransaction.getTaid() || this.transaction.getTaid() < 0) {
                this.transaction = null;
                this.freeConnection();
            } else {
                throw TBException.getTBException(11027, new String[]{String.valueOf(String.valueOf(Integer.toString(this.transaction.getTaid()))).concat(" (freeTransaction) "), this.url.getUrl()});
            }
        }
    }

    public synchronized TBXJavaTransaction getBoundTransaction() throws SQLException {
        if (this.transaction == null) {
            throw TBException.getTBException(30001, this.url.getUrl());
        }
        return this.transaction;
    }

    public TBXTransactionIf getBoundTransactionInternal() {
        return this.transaction;
    }

    public synchronized void close() throws SQLException {
        if (this.dbState == 5) {
            throw new TBException(11011);
        }
        if (this.transaction != null && this.transaction.getTaid() >= 0) {
            throw TBException.getTBException(11027, new String[]{String.valueOf(String.valueOf(Integer.toString(this.transaction.getTaid()))).concat("(close)"), this.url.getDatabase()});
        }
        if (this.dbState == 3) {
            return;
        }
        try {
            TBRequest tBRequest;
            block12: {
                try {
                    tBRequest = new TBReqDconn(this);
                }
                catch (SQLException sQLException) {
                    if (this.getCommVersion() <= 3) break block12;
                    throw sQLException;
                }
            }
            try {
                this.socket.close();
                this.isConnected = false;
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30209, iOException.getMessage());
            }
            if (this.isMultiplexed) {
                this.switchStreams(true);
                tBRequest = new TBReqDelAppl(this);
                try {
                    this.multiplexerSocket.close();
                }
                catch (IOException iOException) {
                    throw TBException.getTBException(30209, iOException.getMessage());
                }
            }
            Object var4_5 = null;
            this.dbState = 1;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.dbState = 1;
            throw throwable;
        }
    }

    private void kill() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.multiplexerSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dbState = 1;
    }

    public synchronized TBTypeTs getTimestamp() throws SQLException {
        if (this.dbState == 5) {
            throw new TBException(11011);
        }
        TBReqTstmp tBReqTstmp = new TBReqTstmp(this);
        return tBReqTstmp.getTimestamp();
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public int getQuid() throws SQLException {
        return this.quids.getId();
    }

    public void freeQuid(int n) throws SQLException {
        if (!this.quids.freeId(n)) {
            throw new TBException(5005, Integer.toString(n));
        }
    }

    public TBURL getUrl() throws SQLException {
        return this.url;
    }

    public String getDatabaseVersionString() throws SQLException {
        if (this.dbState != 4 && this.dbState != 2) {
            throw new TBException(30020);
        }
        TBReqVersion tBReqVersion = new TBReqVersion(this);
        return tBReqVersion.getVersionString();
    }

    public String getDatabaseVersion() throws SQLException {
        if (this.dbState != 4 && this.dbState != 2) {
            throw new TBException(30020);
        }
        TBReqVersion tBReqVersion = new TBReqVersion(this);
        return tBReqVersion.getVersion();
    }

    public CharEncodingFactory getCharEncodingFactory() {
        return this.mCharEncodingFactory;
    }

    public TBLog getLogInstance() {
        return this.mLog;
    }

    protected boolean isExecuting() {
        return this.mIsExecuting;
    }

    protected TBTypePd getRemoteProcessId() {
        return this.remoteProcessId;
    }
}

