/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import transbase.tbx.TBException;
import transbase.tbx.TBLog;
import transbase.tbx.TBStreamInterface;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.stypes.TBType;
import transbase.tbx.stypes.TBTypeR;

public abstract class TBRequest
implements TBStreamInterface {
    public static final int APID_R = 1;
    public static final int RET_REQ = 5;
    public static final int SNDSIG_R = 8;
    public static final int LOGIN_R = 9;
    public static final int CONN_R = 10;
    public static final int DCONN_R = 11;
    public static final int BT_R = 12;
    public static final int CT_R = 13;
    public static final int AT_R = 14;
    public static final int PT_R = 15;
    public static final int MKZ_R = 16;
    public static final int DML_R = 17;
    public static final int RU_SPC_R = 19;
    public static final int RU_SPR_R = 20;
    public static final int RU_SPF_R = 21;
    public static final int RU_DDL_R = 22;
    public static final int RU_MQL_R = 23;
    public static final int RU_LCK_R = 24;
    public static final int CLOSE_R = 25;
    public static final int EVAL_R = 26;
    public static final int DELPOS_R = 27;
    public static final int UPDPOS_R = 28;
    public static final int EXCL_R = 29;
    public static final int TSTMP_R = 30;
    public static final int VERSION_R = 31;
    public static final int UPDSTO_R = 35;
    public static final int DELSTO_R = 36;
    public static final int OPSTO_R = 37;
    public static final int RUNSTO_R = 38;
    public static final int STORE_R = 39;
    public static final int DROPSTO_R = 40;
    public static final int APPL_R = 42;
    public static final int RU_LOAD_R = 43;
    public static final int GTBLOB_R = 44;
    public static final int MKBLOB_R = 45;
    public static final int BL_SPIN_R = 46;
    public static final int TBMODE = 49;
    public static final int RUN_CONTEXT_R = 55;
    public static final int DEL_APPL_R = 56;
    public static final int COMMVERS_R = 60;
    public static final int CURSOR_OPEN_R = 62;
    public static final int CURSOR_OPENSTORED_R = 63;
    public static final int CURSOR_FETCH_R = 64;
    public static final int GETBLOBPART_R = 65;
    public static final int DBPROPERTY_R = 66;
    private static Hashtable requestNames = new Hashtable(100);

    public static String getRequestName(int n) {
        Integer n2 = new Integer(n);
        return (String)requestNames.get(n2);
    }

    public abstract TBTypeR getRequestCode();

    public abstract TBType[] getValuesToSend(TBXConnectionIf var1);

    public abstract TBType[] getValuesToReceive(TBXConnectionIf var1);

    public String getParameterLog(TBXConnectionIf tBXConnectionIf, TBType[] tBTypeArray) {
        String string = "";
        for (int i = tBTypeArray.length - 1; i >= 0; --i) {
            string = String.valueOf(String.valueOf(new StringBuffer("{").append(tBTypeArray[i].getLogString(tBXConnectionIf)).append("}").append(string)));
            if (i <= 0) continue;
            string = ", ".concat(String.valueOf(String.valueOf(string)));
        }
        return string;
    }

    public void logSend(TBXConnectionIf tBXConnectionIf, TBType[] tBTypeArray) {
        TBLog tBLog = tBXConnectionIf.getLogInstance();
        if (!tBLog.loggingEnabled()) {
            return;
        }
        if (tBLog.getTBXRequestLogging()) {
            tBLog.println("TB REQUEST SEND ".concat(String.valueOf(String.valueOf(TBRequest.getRequestName(this.getRequestCode().getValue())))));
            if (tBLog.getTBXRequestValuesLogging()) {
                tBLog.println("TB REQUEST VALUES ".concat(String.valueOf(String.valueOf(this.getParameterLog(tBXConnectionIf, tBTypeArray)))));
            }
        }
    }

    public void logReceive(TBXConnectionIf tBXConnectionIf, TBType[] tBTypeArray) {
        TBLog tBLog = tBXConnectionIf.getLogInstance();
        if (!tBLog.loggingEnabled()) {
            return;
        }
        if (tBLog.getTBXRequestLogging()) {
            tBLog.println("TB REQUEST RECEIVE ".concat(String.valueOf(String.valueOf(TBRequest.getRequestName(this.getRequestCode().getValue())))));
            if (tBLog.getTBXRequestValuesLogging()) {
                tBLog.println("TB REQUEST VALUES ".concat(String.valueOf(String.valueOf(this.getParameterLog(tBXConnectionIf, tBTypeArray)))));
            }
        }
    }

    private void appendException(SQLException sQLException, SQLException sQLException2) {
        SQLException sQLException3 = sQLException;
        while (sQLException.getNextException() != null) {
            sQLException3 = sQLException.getNextException();
        }
        sQLException3.setNextException(sQLException2);
    }

    public void readTBStream(DataInput dataInput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        TBType[] tBTypeArray = this.getValuesToReceive(tBXConnectionIf);
        int n = tBTypeArray.length;
        TBException tBException = null;
        for (int i = 0; i < n; ++i) {
            try {
                tBTypeArray[i].readTBStream(dataInput, tBXConnectionIf);
                continue;
            }
            catch (SQLException sQLException) {
                if (!(sQLException instanceof TBException) || !((TBException)sQLException).getIgnoreOnRequests()) continue;
                if (tBException == null) {
                    tBException = (TBException)sQLException;
                    continue;
                }
                this.appendException(tBException, sQLException);
            }
        }
        if (tBException != null) {
            throw tBException;
        }
        this.logReceive(tBXConnectionIf, tBTypeArray);
    }

    public void writeTBStream(DataOutput dataOutput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        TBType[] tBTypeArray = this.getValuesToSend(tBXConnectionIf);
        this.logSend(tBXConnectionIf, tBTypeArray);
        int n = tBTypeArray.length;
        TBException tBException = null;
        for (int i = 0; i < n; ++i) {
            try {
                tBTypeArray[i].writeTBStream(dataOutput, tBXConnectionIf);
                continue;
            }
            catch (SQLException sQLException) {
                if (!(sQLException instanceof TBException) || !((TBException)sQLException).getIgnoreOnRequests()) continue;
                if (tBException == null) {
                    tBException = (TBException)sQLException;
                    continue;
                }
                this.appendException(tBException, sQLException);
            }
        }
        if (tBException != null) {
            throw tBException;
        }
    }

    static {
        requestNames.put(new Integer(1), new String("APID_R"));
        requestNames.put(new Integer(5), new String("RET_REQ"));
        requestNames.put(new Integer(9), new String("LOGIN_R"));
        requestNames.put(new Integer(10), new String("CONN_R"));
        requestNames.put(new Integer(11), new String("DCONN_R"));
        requestNames.put(new Integer(12), new String("BT_R"));
        requestNames.put(new Integer(13), new String("CT_R"));
        requestNames.put(new Integer(14), new String("AT_R"));
        requestNames.put(new Integer(15), new String("PT_R"));
        requestNames.put(new Integer(16), new String("MKZ_R"));
        requestNames.put(new Integer(17), new String("DML_R"));
        requestNames.put(new Integer(22), new String("RU_DDL_R"));
        requestNames.put(new Integer(23), new String("RU_MQL_R"));
        requestNames.put(new Integer(24), new String("RU_LCK_R"));
        requestNames.put(new Integer(25), new String("CLOSE_R"));
        requestNames.put(new Integer(26), new String("EVAL_R"));
        requestNames.put(new Integer(27), new String("DELPOS_R"));
        requestNames.put(new Integer(28), new String("UPDPOS_R"));
        requestNames.put(new Integer(29), new String("EXCL_R"));
        requestNames.put(new Integer(30), new String("TSTMP_R"));
        requestNames.put(new Integer(31), new String("VERSION_R"));
        requestNames.put(new Integer(35), new String("UPDSTO_R"));
        requestNames.put(new Integer(36), new String("DELSTO_R"));
        requestNames.put(new Integer(37), new String("OPSTO_R"));
        requestNames.put(new Integer(38), new String("RUNSTO_R"));
        requestNames.put(new Integer(39), new String("STORE_R"));
        requestNames.put(new Integer(40), new String("DROPSTO_R"));
        requestNames.put(new Integer(43), new String("RU_LOAD_R"));
        requestNames.put(new Integer(44), new String("GTBLOB_R"));
        requestNames.put(new Integer(45), new String("MKBLOB_R"));
        requestNames.put(new Integer(55), new String("RUN_CONTEXT_R"));
        requestNames.put(new Integer(56), new String("DEL_APPL_R"));
        requestNames.put(new Integer(60), new String("COMMVERS_R"));
        requestNames.put(new Integer(62), new String("CURSOR_OPEN_R"));
        requestNames.put(new Integer(63), new String("CURSOR_OPENSTORED_R"));
        requestNames.put(new Integer(64), new String("CURSOR_FETCH_R"));
        requestNames.put(new Integer(65), new String("GETBLOBPART_R"));
        requestNames.put(new Integer(66), new String("DBPROPERTY_R"));
        requestNames.put(new Integer(19), new String("RU_SPC_R"));
        requestNames.put(new Integer(20), new String("RU_SPR_R"));
        requestNames.put(new Integer(21), new String("RU_SPF_R"));
    }
}

