/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.stypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBException;
import transbase.tbx.TBStreamInterface;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.stypes.TBInteger;
import transbase.tbx.stypes.TBShort;
import transbase.tbx.stypes.TBType;
import transbase.tbx.stypes.TBTypeF;
import transbase.tbx.stypes.TBTypeP;
import transbase.tbx.types.helpers.QueryDescriptor;
import transbase.tbx.types.helpers.TSpec;

public class TBTypeQd
implements TBStreamInterface,
TBType,
QueryDescriptor {
    int queryId;
    short eod;
    short qtype;
    short updatable;
    short qattrNo;
    short paramNo = 0;
    Vector field = new Vector(0, 1);
    Vector params = new Vector(0, 1);

    public int getQueryType() {
        return this.qtype;
    }

    public int getQuid() {
        return this.queryId;
    }

    public boolean isEod() {
        return this.eod != 0;
    }

    public int getAttrNo() {
        return this.qattrNo;
    }

    public int getParamNo() {
        return this.paramNo;
    }

    private void testIndex(int n, int n2) throws SQLException {
        if (n <= 0 || n > n2) {
            throw new TBException(30003, Integer.toString(n));
        }
    }

    public int getFieldType(int n) throws SQLException {
        this.testIndex(n, this.qattrNo);
        return ((TBTypeF)this.field.elementAt(n - 1)).getFieldType();
    }

    public int getParamFieldType(int n) throws SQLException {
        if (n < 1 || n > this.getParamNo()) {
            return 0;
        }
        return ((TBTypeP)this.params.elementAt(n - 1)).getFieldType();
    }

    public String getFieldName(int n) throws SQLException {
        this.testIndex(n, this.qattrNo);
        return ((TBTypeF)this.field.elementAt(n - 1)).getFieldName();
    }

    public TSpec getTspec(int n) throws SQLException {
        this.testIndex(n, this.qattrNo);
        return ((TBTypeF)this.field.elementAt(n - 1)).getTspec();
    }

    public String getLogString(TBXConnectionIf tBXConnectionIf) {
        int n;
        String string = "Qd(";
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new TBInteger(this.queryId).getLogString(tBXConnectionIf))).concat(","))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new TBShort(this.qtype).getLogString(tBXConnectionIf))).concat(","))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new TBShort(this.updatable).getLogString(tBXConnectionIf))).concat(","))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new TBShort(this.qattrNo).getLogString(tBXConnectionIf))).concat(","))));
        if (tBXConnectionIf.getCommVersion() > 0) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new TBShort(this.paramNo).getLogString(tBXConnectionIf))).concat(","))));
        }
        for (n = 0; n < this.field.size(); ++n) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(((TBTypeF)this.field.elementAt(n)).getLogString(tBXConnectionIf))));
            if (n >= this.field.size() - 1) continue;
            string = String.valueOf(String.valueOf(string)).concat(", ");
        }
        if (tBXConnectionIf.getCommVersion() > 0) {
            for (n = 0; n < this.params.size(); ++n) {
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(((TBTypeP)this.params.elementAt(n)).getLogString(tBXConnectionIf))));
                if (n >= this.params.size() - 1) continue;
                string = String.valueOf(String.valueOf(string)).concat(", ");
            }
        }
        return string;
    }

    public void readTBStream(DataInput dataInput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        int n;
        this.field.removeAllElements();
        this.params.removeAllElements();
        TBInteger tBInteger = new TBInteger();
        tBInteger.readTBStream(dataInput, tBXConnectionIf);
        this.queryId = tBInteger.getValue();
        TBShort tBShort = new TBShort();
        tBShort.readTBStream(dataInput, tBXConnectionIf);
        this.qtype = tBShort.getValue();
        tBShort.readTBStream(dataInput, tBXConnectionIf);
        this.updatable = tBShort.getValue();
        tBShort.readTBStream(dataInput, tBXConnectionIf);
        this.qattrNo = tBShort.getValue();
        if (tBXConnectionIf.getCommVersion() > 0) {
            tBShort.readTBStream(dataInput, tBXConnectionIf);
            this.paramNo = tBShort.getValue();
        } else {
            this.paramNo = 0;
        }
        for (n = 0; n < this.qattrNo; ++n) {
            TBTypeF tBTypeF = new TBTypeF();
            tBTypeF.readTBStream(dataInput, tBXConnectionIf);
            this.field.addElement(tBTypeF);
        }
        if (tBXConnectionIf.getCommVersion() > 0) {
            for (n = 0; n < this.paramNo; ++n) {
                TBTypeP tBTypeP = new TBTypeP();
                tBTypeP.readTBStream(dataInput, tBXConnectionIf);
                this.params.addElement(tBTypeP);
            }
        }
    }

    public void writeTBStream(DataOutput dataOutput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        int n;
        new TBInteger(this.queryId).writeTBStream(dataOutput, tBXConnectionIf);
        new TBShort(this.qtype).writeTBStream(dataOutput, tBXConnectionIf);
        new TBShort(this.updatable).writeTBStream(dataOutput, tBXConnectionIf);
        new TBShort(this.qattrNo).writeTBStream(dataOutput, tBXConnectionIf);
        if (tBXConnectionIf.getCommVersion() > 0) {
            new TBShort(this.paramNo).writeTBStream(dataOutput, tBXConnectionIf);
        }
        if (this.field.size() != this.qattrNo || this.params.size() != this.paramNo) {
            throw new IOException("Array sizes do not match in TBTypeQd");
        }
        for (n = 0; n < this.qattrNo; ++n) {
            ((TBTypeF)this.field.elementAt(n)).writeTBStream(dataOutput, tBXConnectionIf);
        }
        if (tBXConnectionIf.getCommVersion() > 0) {
            for (n = 0; n < this.paramNo; ++n) {
                ((TBTypeP)this.params.elementAt(n)).writeTBStream(dataOutput, tBXConnectionIf);
            }
        }
    }
}

